/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.TypesUtilities;
import org.hl7.fhir.utilities.Utilities;

public class Property {
    private IWorkerContext context;
    private ElementDefinition definition;
    private StructureDefinition structure;
    private Boolean canBePrimitive;
    private ProfileUtilities profileUtilities;

    public Property(IWorkerContext context, ElementDefinition definition, StructureDefinition structure) {
        this.context = context;
        this.definition = definition;
        this.structure = structure;
        this.profileUtilities = new ProfileUtilities(context, null, null);
    }

    public String getName() {
        return this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
    }

    public ElementDefinition getDefinition() {
        return this.definition;
    }

    public String getType() {
        if (this.definition.getType().size() == 0) {
            return null;
        }
        if (this.definition.getType().size() > 1) {
            String tn = this.definition.getType().get(0).getWorkingCode();
            for (int i = 1; i < this.definition.getType().size(); ++i) {
                if (tn.equals(this.definition.getType().get(i).getWorkingCode())) continue;
                throw new Error("logic error, gettype when types > 1");
            }
            return tn;
        }
        return this.definition.getType().get(0).getWorkingCode();
    }

    public String getType(String elementName) {
        if (!this.definition.getPath().contains(".")) {
            return this.definition.getPath();
        }
        ElementDefinition ed = this.definition;
        if (this.definition.hasContentReference()) {
            if (!this.definition.getContentReference().startsWith("#")) {
                throw new Error("not handled yet");
            }
            boolean found = false;
            for (ElementDefinition elementDefinition : this.structure.getSnapshot().getElement()) {
                if (!elementDefinition.hasId() || !elementDefinition.getId().equals(this.definition.getContentReference().substring(1))) continue;
                found = true;
                ed = elementDefinition;
            }
            if (!found) {
                throw new Error("Unable to resolve " + this.definition.getContentReference() + " at " + this.definition.getPath() + " on " + this.structure.getUrl());
            }
        }
        if (ed.getType().size() == 0) {
            return null;
        }
        if (ed.getType().size() > 1) {
            String t = ed.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return t;
            }
            String string = ed.getPath().substring(ed.getPath().lastIndexOf(".") + 1);
            if (string.endsWith("[x]") && elementName != null && elementName.startsWith(string.substring(0, string.length() - 3))) {
                String name = elementName.substring(string.length() - 3);
                return this.isPrimitive(this.lowFirst(name)) ? this.lowFirst(name) : name;
            }
            if (ToolingExtensions.hasExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
                return ToolingExtensions.readStringExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
            }
            throw new Error("logic error, gettype when types > 1, name mismatch for " + elementName + " on at " + ed.getPath());
        }
        if (ed.getType().get(0).getCode() == null) {
            if (Utilities.existsInList((String)ed.getId(), (String[])new String[]{"Element.id", "Extension.url"})) {
                return "string";
            }
            return this.structure.getId();
        }
        return ed.getType().get(0).getWorkingCode();
    }

    public boolean hasType(String elementName) {
        if (this.definition.getType().size() == 0) {
            return false;
        }
        if (this.definition.getType().size() > 1) {
            String t = this.definition.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return true;
            }
            String tail = this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
            if (tail.endsWith("[x]") && elementName.startsWith(tail.substring(0, tail.length() - 3))) {
                String name = elementName.substring(tail.length() - 3);
                return true;
            }
            return false;
        }
        return true;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public boolean isPrimitiveName(String name) {
        String code = this.getType(name);
        return this.isPrimitive(code);
    }

    public boolean isPrimitive(String code) {
        return TypesUtilities.isPrimitive(code);
    }

    private String lowFirst(String t) {
        return t.substring(0, 1).toLowerCase() + t.substring(1);
    }

    public boolean isResource() {
        if (this.definition.getType().size() > 0) {
            return this.definition.getType().size() == 1 && ("Resource".equals(this.definition.getType().get(0).getCode()) || "DomainResource".equals(this.definition.getType().get(0).getCode()));
        }
        return !this.definition.getPath().contains(".") && (this.structure.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE || this.structure.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL);
    }

    public boolean isList() {
        return !"1".equals(this.definition.getMax());
    }

    public String getScopedPropertyName() {
        return this.definition.getBase().getPath();
    }

    public String getNamespace() {
        if (ToolingExtensions.hasExtension(this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension(this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        if (ToolingExtensions.hasExtension(this.structure, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension(this.structure, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        return "http://hl7.org/fhir";
    }

    private boolean isElementWithOnlyExtension(ElementDefinition ed, List<ElementDefinition> children) {
        boolean result = false;
        if (!ed.getType().isEmpty()) {
            result = true;
            for (ElementDefinition ele : children) {
                if (ele.getPath().contains("extension")) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean IsLogicalAndHasPrimitiveValue(String name) {
        this.canBePrimitive = false;
        if (this.structure.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        if (!this.hasType(name)) {
            return false;
        }
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, this.structure.getUrl().substring(0, this.structure.getUrl().lastIndexOf("/") + 1) + this.getType(name));
        if (sd == null) {
            sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(this.getType(name), this.context.getOverrideVersionNs()));
        }
        if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
            return true;
        }
        if (sd == null || sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(sd.getId() + ".value") || ed.getType().size() != 1 || !this.isPrimitive(ed.getType().get(0).getCode())) continue;
            this.canBePrimitive = true;
            return true;
        }
        return false;
    }

    public boolean isChoice() {
        if (this.definition.getType().size() <= 1) {
            return false;
        }
        String tn = this.definition.getType().get(0).getCode();
        for (int i = 1; i < this.definition.getType().size(); ++i) {
            if (this.definition.getType().get(i).getCode().equals(tn)) continue;
            return true;
        }
        return false;
    }

    protected List<Property> getChildProperties(String elementName, String statedType) throws FHIRException {
        ElementDefinition ed = this.definition;
        StructureDefinition sd = this.structure;
        List<ElementDefinition> children = this.profileUtilities.getChildMap(sd, ed);
        String url = null;
        if (children.isEmpty() || this.isElementWithOnlyExtension(ed, children)) {
            String t = null;
            if (ed.getType().size() == 1) {
                t = ed.getType().get(0).getWorkingCode();
            } else {
                if (ed.getType().size() == 0) {
                    throw new Error("types == 0, and no children found on " + this.getDefinition().getPath());
                }
                t = ed.getType().get(0).getWorkingCode();
                boolean all = true;
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    if (tr.getWorkingCode().equals(t)) continue;
                    all = false;
                    break;
                }
                if (!all) {
                    if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                        t = statedType;
                        if (t == null && ToolingExtensions.hasExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
                            t = ToolingExtensions.readStringExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
                        }
                        boolean ok = false;
                        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                            StructureDefinition sdt;
                            if (tr.getWorkingCode().equals(t)) {
                                ok = true;
                            }
                            if (Utilities.isAbsoluteUrl((String)tr.getWorkingCode()) && (sdt = this.context.fetchResource(StructureDefinition.class, tr.getWorkingCode())) != null && sdt.getType().equals(t)) {
                                url = tr.getWorkingCode();
                                ok = true;
                            }
                            if (!ok) continue;
                            break;
                        }
                        if (!ok) {
                            throw new DefinitionException("Type '" + t + "' is not an acceptable type for '" + elementName + "' on property " + this.definition.getPath());
                        }
                    } else {
                        t = elementName.substring(this.tail(ed.getPath()).length() - 3);
                        if (this.isPrimitive(this.lowFirst(t))) {
                            t = this.lowFirst(t);
                        }
                    }
                }
            }
            if (!"xhtml".equals(t)) {
                for (ElementDefinition.TypeRefComponent aType : ed.getType()) {
                    if (!aType.getWorkingCode().equals(t)) continue;
                    if (aType.hasProfile()) {
                        assert (aType.getProfile().size() == 1);
                        url = (String)aType.getProfile().get(0).getValue();
                        break;
                    }
                    url = ProfileUtilities.sdNs(t, this.context.getOverrideVersionNs());
                    break;
                }
                if (url == null) {
                    throw new FHIRException("Unable to find type " + t + " for element " + elementName + " with path " + ed.getPath());
                }
                sd = this.context.fetchResource(StructureDefinition.class, url);
                if (sd == null) {
                    throw new DefinitionException("Unable to find type '" + t + "' for name '" + elementName + "' on property " + this.definition.getPath());
                }
                children = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElement().get(0));
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (ElementDefinition child : children) {
            properties.add(new Property(this.context, child, sd));
        }
        return properties;
    }

    protected List<Property> getChildProperties(TypeDetails type) throws DefinitionException {
        StructureDefinition sd = this.structure;
        ElementDefinition ed = this.definition;
        List<ElementDefinition> children = this.profileUtilities.getChildMap(sd, ed);
        if (children.isEmpty()) {
            String t = null;
            if (ed.getType().size() == 1) {
                t = ed.getType().get(0).getCode();
            } else {
                if (ed.getType().size() == 0) {
                    throw new Error("types == 0, and no children found");
                }
                t = ed.getType().get(0).getCode();
                boolean all = true;
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    if (tr.getCode().equals(t)) continue;
                    all = false;
                    break;
                }
                if (!all) {
                    t = type.getType();
                }
            }
            if (!"xhtml".equals(t)) {
                sd = this.context.fetchResource(StructureDefinition.class, t);
                if (sd == null) {
                    throw new DefinitionException("Unable to find class '" + t + "' for name '" + ed.getPath() + "' on property " + this.definition.getPath());
                }
                children = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElement().get(0));
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (ElementDefinition child : children) {
            properties.add(new Property(this.context, child, sd));
        }
        return properties;
    }

    private String tail(String path) {
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : path;
    }

    public Property getChild(String elementName, String childName) throws FHIRException {
        List<Property> children = this.getChildProperties(elementName, null);
        for (Property p : children) {
            if (!p.getName().equals(childName)) continue;
            return p;
        }
        return null;
    }

    public Property getChild(String name, TypeDetails type) throws DefinitionException {
        List<Property> children = this.getChildProperties(type);
        for (Property p : children) {
            if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
            return p;
        }
        return null;
    }

    public Property getChild(String name) throws FHIRException {
        List<Property> children = this.getChildProperties(name, null);
        for (Property p : children) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Property getChildSimpleName(String elementName, String name) throws FHIRException {
        List<Property> children = this.getChildProperties(elementName, null);
        for (Property p : children) {
            if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
            return p;
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.definition.getPath();
    }
}

