/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUseStatement;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceFocus;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClinicalImpression", profile="http://hl7.org/fhir/StructureDefinition/ClinicalImpression")
public class ClinicalImpression
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", formalDefinition="Identifies the workflow status of the assessment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<Enumerations.EventStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the ClinicalImpression.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-status-reason")
    protected CodeableConcept statusReason;
    @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why/how the assessment was performed", formalDefinition="A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.")
    protected StringType description;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient or group assessed", formalDefinition="The patient or group of individuals assessed as part of this record.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Encounter during which this ClinicalImpression was created", formalDefinition="The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time of assessment", formalDefinition="The point in time or period over which the subject was assessed.")
    protected DataType effective;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the assessment was documented", formalDefinition="Indicates when the documentation of the assessment was complete.")
    protected DateTimeType date;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The clinician performing the assessment", formalDefinition="The clinician performing the assessment.")
    protected Reference performer;
    @Child(name="previous", type={ClinicalImpression.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to last assessment", formalDefinition="A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.")
    protected Reference previous;
    @Child(name="problem", type={Condition.class, AllergyIntolerance.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Relevant impressions of patient state", formalDefinition="A list of the relevant problems/conditions for a patient.")
    protected List<Reference> problem;
    @Child(name="protocol", type={UriType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Protocol followed", formalDefinition="Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.")
    protected List<UriType> protocol;
    @Child(name="summary", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Summary of the assessment", formalDefinition="A text summary of the investigations and the diagnosis.")
    protected StringType summary;
    @Child(name="finding", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Possible or likely findings and diagnoses", formalDefinition="Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.")
    protected List<ClinicalImpressionFindingComponent> finding;
    @Child(name="prognosisCodeableConcept", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Estimate of likely outcome", formalDefinition="Estimate of likely outcome.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-prognosis")
    protected List<CodeableConcept> prognosisCodeableConcept;
    @Child(name="prognosisReference", type={RiskAssessment.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="RiskAssessment expressing likely outcome", formalDefinition="RiskAssessment expressing likely outcome.")
    protected List<Reference> prognosisReference;
    @Child(name="supportingInfo", type={Reference.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information supporting the clinical impression", formalDefinition="Information supporting the clinical impression, which can contain investigation results.")
    protected List<Reference> supportingInfo;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the ClinicalImpression", formalDefinition="Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 2042987378L;
    @SearchParamDefinition(name="encounter", path="ClinicalImpression.encounter", description="The Encounter during which this ClinicalImpression was created", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ClinicalImpression:encounter").toLocked();
    @SearchParamDefinition(name="finding-code", path="ClinicalImpression.finding.item.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_FINDING_CODE = "finding-code";
    public static final TokenClientParam FINDING_CODE = new TokenClientParam("finding-code");
    @SearchParamDefinition(name="finding-ref", path="ClinicalImpression.finding.item.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_FINDING_REF = "finding-ref";
    public static final ReferenceClientParam FINDING_REF = new ReferenceClientParam("finding-ref");
    public static final Include INCLUDE_FINDING_REF = new Include("ClinicalImpression:finding-ref").toLocked();
    @SearchParamDefinition(name="identifier", path="ClinicalImpression.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="performer", path="ClinicalImpression.performer", description="The clinician performing the assessment", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("ClinicalImpression:performer").toLocked();
    @SearchParamDefinition(name="previous", path="ClinicalImpression.previous", description="Reference to last assessment", type="reference", target={ClinicalImpression.class})
    public static final String SP_PREVIOUS = "previous";
    public static final ReferenceClientParam PREVIOUS = new ReferenceClientParam("previous");
    public static final Include INCLUDE_PREVIOUS = new Include("ClinicalImpression:previous").toLocked();
    @SearchParamDefinition(name="problem", path="ClinicalImpression.problem", description="Relevant impressions of patient state", type="reference", target={AllergyIntolerance.class, Condition.class})
    public static final String SP_PROBLEM = "problem";
    public static final ReferenceClientParam PROBLEM = new ReferenceClientParam("problem");
    public static final Include INCLUDE_PROBLEM = new Include("ClinicalImpression:problem").toLocked();
    @SearchParamDefinition(name="status", path="ClinicalImpression.status", description="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="ClinicalImpression.subject", description="Patient or group assessed", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ClinicalImpression:subject").toLocked();
    @SearchParamDefinition(name="supporting-info", path="ClinicalImpression.supportingInfo", description="Information supporting the clinical impression", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceFocus.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUPPORTING_INFO = "supporting-info";
    public static final ReferenceClientParam SUPPORTING_INFO = new ReferenceClientParam("supporting-info");
    public static final Include INCLUDE_SUPPORTING_INFO = new Include("ClinicalImpression:supporting-info").toLocked();
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClinicalImpression:patient").toLocked();

    public ClinicalImpression() {
    }

    public ClinicalImpression(Enumerations.EventStatus status, Reference subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClinicalImpression setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClinicalImpression addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.EventStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClinicalImpression setStatusElement(Enumeration<Enumerations.EventStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.EventStatus getStatus() {
        return this.status == null ? null : (Enumerations.EventStatus)((Object)this.status.getValue());
    }

    public ClinicalImpression setStatus(Enumerations.EventStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public ClinicalImpression setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ClinicalImpression setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ClinicalImpression setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ClinicalImpression setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ClinicalImpression setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public ClinicalImpression setEffective(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for ClinicalImpression.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ClinicalImpression setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ClinicalImpression setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public ClinicalImpression setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Reference getPrevious() {
        if (this.previous == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.previous");
            }
            if (Configuration.doAutoCreate()) {
                this.previous = new Reference();
            }
        }
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null && !this.previous.isEmpty();
    }

    public ClinicalImpression setPrevious(Reference value) {
        this.previous = value;
        return this;
    }

    public List<Reference> getProblem() {
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        return this.problem;
    }

    public ClinicalImpression setProblem(List<Reference> theProblem) {
        this.problem = theProblem;
        return this;
    }

    public boolean hasProblem() {
        if (this.problem == null) {
            return false;
        }
        for (Reference item : this.problem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProblem() {
        Reference t = new Reference();
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return t;
    }

    public ClinicalImpression addProblem(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return this;
    }

    public Reference getProblemFirstRep() {
        if (this.getProblem().isEmpty()) {
            this.addProblem();
        }
        return this.getProblem().get(0);
    }

    public List<UriType> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        return this.protocol;
    }

    public ClinicalImpression setProtocol(List<UriType> theProtocol) {
        this.protocol = theProtocol;
        return this;
    }

    public boolean hasProtocol() {
        if (this.protocol == null) {
            return false;
        }
        for (UriType item : this.protocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addProtocolElement() {
        UriType t = new UriType();
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        this.protocol.add(t);
        return t;
    }

    public ClinicalImpression addProtocol(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        this.protocol.add(t);
        return this;
    }

    public boolean hasProtocol(String value) {
        if (this.protocol == null) {
            return false;
        }
        for (UriType v : this.protocol) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getSummaryElement() {
        if (this.summary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.summary");
            }
            if (Configuration.doAutoCreate()) {
                this.summary = new StringType();
            }
        }
        return this.summary;
    }

    public boolean hasSummaryElement() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public boolean hasSummary() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public ClinicalImpression setSummaryElement(StringType value) {
        this.summary = value;
        return this;
    }

    public String getSummary() {
        return this.summary == null ? null : (String)this.summary.getValue();
    }

    public ClinicalImpression setSummary(String value) {
        if (Utilities.noString((String)value)) {
            this.summary = null;
        } else {
            if (this.summary == null) {
                this.summary = new StringType();
            }
            this.summary.setValue(value);
        }
        return this;
    }

    public List<ClinicalImpressionFindingComponent> getFinding() {
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        return this.finding;
    }

    public ClinicalImpression setFinding(List<ClinicalImpressionFindingComponent> theFinding) {
        this.finding = theFinding;
        return this;
    }

    public boolean hasFinding() {
        if (this.finding == null) {
            return false;
        }
        for (ClinicalImpressionFindingComponent item : this.finding) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionFindingComponent addFinding() {
        ClinicalImpressionFindingComponent t = new ClinicalImpressionFindingComponent();
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return t;
    }

    public ClinicalImpression addFinding(ClinicalImpressionFindingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return this;
    }

    public ClinicalImpressionFindingComponent getFindingFirstRep() {
        if (this.getFinding().isEmpty()) {
            this.addFinding();
        }
        return this.getFinding().get(0);
    }

    public List<CodeableConcept> getPrognosisCodeableConcept() {
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        return this.prognosisCodeableConcept;
    }

    public ClinicalImpression setPrognosisCodeableConcept(List<CodeableConcept> thePrognosisCodeableConcept) {
        this.prognosisCodeableConcept = thePrognosisCodeableConcept;
        return this;
    }

    public boolean hasPrognosisCodeableConcept() {
        if (this.prognosisCodeableConcept == null) {
            return false;
        }
        for (CodeableConcept item : this.prognosisCodeableConcept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPrognosisCodeableConcept() {
        CodeableConcept t = new CodeableConcept();
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        this.prognosisCodeableConcept.add(t);
        return t;
    }

    public ClinicalImpression addPrognosisCodeableConcept(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        this.prognosisCodeableConcept.add(t);
        return this;
    }

    public CodeableConcept getPrognosisCodeableConceptFirstRep() {
        if (this.getPrognosisCodeableConcept().isEmpty()) {
            this.addPrognosisCodeableConcept();
        }
        return this.getPrognosisCodeableConcept().get(0);
    }

    public List<Reference> getPrognosisReference() {
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        return this.prognosisReference;
    }

    public ClinicalImpression setPrognosisReference(List<Reference> thePrognosisReference) {
        this.prognosisReference = thePrognosisReference;
        return this;
    }

    public boolean hasPrognosisReference() {
        if (this.prognosisReference == null) {
            return false;
        }
        for (Reference item : this.prognosisReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPrognosisReference() {
        Reference t = new Reference();
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        this.prognosisReference.add(t);
        return t;
    }

    public ClinicalImpression addPrognosisReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        this.prognosisReference.add(t);
        return this;
    }

    public Reference getPrognosisReferenceFirstRep() {
        if (this.getPrognosisReference().isEmpty()) {
            this.addPrognosisReference();
        }
        return this.getPrognosisReference().get(0);
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public ClinicalImpression setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public ClinicalImpression addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ClinicalImpression setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ClinicalImpression addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Identifies the workflow status of the assessment.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the ClinicalImpression.", 0, 1, this.statusReason));
        children.add(new Property("description", "string", "A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.", 0, 1, this.description));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group of individuals assessed as part of this record.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective));
        children.add(new Property(SP_DATE, "dateTime", "Indicates when the documentation of the assessment was complete.", 0, 1, this.date));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole)", "The clinician performing the assessment.", 0, 1, this.performer));
        children.add(new Property(SP_PREVIOUS, "Reference(ClinicalImpression)", "A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.", 0, 1, this.previous));
        children.add(new Property(SP_PROBLEM, "Reference(Condition|AllergyIntolerance)", "A list of the relevant problems/conditions for a patient.", 0, Integer.MAX_VALUE, this.problem));
        children.add(new Property("protocol", "uri", "Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.", 0, Integer.MAX_VALUE, this.protocol));
        children.add(new Property("summary", "string", "A text summary of the investigations and the diagnosis.", 0, 1, this.summary));
        children.add(new Property("finding", "", "Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.", 0, Integer.MAX_VALUE, this.finding));
        children.add(new Property("prognosisCodeableConcept", "CodeableConcept", "Estimate of likely outcome.", 0, Integer.MAX_VALUE, this.prognosisCodeableConcept));
        children.add(new Property("prognosisReference", "Reference(RiskAssessment)", "RiskAssessment expressing likely outcome.", 0, Integer.MAX_VALUE, this.prognosisReference));
        children.add(new Property("supportingInfo", "Reference(Any)", "Information supporting the clinical impression, which can contain investigation results.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("note", "Annotation", "Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Identifies the workflow status of the assessment.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the ClinicalImpression.", 0, 1, this.statusReason);
            }
            case -1724546052: {
                return new Property("description", "string", "A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.", 0, 1, this.description);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group of individuals assessed as part of this record.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "Indicates when the documentation of the assessment was complete.", 0, 1, this.date);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole)", "The clinician performing the assessment.", 0, 1, this.performer);
            }
            case -1273775369: {
                return new Property(SP_PREVIOUS, "Reference(ClinicalImpression)", "A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.", 0, 1, this.previous);
            }
            case -309542241: {
                return new Property(SP_PROBLEM, "Reference(Condition|AllergyIntolerance)", "A list of the relevant problems/conditions for a patient.", 0, Integer.MAX_VALUE, this.problem);
            }
            case -989163880: {
                return new Property("protocol", "uri", "Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.", 0, Integer.MAX_VALUE, this.protocol);
            }
            case -1857640538: {
                return new Property("summary", "string", "A text summary of the investigations and the diagnosis.", 0, 1, this.summary);
            }
            case -853173367: {
                return new Property("finding", "", "Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.", 0, Integer.MAX_VALUE, this.finding);
            }
            case -676337953: {
                return new Property("prognosisCodeableConcept", "CodeableConcept", "Estimate of likely outcome.", 0, Integer.MAX_VALUE, this.prognosisCodeableConcept);
            }
            case -587137783: {
                return new Property("prognosisReference", "Reference(RiskAssessment)", "RiskAssessment expressing likely outcome.", 0, Integer.MAX_VALUE, this.prognosisReference);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Information supporting the clinical impression, which can contain investigation results.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.effective;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.performer;
                }
                return baseArray;
            }
            case -1273775369: {
                Base[] baseArray;
                if (this.previous == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.previous;
                }
                return baseArray;
            }
            case -309542241: {
                return this.problem == null ? new Base[]{} : this.problem.toArray(new Base[this.problem.size()]);
            }
            case -989163880: {
                return this.protocol == null ? new Base[]{} : this.protocol.toArray(new Base[this.protocol.size()]);
            }
            case -1857640538: {
                Base[] baseArray;
                if (this.summary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.summary;
                }
                return baseArray;
            }
            case -853173367: {
                return this.finding == null ? new Base[]{} : this.finding.toArray(new Base[this.finding.size()]);
            }
            case -676337953: {
                return this.prognosisCodeableConcept == null ? new Base[]{} : this.prognosisCodeableConcept.toArray(new Base[this.prognosisCodeableConcept.size()]);
            }
            case -587137783: {
                return this.prognosisReference == null ? new Base[]{} : this.prognosisReference.toArray(new Base[this.prognosisReference.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 481140686: {
                this.performer = TypeConvertor.castToReference(value);
                return value;
            }
            case -1273775369: {
                this.previous = TypeConvertor.castToReference(value);
                return value;
            }
            case -309542241: {
                this.getProblem().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -989163880: {
                this.getProtocol().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -1857640538: {
                this.summary = TypeConvertor.castToString(value);
                return value;
            }
            case -853173367: {
                this.getFinding().add((ClinicalImpressionFindingComponent)((Object)value));
                return value;
            }
            case -676337953: {
                this.getPrognosisCodeableConcept().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -587137783: {
                this.getPrognosisReference().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PREVIOUS)) {
            this.previous = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PROBLEM)) {
            this.getProblem().add(TypeConvertor.castToReference(value));
        } else if (name.equals("protocol")) {
            this.getProtocol().add(TypeConvertor.castToUri(value));
        } else if (name.equals("summary")) {
            this.summary = TypeConvertor.castToString(value);
        } else if (name.equals("finding")) {
            this.getFinding().add((ClinicalImpressionFindingComponent)((Object)value));
        } else if (name.equals("prognosisCodeableConcept")) {
            this.getPrognosisCodeableConcept().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("prognosisReference")) {
            this.getPrognosisReference().add(TypeConvertor.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -1273775369: {
                return this.getPrevious();
            }
            case -309542241: {
                return this.addProblem();
            }
            case -989163880: {
                return this.addProtocolElement();
            }
            case -1857640538: {
                return this.getSummaryElement();
            }
            case -853173367: {
                return this.addFinding();
            }
            case -676337953: {
                return this.addPrognosisCodeableConcept();
            }
            case -587137783: {
                return this.addPrognosisReference();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -1273775369: {
                return new String[]{"Reference"};
            }
            case -309542241: {
                return new String[]{"Reference"};
            }
            case -989163880: {
                return new String[]{"uri"};
            }
            case -1857640538: {
                return new String[]{"string"};
            }
            case -853173367: {
                return new String[0];
            }
            case -676337953: {
                return new String[]{"CodeableConcept"};
            }
            case -587137783: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.description");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.date");
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals(SP_PREVIOUS)) {
            this.previous = new Reference();
            return this.previous;
        }
        if (name.equals(SP_PROBLEM)) {
            return this.addProblem();
        }
        if (name.equals("protocol")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.protocol");
        }
        if (name.equals("summary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.summary");
        }
        if (name.equals("finding")) {
            return this.addFinding();
        }
        if (name.equals("prognosisCodeableConcept")) {
            return this.addPrognosisCodeableConcept();
        }
        if (name.equals("prognosisReference")) {
            return this.addPrognosisReference();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClinicalImpression";
    }

    @Override
    public ClinicalImpression copy() {
        ClinicalImpression dst = new ClinicalImpression();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ClinicalImpression dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        Reference reference = dst.previous = this.previous == null ? null : this.previous.copy();
        if (this.problem != null) {
            dst.problem = new ArrayList<Reference>();
            for (Reference reference2 : this.problem) {
                dst.problem.add(reference2.copy());
            }
        }
        if (this.protocol != null) {
            dst.protocol = new ArrayList<UriType>();
            for (UriType uriType : this.protocol) {
                dst.protocol.add(uriType.copy());
            }
        }
        StringType stringType = dst.summary = this.summary == null ? null : this.summary.copy();
        if (this.finding != null) {
            dst.finding = new ArrayList<ClinicalImpressionFindingComponent>();
            for (ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : this.finding) {
                dst.finding.add(clinicalImpressionFindingComponent.copy());
            }
        }
        if (this.prognosisCodeableConcept != null) {
            dst.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.prognosisCodeableConcept) {
                dst.prognosisCodeableConcept.add(codeableConcept.copy());
            }
        }
        if (this.prognosisReference != null) {
            dst.prognosisReference = new ArrayList<Reference>();
            for (Reference reference3 : this.prognosisReference) {
                dst.prognosisReference.add(reference3.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference4 : this.supportingInfo) {
                dst.supportingInfo.add(reference4.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected ClinicalImpression typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other_;
        return ClinicalImpression.compareDeep(this.identifier, o.identifier, true) && ClinicalImpression.compareDeep(this.status, o.status, true) && ClinicalImpression.compareDeep(this.statusReason, o.statusReason, true) && ClinicalImpression.compareDeep(this.description, o.description, true) && ClinicalImpression.compareDeep(this.subject, o.subject, true) && ClinicalImpression.compareDeep(this.encounter, o.encounter, true) && ClinicalImpression.compareDeep(this.effective, o.effective, true) && ClinicalImpression.compareDeep(this.date, o.date, true) && ClinicalImpression.compareDeep(this.performer, o.performer, true) && ClinicalImpression.compareDeep(this.previous, o.previous, true) && ClinicalImpression.compareDeep(this.problem, o.problem, true) && ClinicalImpression.compareDeep(this.protocol, o.protocol, true) && ClinicalImpression.compareDeep(this.summary, o.summary, true) && ClinicalImpression.compareDeep(this.finding, o.finding, true) && ClinicalImpression.compareDeep(this.prognosisCodeableConcept, o.prognosisCodeableConcept, true) && ClinicalImpression.compareDeep(this.prognosisReference, o.prognosisReference, true) && ClinicalImpression.compareDeep(this.supportingInfo, o.supportingInfo, true) && ClinicalImpression.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other_;
        return ClinicalImpression.compareValues(this.status, o.status, true) && ClinicalImpression.compareValues(this.description, o.description, true) && ClinicalImpression.compareValues(this.date, o.date, true) && ClinicalImpression.compareValues(this.protocol, o.protocol, true) && ClinicalImpression.compareValues(this.summary, o.summary, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.statusReason, this.description, this.subject, this.encounter, this.effective, this.date, this.performer, this.previous, this.problem, this.protocol, this.summary, this.finding, this.prognosisCodeableConcept, this.prognosisReference, this.supportingInfo, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClinicalImpression;
    }

    @Block
    public static class ClinicalImpressionFindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What was found", formalDefinition="Specific text, code or reference for finding or diagnosis, which may include ruled-out or resolved conditions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected CodeableReference item;
        @Child(name="basis", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which investigations support finding", formalDefinition="Which investigations support finding or diagnosis.")
        protected StringType basis;
        private static final long serialVersionUID = -1363589306L;

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ClinicalImpressionFindingComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public StringType getBasisElement() {
            if (this.basis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.basis");
                }
                if (Configuration.doAutoCreate()) {
                    this.basis = new StringType();
                }
            }
            return this.basis;
        }

        public boolean hasBasisElement() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public boolean hasBasis() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public ClinicalImpressionFindingComponent setBasisElement(StringType value) {
            this.basis = value;
            return this;
        }

        public String getBasis() {
            return this.basis == null ? null : (String)this.basis.getValue();
        }

        public ClinicalImpressionFindingComponent setBasis(String value) {
            if (Utilities.noString((String)value)) {
                this.basis = null;
            } else {
                if (this.basis == null) {
                    this.basis = new StringType();
                }
                this.basis.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(Condition|Observation|DocumentReference)", "Specific text, code or reference for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.item));
            children.add(new Property("basis", "string", "Which investigations support finding or diagnosis.", 0, 1, this.basis));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(Condition|Observation|DocumentReference)", "Specific text, code or reference for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.item);
                }
                case 93508670: {
                    return new Property("basis", "string", "Which investigations support finding or diagnosis.", 0, 1, this.basis);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case 93508670: {
                    Base[] baseArray;
                    if (this.basis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.basis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 93508670: {
                    this.basis = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("basis")) {
                this.basis = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case 93508670: {
                    return this.getBasisElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case 93508670: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("basis")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.finding.basis");
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionFindingComponent copy() {
            ClinicalImpressionFindingComponent dst = new ClinicalImpressionFindingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalImpressionFindingComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.basis = this.basis == null ? null : this.basis.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other_;
            return ClinicalImpressionFindingComponent.compareDeep(this.item, o.item, true) && ClinicalImpressionFindingComponent.compareDeep(this.basis, o.basis, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other_;
            return ClinicalImpressionFindingComponent.compareValues(this.basis, o.basis, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.basis});
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.finding";
        }
    }
}

