/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="Flag", profile="http://hl7.org/fhir/StructureDefinition/Flag")
public class Flag
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifiers assigned to this flag by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="Supports basic workflow.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/flag-status")
    protected Enumeration<FlagStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical, administrative, etc.", formalDefinition="Allows a flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/flag-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coded or textual message to display to user", formalDefinition="The coded value or textual component of the flag to display to the user.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/flag-code")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Location.class, Group.class, Organization.class, Practitioner.class, PractitionerRole.class, PlanDefinition.class, Medication.class, Procedure.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What is flag about?", formalDefinition="The patient, location, group, organization, or practitioner etc. this is about record this flag is associated with.")
    protected Reference subject;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when flag is active", formalDefinition="The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.")
    protected Period period;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Alert relevant during encounter", formalDefinition="This alert is only relevant during the encounter.")
    protected Reference encounter;
    @Child(name="author", type={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Flag creator", formalDefinition="The person, organization or device that created the flag.")
    protected Reference author;
    private static final long serialVersionUID = -901823137L;
    @SearchParamDefinition(name="author", path="Flag.author", description="Flag creator", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Flag:author").toLocked();
    @SearchParamDefinition(name="identifier", path="Flag.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Flag.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Flag.subject", description="The identity of a subject to list flags for", type="reference", target={Group.class, Location.class, Medication.class, Organization.class, Patient.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Flag:subject").toLocked();
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.context.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Flag:encounter").toLocked();
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Flag:patient").toLocked();

    public Flag() {
    }

    public Flag(FlagStatus status, CodeableConcept code, Reference subject) {
        this.setStatus(status);
        this.setCode(code);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Flag setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Flag addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<FlagStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FlagStatus>(new FlagStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Flag setStatusElement(Enumeration<FlagStatus> value) {
        this.status = value;
        return this;
    }

    public FlagStatus getStatus() {
        return this.status == null ? null : (FlagStatus)((Object)this.status.getValue());
    }

    public Flag setStatus(FlagStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<FlagStatus>(new FlagStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Flag setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Flag addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Flag setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Flag setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Flag setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Flag setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Flag.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Flag setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this flag by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Supports basic workflow.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "Allows a flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("code", "CodeableConcept", "The coded value or textual component of the flag to display to the user.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Location|Group|Organization|Practitioner|PractitionerRole|PlanDefinition|Medication|Procedure)", "The patient, location, group, organization, or practitioner etc. this is about record this flag is associated with.", 0, 1, this.subject));
        children.add(new Property("period", "Period", "The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.", 0, 1, this.period));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "This alert is only relevant during the encounter.", 0, 1, this.encounter));
        children.add(new Property(SP_AUTHOR, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole)", "The person, organization or device that created the flag.", 0, 1, this.author));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this flag by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Supports basic workflow.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Allows a flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The coded value or textual component of the flag to display to the user.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Location|Group|Organization|Practitioner|PractitionerRole|PlanDefinition|Medication|Procedure)", "The patient, location, group, organization, or practitioner etc. this is about record this flag is associated with.", 0, 1, this.subject);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.", 0, 1, this.period);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "This alert is only relevant during the encounter.", 0, 1, this.encounter);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole)", "The person, organization or device that created the flag.", 0, 1, this.author);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.author;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new FlagStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new FlagStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1406328437: {
                return this.getAuthor();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Flag.status");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Flag";
    }

    @Override
    public Flag copy() {
        Flag dst = new Flag();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Flag dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<FlagStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.author = this.author == null ? null : this.author.copy();
    }

    protected Flag typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Flag)) {
            return false;
        }
        Flag o = (Flag)other_;
        return Flag.compareDeep(this.identifier, o.identifier, true) && Flag.compareDeep(this.status, o.status, true) && Flag.compareDeep(this.category, o.category, true) && Flag.compareDeep(this.code, o.code, true) && Flag.compareDeep(this.subject, o.subject, true) && Flag.compareDeep(this.period, o.period, true) && Flag.compareDeep(this.encounter, o.encounter, true) && Flag.compareDeep(this.author, o.author, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Flag)) {
            return false;
        }
        Flag o = (Flag)other_;
        return Flag.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.code, this.subject, this.period, this.encounter, this.author});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Flag;
    }

    public static class FlagStatusEnumFactory
    implements EnumFactory<FlagStatus> {
        @Override
        public FlagStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FlagStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FlagStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FlagStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown FlagStatus code '" + codeString + "'");
        }

        public Enumeration<FlagStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FlagStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FlagStatus>(this, FlagStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown FlagStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FlagStatus code) {
            if (code == FlagStatus.ACTIVE) {
                return "active";
            }
            if (code == FlagStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FlagStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(FlagStatus code) {
            return code.getSystem();
        }
    }

    public static enum FlagStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static FlagStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FlagStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/flag-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/flag-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/flag-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "A current flag that should be displayed to a user. A system may use the category to determine which user roles should view the flag.";
                }
                case INACTIVE: {
                    return "The flag no longer needs to be displayed.";
                }
                case ENTEREDINERROR: {
                    return "The flag was added in error and should no longer be displayed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

