/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PackagedProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/PackagedProductDefinition")
public class PackagedProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name for this product pack. Typically what it would be listed as in a drug formulary", formalDefinition="A name for this product pack. Typically what it would be listed as in a drug formulary.")
    protected StringType name;
    @Child(name="subject", type={MedicinalProductDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product that this is a pack for", formalDefinition="The product that this is a pack for.")
    protected List<Reference> subject;
    @Child(name="status", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization or marketing status", formalDefinition="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization or marketing status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status became applicable", formalDefinition="The date at which the given status became applicable.")
    protected DateTimeType statusDate;
    @Child(name="description", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description. Note that this is not the name of the product", formalDefinition="Textual description. Note that this is not the name of the product.")
    protected MarkdownType description;
    @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the medicinal product as classified by the regulator", formalDefinition="The legal status of supply of the medicinal product as classified by the regulator.")
    protected CodeableConcept legalStatusOfSupply;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing information", formalDefinition="Marketing information.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="characteristic", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the key product features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\"", formalDefinition="Allows the key product features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".")
    protected List<CodeableConcept> characteristic;
    @Child(name="copackagedIndicator", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="States whether a drug product is supplied with another item such as a diluent or adjuvant", formalDefinition="States whether a drug product is supplied with another item such as a diluent or adjuvant.")
    protected BooleanType copackagedIndicator;
    @Child(name="marketingAuthorization", type={RegulatedAuthorization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
    protected Reference marketingAuthorization;
    @Child(name="manufacturer", type={Organization.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
    protected List<Reference> manufacturer;
    @Child(name="batchIdentifier", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Batch numbering", formalDefinition="Batch numbering.")
    protected List<PackagedProductDefinitionBatchIdentifierComponent> batchIdentifier;
    @Child(name="package", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within", formalDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within.")
    protected List<PackagedProductDefinitionPackageComponent> package_;
    private static final long serialVersionUID = 1013618678L;
    @SearchParamDefinition(name="device", path="", description="A device associated within packaged product", type="reference", target={DeviceDefinition.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("PackagedProductDefinition:device").toLocked();
    @SearchParamDefinition(name="identifier", path="PackagedProductDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manufactured-item", path="", description="A manufactured item of medication within this packaged product", type="reference", target={ManufacturedItemDefinition.class})
    public static final String SP_MANUFACTURED_ITEM = "manufactured-item";
    public static final ReferenceClientParam MANUFACTURED_ITEM = new ReferenceClientParam("manufactured-item");
    public static final Include INCLUDE_MANUFACTURED_ITEM = new Include("PackagedProductDefinition:manufactured-item").toLocked();
    @SearchParamDefinition(name="name", path="PackagedProductDefinition.name", description="A name for this product pack. Typically what it would be listed as in a drug formulary", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="status", path="PackagedProductDefinition.status", description="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization or marketing status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="PackagedProductDefinition.subject", description="The product that this is a pack for", type="reference", target={MedicinalProductDefinition.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("PackagedProductDefinition:subject").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PackagedProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PackagedProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public PackagedProductDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public PackagedProductDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public PackagedProductDefinition setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public PackagedProductDefinition addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PackagedProductDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public PackagedProductDefinition setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public PackagedProductDefinition setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public PackagedProductDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public PackagedProductDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.legalStatusOfSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.legalStatusOfSupply = new CodeableConcept();
            }
        }
        return this.legalStatusOfSupply;
    }

    public boolean hasLegalStatusOfSupply() {
        return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
    }

    public PackagedProductDefinition setLegalStatusOfSupply(CodeableConcept value) {
        this.legalStatusOfSupply = value;
        return this;
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public PackagedProductDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public PackagedProductDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public PackagedProductDefinition setCharacteristic(List<CodeableConcept> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public PackagedProductDefinition addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public CodeableConcept getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public BooleanType getCopackagedIndicatorElement() {
        if (this.copackagedIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.copackagedIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.copackagedIndicator = new BooleanType();
            }
        }
        return this.copackagedIndicator;
    }

    public boolean hasCopackagedIndicatorElement() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public boolean hasCopackagedIndicator() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public PackagedProductDefinition setCopackagedIndicatorElement(BooleanType value) {
        this.copackagedIndicator = value;
        return this;
    }

    public boolean getCopackagedIndicator() {
        return this.copackagedIndicator == null || this.copackagedIndicator.isEmpty() ? false : (Boolean)this.copackagedIndicator.getValue();
    }

    public PackagedProductDefinition setCopackagedIndicator(boolean value) {
        if (this.copackagedIndicator == null) {
            this.copackagedIndicator = new BooleanType();
        }
        this.copackagedIndicator.setValue((Object)value);
        return this;
    }

    public Reference getMarketingAuthorization() {
        if (this.marketingAuthorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorization = new Reference();
            }
        }
        return this.marketingAuthorization;
    }

    public boolean hasMarketingAuthorization() {
        return this.marketingAuthorization != null && !this.marketingAuthorization.isEmpty();
    }

    public PackagedProductDefinition setMarketingAuthorization(Reference value) {
        this.marketingAuthorization = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public PackagedProductDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public PackagedProductDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<PackagedProductDefinitionBatchIdentifierComponent> getBatchIdentifier() {
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<PackagedProductDefinitionBatchIdentifierComponent>();
        }
        return this.batchIdentifier;
    }

    public PackagedProductDefinition setBatchIdentifier(List<PackagedProductDefinitionBatchIdentifierComponent> theBatchIdentifier) {
        this.batchIdentifier = theBatchIdentifier;
        return this;
    }

    public boolean hasBatchIdentifier() {
        if (this.batchIdentifier == null) {
            return false;
        }
        for (PackagedProductDefinitionBatchIdentifierComponent item : this.batchIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PackagedProductDefinitionBatchIdentifierComponent addBatchIdentifier() {
        PackagedProductDefinitionBatchIdentifierComponent t = new PackagedProductDefinitionBatchIdentifierComponent();
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<PackagedProductDefinitionBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return t;
    }

    public PackagedProductDefinition addBatchIdentifier(PackagedProductDefinitionBatchIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<PackagedProductDefinitionBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return this;
    }

    public PackagedProductDefinitionBatchIdentifierComponent getBatchIdentifierFirstRep() {
        if (this.getBatchIdentifier().isEmpty()) {
            this.addBatchIdentifier();
        }
        return this.getBatchIdentifier().get(0);
    }

    public List<PackagedProductDefinitionPackageComponent> getPackage() {
        if (this.package_ == null) {
            this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
        }
        return this.package_;
    }

    public PackagedProductDefinition setPackage(List<PackagedProductDefinitionPackageComponent> thePackage) {
        this.package_ = thePackage;
        return this;
    }

    public boolean hasPackage() {
        if (this.package_ == null) {
            return false;
        }
        for (PackagedProductDefinitionPackageComponent item : this.package_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PackagedProductDefinitionPackageComponent addPackage() {
        PackagedProductDefinitionPackageComponent t = new PackagedProductDefinitionPackageComponent();
        if (this.package_ == null) {
            this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
        }
        this.package_.add(t);
        return t;
    }

    public PackagedProductDefinition addPackage(PackagedProductDefinitionPackageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.package_ == null) {
            this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
        }
        this.package_.add(t);
        return this;
    }

    public PackagedProductDefinitionPackageComponent getPackageFirstRep() {
        if (this.getPackage().isEmpty()) {
            this.addPackage();
        }
        return this.getPackage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_NAME, "string", "A name for this product pack. Typically what it would be listed as in a drug formulary.", 0, 1, this.name));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pack for.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization or marketing status.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate));
        children.add(new Property("description", "markdown", "Textual description. Note that this is not the name of the product.", 0, 1, this.description));
        children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("characteristic", "CodeableConcept", "Allows the key product features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("copackagedIndicator", "boolean", "States whether a drug product is supplied with another item such as a diluent or adjuvant.", 0, 1, this.copackagedIndicator));
        children.add(new Property("marketingAuthorization", "Reference(RegulatedAuthorization)", "Manufacturer of this Package Item.", 0, 1, this.marketingAuthorization));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier));
        children.add(new Property("package", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.package_));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A name for this product pack. Typically what it would be listed as in a drug formulary.", 0, 1, this.name);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pack for.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization or marketing status.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Textual description. Note that this is not the name of the product.", 0, 1, this.description);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case 366313883: {
                return new Property("characteristic", "CodeableConcept", "Allows the key product features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case -1638663195: {
                return new Property("copackagedIndicator", "boolean", "States whether a drug product is supplied with another item such as a diluent or adjuvant.", 0, 1, this.copackagedIndicator);
            }
            case 571831283: {
                return new Property("marketingAuthorization", "Reference(RegulatedAuthorization)", "Manufacturer of this Package Item.", 0, 1, this.marketingAuthorization);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -1688395901: {
                return new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier);
            }
            case -807062458: {
                return new Property("package", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.package_);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -844874031: {
                Base[] baseArray;
                if (this.legalStatusOfSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.legalStatusOfSupply;
                }
                return baseArray;
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case -1638663195: {
                Base[] baseArray;
                if (this.copackagedIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.copackagedIndicator;
                }
                return baseArray;
            }
            case 571831283: {
                Base[] baseArray;
                if (this.marketingAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.marketingAuthorization;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -1688395901: {
                return this.batchIdentifier == null ? new Base[]{} : this.batchIdentifier.toArray(new Base[this.batchIdentifier.size()]);
            }
            case -807062458: {
                return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -844874031: {
                this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1638663195: {
                this.copackagedIndicator = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 571831283: {
                this.marketingAuthorization = TypeConvertor.castToReference(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1688395901: {
                this.getBatchIdentifier().add((PackagedProductDefinitionBatchIdentifierComponent)value);
                return value;
            }
            case -807062458: {
                this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("copackagedIndicator")) {
            this.copackagedIndicator = TypeConvertor.castToBoolean(value);
        } else if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = TypeConvertor.castToReference(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("batchIdentifier")) {
            this.getBatchIdentifier().add((PackagedProductDefinitionBatchIdentifierComponent)value);
        } else if (name.equals("package")) {
            this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -844874031: {
                return this.getLegalStatusOfSupply();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case -1638663195: {
                return this.getCopackagedIndicatorElement();
            }
            case 571831283: {
                return this.getMarketingAuthorization();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -1688395901: {
                return this.addBatchIdentifier();
            }
            case -807062458: {
                return this.addPackage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -844874031: {
                return new String[]{"CodeableConcept"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case 366313883: {
                return new String[]{"CodeableConcept"};
            }
            case -1638663195: {
                return new String[]{"boolean"};
            }
            case 571831283: {
                return new String[]{"Reference"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -1688395901: {
                return new String[0];
            }
            case -807062458: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.name");
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.statusDate");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.description");
        }
        if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = new CodeableConcept();
            return this.legalStatusOfSupply;
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        if (name.equals("copackagedIndicator")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.copackagedIndicator");
        }
        if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = new Reference();
            return this.marketingAuthorization;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("batchIdentifier")) {
            return this.addBatchIdentifier();
        }
        if (name.equals("package")) {
            return this.addPackage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PackagedProductDefinition";
    }

    @Override
    public PackagedProductDefinition copy() {
        PackagedProductDefinition dst = new PackagedProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PackagedProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.description = this.description == null ? null : this.description.copy();
        CodeableConcept codeableConcept = dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.characteristic) {
                dst.characteristic.add(codeableConcept2.copy());
            }
        }
        dst.copackagedIndicator = this.copackagedIndicator == null ? null : this.copackagedIndicator.copy();
        Reference reference = dst.marketingAuthorization = this.marketingAuthorization == null ? null : this.marketingAuthorization.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference2 : this.manufacturer) {
                dst.manufacturer.add(reference2.copy());
            }
        }
        if (this.batchIdentifier != null) {
            dst.batchIdentifier = new ArrayList<PackagedProductDefinitionBatchIdentifierComponent>();
            for (PackagedProductDefinitionBatchIdentifierComponent packagedProductDefinitionBatchIdentifierComponent : this.batchIdentifier) {
                dst.batchIdentifier.add(packagedProductDefinitionBatchIdentifierComponent.copy());
            }
        }
        if (this.package_ != null) {
            dst.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            for (PackagedProductDefinitionPackageComponent packagedProductDefinitionPackageComponent : this.package_) {
                dst.package_.add(packagedProductDefinitionPackageComponent.copy());
            }
        }
    }

    protected PackagedProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinition.compareDeep(this.name, o.name, true) && PackagedProductDefinition.compareDeep(this.subject, o.subject, true) && PackagedProductDefinition.compareDeep(this.status, o.status, true) && PackagedProductDefinition.compareDeep(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareDeep(this.description, o.description, true) && PackagedProductDefinition.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && PackagedProductDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && PackagedProductDefinition.compareDeep(this.characteristic, o.characteristic, true) && PackagedProductDefinition.compareDeep(this.copackagedIndicator, o.copackagedIndicator, true) && PackagedProductDefinition.compareDeep(this.marketingAuthorization, o.marketingAuthorization, true) && PackagedProductDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinition.compareDeep(this.batchIdentifier, o.batchIdentifier, true) && PackagedProductDefinition.compareDeep(this.package_, o.package_, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareValues(this.name, o.name, true) && PackagedProductDefinition.compareValues(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareValues(this.description, o.description, true) && PackagedProductDefinition.compareValues(this.copackagedIndicator, o.copackagedIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.name, this.subject, this.status, this.statusDate, this.description, this.legalStatusOfSupply, this.marketingStatus, this.characteristic, this.copackagedIndicator, this.marketingAuthorization, this.manufacturer, this.batchIdentifier, this.package_});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PackagedProductDefinition;
    }

    @Block
    public static class PackagedProductDefinitionPackageContainedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={ManufacturedItemDefinition.class, DeviceDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The manufactured item or device as contained in the packaged medicinal product", formalDefinition="The manufactured item or device as contained in the packaged medicinal product.")
        protected List<Reference> item;
        @Child(name="amount", type={Quantity.class, IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The number of this type of item within this packaging", formalDefinition="The number of this type of item within this packaging.")
        protected DataType amount;
        private static final long serialVersionUID = 454818874L;

        public List<Reference> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            return this.item;
        }

        public PackagedProductDefinitionPackageContainedItemComponent setItem(List<Reference> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (Reference item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addItem() {
            Reference t = new Reference();
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageContainedItemComponent addItem(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return this;
        }

        public Reference getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        public DataType getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public IntegerType getAmountIntegerType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new IntegerType();
            }
            if (!(this.amount instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.amount;
        }

        public boolean hasAmountIntegerType() {
            return this != null && this.amount instanceof IntegerType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PackagedProductDefinitionPackageContainedItemComponent setAmount(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof IntegerType)) {
                throw new Error("Not the right type for PackagedProductDefinition.package.containedItem.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "Reference(ManufacturedItemDefinition|DeviceDefinition)", "The manufactured item or device as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.item));
            children.add(new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "Reference(ManufacturedItemDefinition|DeviceDefinition)", "The manufactured item or device as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.item);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case 2053191110: {
                    return new Property("amount[x]", "integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.getItem().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.getItem().add(TypeConvertor.castToReference(value));
            } else if (name.equals("amount[x]")) {
                this.amount = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.addItem();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                return this.addItem();
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountInteger")) {
                this.amount = new IntegerType();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackageContainedItemComponent copy() {
            PackagedProductDefinitionPackageContainedItemComponent dst = new PackagedProductDefinitionPackageContainedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackageContainedItemComponent dst) {
            super.copyValues(dst);
            if (this.item != null) {
                dst.item = new ArrayList<Reference>();
                for (Reference i : this.item) {
                    dst.item.add(i.copy());
                }
            }
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageContainedItemComponent o = (PackagedProductDefinitionPackageContainedItemComponent)other_;
            return PackagedProductDefinitionPackageContainedItemComponent.compareDeep(this.item, o.item, true) && PackagedProductDefinitionPackageContainedItemComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageContainedItemComponent o = (PackagedProductDefinitionPackageContainedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.item, this.amount});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package.containedItem";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackagePropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public PackagedProductDefinitionPackagePropertyComponent() {
        }

        public PackagedProductDefinitionPackagePropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagePropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackagePropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public PackagedProductDefinitionPackagePropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for PackagedProductDefinition.package.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackagePropertyComponent copy() {
            PackagedProductDefinitionPackagePropertyComponent dst = new PackagedProductDefinitionPackagePropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackagePropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagePropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagePropertyComponent o = (PackagedProductDefinitionPackagePropertyComponent)other_;
            return PackagedProductDefinitionPackagePropertyComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackagePropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagePropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagePropertyComponent o = (PackagedProductDefinitionPackagePropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package.property";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Including possibly Data Carrier Identifier", formalDefinition="Including possibly Data Carrier Identifier.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The physical type of the container of the medicine", formalDefinition="The physical type of the container of the medicine.")
        protected CodeableConcept type;
        @Child(name="quantity", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of this package in the medicinal product, at the current level of packaging. If specified, the outermost level is always 1", formalDefinition="The quantity of this package in the medicinal product, at the current level of packaging. If specified, the outermost level is always 1.")
        protected IntegerType quantity;
        @Child(name="material", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        protected List<CodeableConcept> material;
        @Child(name="alternateMaterial", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A possible alternate material for the packaging", formalDefinition="A possible alternate material for the packaging.")
        protected List<CodeableConcept> alternateMaterial;
        @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
        protected List<ProductShelfLife> shelfLifeStorage;
        @Child(name="manufacturer", type={Organization.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
        protected List<Reference> manufacturer;
        @Child(name="property", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
        protected List<PackagedProductDefinitionPackagePropertyComponent> property;
        @Child(name="containedItem", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The item(s) within the packaging", formalDefinition="The item(s) within the packaging.")
        protected List<PackagedProductDefinitionPackageContainedItemComponent> containedItem;
        @Child(name="package", type={PackagedProductDefinitionPackageComponent.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Allows containers within containers", formalDefinition="Allows containers within containers.")
        protected List<PackagedProductDefinitionPackageComponent> package_;
        private static final long serialVersionUID = 387482302L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public PackagedProductDefinitionPackageComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public IntegerType getQuantityElement() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackageComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new IntegerType();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantityElement() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public PackagedProductDefinitionPackageComponent setQuantityElement(IntegerType value) {
            this.quantity = value;
            return this;
        }

        public int getQuantity() {
            return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
        }

        public PackagedProductDefinitionPackageComponent setQuantity(int value) {
            if (this.quantity == null) {
                this.quantity = new IntegerType();
            }
            this.quantity.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getMaterial() {
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            return this.material;
        }

        public PackagedProductDefinitionPackageComponent setMaterial(List<CodeableConcept> theMaterial) {
            this.material = theMaterial;
            return this;
        }

        public boolean hasMaterial() {
            if (this.material == null) {
                return false;
            }
            for (CodeableConcept item : this.material) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return this;
        }

        public CodeableConcept getMaterialFirstRep() {
            if (this.getMaterial().isEmpty()) {
                this.addMaterial();
            }
            return this.getMaterial().get(0);
        }

        public List<CodeableConcept> getAlternateMaterial() {
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            return this.alternateMaterial;
        }

        public PackagedProductDefinitionPackageComponent setAlternateMaterial(List<CodeableConcept> theAlternateMaterial) {
            this.alternateMaterial = theAlternateMaterial;
            return this;
        }

        public boolean hasAlternateMaterial() {
            if (this.alternateMaterial == null) {
                return false;
            }
            for (CodeableConcept item : this.alternateMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAlternateMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addAlternateMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return this;
        }

        public CodeableConcept getAlternateMaterialFirstRep() {
            if (this.getAlternateMaterial().isEmpty()) {
                this.addAlternateMaterial();
            }
            return this.getAlternateMaterial().get(0);
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            return this.shelfLifeStorage;
        }

        public PackagedProductDefinitionPackageComponent setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
            this.shelfLifeStorage = theShelfLifeStorage;
            return this;
        }

        public boolean hasShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                return false;
            }
            for (ProductShelfLife item : this.shelfLifeStorage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductShelfLife addShelfLifeStorage() {
            ProductShelfLife t = new ProductShelfLife();
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addShelfLifeStorage(ProductShelfLife t) {
            if (t == null) {
                return this;
            }
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return this;
        }

        public ProductShelfLife getShelfLifeStorageFirstRep() {
            if (this.getShelfLifeStorage().isEmpty()) {
                this.addShelfLifeStorage();
            }
            return this.getShelfLifeStorage().get(0);
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public PackagedProductDefinitionPackageComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        public List<PackagedProductDefinitionPackagePropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            return this.property;
        }

        public PackagedProductDefinitionPackageComponent setProperty(List<PackagedProductDefinitionPackagePropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (PackagedProductDefinitionPackagePropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackagePropertyComponent addProperty() {
            PackagedProductDefinitionPackagePropertyComponent t = new PackagedProductDefinitionPackagePropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addProperty(PackagedProductDefinitionPackagePropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public PackagedProductDefinitionPackagePropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<PackagedProductDefinitionPackageContainedItemComponent> getContainedItem() {
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            return this.containedItem;
        }

        public PackagedProductDefinitionPackageComponent setContainedItem(List<PackagedProductDefinitionPackageContainedItemComponent> theContainedItem) {
            this.containedItem = theContainedItem;
            return this;
        }

        public boolean hasContainedItem() {
            if (this.containedItem == null) {
                return false;
            }
            for (PackagedProductDefinitionPackageContainedItemComponent item : this.containedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackageContainedItemComponent addContainedItem() {
            PackagedProductDefinitionPackageContainedItemComponent t = new PackagedProductDefinitionPackageContainedItemComponent();
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            this.containedItem.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addContainedItem(PackagedProductDefinitionPackageContainedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            this.containedItem.add(t);
            return this;
        }

        public PackagedProductDefinitionPackageContainedItemComponent getContainedItemFirstRep() {
            if (this.getContainedItem().isEmpty()) {
                this.addContainedItem();
            }
            return this.getContainedItem().get(0);
        }

        public List<PackagedProductDefinitionPackageComponent> getPackage() {
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            return this.package_;
        }

        public PackagedProductDefinitionPackageComponent setPackage(List<PackagedProductDefinitionPackageComponent> thePackage) {
            this.package_ = thePackage;
            return this;
        }

        public boolean hasPackage() {
            if (this.package_ == null) {
                return false;
            }
            for (PackagedProductDefinitionPackageComponent item : this.package_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackageComponent addPackage() {
            PackagedProductDefinitionPackageComponent t = new PackagedProductDefinitionPackageComponent();
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addPackage(PackagedProductDefinitionPackageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return this;
        }

        public PackagedProductDefinitionPackageComponent getPackageFirstRep() {
            if (this.getPackage().isEmpty()) {
                this.addPackage();
            }
            return this.getPackage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type));
            children.add(new Property("quantity", "integer", "The quantity of this package in the medicinal product, at the current level of packaging. If specified, the outermost level is always 1.", 0, 1, this.quantity));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material));
            children.add(new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial));
            children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
            children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem));
            children.add(new Property("package", "@PackagedProductDefinition.package", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.package_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "integer", "The quantity of this package in the medicinal product, at the current level of packaging. If specified, the outermost level is always 1.", 0, 1, this.quantity);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material);
                }
                case -1021448255: {
                    return new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial);
                }
                case 172049237: {
                    return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case -993141291: {
                    return new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property);
                }
                case 1953679910: {
                    return new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem);
                }
                case -807062458: {
                    return new Property("package", "@PackagedProductDefinition.package", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.package_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 299066663: {
                    return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
                }
                case -1021448255: {
                    return this.alternateMaterial == null ? new Base[]{} : this.alternateMaterial.toArray(new Base[this.alternateMaterial.size()]);
                }
                case 172049237: {
                    return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case 1953679910: {
                    return this.containedItem == null ? new Base[]{} : this.containedItem.toArray(new Base[this.containedItem.size()]);
                }
                case -807062458: {
                    return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 299066663: {
                    this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1021448255: {
                    this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 172049237: {
                    this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((PackagedProductDefinitionPackagePropertyComponent)value);
                    return value;
                }
                case 1953679910: {
                    this.getContainedItem().add((PackagedProductDefinitionPackageContainedItemComponent)value);
                    return value;
                }
                case -807062458: {
                    this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToInteger(value);
            } else if (name.equals("material")) {
                this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
            } else if (name.equals("property")) {
                this.getProperty().add((PackagedProductDefinitionPackagePropertyComponent)value);
            } else if (name.equals("containedItem")) {
                this.getContainedItem().add((PackagedProductDefinitionPackageContainedItemComponent)value);
            } else if (name.equals("package")) {
                this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantityElement();
                }
                case 299066663: {
                    return this.addMaterial();
                }
                case -1021448255: {
                    return this.addAlternateMaterial();
                }
                case 172049237: {
                    return this.addShelfLifeStorage();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case 1953679910: {
                    return this.addContainedItem();
                }
                case -807062458: {
                    return this.addPackage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"integer"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case -1021448255: {
                    return new String[]{"CodeableConcept"};
                }
                case 172049237: {
                    return new String[]{"ProductShelfLife"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case -993141291: {
                    return new String[0];
                }
                case 1953679910: {
                    return new String[0];
                }
                case -807062458: {
                    return new String[]{"@PackagedProductDefinition.package"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.package.quantity");
            }
            if (name.equals("material")) {
                return this.addMaterial();
            }
            if (name.equals("alternateMaterial")) {
                return this.addAlternateMaterial();
            }
            if (name.equals("shelfLifeStorage")) {
                return this.addShelfLifeStorage();
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("containedItem")) {
                return this.addContainedItem();
            }
            if (name.equals("package")) {
                return this.addPackage();
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackageComponent copy() {
            PackagedProductDefinitionPackageComponent dst = new PackagedProductDefinitionPackageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackageComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            IntegerType integerType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.material != null) {
                dst.material = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.material) {
                    dst.material.add(codeableConcept.copy());
                }
            }
            if (this.alternateMaterial != null) {
                dst.alternateMaterial = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.alternateMaterial) {
                    dst.alternateMaterial.add(codeableConcept.copy());
                }
            }
            if (this.shelfLifeStorage != null) {
                dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
                for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                    dst.shelfLifeStorage.add(productShelfLife.copy());
                }
            }
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference reference : this.manufacturer) {
                    dst.manufacturer.add(reference.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
                for (PackagedProductDefinitionPackagePropertyComponent packagedProductDefinitionPackagePropertyComponent : this.property) {
                    dst.property.add(packagedProductDefinitionPackagePropertyComponent.copy());
                }
            }
            if (this.containedItem != null) {
                dst.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
                for (PackagedProductDefinitionPackageContainedItemComponent packagedProductDefinitionPackageContainedItemComponent : this.containedItem) {
                    dst.containedItem.add(packagedProductDefinitionPackageContainedItemComponent.copy());
                }
            }
            if (this.package_ != null) {
                dst.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
                for (PackagedProductDefinitionPackageComponent packagedProductDefinitionPackageComponent : this.package_) {
                    dst.package_.add(packagedProductDefinitionPackageComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageComponent o = (PackagedProductDefinitionPackageComponent)other_;
            return PackagedProductDefinitionPackageComponent.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.quantity, o.quantity, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.material, o.material, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.alternateMaterial, o.alternateMaterial, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.property, o.property, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.containedItem, o.containedItem, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.package_, o.package_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageComponent o = (PackagedProductDefinitionPackageComponent)other_;
            return PackagedProductDefinitionPackageComponent.compareValues(this.quantity, o.quantity, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.shelfLifeStorage, this.manufacturer, this.property, this.containedItem, this.package_});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package";
        }
    }

    @Block
    public static class PackagedProductDefinitionBatchIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outerPackaging", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the outer packaging of a specific batch", formalDefinition="A number appearing on the outer packaging of a specific batch.")
        protected Identifier outerPackaging;
        @Child(name="immediatePackaging", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the immediate packaging (and not the outer packaging)", formalDefinition="A number appearing on the immediate packaging (and not the outer packaging).")
        protected Identifier immediatePackaging;
        private static final long serialVersionUID = 1187365068L;

        public PackagedProductDefinitionBatchIdentifierComponent() {
        }

        public PackagedProductDefinitionBatchIdentifierComponent(Identifier outerPackaging) {
            this.setOuterPackaging(outerPackaging);
        }

        public Identifier getOuterPackaging() {
            if (this.outerPackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionBatchIdentifierComponent.outerPackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.outerPackaging = new Identifier();
                }
            }
            return this.outerPackaging;
        }

        public boolean hasOuterPackaging() {
            return this.outerPackaging != null && !this.outerPackaging.isEmpty();
        }

        public PackagedProductDefinitionBatchIdentifierComponent setOuterPackaging(Identifier value) {
            this.outerPackaging = value;
            return this;
        }

        public Identifier getImmediatePackaging() {
            if (this.immediatePackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionBatchIdentifierComponent.immediatePackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.immediatePackaging = new Identifier();
                }
            }
            return this.immediatePackaging;
        }

        public boolean hasImmediatePackaging() {
            return this.immediatePackaging != null && !this.immediatePackaging.isEmpty();
        }

        public PackagedProductDefinitionBatchIdentifierComponent setImmediatePackaging(Identifier value) {
            this.immediatePackaging = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging));
            children.add(new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -682249912: {
                    return new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging);
                }
                case 721147602: {
                    return new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    Base[] baseArray;
                    if (this.outerPackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.outerPackaging;
                    }
                    return baseArray;
                }
                case 721147602: {
                    Base[] baseArray;
                    if (this.immediatePackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.immediatePackaging;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    this.outerPackaging = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 721147602: {
                    this.immediatePackaging = TypeConvertor.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("immediatePackaging")) {
                this.immediatePackaging = TypeConvertor.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return this.getOuterPackaging();
                }
                case 721147602: {
                    return this.getImmediatePackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return new String[]{"Identifier"};
                }
                case 721147602: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = new Identifier();
                return this.outerPackaging;
            }
            if (name.equals("immediatePackaging")) {
                this.immediatePackaging = new Identifier();
                return this.immediatePackaging;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionBatchIdentifierComponent copy() {
            PackagedProductDefinitionBatchIdentifierComponent dst = new PackagedProductDefinitionBatchIdentifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionBatchIdentifierComponent dst) {
            super.copyValues(dst);
            dst.outerPackaging = this.outerPackaging == null ? null : this.outerPackaging.copy();
            dst.immediatePackaging = this.immediatePackaging == null ? null : this.immediatePackaging.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionBatchIdentifierComponent)) {
                return false;
            }
            PackagedProductDefinitionBatchIdentifierComponent o = (PackagedProductDefinitionBatchIdentifierComponent)other_;
            return PackagedProductDefinitionBatchIdentifierComponent.compareDeep(this.outerPackaging, o.outerPackaging, true) && PackagedProductDefinitionBatchIdentifierComponent.compareDeep(this.immediatePackaging, o.immediatePackaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionBatchIdentifierComponent)) {
                return false;
            }
            PackagedProductDefinitionBatchIdentifierComponent o = (PackagedProductDefinitionBatchIdentifierComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.outerPackaging, this.immediatePackaging});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.batchIdentifier";
        }
    }
}

