/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Statistic")
public class Statistic
extends BackboneType
implements ICompositeType {
    @Child(name="description", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of content", formalDefinition="A description of the content value of the statistic.")
    protected StringType description;
    @Child(name="note", type={Annotation.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
    protected List<Annotation> note;
    @Child(name="statisticType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of statistic, eg relative risk", formalDefinition="Type of statistic, eg relative risk.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/statistic-type")
    protected CodeableConcept statisticType;
    @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Statistic value", formalDefinition="Statistic value.")
    protected Quantity quantity;
    @Child(name="sampleSize", type={}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of samples in the statistic", formalDefinition="Number of samples in the statistic.")
    protected StatisticSampleSizeComponent sampleSize;
    @Child(name="attributeEstimate", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An estimate of the precision of the statistic", formalDefinition="An estimate of the precision of the statistic.")
    protected List<StatisticAttributeEstimateComponent> attributeEstimate;
    private static final long serialVersionUID = 1999038309L;

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Statistic setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Statistic setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Statistic setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Statistic addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public CodeableConcept getStatisticType() {
        if (this.statisticType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.statisticType");
            }
            if (Configuration.doAutoCreate()) {
                this.statisticType = new CodeableConcept();
            }
        }
        return this.statisticType;
    }

    public boolean hasStatisticType() {
        return this.statisticType != null && !this.statisticType.isEmpty();
    }

    public Statistic setStatisticType(CodeableConcept value) {
        this.statisticType = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public Statistic setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public StatisticSampleSizeComponent getSampleSize() {
        if (this.sampleSize == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.sampleSize");
            }
            if (Configuration.doAutoCreate()) {
                this.sampleSize = new StatisticSampleSizeComponent();
            }
        }
        return this.sampleSize;
    }

    public boolean hasSampleSize() {
        return this.sampleSize != null && !this.sampleSize.isEmpty();
    }

    public Statistic setSampleSize(StatisticSampleSizeComponent value) {
        this.sampleSize = value;
        return this;
    }

    public List<StatisticAttributeEstimateComponent> getAttributeEstimate() {
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        return this.attributeEstimate;
    }

    public Statistic setAttributeEstimate(List<StatisticAttributeEstimateComponent> theAttributeEstimate) {
        this.attributeEstimate = theAttributeEstimate;
        return this;
    }

    public boolean hasAttributeEstimate() {
        if (this.attributeEstimate == null) {
            return false;
        }
        for (StatisticAttributeEstimateComponent item : this.attributeEstimate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StatisticAttributeEstimateComponent addAttributeEstimate() {
        StatisticAttributeEstimateComponent t = new StatisticAttributeEstimateComponent();
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        this.attributeEstimate.add(t);
        return t;
    }

    public Statistic addAttributeEstimate(StatisticAttributeEstimateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        this.attributeEstimate.add(t);
        return this;
    }

    public StatisticAttributeEstimateComponent getAttributeEstimateFirstRep() {
        if (this.getAttributeEstimate().isEmpty()) {
            this.addAttributeEstimate();
        }
        return this.getAttributeEstimate().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("description", "string", "A description of the content value of the statistic.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("statisticType", "CodeableConcept", "Type of statistic, eg relative risk.", 0, 1, this.statisticType));
        children.add(new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity));
        children.add(new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize));
        children.add(new Property("attributeEstimate", "", "An estimate of the precision of the statistic.", 0, Integer.MAX_VALUE, this.attributeEstimate));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1724546052: {
                return new Property("description", "string", "A description of the content value of the statistic.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -392342358: {
                return new Property("statisticType", "CodeableConcept", "Type of statistic, eg relative risk.", 0, 1, this.statisticType);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity);
            }
            case 143123659: {
                return new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize);
            }
            case -1539581980: {
                return new Property("attributeEstimate", "", "An estimate of the precision of the statistic.", 0, Integer.MAX_VALUE, this.attributeEstimate);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -392342358: {
                Base[] baseArray;
                if (this.statisticType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statisticType;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.quantity;
                }
                return baseArray;
            }
            case 143123659: {
                Base[] baseArray;
                if (this.sampleSize == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.sampleSize;
                }
                return baseArray;
            }
            case -1539581980: {
                return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -392342358: {
                this.statisticType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 143123659: {
                this.sampleSize = (StatisticSampleSizeComponent)value;
                return value;
            }
            case -1539581980: {
                this.getAttributeEstimate().add((StatisticAttributeEstimateComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("statisticType")) {
            this.statisticType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("sampleSize")) {
            this.sampleSize = (StatisticSampleSizeComponent)value;
        } else if (name.equals("attributeEstimate")) {
            this.getAttributeEstimate().add((StatisticAttributeEstimateComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -392342358: {
                return this.getStatisticType();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 143123659: {
                return this.getSampleSize();
            }
            case -1539581980: {
                return this.addAttributeEstimate();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return new String[]{"string"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -392342358: {
                return new String[]{"CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 143123659: {
                return new String[0];
            }
            case -1539581980: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Statistic.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("statisticType")) {
            this.statisticType = new CodeableConcept();
            return this.statisticType;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("sampleSize")) {
            this.sampleSize = new StatisticSampleSizeComponent();
            return this.sampleSize;
        }
        if (name.equals("attributeEstimate")) {
            return this.addAttributeEstimate();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Statistic";
    }

    @Override
    public Statistic copy() {
        Statistic dst = new Statistic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Statistic dst) {
        super.copyValues(dst);
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.statisticType = this.statisticType == null ? null : this.statisticType.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        StatisticSampleSizeComponent statisticSampleSizeComponent = dst.sampleSize = this.sampleSize == null ? null : this.sampleSize.copy();
        if (this.attributeEstimate != null) {
            dst.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
            for (StatisticAttributeEstimateComponent statisticAttributeEstimateComponent : this.attributeEstimate) {
                dst.attributeEstimate.add(statisticAttributeEstimateComponent.copy());
            }
        }
    }

    protected Statistic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Statistic)) {
            return false;
        }
        Statistic o = (Statistic)other_;
        return Statistic.compareDeep(this.description, o.description, true) && Statistic.compareDeep(this.note, o.note, true) && Statistic.compareDeep(this.statisticType, o.statisticType, true) && Statistic.compareDeep(this.quantity, o.quantity, true) && Statistic.compareDeep(this.sampleSize, o.sampleSize, true) && Statistic.compareDeep(this.attributeEstimate, o.attributeEstimate, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Statistic)) {
            return false;
        }
        Statistic o = (Statistic)other_;
        return Statistic.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.statisticType, this.quantity, this.sampleSize, this.attributeEstimate});
    }

    @Block
    public static class StatisticAttributeEstimateEstimateQualifierComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of the precision estimate", formalDefinition="Human-readable summary of the estimate.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the estimate", formalDefinition="Footnote or explanatory note about the estimate.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The estimateType of attribute estimate, eg confidence interval or p value type", formalDefinition="The estimateType of attribute estimate, eg confidence interval or p value type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure", formalDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.")
        protected Quantity quantity;
        @Child(name="level", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Level of confidence interval, eg 0.95 for 95% confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="range", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lower and upper bound values of the precision estimate", formalDefinition="Lower bound of confidence interval.")
        protected Range range;
        private static final long serialVersionUID = 1873606362L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateEstimateQualifierComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateEstimateQualifierComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateEstimateQualifierComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateEstimateQualifierComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateEstimateQualifierComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public StatisticAttributeEstimateEstimateQualifierComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "The estimateType of attribute estimate, eg confidence interval or p value type.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The estimateType of attribute estimate, eg confidence interval or p value type.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 108280125: {
                    return new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.level;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.range;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 102865796: {
                    this.level = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("level")) {
                this.level = TypeConvertor.castToDecimal(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 108280125: {
                    return this.getRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.estimateQualifier.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.estimateQualifier.level");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            return super.addChild(name);
        }

        @Override
        public StatisticAttributeEstimateEstimateQualifierComponent copy() {
            StatisticAttributeEstimateEstimateQualifierComponent dst = new StatisticAttributeEstimateEstimateQualifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticAttributeEstimateEstimateQualifierComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.level = this.level == null ? null : this.level.copy();
            dst.range = this.range == null ? null : this.range.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateEstimateQualifierComponent)) {
                return false;
            }
            StatisticAttributeEstimateEstimateQualifierComponent o = (StatisticAttributeEstimateEstimateQualifierComponent)other_;
            return StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.description, o.description, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.note, o.note, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.type, o.type, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.quantity, o.quantity, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.level, o.level, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareDeep(this.range, o.range, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateEstimateQualifierComponent)) {
                return false;
            }
            StatisticAttributeEstimateEstimateQualifierComponent o = (StatisticAttributeEstimateEstimateQualifierComponent)other_;
            return StatisticAttributeEstimateEstimateQualifierComponent.compareValues(this.description, o.description, true) && StatisticAttributeEstimateEstimateQualifierComponent.compareValues(this.level, o.level, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.quantity, this.level, this.range});
        }

        @Override
        public String fhirType() {
            return "Statistic.attributeEstimate.estimateQualifier";
        }
    }

    @Block
    public static class StatisticAttributeEstimateComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of the precision estimate", formalDefinition="Human-readable summary of the estimate.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the estimate", formalDefinition="Footnote or explanatory note about the estimate.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The estimateType of precision estimate, eg confidence interval or p value type", formalDefinition="The estimateType of precision estimate, eg confidence interval or p value type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The singular quantity of the precision estimate, for precision estimates represented as single values; also used to report unit of measure", formalDefinition="The singular quantity of the precision estimate, for precision estimates represented as single values; also used to report unit of measure.")
        protected Quantity quantity;
        @Child(name="level", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Level of confidence interval, eg 0.95 for 95% confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="range", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lower and upper bound values of the precision estimate", formalDefinition="Lower bound of confidence interval.")
        protected Range range;
        @Child(name="estimateQualifier", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="An estimate of the precision of the estimate", formalDefinition="An estimate of the precision of the estimate.")
        protected List<StatisticAttributeEstimateEstimateQualifierComponent> estimateQualifier;
        private static final long serialVersionUID = -682237703L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticAttributeEstimateComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticAttributeEstimateComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticAttributeEstimateComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticAttributeEstimateComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StatisticAttributeEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public StatisticAttributeEstimateComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public StatisticAttributeEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public StatisticAttributeEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public StatisticAttributeEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public StatisticAttributeEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public StatisticAttributeEstimateComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        public List<StatisticAttributeEstimateEstimateQualifierComponent> getEstimateQualifier() {
            if (this.estimateQualifier == null) {
                this.estimateQualifier = new ArrayList<StatisticAttributeEstimateEstimateQualifierComponent>();
            }
            return this.estimateQualifier;
        }

        public StatisticAttributeEstimateComponent setEstimateQualifier(List<StatisticAttributeEstimateEstimateQualifierComponent> theEstimateQualifier) {
            this.estimateQualifier = theEstimateQualifier;
            return this;
        }

        public boolean hasEstimateQualifier() {
            if (this.estimateQualifier == null) {
                return false;
            }
            for (StatisticAttributeEstimateEstimateQualifierComponent item : this.estimateQualifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent addEstimateQualifier() {
            StatisticAttributeEstimateEstimateQualifierComponent t = new StatisticAttributeEstimateEstimateQualifierComponent();
            if (this.estimateQualifier == null) {
                this.estimateQualifier = new ArrayList<StatisticAttributeEstimateEstimateQualifierComponent>();
            }
            this.estimateQualifier.add(t);
            return t;
        }

        public StatisticAttributeEstimateComponent addEstimateQualifier(StatisticAttributeEstimateEstimateQualifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.estimateQualifier == null) {
                this.estimateQualifier = new ArrayList<StatisticAttributeEstimateEstimateQualifierComponent>();
            }
            this.estimateQualifier.add(t);
            return this;
        }

        public StatisticAttributeEstimateEstimateQualifierComponent getEstimateQualifierFirstRep() {
            if (this.getEstimateQualifier().isEmpty()) {
                this.addEstimateQualifier();
            }
            return this.getEstimateQualifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "The estimateType of precision estimate, eg confidence interval or p value type.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The singular quantity of the precision estimate, for precision estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range));
            children.add(new Property("estimateQualifier", "", "An estimate of the precision of the estimate.", 0, Integer.MAX_VALUE, this.estimateQualifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The estimateType of precision estimate, eg confidence interval or p value type.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The singular quantity of the precision estimate, for precision estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 108280125: {
                    return new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range);
                }
                case 11745378: {
                    return new Property("estimateQualifier", "", "An estimate of the precision of the estimate.", 0, Integer.MAX_VALUE, this.estimateQualifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.level;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.range;
                    }
                    return baseArray;
                }
                case 11745378: {
                    return this.estimateQualifier == null ? new Base[]{} : this.estimateQualifier.toArray(new Base[this.estimateQualifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 102865796: {
                    this.level = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
                case 11745378: {
                    this.getEstimateQualifier().add((StatisticAttributeEstimateEstimateQualifierComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("level")) {
                this.level = TypeConvertor.castToDecimal(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else if (name.equals("estimateQualifier")) {
                this.getEstimateQualifier().add((StatisticAttributeEstimateEstimateQualifierComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 108280125: {
                    return this.getRange();
                }
                case 11745378: {
                    return this.addEstimateQualifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
                case 11745378: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.level");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            if (name.equals("estimateQualifier")) {
                return this.addEstimateQualifier();
            }
            return super.addChild(name);
        }

        @Override
        public StatisticAttributeEstimateComponent copy() {
            StatisticAttributeEstimateComponent dst = new StatisticAttributeEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticAttributeEstimateComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.level = this.level == null ? null : this.level.copy();
            Range range = dst.range = this.range == null ? null : this.range.copy();
            if (this.estimateQualifier != null) {
                dst.estimateQualifier = new ArrayList<StatisticAttributeEstimateEstimateQualifierComponent>();
                for (StatisticAttributeEstimateEstimateQualifierComponent statisticAttributeEstimateEstimateQualifierComponent : this.estimateQualifier) {
                    dst.estimateQualifier.add(statisticAttributeEstimateEstimateQualifierComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateComponent o = (StatisticAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateComponent.compareDeep(this.description, o.description, true) && StatisticAttributeEstimateComponent.compareDeep(this.note, o.note, true) && StatisticAttributeEstimateComponent.compareDeep(this.type, o.type, true) && StatisticAttributeEstimateComponent.compareDeep(this.quantity, o.quantity, true) && StatisticAttributeEstimateComponent.compareDeep(this.level, o.level, true) && StatisticAttributeEstimateComponent.compareDeep(this.range, o.range, true) && StatisticAttributeEstimateComponent.compareDeep(this.estimateQualifier, o.estimateQualifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateComponent o = (StatisticAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateComponent.compareValues(this.description, o.description, true) && StatisticAttributeEstimateComponent.compareValues(this.level, o.level, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.quantity, this.level, this.range, this.estimateQualifier});
        }

        @Override
        public String fhirType() {
            return "Statistic.attributeEstimate";
        }
    }

    @Block
    public static class StatisticSampleSizeComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of sample size for statistic", formalDefinition="Human-readable summary of population sample size.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the sample size", formalDefinition="Footnote or explanatory note about the sample size.")
        protected List<Annotation> note;
        @Child(name="numberOfStudies", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of contributing studies", formalDefinition="Number of participants in the population.")
        protected IntegerType numberOfStudies;
        @Child(name="numberOfParticipants", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Cumulative number of participants", formalDefinition="A human-readable string to clarify or explain concepts about the sample size.")
        protected IntegerType numberOfParticipants;
        @Child(name="knownDataCount", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of participants with known results for measured variables", formalDefinition="Number of participants with known results for measured variables.")
        protected IntegerType knownDataCount;
        @Child(name="numeratorCount", type={IntegerType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of participants with \u201cpositive\u201d results, only used to report actual numerator count for a proportion", formalDefinition="Number of participants with \u201cpositive\u201d results, only used to report actual numerator count for a proportion.")
        protected IntegerType numeratorCount;
        private static final long serialVersionUID = 1908820199L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticSampleSizeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticSampleSizeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticSampleSizeComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticSampleSizeComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public IntegerType getNumberOfStudiesElement() {
            if (this.numberOfStudies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.numberOfStudies");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfStudies = new IntegerType();
                }
            }
            return this.numberOfStudies;
        }

        public boolean hasNumberOfStudiesElement() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public boolean hasNumberOfStudies() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public StatisticSampleSizeComponent setNumberOfStudiesElement(IntegerType value) {
            this.numberOfStudies = value;
            return this;
        }

        public int getNumberOfStudies() {
            return this.numberOfStudies == null || this.numberOfStudies.isEmpty() ? 0 : (Integer)this.numberOfStudies.getValue();
        }

        public StatisticSampleSizeComponent setNumberOfStudies(int value) {
            if (this.numberOfStudies == null) {
                this.numberOfStudies = new IntegerType();
            }
            this.numberOfStudies.setValue((Object)value);
            return this;
        }

        public IntegerType getNumberOfParticipantsElement() {
            if (this.numberOfParticipants == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.numberOfParticipants");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfParticipants = new IntegerType();
                }
            }
            return this.numberOfParticipants;
        }

        public boolean hasNumberOfParticipantsElement() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public boolean hasNumberOfParticipants() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public StatisticSampleSizeComponent setNumberOfParticipantsElement(IntegerType value) {
            this.numberOfParticipants = value;
            return this;
        }

        public int getNumberOfParticipants() {
            return this.numberOfParticipants == null || this.numberOfParticipants.isEmpty() ? 0 : (Integer)this.numberOfParticipants.getValue();
        }

        public StatisticSampleSizeComponent setNumberOfParticipants(int value) {
            if (this.numberOfParticipants == null) {
                this.numberOfParticipants = new IntegerType();
            }
            this.numberOfParticipants.setValue((Object)value);
            return this;
        }

        public IntegerType getKnownDataCountElement() {
            if (this.knownDataCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.knownDataCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.knownDataCount = new IntegerType();
                }
            }
            return this.knownDataCount;
        }

        public boolean hasKnownDataCountElement() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public boolean hasKnownDataCount() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public StatisticSampleSizeComponent setKnownDataCountElement(IntegerType value) {
            this.knownDataCount = value;
            return this;
        }

        public int getKnownDataCount() {
            return this.knownDataCount == null || this.knownDataCount.isEmpty() ? 0 : (Integer)this.knownDataCount.getValue();
        }

        public StatisticSampleSizeComponent setKnownDataCount(int value) {
            if (this.knownDataCount == null) {
                this.knownDataCount = new IntegerType();
            }
            this.knownDataCount.setValue((Object)value);
            return this;
        }

        public IntegerType getNumeratorCountElement() {
            if (this.numeratorCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.numeratorCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.numeratorCount = new IntegerType();
                }
            }
            return this.numeratorCount;
        }

        public boolean hasNumeratorCountElement() {
            return this.numeratorCount != null && !this.numeratorCount.isEmpty();
        }

        public boolean hasNumeratorCount() {
            return this.numeratorCount != null && !this.numeratorCount.isEmpty();
        }

        public StatisticSampleSizeComponent setNumeratorCountElement(IntegerType value) {
            this.numeratorCount = value;
            return this;
        }

        public int getNumeratorCount() {
            return this.numeratorCount == null || this.numeratorCount.isEmpty() ? 0 : (Integer)this.numeratorCount.getValue();
        }

        public StatisticSampleSizeComponent setNumeratorCount(int value) {
            if (this.numeratorCount == null) {
                this.numeratorCount = new IntegerType();
            }
            this.numeratorCount.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of population sample size.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("numberOfStudies", "integer", "Number of participants in the population.", 0, 1, this.numberOfStudies));
            children.add(new Property("numberOfParticipants", "integer", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants));
            children.add(new Property("knownDataCount", "integer", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount));
            children.add(new Property("numeratorCount", "integer", "Number of participants with \u201cpositive\u201d results, only used to report actual numerator count for a proportion.", 0, 1, this.numeratorCount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of population sample size.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note);
                }
                case -177467129: {
                    return new Property("numberOfStudies", "integer", "Number of participants in the population.", 0, 1, this.numberOfStudies);
                }
                case 1799357120: {
                    return new Property("numberOfParticipants", "integer", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants);
                }
                case -937344126: {
                    return new Property("knownDataCount", "integer", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount);
                }
                case -755509242: {
                    return new Property("numeratorCount", "integer", "Number of participants with \u201cpositive\u201d results, only used to report actual numerator count for a proportion.", 0, 1, this.numeratorCount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -177467129: {
                    Base[] baseArray;
                    if (this.numberOfStudies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfStudies;
                    }
                    return baseArray;
                }
                case 1799357120: {
                    Base[] baseArray;
                    if (this.numberOfParticipants == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.numberOfParticipants;
                    }
                    return baseArray;
                }
                case -937344126: {
                    Base[] baseArray;
                    if (this.knownDataCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.knownDataCount;
                    }
                    return baseArray;
                }
                case -755509242: {
                    Base[] baseArray;
                    if (this.numeratorCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.numeratorCount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -177467129: {
                    this.numberOfStudies = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 1799357120: {
                    this.numberOfParticipants = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -937344126: {
                    this.knownDataCount = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -755509242: {
                    this.numeratorCount = TypeConvertor.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("numberOfStudies")) {
                this.numberOfStudies = TypeConvertor.castToInteger(value);
            } else if (name.equals("numberOfParticipants")) {
                this.numberOfParticipants = TypeConvertor.castToInteger(value);
            } else if (name.equals("knownDataCount")) {
                this.knownDataCount = TypeConvertor.castToInteger(value);
            } else if (name.equals("numeratorCount")) {
                this.numeratorCount = TypeConvertor.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -177467129: {
                    return this.getNumberOfStudiesElement();
                }
                case 1799357120: {
                    return this.getNumberOfParticipantsElement();
                }
                case -937344126: {
                    return this.getKnownDataCountElement();
                }
                case -755509242: {
                    return this.getNumeratorCountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -177467129: {
                    return new String[]{"integer"};
                }
                case 1799357120: {
                    return new String[]{"integer"};
                }
                case -937344126: {
                    return new String[]{"integer"};
                }
                case -755509242: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("numberOfStudies")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.numberOfStudies");
            }
            if (name.equals("numberOfParticipants")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.numberOfParticipants");
            }
            if (name.equals("knownDataCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.knownDataCount");
            }
            if (name.equals("numeratorCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.numeratorCount");
            }
            return super.addChild(name);
        }

        @Override
        public StatisticSampleSizeComponent copy() {
            StatisticSampleSizeComponent dst = new StatisticSampleSizeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticSampleSizeComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.numberOfStudies = this.numberOfStudies == null ? null : this.numberOfStudies.copy();
            dst.numberOfParticipants = this.numberOfParticipants == null ? null : this.numberOfParticipants.copy();
            dst.knownDataCount = this.knownDataCount == null ? null : this.knownDataCount.copy();
            dst.numeratorCount = this.numeratorCount == null ? null : this.numeratorCount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticSampleSizeComponent)) {
                return false;
            }
            StatisticSampleSizeComponent o = (StatisticSampleSizeComponent)other_;
            return StatisticSampleSizeComponent.compareDeep(this.description, o.description, true) && StatisticSampleSizeComponent.compareDeep(this.note, o.note, true) && StatisticSampleSizeComponent.compareDeep(this.numberOfStudies, o.numberOfStudies, true) && StatisticSampleSizeComponent.compareDeep(this.numberOfParticipants, o.numberOfParticipants, true) && StatisticSampleSizeComponent.compareDeep(this.knownDataCount, o.knownDataCount, true) && StatisticSampleSizeComponent.compareDeep(this.numeratorCount, o.numeratorCount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticSampleSizeComponent)) {
                return false;
            }
            StatisticSampleSizeComponent o = (StatisticSampleSizeComponent)other_;
            return StatisticSampleSizeComponent.compareValues(this.description, o.description, true) && StatisticSampleSizeComponent.compareValues(this.numberOfStudies, o.numberOfStudies, true) && StatisticSampleSizeComponent.compareValues(this.numberOfParticipants, o.numberOfParticipants, true) && StatisticSampleSizeComponent.compareValues(this.knownDataCount, o.knownDataCount, true) && StatisticSampleSizeComponent.compareValues(this.numeratorCount, o.numeratorCount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.numberOfStudies, this.numberOfParticipants, this.knownDataCount, this.numeratorCount});
        }

        @Override
        public String fhirType() {
            return "Statistic.sampleSize";
        }
    }
}

