/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DOMWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Element;

public class ProfileDrivenRenderer
extends ResourceRenderer {
    public ProfileDrivenRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    public ProfileDrivenRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, DomainResource r) throws FHIRFormatError, DefinitionException, IOException {
        return false;
    }

    @Override
    public String display(DomainResource r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    public void inject(Element er, XhtmlNode x, Narrative.NarrativeStatus status, boolean pretty) {
        Element st;
        Element txt;
        Element le;
        String l;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        String string = l = (le = XMLUtil.getNamedChild((Element)er, (String)"language")) == null ? null : le.getAttribute("value");
        if (!Utilities.noString((String)l)) {
            x.setAttribute("lang", l);
            x.setAttribute("xml:lang", l);
        }
        if ((txt = XMLUtil.getNamedChild((Element)er, (String)"text")) == null) {
            txt = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
            Element n = XMLUtil.getFirstChild((Element)er);
            while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                n = XMLUtil.getNextSibling((Element)n);
            }
            if (n == null) {
                er.appendChild(txt);
            } else {
                er.insertBefore(txt, n);
            }
        }
        if ((st = XMLUtil.getNamedChild((Element)txt, (String)"status")) == null) {
            st = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
            Element n = XMLUtil.getFirstChild((Element)txt);
            if (n == null) {
                txt.appendChild(st);
            } else {
                txt.insertBefore(st, n);
            }
        }
        st.setAttribute("value", status.toCode());
        Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
        if (div == null) {
            div = er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            txt.appendChild(div);
        }
        if (div.hasChildNodes()) {
            div.appendChild(er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
        }
        new XhtmlComposer(true, pretty).compose(div, x);
    }

    public void inject(org.hl7.fhir.r5.elementmodel.Element er, XhtmlNode x, Narrative.NarrativeStatus status, boolean pretty) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element st;
        org.hl7.fhir.r5.elementmodel.Element txt;
        String l;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (!Utilities.noString((String)(l = er.getChildValue("language")))) {
            x.setAttribute("lang", l);
            x.setAttribute("xml:lang", l);
        }
        if ((txt = er.getNamedChild("text")) == null) {
            int i;
            txt = new org.hl7.fhir.r5.elementmodel.Element("text", er.getProperty().getChild(null, "text"));
            for (i = 0; i < er.getChildren().size() && (er.getChildren().get(i).getName().equals("id") || er.getChildren().get(i).getName().equals("meta") || er.getChildren().get(i).getName().equals("implicitRules") || er.getChildren().get(i).getName().equals("language")); ++i) {
            }
            if (i >= er.getChildren().size()) {
                er.getChildren().add(txt);
            } else {
                er.getChildren().add(i, txt);
            }
        }
        if ((st = txt.getNamedChild("status")) == null) {
            st = new org.hl7.fhir.r5.elementmodel.Element("status", txt.getProperty().getChild(null, "status"));
            txt.getChildren().add(0, st);
        }
        st.setValue(status.toCode());
        org.hl7.fhir.r5.elementmodel.Element div = txt.getNamedChild("div");
        if (div == null) {
            div = new org.hl7.fhir.r5.elementmodel.Element("div", txt.getProperty().getChild(null, "div"));
            txt.getChildren().add(div);
            div.setValue(new XhtmlComposer(true, pretty).compose(x));
        }
        div.setValue(x.toString());
        div.setXhtml(x);
    }

    public void generateResourceSummary(XhtmlNode x, BaseWrappers.ResourceWrapper res, boolean textAlready, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && ((XhtmlNode)div.getChildNodes().get(0)).allChildrenAreText()) {
                    x.getChildNodes().addAll(((XhtmlNode)div.getChildNodes().get(0)).getChildNodes());
                }
            }
            x.tx("Generated Summary: ");
        }
        String path = res.getName();
        StructureDefinition profile = this.getContext().getWorker().fetchResource(StructureDefinition.class, path);
        if (profile == null) {
            x.tx("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (BaseWrappers.PropertyWrapper p : res.children()) {
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.tx("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.tx(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails) || last;
                }
            }
        }
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getWorkingCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri") && !t.equals("Url") && !t.equals("Canonical");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, BaseWrappers.PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(BaseWrappers.ResourceWrapper res, BaseWrappers.BaseWrapper ew, ElementDefinition defn, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else {
            if (e instanceof Extension) {
                return;
            }
            if (e instanceof InstantType) {
                x.addText(((InstantType)e).toHumanDisplay());
            } else if (e instanceof DateTimeType) {
                this.renderDateTime(x, e);
            } else if (e instanceof Base64BinaryType) {
                x.addText(new Base64().encodeAsString(((Base64BinaryType)e).getValue()));
            } else if (e instanceof DateType) {
                x.addText(((DateType)e).toHumanDisplay());
            } else if (e instanceof Enumeration) {
                Object ev = ((Enumeration)e).getValue();
                x.addText(ev == null ? "" : ev.toString());
            } else if (e instanceof BooleanType) {
                x.addText(((Boolean)((BooleanType)e).getValue()).toString());
            } else if (e instanceof CodeableConcept) {
                this.renderCodeableConcept(x, (CodeableConcept)e, showCodeDetails);
            } else if (e instanceof Coding) {
                this.renderCoding(x, (Coding)e, showCodeDetails);
            } else if (e instanceof Annotation) {
                this.renderAnnotation(x, (Annotation)e);
            } else if (e instanceof Identifier) {
                this.renderIdentifier(x, (Identifier)e);
            } else if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
            } else if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
            } else if (e instanceof HumanName) {
                this.renderHumanName(x, (HumanName)e);
            } else if (e instanceof SampledData) {
                this.renderSampledData(x, (SampledData)e);
            } else if (e instanceof Address) {
                this.renderAddress(x, (Address)e);
            } else if (e instanceof ContactPoint) {
                this.renderContactPoint(x, (ContactPoint)e);
            } else if (e instanceof ContactDetail) {
                ContactDetail cd = (ContactDetail)e;
                if (cd.hasName()) {
                    x.tx(cd.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    this.renderContactPoint(x, c);
                }
            } else if (e instanceof UriType) {
                this.renderUri(x, (UriType)e, defn.getPath(), this.rcontext != null && this.rcontext.getResourceResource() != null ? this.rcontext.getResourceResource().getId() : null);
            } else if (e instanceof Timing) {
                this.renderTiming(x, (Timing)e);
            } else if (e instanceof Range) {
                this.renderRange(x, (Range)e);
            } else if (e instanceof Quantity) {
                this.renderQuantity(x, (Quantity)e, showCodeDetails);
            } else if (e instanceof Ratio) {
                this.renderQuantity(x, ((Ratio)e).getNumerator(), showCodeDetails);
                x.tx("/");
                this.renderQuantity(x, ((Ratio)e).getDenominator(), showCodeDetails);
            } else if (e instanceof Period) {
                Period p = (Period)e;
                this.renderPeriod(x, p);
            } else if (e instanceof Reference) {
                Reference r = (Reference)e;
                this.renderReference(res, x, r);
            } else {
                if (e instanceof Resource) {
                    return;
                }
                if (e instanceof ElementDefinition) {
                    x.tx("todo-bundle");
                } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                    StructureDefinition sd = this.getContext().getWorker().fetchTypeDefinition(e.fhirType());
                    if (sd == null) {
                        throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet, and no structure found");
                    }
                    this.generateByProfile(res, sd, ew, sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep(), this.getChildrenForPath(sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep().getPath()), x, path, showCodeDetails, indent + 1);
                }
            }
        }
    }

    private boolean displayLeaf(BaseWrappers.ResourceWrapper res, BaseWrappers.BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        if (e == null) {
            return false;
        }
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof UriType) {
            x.addText(name + ": " + (String)((UriType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            return false;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept(x, (CodeableConcept)e, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding(x, (Coding)e, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation(x, (Annotation)e, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier(x, (Identifier)e);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName(x, (HumanName)e);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData(x, (SampledData)e);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress(x, (Address)e);
                return true;
            }
            if (e instanceof ContactPoint) {
                this.renderContactPoint(x, (ContactPoint)e);
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming(x, (Timing)e);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity(x, (Quantity)e, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(x, ((Ratio)e).getNumerator(), showCodeDetails);
                x.tx("/");
                this.renderQuantity(x, ((Ratio)e).getDenominator(), showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "?ngen-2?" : p.getStartElement().toHumanDisplay());
                x.tx(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    Resolver.ResourceWithReference tr = this.resolveReference(res, r.getReference());
                    x.addText(tr == null ? r.getReference() : "?ngen-3");
                } else {
                    x.tx("?ngen-4?");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (e instanceof ContactDetail) {
                ContactDetail cd = (ContactDetail)e;
                if (cd.hasName()) {
                    x.tx(cd.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    this.renderContactPoint(x, c);
                }
                return true;
            }
            if (e instanceof Range) {
                return false;
            }
            if (e instanceof Meta) {
                return false;
            }
            if (e instanceof Dosage) {
                return false;
            }
            if (e instanceof Signature) {
                return false;
            }
            if (e instanceof UsageContext) {
                return false;
            }
            if (e instanceof RelatedArtifact) {
                return false;
            }
            if (e instanceof ElementDefinition) {
                return false;
            }
            if (e instanceof Base64BinaryType) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        return e.getType().size() != 1 || !this.isBase(e.getType().get(0).getWorkingCode());
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    private boolean generateByProfile(StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(this.rcontext.getResourceResource(), profile, this.rcontext.getResourceResource(), profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), this.rcontext.getResourceResource().getResourceType().toString()), x, this.rcontext.getResourceResource().getResourceType().toString(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(this.rcontext.getResourceResource(), x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private String generateByProfile(Element er, StructureDefinition profile, boolean showCodeDetails) throws IOException, FHIRException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(er, profile, er, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), er.getLocalName()), x, er.getLocalName(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED, false);
        String b = new XhtmlComposer(true, false).compose(x);
        return b;
    }

    private void generateByProfile(Element eres, StructureDefinition profile, Element ee, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        DOMWrappers.ResourceWrapperElement resw = new DOMWrappers.ResourceWrapperElement(this, eres, profile);
        DOMWrappers.BaseWrapperElement base = new DOMWrappers.BaseWrapperElement(this, ee, null, profile, profile.getSnapshot().getElement().get(0));
        this.generateByProfile(resw, profile, base, allElements, defn, children, x, path, showCodeDetails, 0);
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        this.generateByProfile(new DirectWrappers.ResourceWrapperDirect(this, res), profile, new DirectWrappers.BaseWrapperDirect(this, e), allElements, defn, children, x, path, showCodeDetails, 0);
    }

    private void generateByProfile(BaseWrappers.ResourceWrapper res, StructureDefinition profile, BaseWrappers.BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent) throws FHIRException, UnsupportedEncodingException, IOException {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, false, showCodeDetails, this.readDisplayHints(defn), path, indent);
        } else {
            for (BaseWrappers.PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                ElementDefinition child;
                if (!p.hasValues() || (child = this.getElementDefinition(children, path + "." + p.getName(), p)) == null) continue;
                Map<String, String> displayHints = this.readDisplayHints(child);
                if (this.exemptFromRendering(child)) continue;
                List<ElementDefinition> grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || child == null) continue;
                if (this.isPrimitive(child)) {
                    XhtmlNode para = x.para();
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) continue;
                    para.b().addText(name);
                    para.tx(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.ul();
                        for (BaseWrappers.BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, list.li(), false, showCodeDetails, displayHints, path, indent);
                        }
                        continue;
                    }
                    boolean first = true;
                    for (BaseWrappers.BaseWrapper v : p.getValues()) {
                        if (first) {
                            first = false;
                        } else {
                            para.tx(", ");
                        }
                        this.renderLeaf(res, v, child, para, false, showCodeDetails, displayHints, path, indent);
                    }
                    continue;
                }
                if (this.canDoTable(path, p, grandChildren)) {
                    x.addTag(this.getHeader()).addText(Utilities.capitalize((String)Utilities.camelCase((String)Utilities.pluralizeMe((String)p.getName()))));
                    XhtmlNode tbl = x.table("grid");
                    XhtmlNode tr = tbl.tr();
                    tr.td().tx("-");
                    this.addColumnHeadings(tr, grandChildren);
                    for (BaseWrappers.BaseWrapper v : p.getValues()) {
                        if (v == null) continue;
                        tr = tbl.tr();
                        tr.td().tx("*");
                        this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints, path, indent);
                    }
                    continue;
                }
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails, indent + 1);
                }
            }
        }
    }

    private String getHeader() {
        int i;
        for (i = 3; i <= this.context.getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    private List<BaseWrappers.PropertyWrapper> getValues(String path, BaseWrappers.PropertyWrapper p, ElementDefinition e) {
        ArrayList<BaseWrappers.PropertyWrapper> res = new ArrayList<BaseWrappers.PropertyWrapper>();
        for (BaseWrappers.BaseWrapper v : p.getValues()) {
            for (BaseWrappers.PropertyWrapper g : v.children()) {
                if (!(path + "." + p.getName() + "." + g.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canDoTable(String path, BaseWrappers.PropertyWrapper p, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            List<BaseWrappers.PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getWorkingCode()).equals("Address") || t.equals("Reference"));
    }

    private void addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            tr.td().b().addText(Utilities.capitalize((String)this.tail(e.getPath())));
        }
    }

    private void addColumnValues(BaseWrappers.ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrappers.BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent) throws FHIRException, UnsupportedEncodingException, IOException {
        for (ElementDefinition e : grandChildren) {
            BaseWrappers.PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                tr.td().tx(" ");
                continue;
            }
            this.renderLeaf(res, p.getValues().get(0), e, tr.td(), false, showCodeDetails, displayHints, path, indent);
        }
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, BaseWrappers.PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrappers.BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                BaseWrappers.PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<BaseWrappers.PropertyWrapper> splitExtensions(StructureDefinition profile, List<BaseWrappers.PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<BaseWrappers.PropertyWrapper> results = new ArrayList<BaseWrappers.PropertyWrapper>();
        HashMap map = new HashMap();
        for (BaseWrappers.PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.getContext().getWorker().fetchResource(StructureDefinition.class, url);
                    if (ed == null) {
                        if (this.xverManager == null) {
                            this.xverManager = new XVerExtensionManager(this.context.getWorker());
                        }
                        if (this.xverManager.matchingUrl(url) && this.xverManager.status(url) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                            ed = this.xverManager.makeDefinition(url);
                            this.getContext().getWorker().generateSnapshot(ed);
                            this.getContext().getWorker().cacheResource(ed);
                        }
                    }
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    BaseWrappers.PropertyWrapper pe = (BaseWrappers.PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir") && !url.startsWith("http://hl7.org/fhir/us")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            pe = new DirectWrappers.PropertyWrapperDirect(this, new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex));
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new DirectWrappers.PropertyWrapperDirect(this, new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex));
                            ((DirectWrappers.PropertyWrapperDirect)pe).getWrapped().setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString((String)(displayHint = ToolingExtensions.getDisplayHint(defn)))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrappers.BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString((String)v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    protected String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }
}

