/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class TerminologyRenderer
extends ResourceRenderer {
    protected boolean noSlowLookup;

    public TerminologyRenderer(RenderingContext context) {
        super(context);
    }

    public TerminologyRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public String display(DomainResource r) throws UnsupportedEncodingException, IOException {
        return ((CanonicalResource)r).present();
    }

    public boolean isNoSlowLookup() {
        return this.noSlowLookup;
    }

    public void setNoSlowLookup(boolean noSlowLookup) {
        this.noSlowLookup = noSlowLookup;
    }

    protected void addMapHeaders(XhtmlNode tr, List<UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        for (UsedConceptMap m : maps) {
            XhtmlNode td = tr.td();
            XhtmlNode b = td.b();
            XhtmlNode a = b.ah(this.getContext().getPrefix() + m.getLink());
            a.addText(m.getDetails().getName());
            if (!m.getDetails().isDoDescription() || !m.getMap().hasDescription()) continue;
            this.addMarkdown(td, m.getMap().getDescription());
        }
    }

    protected String getHeader() {
        int i;
        for (i = 3; i <= this.getContext().getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    protected List<TargetElementComponentWrapper> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<TargetElementComponentWrapper> mappings = new ArrayList<TargetElementComponentWrapper>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            for (ConceptMap.SourceElementComponent c : g.getElement()) {
                if (!c.getCode().equals(code)) continue;
                for (ConceptMap.TargetElementComponent cc : c.getTarget()) {
                    mappings.add(new TargetElementComponentWrapper(g, cc));
                }
            }
        }
        return mappings;
    }

    protected String getCharForRelationship(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasRelationship()) {
            return "";
        }
        switch (mapping.getRelationship()) {
            case EQUIVALENT: {
                return "~";
            }
            case SOURCEISNARROWERTHANTARGET: {
                return "<";
            }
            case SOURCEISBROADERTHANTARGET: {
                return ">";
            }
            case NOTRELATEDTO: {
                return "!=";
            }
        }
        return "?";
    }

    protected <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String spec;
        String ref = null;
        boolean addHtml = true;
        if (cs != null) {
            ref = (String)cs.getUserData("external.url");
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("filename");
            } else {
                addHtml = false;
            }
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("path");
            }
        }
        if ((spec = this.getSpecialReference(inc.getSystem())) != null) {
            XhtmlNode a = li.ah(spec);
            a.code(inc.getSystem());
        } else if (cs != null && ref != null) {
            if (!Utilities.noString((String)this.getContext().getPrefix()) && ref.startsWith("http://hl7.org/fhir/")) {
                ref = ref.substring(20) + "/index.html";
            } else if (addHtml && !ref.contains(".html")) {
                ref = ref + ".html";
            }
            XhtmlNode a = li.ah(this.getContext().getPrefix() + ref.replace("\\", "/"));
            a.code(inc.getSystem());
        } else {
            li.code(inc.getSystem());
        }
    }

    private String getSpecialReference(String system) {
        if ("http://snomed.info/sct".equals(system)) {
            return "http://www.snomed.org/";
        }
        if (Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://ncimeta.nci.nih.gov", "http://fdasis.nlm.nih.gov", "http://www.radlex.org", "http://www.whocc.no/atc", "http://dicom.nema.org/resources/ontology/DCM", "http://www.genenames.org", "http://www.ensembl.org", "http://www.ncbi.nlm.nih.gov/nuccore", "http://www.ncbi.nlm.nih.gov/clinvar", "http://sequenceontology.org", "http://www.hgvs.org/mutnomen", "http://www.ncbi.nlm.nih.gov/projects/SNP", "http://cancer.sanger.ac.uk/cancergenome/projects/cosmic", "http://www.lrg-sequence.org", "http://www.omim.org", "http://www.ncbi.nlm.nih.gov/pubmed", "http://www.pharmgkb.org", "http://clinicaltrials.gov", "http://www.ebi.ac.uk/ipd/imgt/hla/"})) {
            return system;
        }
        return null;
    }

    protected XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean version, boolean deprecated, List<CodeSystem.PropertyComponent> properties) {
        XhtmlNode tr = t.tr();
        if (hasHierarchy) {
            tr.td().b().tx("Lvl");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
        if (hasDisplay) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Display", this.getContext().getLang()));
        }
        if (definitions) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Definition", this.getContext().getLang()));
        }
        if (deprecated) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Deprecated", this.getContext().getLang()));
        }
        if (comments) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Comments", this.getContext().getLang()));
        }
        if (version) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Version", this.getContext().getLang()));
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent pc : properties) {
                String display = ToolingExtensions.getPresentation(pc, pc.getCodeElement());
                if ((display == null || display.equals(pc.getCode()) && pc.hasUri()) && (display = this.getDisplayForProperty(pc.getUri())) == null) {
                    display = pc.getCode();
                }
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", display, this.getContext().getLang()));
            }
        }
        return tr;
    }

    protected String getDisplayForProperty(String uri) {
        CodeSystem cs;
        if (Utilities.noString((String)uri)) {
            return null;
        }
        String code = null;
        if (uri.contains("#")) {
            code = uri.substring(uri.indexOf("#") + 1);
            uri = uri.substring(0, uri.indexOf("#"));
        }
        if ((cs = this.getContext().getWorker().fetchCodeSystem(uri)) == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent cc = CodeSystemUtilities.getCode(cs, code);
        return cc == null ? null : cc.getDisplay();
    }

    protected void AddVsRef(String value, XhtmlNode li) {
        Bundle.BundleEntryComponent be;
        Resource res = null;
        if (this.rcontext != null && (be = this.rcontext.resolve(value)) != null) {
            res = be.getResource();
        }
        if (res != null && !(res instanceof CanonicalResource)) {
            li.addText(value);
            return;
        }
        CanonicalResource vs = (CanonicalResource)res;
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(ValueSet.class, value);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(StructureDefinition.class, value);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(Questionnaire.class, value);
        }
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "?ngen-11?" : ref.replace("\\", "/"));
            a.addText(value);
        } else {
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(value);
            if (cs != null) {
                String ref = (String)cs.getUserData("path");
                XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "?ngen-12?" : ref.replace("\\", "/"));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.ah(value);
                a.tx("SNOMED-CT");
            } else {
                if (value.startsWith("http://hl7.org") && !Utilities.existsInList((String)value, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10-us"})) {
                    System.out.println("Unable to resolve value set " + value);
                }
                li.addText(value);
            }
        }
    }

    private String adjustForPath(String ref) {
        if (this.getContext().getPrefix() == null) {
            return ref;
        }
        return this.getContext().getPrefix() + ref;
    }

    protected String getDisplayForConcept(String system, String value) {
        if (value == null || system == null) {
            return null;
        }
        IWorkerContext.ValidationResult cl = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions(), system, value, null);
        return cl == null ? null : cl.getDisplay();
    }

    public class ConceptMapRenderInstructions {
        private String name;
        private String url;
        private boolean doDescription;

        public ConceptMapRenderInstructions(String name, String url, boolean doDescription) {
            this.name = name;
            this.url = url;
            this.doDescription = doDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDoDescription() {
            return this.doDescription;
        }
    }

    public class UsedConceptMap {
        private ConceptMapRenderInstructions details;
        private String link;
        private ConceptMap map;

        public UsedConceptMap(ConceptMapRenderInstructions details, String link, ConceptMap map) {
            this.details = details;
            this.link = link;
            this.map = map;
        }

        public ConceptMapRenderInstructions getDetails() {
            return this.details;
        }

        public ConceptMap getMap() {
            return this.map;
        }

        public String getLink() {
            return this.link;
        }
    }

    protected class TargetElementComponentWrapper {
        protected ConceptMap.ConceptMapGroupComponent group;
        protected ConceptMap.TargetElementComponent comp;

        protected TargetElementComponentWrapper(ConceptMap.ConceptMapGroupComponent group, ConceptMap.TargetElementComponent comp) {
            this.group = group;
            this.comp = comp;
        }
    }
}

