/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class BaseWrappers {

    public static abstract class WrapperBaseImpl
    extends RendererWrapperImpl
    implements WrapperBase {
        public WrapperBaseImpl(ResourceRenderer renderer) {
            super(renderer);
        }

        @Override
        public boolean has(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p.hasValues();
            }
            return false;
        }

        @Override
        public Base get(String name) throws UnsupportedEncodingException, FHIRException, IOException {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                if (p.hasValues()) {
                    return p.getValues().get(0).getBase();
                }
                return null;
            }
            return null;
        }

        @Override
        public List<BaseWrapper> children(String name) throws UnsupportedEncodingException, FHIRException, IOException {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                ArrayList<BaseWrapper> res = new ArrayList<BaseWrapper>();
                for (BaseWrapper b : p.getValues()) {
                    res.add(b);
                }
                return res;
            }
            return null;
        }
    }

    public static abstract class RendererWrapperImpl
    implements RendererWrapper {
        protected ResourceRenderer renderer;

        public RendererWrapperImpl(ResourceRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public ResourceRenderer getRenderer() {
            return this.renderer;
        }

        protected String tail(String path) {
            return path.substring(path.lastIndexOf(".") + 1);
        }
    }

    public static interface BaseWrapper
    extends WrapperBase {
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException;

        public PropertyWrapper getChildByName(String var1);
    }

    public static interface ResourceWrapper
    extends WrapperBase {
        public List<ResourceWrapper> getContained();

        public String getId();

        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException;

        public String getName();

        public void describe(XhtmlNode var1) throws UnsupportedEncodingException, IOException;
    }

    public static interface WrapperBase
    extends RendererWrapper {
        public boolean has(String var1);

        public Base get(String var1) throws UnsupportedEncodingException, FHIRException, IOException;

        public List<BaseWrapper> children(String var1) throws UnsupportedEncodingException, FHIRException, IOException;

        public List<PropertyWrapper> children();
    }

    public static interface PropertyWrapper
    extends RendererWrapper {
        public String getName();

        public boolean hasValues();

        public List<BaseWrapper> getValues();

        public String getTypeCode();

        public String getDefinition();

        public int getMinCardinality();

        public int getMaxCardinality();

        public StructureDefinition getStructure();

        public BaseWrapper value();
    }

    public static interface RendererWrapper {
        public ResourceRenderer getRenderer();
    }
}

