/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ElementWrappers {

    public static class PropertyWrapperMetaElement
    extends BaseWrappers.RendererWrapperImpl
    implements BaseWrappers.PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrappers.BaseWrapper> list;

        public PropertyWrapperMetaElement(ResourceRenderer renderer, StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            super(renderer);
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrappers.BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperMetaElement(this.renderer, e, e.fhirType(), this.structure, this.definition));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.definition.typeSummary();
        }

        @Override
        public String getDefinition() {
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            return "*".equals(this.definition.getMax()) ? Integer.MAX_VALUE : Integer.valueOf(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrappers.BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    public static class ResourceWrapperMetaElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.ResourceWrapper {
        private Element wrapped;
        private List<BaseWrappers.ResourceWrapper> list;
        private List<BaseWrappers.PropertyWrapper> list2;
        private StructureDefinition definition;

        public ResourceWrapperMetaElement(ResourceRenderer renderer, Element wrapped) {
            super(renderer);
            this.wrapped = wrapped;
            this.definition = wrapped.getProperty().getStructure();
        }

        @Override
        public List<BaseWrappers.ResourceWrapper> getContained() {
            if (this.list == null) {
                List<Element> children = this.wrapped.getChildrenByName("contained");
                this.list = new ArrayList<BaseWrappers.ResourceWrapper>();
                for (Element e : children) {
                    this.list.add(new ResourceWrapperMetaElement(this.renderer, e));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return this.wrapped.getNamedChildValue("id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = this.wrapped.getNamedChild("text");
            if (txt == null) {
                return null;
            }
            Element div = txt.getNamedChild("div");
            if (div == null) {
                return null;
            }
            return div.getXhtml();
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = this.renderer.getContext().getProfileUtilities().getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    if (child.getPath().endsWith("[x]")) {
                        this.wrapped.getNamedChildrenWithWildcard(this.tail(child.getPath()), elements);
                    } else {
                        this.wrapped.getNamedChildren(this.tail(child.getPath()), elements);
                    }
                    this.list2.add(new PropertyWrapperMetaElement(this.renderer, this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void describe(XhtmlNode x) {
            if (this.wrapped.hasChild("title") && this.wrapped.getChildValue("title") != null) {
                x.tx(this.wrapped.getChildValue("title"));
            } else if (this.wrapped.hasChild("name") && this.wrapped.getChildValue("name") != null) {
                x.tx(this.wrapped.getChildValue("name"));
            } else {
                x.tx("?ngen-1?");
            }
        }
    }

    public static class BaseWrapperMetaElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<BaseWrappers.PropertyWrapper> list;

        public BaseWrapperMetaElement(ResourceRenderer renderer, Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            super(renderer);
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            if (this.element.hasElementProperty()) {
                return null;
            }
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            try {
                new XmlParser(this.renderer.getContext().getWorker()).compose(this.element, (OutputStream)xml, IParser.OutputStyle.PRETTY, null);
            }
            catch (Exception e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            return this.renderer.parseType(xml.toString(), this.type);
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list == null) {
                this.children = this.renderer.getContext().getProfileUtilities().getChildList(this.structure, this.definition);
                this.list = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    String name = this.tail(child.getPath());
                    if (name.endsWith("[x]")) {
                        this.element.getNamedChildrenWithWildcard(name, elements);
                    } else {
                        this.element.getNamedChildren(name, elements);
                    }
                    this.list.add(new PropertyWrapperMetaElement(this.renderer, this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            for (BaseWrappers.PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }
}

