/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.model.ImplementationGuide;

public class IGHelper {
    public static final String EXT_SPREADSHEET = "http://hl7.org/fhir/StructureDefinition/igpublisher-spreadsheet";
    public static final String EXT_MAPPING_CSV = "http://hl7.org/fhir/StructureDefinition/igpublisher-mapping-csv";
    public static final String EXT_BUNDLE = "http://hl7.org/fhir/StructureDefinition/igpublisher-bundle";
    public static final String EXT_RESOURCE_INFO = "http://hl7.org/fhir/tools/StructureDefinition/resource-information";
    public static final String EXT_PRIVATE_BASE = "http://hl7.org/fhir/tools/";

    public static String readStringParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, String name) {
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent p : ig.getParameter()) {
            if (name != p.getCode()) continue;
            return p.getValue();
        }
        return null;
    }

    public static boolean getBooleanParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, String name, boolean defaultValue) {
        String v = IGHelper.readStringParameter(ig, name);
        return v == null ? false : Boolean.parseBoolean(v);
    }

    public static void setParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, String name, String value) {
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent p : ig.getParameter()) {
            if (name != p.getCode()) continue;
            p.setValue(value);
            return;
        }
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent p = ig.addParameter();
        p.setCode(name);
        p.setValue(value);
    }

    public static void addParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, String name, String value) {
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent p = ig.addParameter();
        p.setCode(name);
        p.setValue(value);
    }

    public static void setParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, String name, boolean value) {
        IGHelper.setParameter(ig, name, Boolean.toString(value));
    }
}

