/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;

@ResourceDef(name="ChargeItem", profile="http://hl7.org/fhir/StructureDefinition/ChargeItem")
public class ChargeItem
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for item", formalDefinition="Identifiers assigned to this event performer or other systems.")
    protected List<Identifier> identifier;
    @Child(name="definitionUri", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Defining information about the code of this charge item", formalDefinition="References the (external) source of pricing information, rules of application for the code this ChargeItem uses.")
    protected List<UriType> definitionUri;
    @Child(name="definitionCanonical", type={CanonicalType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Resource defining the code of this ChargeItem", formalDefinition="References the source of pricing information, rules of application for the code this ChargeItem uses.")
    protected List<CanonicalType> definitionCanonical;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | billable | not-billable | aborted | billed | entered-in-error | unknown", formalDefinition="The current state of the ChargeItem.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-status")
    protected Enumeration<ChargeItemStatus> status;
    @Child(name="partOf", type={ChargeItem.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Part of referenced ChargeItem", formalDefinition="ChargeItems can be grouped to larger ChargeItems covering the whole set.")
    protected List<Reference> partOf;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A code that identifies the charge, like a billing code", formalDefinition="A code that identifies the charge, like a billing code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual service was done for/to", formalDefinition="The individual or set of individuals the action is being or was performed on.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter associated with this ChargeItem", formalDefinition="This ChargeItem has the details of how the associated Encounter should be billed or otherwise be handled by finance systems.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the charged service was applied", formalDefinition="Date/time(s) or duration when the charged service was applied.")
    protected DataType occurrence;
    @Child(name="performer", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who performed charged service", formalDefinition="Indicates who or what performed or participated in the charged service.")
    protected List<ChargeItemPerformerComponent> performer;
    @Child(name="performingOrganization", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization providing the charged service", formalDefinition="The organization performing the service.")
    protected Reference performingOrganization;
    @Child(name="requestingOrganization", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization requesting the charged service", formalDefinition="The organization requesting the service.")
    protected Reference requestingOrganization;
    @Child(name="costCenter", type={Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization that has ownership of the (potential, future) revenue", formalDefinition="The financial cost center permits the tracking of charge attribution.")
    protected Reference costCenter;
    @Child(name="quantity", type={Quantity.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Quantity of which the charge item has been serviced", formalDefinition="Quantity of which the charge item has been serviced.")
    protected Quantity quantity;
    @Child(name="bodysite", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where the related service has been applied.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodysite;
    @Child(name="unitPriceComponent", type={MonetaryComponent.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unit price overriding the associated rules", formalDefinition="The unit price of the chargable item.")
    protected MonetaryComponent unitPriceComponent;
    @Child(name="totalPriceComponent", type={MonetaryComponent.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Total price overriding the associated rules", formalDefinition="The total price for the chargable item, accounting for the quantity.")
    protected MonetaryComponent totalPriceComponent;
    @Child(name="overrideReason", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for overriding the list price/factor", formalDefinition="If the list price or the rule-based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.")
    protected CodeableConcept overrideReason;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, Device.class, RelatedPerson.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual who was entering", formalDefinition="The device, practitioner, etc. who entered the charge item.")
    protected Reference enterer;
    @Child(name="enteredDate", type={DateTimeType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date the charge item was entered", formalDefinition="Date the charge item was entered.")
    protected DateTimeType enteredDate;
    @Child(name="reason", type={CodeableConcept.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why was the charged  service rendered?", formalDefinition="Describes why the event occurred in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
    protected List<CodeableConcept> reason;
    @Child(name="service", type={CodeableReference.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Which rendered service is being charged?", formalDefinition="Indicated the rendered service that caused this charge.")
    protected List<CodeableReference> service;
    @Child(name="product", type={CodeableReference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Product charged", formalDefinition="Identifies the device, food, drug or other product being charged either by type code or reference to an instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
    protected List<CodeableReference> product;
    @Child(name="account", type={Account.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Account to place this charge", formalDefinition="Account into which this ChargeItems belongs.")
    protected List<Reference> account;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the ChargeItem", formalDefinition="Comments made about the event by the performer, subject or other participants.")
    protected List<Annotation> note;
    @Child(name="supportingInformation", type={Reference.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information supporting this charge", formalDefinition="Further information supporting this charge.")
    protected List<Reference> supportingInformation;
    private static final long serialVersionUID = -766813613L;
    @SearchParamDefinition(name="account", path="ChargeItem.account", description="Account to place this charge", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("ChargeItem:account").toLocked();
    @SearchParamDefinition(name="code", path="ChargeItem.code", description="A code that identifies the charge, like a billing code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="encounter", path="ChargeItem.encounter", description="Encounter associated with event", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ChargeItem:encounter").toLocked();
    @SearchParamDefinition(name="entered-date", path="ChargeItem.enteredDate", description="Date the charge item was entered", type="date")
    public static final String SP_ENTERED_DATE = "entered-date";
    public static final DateClientParam ENTERED_DATE = new DateClientParam("entered-date");
    @SearchParamDefinition(name="enterer", path="ChargeItem.enterer", description="Individual who was entering", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("ChargeItem:enterer").toLocked();
    @SearchParamDefinition(name="factor-override", path="ChargeItem.totalPriceComponent.factor", description="Factor overriding the associated rules", type="number")
    public static final String SP_FACTOR_OVERRIDE = "factor-override";
    public static final NumberClientParam FACTOR_OVERRIDE = new NumberClientParam("factor-override");
    @SearchParamDefinition(name="identifier", path="ChargeItem.identifier", description="Business Identifier for item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="occurrence", path="ChargeItem.occurrence", description="When the charged service was applied", type="date")
    public static final String SP_OCCURRENCE = "occurrence";
    public static final DateClientParam OCCURRENCE = new DateClientParam("occurrence");
    @SearchParamDefinition(name="patient", path="ChargeItem.subject.where(resolve() is Patient)", description="Individual service was done for/to", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ChargeItem:patient").toLocked();
    @SearchParamDefinition(name="performer-actor", path="ChargeItem.performer.actor", description="Individual who was performing", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER_ACTOR = "performer-actor";
    public static final ReferenceClientParam PERFORMER_ACTOR = new ReferenceClientParam("performer-actor");
    public static final Include INCLUDE_PERFORMER_ACTOR = new Include("ChargeItem:performer-actor").toLocked();
    @SearchParamDefinition(name="performer-function", path="ChargeItem.performer.function", description="What type of performance was done", type="token")
    public static final String SP_PERFORMER_FUNCTION = "performer-function";
    public static final TokenClientParam PERFORMER_FUNCTION = new TokenClientParam("performer-function");
    @SearchParamDefinition(name="performing-organization", path="ChargeItem.performingOrganization", description="Organization providing the charged service", type="reference", target={Organization.class})
    public static final String SP_PERFORMING_ORGANIZATION = "performing-organization";
    public static final ReferenceClientParam PERFORMING_ORGANIZATION = new ReferenceClientParam("performing-organization");
    public static final Include INCLUDE_PERFORMING_ORGANIZATION = new Include("ChargeItem:performing-organization").toLocked();
    @SearchParamDefinition(name="price-override", path="ChargeItem.totalPriceComponent.amount", description="Price overriding the associated rules", type="quantity")
    public static final String SP_PRICE_OVERRIDE = "price-override";
    public static final QuantityClientParam PRICE_OVERRIDE = new QuantityClientParam("price-override");
    @SearchParamDefinition(name="quantity", path="ChargeItem.quantity", description="Quantity of which the charge item has been serviced", type="quantity")
    public static final String SP_QUANTITY = "quantity";
    public static final QuantityClientParam QUANTITY = new QuantityClientParam("quantity");
    @SearchParamDefinition(name="requesting-organization", path="ChargeItem.requestingOrganization", description="Organization requesting the charged service", type="reference", target={Organization.class})
    public static final String SP_REQUESTING_ORGANIZATION = "requesting-organization";
    public static final ReferenceClientParam REQUESTING_ORGANIZATION = new ReferenceClientParam("requesting-organization");
    public static final Include INCLUDE_REQUESTING_ORGANIZATION = new Include("ChargeItem:requesting-organization").toLocked();
    @SearchParamDefinition(name="service", path="ChargeItem.service.reference", description="Which rendered service is being charged?", type="reference")
    public static final String SP_SERVICE = "service";
    public static final ReferenceClientParam SERVICE = new ReferenceClientParam("service");
    public static final Include INCLUDE_SERVICE = new Include("ChargeItem:service").toLocked();
    @SearchParamDefinition(name="subject", path="ChargeItem.subject", description="Individual service was done for/to", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ChargeItem:subject").toLocked();

    public ChargeItem() {
    }

    public ChargeItem(ChargeItemStatus status, CodeableConcept code, Reference subject) {
        this.setStatus(status);
        this.setCode(code);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ChargeItem setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ChargeItem addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<UriType> getDefinitionUri() {
        if (this.definitionUri == null) {
            this.definitionUri = new ArrayList<UriType>();
        }
        return this.definitionUri;
    }

    public ChargeItem setDefinitionUri(List<UriType> theDefinitionUri) {
        this.definitionUri = theDefinitionUri;
        return this;
    }

    public boolean hasDefinitionUri() {
        if (this.definitionUri == null) {
            return false;
        }
        for (UriType item : this.definitionUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDefinitionUriElement() {
        UriType t = new UriType();
        if (this.definitionUri == null) {
            this.definitionUri = new ArrayList<UriType>();
        }
        this.definitionUri.add(t);
        return t;
    }

    public ChargeItem addDefinitionUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.definitionUri == null) {
            this.definitionUri = new ArrayList<UriType>();
        }
        this.definitionUri.add(t);
        return this;
    }

    public boolean hasDefinitionUri(String value) {
        if (this.definitionUri == null) {
            return false;
        }
        for (UriType v : this.definitionUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getDefinitionCanonical() {
        if (this.definitionCanonical == null) {
            this.definitionCanonical = new ArrayList<CanonicalType>();
        }
        return this.definitionCanonical;
    }

    public ChargeItem setDefinitionCanonical(List<CanonicalType> theDefinitionCanonical) {
        this.definitionCanonical = theDefinitionCanonical;
        return this;
    }

    public boolean hasDefinitionCanonical() {
        if (this.definitionCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.definitionCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDefinitionCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.definitionCanonical == null) {
            this.definitionCanonical = new ArrayList<CanonicalType>();
        }
        this.definitionCanonical.add(t);
        return t;
    }

    public ChargeItem addDefinitionCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.definitionCanonical == null) {
            this.definitionCanonical = new ArrayList<CanonicalType>();
        }
        this.definitionCanonical.add(t);
        return this;
    }

    public boolean hasDefinitionCanonical(String value) {
        if (this.definitionCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.definitionCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ChargeItemStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ChargeItemStatus>(new ChargeItemStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ChargeItem setStatusElement(Enumeration<ChargeItemStatus> value) {
        this.status = value;
        return this;
    }

    public ChargeItemStatus getStatus() {
        return this.status == null ? null : (ChargeItemStatus)((Object)this.status.getValue());
    }

    public ChargeItem setStatus(ChargeItemStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ChargeItemStatus>(new ChargeItemStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public ChargeItem setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public ChargeItem addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ChargeItem setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ChargeItem setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ChargeItem setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public ChargeItem setOccurrence(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new Error("Not the right type for ChargeItem.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public List<ChargeItemPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ChargeItemPerformerComponent>();
        }
        return this.performer;
    }

    public ChargeItem setPerformer(List<ChargeItemPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ChargeItemPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemPerformerComponent addPerformer() {
        ChargeItemPerformerComponent t = new ChargeItemPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ChargeItemPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public ChargeItem addPerformer(ChargeItemPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ChargeItemPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ChargeItemPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getPerformingOrganization() {
        if (this.performingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.performingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.performingOrganization = new Reference();
            }
        }
        return this.performingOrganization;
    }

    public boolean hasPerformingOrganization() {
        return this.performingOrganization != null && !this.performingOrganization.isEmpty();
    }

    public ChargeItem setPerformingOrganization(Reference value) {
        this.performingOrganization = value;
        return this;
    }

    public Reference getRequestingOrganization() {
        if (this.requestingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.requestingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestingOrganization = new Reference();
            }
        }
        return this.requestingOrganization;
    }

    public boolean hasRequestingOrganization() {
        return this.requestingOrganization != null && !this.requestingOrganization.isEmpty();
    }

    public ChargeItem setRequestingOrganization(Reference value) {
        this.requestingOrganization = value;
        return this;
    }

    public Reference getCostCenter() {
        if (this.costCenter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.costCenter");
            }
            if (Configuration.doAutoCreate()) {
                this.costCenter = new Reference();
            }
        }
        return this.costCenter;
    }

    public boolean hasCostCenter() {
        return this.costCenter != null && !this.costCenter.isEmpty();
    }

    public ChargeItem setCostCenter(Reference value) {
        this.costCenter = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public ChargeItem setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public List<CodeableConcept> getBodysite() {
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        return this.bodysite;
    }

    public ChargeItem setBodysite(List<CodeableConcept> theBodysite) {
        this.bodysite = theBodysite;
        return this;
    }

    public boolean hasBodysite() {
        if (this.bodysite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodysite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodysite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        this.bodysite.add(t);
        return t;
    }

    public ChargeItem addBodysite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        this.bodysite.add(t);
        return this;
    }

    public CodeableConcept getBodysiteFirstRep() {
        if (this.getBodysite().isEmpty()) {
            this.addBodysite();
        }
        return this.getBodysite().get(0);
    }

    public MonetaryComponent getUnitPriceComponent() {
        if (this.unitPriceComponent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.unitPriceComponent");
            }
            if (Configuration.doAutoCreate()) {
                this.unitPriceComponent = new MonetaryComponent();
            }
        }
        return this.unitPriceComponent;
    }

    public boolean hasUnitPriceComponent() {
        return this.unitPriceComponent != null && !this.unitPriceComponent.isEmpty();
    }

    public ChargeItem setUnitPriceComponent(MonetaryComponent value) {
        this.unitPriceComponent = value;
        return this;
    }

    public MonetaryComponent getTotalPriceComponent() {
        if (this.totalPriceComponent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.totalPriceComponent");
            }
            if (Configuration.doAutoCreate()) {
                this.totalPriceComponent = new MonetaryComponent();
            }
        }
        return this.totalPriceComponent;
    }

    public boolean hasTotalPriceComponent() {
        return this.totalPriceComponent != null && !this.totalPriceComponent.isEmpty();
    }

    public ChargeItem setTotalPriceComponent(MonetaryComponent value) {
        this.totalPriceComponent = value;
        return this;
    }

    public CodeableConcept getOverrideReason() {
        if (this.overrideReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.overrideReason");
            }
            if (Configuration.doAutoCreate()) {
                this.overrideReason = new CodeableConcept();
            }
        }
        return this.overrideReason;
    }

    public boolean hasOverrideReason() {
        return this.overrideReason != null && !this.overrideReason.isEmpty();
    }

    public ChargeItem setOverrideReason(CodeableConcept value) {
        this.overrideReason = value;
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public ChargeItem setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public DateTimeType getEnteredDateElement() {
        if (this.enteredDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.enteredDate");
            }
            if (Configuration.doAutoCreate()) {
                this.enteredDate = new DateTimeType();
            }
        }
        return this.enteredDate;
    }

    public boolean hasEnteredDateElement() {
        return this.enteredDate != null && !this.enteredDate.isEmpty();
    }

    public boolean hasEnteredDate() {
        return this.enteredDate != null && !this.enteredDate.isEmpty();
    }

    public ChargeItem setEnteredDateElement(DateTimeType value) {
        this.enteredDate = value;
        return this;
    }

    public Date getEnteredDate() {
        return this.enteredDate == null ? null : (Date)this.enteredDate.getValue();
    }

    public ChargeItem setEnteredDate(Date value) {
        if (value == null) {
            this.enteredDate = null;
        } else {
            if (this.enteredDate == null) {
                this.enteredDate = new DateTimeType();
            }
            this.enteredDate.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public ChargeItem setReason(List<CodeableConcept> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public ChargeItem addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableConcept getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<CodeableReference> getService() {
        if (this.service == null) {
            this.service = new ArrayList<CodeableReference>();
        }
        return this.service;
    }

    public ChargeItem setService(List<CodeableReference> theService) {
        this.service = theService;
        return this;
    }

    public boolean hasService() {
        if (this.service == null) {
            return false;
        }
        for (CodeableReference item : this.service) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addService() {
        CodeableReference t = new CodeableReference();
        if (this.service == null) {
            this.service = new ArrayList<CodeableReference>();
        }
        this.service.add(t);
        return t;
    }

    public ChargeItem addService(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.service == null) {
            this.service = new ArrayList<CodeableReference>();
        }
        this.service.add(t);
        return this;
    }

    public CodeableReference getServiceFirstRep() {
        if (this.getService().isEmpty()) {
            this.addService();
        }
        return this.getService().get(0);
    }

    public List<CodeableReference> getProduct() {
        if (this.product == null) {
            this.product = new ArrayList<CodeableReference>();
        }
        return this.product;
    }

    public ChargeItem setProduct(List<CodeableReference> theProduct) {
        this.product = theProduct;
        return this;
    }

    public boolean hasProduct() {
        if (this.product == null) {
            return false;
        }
        for (CodeableReference item : this.product) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addProduct() {
        CodeableReference t = new CodeableReference();
        if (this.product == null) {
            this.product = new ArrayList<CodeableReference>();
        }
        this.product.add(t);
        return t;
    }

    public ChargeItem addProduct(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.product == null) {
            this.product = new ArrayList<CodeableReference>();
        }
        this.product.add(t);
        return this;
    }

    public CodeableReference getProductFirstRep() {
        if (this.getProduct().isEmpty()) {
            this.addProduct();
        }
        return this.getProduct().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public ChargeItem setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public ChargeItem addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ChargeItem setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ChargeItem addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public ChargeItem setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public ChargeItem addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this event performer or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("definitionUri", "uri", "References the (external) source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definitionUri));
        children.add(new Property("definitionCanonical", "canonical(ChargeItemDefinition)", "References the source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definitionCanonical));
        children.add(new Property("status", SP_CODE, "The current state of the ChargeItem.", 0, 1, this.status));
        children.add(new Property("partOf", "Reference(ChargeItem)", "ChargeItems can be grouped to larger ChargeItems covering the whole set.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that identifies the charge, like a billing code.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals the action is being or was performed on.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "This ChargeItem has the details of how the associated Encounter should be billed or otherwise be handled by finance systems.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence));
        children.add(new Property("performer", "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("performingOrganization", "Reference(Organization)", "The organization performing the service.", 0, 1, this.performingOrganization));
        children.add(new Property("requestingOrganization", "Reference(Organization)", "The organization requesting the service.", 0, 1, this.requestingOrganization));
        children.add(new Property("costCenter", "Reference(Organization)", "The financial cost center permits the tracking of charge attribution.", 0, 1, this.costCenter));
        children.add(new Property(SP_QUANTITY, "Quantity", "Quantity of which the charge item has been serviced.", 0, 1, this.quantity));
        children.add(new Property("bodysite", "CodeableConcept", "The anatomical location where the related service has been applied.", 0, Integer.MAX_VALUE, this.bodysite));
        children.add(new Property("unitPriceComponent", "MonetaryComponent", "The unit price of the chargable item.", 0, 1, this.unitPriceComponent));
        children.add(new Property("totalPriceComponent", "MonetaryComponent", "The total price for the chargable item, accounting for the quantity.", 0, 1, this.totalPriceComponent));
        children.add(new Property("overrideReason", "CodeableConcept", "If the list price or the rule-based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.", 0, 1, this.overrideReason));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who entered the charge item.", 0, 1, this.enterer));
        children.add(new Property("enteredDate", "dateTime", "Date the charge item was entered.", 0, 1, this.enteredDate));
        children.add(new Property("reason", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_SERVICE, "CodeableReference(DiagnosticReport|ImagingStudy|Immunization|MedicationAdministration|MedicationDispense|MedicationRequest|Observation|Procedure|ServiceRequest|SupplyDelivery)", "Indicated the rendered service that caused this charge.", 0, Integer.MAX_VALUE, this.service));
        children.add(new Property("product", "CodeableReference(Device|Medication|Substance)", "Identifies the device, food, drug or other product being charged either by type code or reference to an instance.", 0, Integer.MAX_VALUE, this.product));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "Account into which this ChargeItems belongs.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("supportingInformation", "Reference(Any)", "Further information supporting this charge.", 0, Integer.MAX_VALUE, this.supportingInformation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this event performer or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1139428583: {
                return new Property("definitionUri", "uri", "References the (external) source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definitionUri);
            }
            case 933485793: {
                return new Property("definitionCanonical", "canonical(ChargeItemDefinition)", "References the source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definitionCanonical);
            }
            case -892481550: {
                return new Property("status", SP_CODE, "The current state of the ChargeItem.", 0, 1, this.status);
            }
            case -995410646: {
                return new Property("partOf", "Reference(ChargeItem)", "ChargeItems can be grouped to larger ChargeItems covering the whole set.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that identifies the charge, like a billing code.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals the action is being or was performed on.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "This ChargeItem has the details of how the associated Encounter should be billed or otherwise be handled by finance systems.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 481140686: {
                return new Property("performer", "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1273192628: {
                return new Property("performingOrganization", "Reference(Organization)", "The organization performing the service.", 0, 1, this.performingOrganization);
            }
            case 1279054790: {
                return new Property("requestingOrganization", "Reference(Organization)", "The organization requesting the service.", 0, 1, this.requestingOrganization);
            }
            case -593192318: {
                return new Property("costCenter", "Reference(Organization)", "The financial cost center permits the tracking of charge attribution.", 0, 1, this.costCenter);
            }
            case -1285004149: {
                return new Property(SP_QUANTITY, "Quantity", "Quantity of which the charge item has been serviced.", 0, 1, this.quantity);
            }
            case 1703573481: {
                return new Property("bodysite", "CodeableConcept", "The anatomical location where the related service has been applied.", 0, Integer.MAX_VALUE, this.bodysite);
            }
            case -925197224: {
                return new Property("unitPriceComponent", "MonetaryComponent", "The unit price of the chargable item.", 0, 1, this.unitPriceComponent);
            }
            case 1731497496: {
                return new Property("totalPriceComponent", "MonetaryComponent", "The total price for the chargable item, accounting for the quantity.", 0, 1, this.totalPriceComponent);
            }
            case -742878928: {
                return new Property("overrideReason", "CodeableConcept", "If the list price or the rule-based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.", 0, 1, this.overrideReason);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who entered the charge item.", 0, 1, this.enterer);
            }
            case 555978181: {
                return new Property("enteredDate", "dateTime", "Date the charge item was entered.", 0, 1, this.enteredDate);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1984153269: {
                return new Property(SP_SERVICE, "CodeableReference(DiagnosticReport|ImagingStudy|Immunization|MedicationAdministration|MedicationDispense|MedicationRequest|Observation|Procedure|ServiceRequest|SupplyDelivery)", "Indicated the rendered service that caused this charge.", 0, Integer.MAX_VALUE, this.service);
            }
            case -309474065: {
                return new Property("product", "CodeableReference(Device|Medication|Substance)", "Identifies the device, food, drug or other product being charged either by type code or reference to an instance.", 0, Integer.MAX_VALUE, this.product);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "Account into which this ChargeItems belongs.", 0, Integer.MAX_VALUE, this.account);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Further information supporting this charge.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1139428583: {
                return this.definitionUri == null ? new Base[]{} : this.definitionUri.toArray(new Base[this.definitionUri.size()]);
            }
            case 933485793: {
                return this.definitionCanonical == null ? new Base[]{} : this.definitionCanonical.toArray(new Base[this.definitionCanonical.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.occurrence;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1273192628: {
                Base[] baseArray;
                if (this.performingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.performingOrganization;
                }
                return baseArray;
            }
            case 1279054790: {
                Base[] baseArray;
                if (this.requestingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requestingOrganization;
                }
                return baseArray;
            }
            case -593192318: {
                Base[] baseArray;
                if (this.costCenter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.costCenter;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.quantity;
                }
                return baseArray;
            }
            case 1703573481: {
                return this.bodysite == null ? new Base[]{} : this.bodysite.toArray(new Base[this.bodysite.size()]);
            }
            case -925197224: {
                Base[] baseArray;
                if (this.unitPriceComponent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.unitPriceComponent;
                }
                return baseArray;
            }
            case 1731497496: {
                Base[] baseArray;
                if (this.totalPriceComponent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.totalPriceComponent;
                }
                return baseArray;
            }
            case -742878928: {
                Base[] baseArray;
                if (this.overrideReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.overrideReason;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.enterer;
                }
                return baseArray;
            }
            case 555978181: {
                Base[] baseArray;
                if (this.enteredDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.enteredDate;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1984153269: {
                return this.service == null ? new Base[]{} : this.service.toArray(new Base[this.service.size()]);
            }
            case -309474065: {
                return this.product == null ? new Base[]{} : this.product.toArray(new Base[this.product.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1139428583: {
                this.getDefinitionUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case 933485793: {
                this.getDefinitionCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new ChargeItemStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ChargeItemPerformerComponent)((Object)value));
                return value;
            }
            case 1273192628: {
                this.performingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case 1279054790: {
                this.requestingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case -593192318: {
                this.costCenter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 1703573481: {
                this.getBodysite().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -925197224: {
                this.unitPriceComponent = TypeConvertor.castToMonetaryComponent(value);
                return value;
            }
            case 1731497496: {
                this.totalPriceComponent = TypeConvertor.castToMonetaryComponent(value);
                return value;
            }
            case -742878928: {
                this.overrideReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1591951995: {
                this.enterer = TypeConvertor.castToReference(value);
                return value;
            }
            case 555978181: {
                this.enteredDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1984153269: {
                this.getService().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -309474065: {
                this.getProduct().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("definitionUri")) {
            this.getDefinitionUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("definitionCanonical")) {
            this.getDefinitionCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("status")) {
            value = new ChargeItemStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add((ChargeItemPerformerComponent)((Object)value));
        } else if (name.equals("performingOrganization")) {
            this.performingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals("requestingOrganization")) {
            this.requestingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals("costCenter")) {
            this.costCenter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_QUANTITY)) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("bodysite")) {
            this.getBodysite().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("unitPriceComponent")) {
            this.unitPriceComponent = TypeConvertor.castToMonetaryComponent(value);
        } else if (name.equals("totalPriceComponent")) {
            this.totalPriceComponent = TypeConvertor.castToMonetaryComponent(value);
        } else if (name.equals("overrideReason")) {
            this.overrideReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = TypeConvertor.castToReference(value);
        } else if (name.equals("enteredDate")) {
            this.enteredDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SERVICE)) {
            this.getService().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("product")) {
            this.getProduct().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_ACCOUNT)) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1139428583: {
                return this.addDefinitionUriElement();
            }
            case 933485793: {
                return this.addDefinitionCanonicalElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1273192628: {
                return this.getPerformingOrganization();
            }
            case 1279054790: {
                return this.getRequestingOrganization();
            }
            case -593192318: {
                return this.getCostCenter();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 1703573481: {
                return this.addBodysite();
            }
            case -925197224: {
                return this.getUnitPriceComponent();
            }
            case 1731497496: {
                return this.getTotalPriceComponent();
            }
            case -742878928: {
                return this.getOverrideReason();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 555978181: {
                return this.getEnteredDateElement();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1984153269: {
                return this.addService();
            }
            case -309474065: {
                return this.addProduct();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1139428583: {
                return new String[]{"uri"};
            }
            case 933485793: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1273192628: {
                return new String[]{"Reference"};
            }
            case 1279054790: {
                return new String[]{"Reference"};
            }
            case -593192318: {
                return new String[]{"Reference"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 1703573481: {
                return new String[]{"CodeableConcept"};
            }
            case -925197224: {
                return new String[]{"MonetaryComponent"};
            }
            case 1731497496: {
                return new String[]{"MonetaryComponent"};
            }
            case -742878928: {
                return new String[]{"CodeableConcept"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 555978181: {
                return new String[]{"dateTime"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case 1984153269: {
                return new String[]{"CodeableReference"};
            }
            case -309474065: {
                return new String[]{"CodeableReference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("definitionUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItem.definitionUri");
        }
        if (name.equals("definitionCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItem.definitionCanonical");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItem.status");
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals("performingOrganization")) {
            this.performingOrganization = new Reference();
            return this.performingOrganization;
        }
        if (name.equals("requestingOrganization")) {
            this.requestingOrganization = new Reference();
            return this.requestingOrganization;
        }
        if (name.equals("costCenter")) {
            this.costCenter = new Reference();
            return this.costCenter;
        }
        if (name.equals(SP_QUANTITY)) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("bodysite")) {
            return this.addBodysite();
        }
        if (name.equals("unitPriceComponent")) {
            this.unitPriceComponent = new MonetaryComponent();
            return this.unitPriceComponent;
        }
        if (name.equals("totalPriceComponent")) {
            this.totalPriceComponent = new MonetaryComponent();
            return this.totalPriceComponent;
        }
        if (name.equals("overrideReason")) {
            this.overrideReason = new CodeableConcept();
            return this.overrideReason;
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("enteredDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItem.enteredDate");
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_SERVICE)) {
            return this.addService();
        }
        if (name.equals("product")) {
            return this.addProduct();
        }
        if (name.equals(SP_ACCOUNT)) {
            return this.addAccount();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ChargeItem";
    }

    @Override
    public ChargeItem copy() {
        ChargeItem dst = new ChargeItem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ChargeItem dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definitionUri != null) {
            dst.definitionUri = new ArrayList<UriType>();
            for (UriType uriType : this.definitionUri) {
                dst.definitionUri.add(uriType.copy());
            }
        }
        if (this.definitionCanonical != null) {
            dst.definitionCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.definitionCanonical) {
                dst.definitionCanonical.add(canonicalType.copy());
            }
        }
        Enumeration<ChargeItemStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        DataType dataType = dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ChargeItemPerformerComponent>();
            for (ChargeItemPerformerComponent chargeItemPerformerComponent : this.performer) {
                dst.performer.add(chargeItemPerformerComponent.copy());
            }
        }
        dst.performingOrganization = this.performingOrganization == null ? null : this.performingOrganization.copy();
        dst.requestingOrganization = this.requestingOrganization == null ? null : this.requestingOrganization.copy();
        dst.costCenter = this.costCenter == null ? null : this.costCenter.copy();
        Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.bodysite != null) {
            dst.bodysite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodysite) {
                dst.bodysite.add(codeableConcept.copy());
            }
        }
        dst.unitPriceComponent = this.unitPriceComponent == null ? null : this.unitPriceComponent.copy();
        dst.totalPriceComponent = this.totalPriceComponent == null ? null : this.totalPriceComponent.copy();
        dst.overrideReason = this.overrideReason == null ? null : this.overrideReason.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        DateTimeType dateTimeType = dst.enteredDate = this.enteredDate == null ? null : this.enteredDate.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        if (this.service != null) {
            dst.service = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.service) {
                dst.service.add(codeableReference.copy());
            }
        }
        if (this.product != null) {
            dst.product = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.product) {
                dst.product.add(codeableReference.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference : this.account) {
                dst.account.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
    }

    protected ChargeItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItem)) {
            return false;
        }
        ChargeItem o = (ChargeItem)other_;
        return ChargeItem.compareDeep(this.identifier, o.identifier, true) && ChargeItem.compareDeep(this.definitionUri, o.definitionUri, true) && ChargeItem.compareDeep(this.definitionCanonical, o.definitionCanonical, true) && ChargeItem.compareDeep(this.status, o.status, true) && ChargeItem.compareDeep(this.partOf, o.partOf, true) && ChargeItem.compareDeep(this.code, o.code, true) && ChargeItem.compareDeep(this.subject, o.subject, true) && ChargeItem.compareDeep(this.encounter, o.encounter, true) && ChargeItem.compareDeep(this.occurrence, o.occurrence, true) && ChargeItem.compareDeep(this.performer, o.performer, true) && ChargeItem.compareDeep(this.performingOrganization, o.performingOrganization, true) && ChargeItem.compareDeep(this.requestingOrganization, o.requestingOrganization, true) && ChargeItem.compareDeep(this.costCenter, o.costCenter, true) && ChargeItem.compareDeep(this.quantity, o.quantity, true) && ChargeItem.compareDeep(this.bodysite, o.bodysite, true) && ChargeItem.compareDeep(this.unitPriceComponent, o.unitPriceComponent, true) && ChargeItem.compareDeep(this.totalPriceComponent, o.totalPriceComponent, true) && ChargeItem.compareDeep(this.overrideReason, o.overrideReason, true) && ChargeItem.compareDeep(this.enterer, o.enterer, true) && ChargeItem.compareDeep(this.enteredDate, o.enteredDate, true) && ChargeItem.compareDeep(this.reason, o.reason, true) && ChargeItem.compareDeep(this.service, o.service, true) && ChargeItem.compareDeep(this.product, o.product, true) && ChargeItem.compareDeep(this.account, o.account, true) && ChargeItem.compareDeep(this.note, o.note, true) && ChargeItem.compareDeep(this.supportingInformation, o.supportingInformation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItem)) {
            return false;
        }
        ChargeItem o = (ChargeItem)other_;
        return ChargeItem.compareValues(this.definitionUri, o.definitionUri, true) && ChargeItem.compareValues(this.definitionCanonical, o.definitionCanonical, true) && ChargeItem.compareValues(this.status, o.status, true) && ChargeItem.compareValues(this.enteredDate, o.enteredDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definitionUri, this.definitionCanonical, this.status, this.partOf, this.code, this.subject, this.encounter, this.occurrence, this.performer, this.performingOrganization, this.requestingOrganization, this.costCenter, this.quantity, this.bodysite, this.unitPriceComponent, this.totalPriceComponent, this.overrideReason, this.enterer, this.enteredDate, this.reason, this.service, this.product, this.account, this.note, this.supportingInformation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ChargeItem;
    }

    @Block
    public static class ChargeItemPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type of performance was done", formalDefinition="Describes the type of performance or participation(e.g. primary surgeon, anesthesiologiest, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, HealthcareService.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was performing", formalDefinition="The device, practitioner, etc. who performed or participated in the service.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public ChargeItemPerformerComponent() {
        }

        public ChargeItemPerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ChargeItemPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ChargeItemPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Describes the type of performance or participation(e.g. primary surgeon, anesthesiologiest, etc.).", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|HealthcareService|CareTeam|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Describes the type of performance or participation(e.g. primary surgeon, anesthesiologiest, etc.).", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|HealthcareService|CareTeam|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemPerformerComponent copy() {
            ChargeItemPerformerComponent dst = new ChargeItemPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemPerformerComponent)) {
                return false;
            }
            ChargeItemPerformerComponent o = (ChargeItemPerformerComponent)other_;
            return ChargeItemPerformerComponent.compareDeep(this.function, o.function, true) && ChargeItemPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemPerformerComponent)) {
                return false;
            }
            ChargeItemPerformerComponent o = (ChargeItemPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "ChargeItem.performer";
        }
    }

    public static class ChargeItemStatusEnumFactory
    implements EnumFactory<ChargeItemStatus> {
        @Override
        public ChargeItemStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return ChargeItemStatus.PLANNED;
            }
            if ("billable".equals(codeString)) {
                return ChargeItemStatus.BILLABLE;
            }
            if ("not-billable".equals(codeString)) {
                return ChargeItemStatus.NOTBILLABLE;
            }
            if ("aborted".equals(codeString)) {
                return ChargeItemStatus.ABORTED;
            }
            if ("billed".equals(codeString)) {
                return ChargeItemStatus.BILLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ChargeItemStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ChargeItemStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        public Enumeration<ChargeItemStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ChargeItemStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.PLANNED);
            }
            if ("billable".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.BILLABLE);
            }
            if ("not-billable".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.NOTBILLABLE);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.ABORTED);
            }
            if ("billed".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.BILLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ChargeItemStatus code) {
            if (code == ChargeItemStatus.PLANNED) {
                return "planned";
            }
            if (code == ChargeItemStatus.BILLABLE) {
                return "billable";
            }
            if (code == ChargeItemStatus.NOTBILLABLE) {
                return "not-billable";
            }
            if (code == ChargeItemStatus.ABORTED) {
                return "aborted";
            }
            if (code == ChargeItemStatus.BILLED) {
                return "billed";
            }
            if (code == ChargeItemStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ChargeItemStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ChargeItemStatus code) {
            return code.getSystem();
        }
    }

    public static enum ChargeItemStatus {
        PLANNED,
        BILLABLE,
        NOTBILLABLE,
        ABORTED,
        BILLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ChargeItemStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("billable".equals(codeString)) {
                return BILLABLE;
            }
            if ("not-billable".equals(codeString)) {
                return NOTBILLABLE;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("billed".equals(codeString)) {
                return BILLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case BILLABLE: {
                    return "billable";
                }
                case NOTBILLABLE: {
                    return "not-billable";
                }
                case ABORTED: {
                    return "aborted";
                }
                case BILLED: {
                    return "billed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case BILLABLE: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case NOTBILLABLE: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case BILLED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The charge item has been entered, but the charged service is not  yet complete, so it shall not be billed yet but might be used in the context of pre-authorization.";
                }
                case BILLABLE: {
                    return "The charge item is ready for billing.";
                }
                case NOTBILLABLE: {
                    return "The charge item has been determined to be not billable (e.g. due to rules associated with the billing code).";
                }
                case ABORTED: {
                    return "The processing of the charge was aborted.";
                }
                case BILLED: {
                    return "The charge item has been billed (e.g. a billing engine has generated financial transactions by applying the associated ruled for the charge item to the context of the Encounter, and placed them into Claims/Invoices.";
                }
                case ENTEREDINERROR: {
                    return "The charge item has been entered in error and should not be processed for billing.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this charge item  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case BILLABLE: {
                    return "Billable";
                }
                case NOTBILLABLE: {
                    return "Not billable";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case BILLED: {
                    return "Billed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

