/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RequestGroup", profile="http://hl7.org/fhir/StructureDefinition/RequestGroup")
public class RequestGroup
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide a unique, business identifier for the request.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Fulfills plan, proposal, or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this request.")
    protected List<Reference> basedOn;
    @Child(name="replaces", type={Reference.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request(s) replaced by this request", formalDefinition="Completed or terminated request(s) whose function is taken by this new request.")
    protected List<Reference> replaces;
    @Child(name="groupIdentifier", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="The current state of the request. For request groups, the status reflects the status of all the requests in the group.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected CodeType status;
    @Child(name="intent", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected CodeType intent;
    @Child(name="priority", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected CodeType priority;
    @Child(name="code", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What's being requested/ordered", formalDefinition="A code that identifies what the overall request group is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-code")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who the request group is about", formalDefinition="The subject for which the request group was created.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Created as part of", formalDefinition="Describes the context of the request group, if any.")
    protected Reference encounter;
    @Child(name="authoredOn", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the request group was authored", formalDefinition="Indicates when the request group was created.")
    protected DateTimeType authoredOn;
    @Child(name="author", type={Device.class, Practitioner.class, PractitionerRole.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Device or practitioner that authored the request group", formalDefinition="Provides a reference to the author of the request group.")
    protected Reference author;
    @Child(name="reason", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the request group is needed", formalDefinition="Describes the reason for the request group in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-reason-code")
    protected List<CodeableReference> reason;
    @Child(name="goal", type={Goal.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What goals", formalDefinition="Goals that are intended to be achieved by following the requests in this RequestGroup.")
    protected List<Reference> goal;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional notes about the response", formalDefinition="Provides a mechanism to communicate additional information about the response.")
    protected List<Annotation> note;
    @Child(name="action", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected List<RequestGroupActionComponent> action;
    private static final long serialVersionUID = 248789676L;

    public RequestGroup() {
    }

    public RequestGroup(String status, String intent) {
        this.setStatus(status);
        this.setIntent(intent);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RequestGroup setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RequestGroup addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public RequestGroup setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public RequestGroup addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public RequestGroup setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public RequestGroup addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public RequestGroup setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public RequestGroup addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public RequestGroup setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public RequestGroup addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public RequestGroup setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public CodeType getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeType();
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RequestGroup setStatusElement(CodeType value) {
        this.status = value;
        return this;
    }

    public String getStatus() {
        return this.status == null ? null : (String)this.status.getValue();
    }

    public RequestGroup setStatus(String value) {
        if (this.status == null) {
            this.status = new CodeType();
        }
        this.status.setValue(value);
        return this;
    }

    public CodeType getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new CodeType();
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public RequestGroup setIntentElement(CodeType value) {
        this.intent = value;
        return this;
    }

    public String getIntent() {
        return this.intent == null ? null : (String)this.intent.getValue();
    }

    public RequestGroup setIntent(String value) {
        if (this.intent == null) {
            this.intent = new CodeType();
        }
        this.intent.setValue(value);
        return this;
    }

    public CodeType getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeType();
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public RequestGroup setPriorityElement(CodeType value) {
        this.priority = value;
        return this;
    }

    public String getPriority() {
        return this.priority == null ? null : (String)this.priority.getValue();
    }

    public RequestGroup setPriority(String value) {
        if (Utilities.noString((String)value)) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new CodeType();
            }
            this.priority.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public RequestGroup setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RequestGroup setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public RequestGroup setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public RequestGroup setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public RequestGroup setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public RequestGroup setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public RequestGroup setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public RequestGroup addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public RequestGroup setGoal(List<Reference> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (Reference item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGoal() {
        Reference t = new Reference();
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return t;
    }

    public RequestGroup addGoal(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return this;
    }

    public Reference getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public RequestGroup setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public RequestGroup addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<RequestGroupActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        return this.action;
    }

    public RequestGroup setAction(List<RequestGroupActionComponent> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (RequestGroupActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RequestGroupActionComponent addAction() {
        RequestGroupActionComponent t = new RequestGroupActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public RequestGroup addAction(RequestGroupActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public RequestGroupActionComponent getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical", "A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier));
        children.add(new Property("status", "code", "The current state of the request. For request groups, the status reflects the status of all the requests in the group.", 0, 1, this.status));
        children.add(new Property("intent", "code", "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property("priority", "code", "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("code", "CodeableConcept", "A code that identifies what the overall request group is.", 0, 1, this.code));
        children.add(new Property("subject", "Reference(Patient|Group)", "The subject for which the request group was created.", 0, 1, this.subject));
        children.add(new Property("encounter", "Reference(Encounter)", "Describes the context of the request group, if any.", 0, 1, this.encounter));
        children.add(new Property("authoredOn", "dateTime", "Indicates when the request group was created.", 0, 1, this.authoredOn));
        children.add(new Property("author", "Reference(Device|Practitioner|PractitionerRole)", "Provides a reference to the author of the request group.", 0, 1, this.author));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Describes the reason for the request group in coded or textual form.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this RequestGroup.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical", "A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property("status", "code", "The current state of the request. For request groups, the status reflects the status of all the requests in the group.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property("intent", "code", "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property("priority", "code", "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "A code that identifies what the overall request group is.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property("subject", "Reference(Patient|Group)", "The subject for which the request group was created.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "Describes the context of the request group, if any.", 0, 1, this.encounter);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "Indicates when the request group was created.", 0, 1, this.authoredOn);
            }
            case -1406328437: {
                return new Property("author", "Reference(Device|Practitioner|PractitionerRole)", "Provides a reference to the author of the request group.", 0, 1, this.author);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Describes the reason for the request group in coded or textual form.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3178259: {
                return new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this RequestGroup.", 0, Integer.MAX_VALUE, this.goal);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1422950858: {
                return new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.encounter;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.authoredOn;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.author;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCode(value);
                return value;
            }
            case -1183762788: {
                this.intent = TypeConvertor.castToCode(value);
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCode(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1422950858: {
                this.getAction().add((RequestGroupActionComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("replaces")) {
            this.getReplaces().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("status")) {
            this.status = TypeConvertor.castToCode(value);
        } else if (name.equals("intent")) {
            this.intent = TypeConvertor.castToCode(value);
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCode(value);
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("subject")) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals("author")) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("goal")) {
            this.getGoal().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("action")) {
            this.getAction().add((RequestGroupActionComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3178259: {
                return this.addGoal();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3178259: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1422950858: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("replaces")) {
            return this.addReplaces();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.status");
        }
        if (name.equals("intent")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.intent");
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.priority");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("subject")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.authoredOn");
        }
        if (name.equals("author")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("goal")) {
            return this.addGoal();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RequestGroup";
    }

    @Override
    public RequestGroup copy() {
        RequestGroup dst = new RequestGroup();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RequestGroup dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<Reference>();
            for (Reference reference2 : this.goal) {
                dst.goal.add(reference2.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<RequestGroupActionComponent>();
            for (RequestGroupActionComponent requestGroupActionComponent : this.action) {
                dst.action.add(requestGroupActionComponent.copy());
            }
        }
    }

    protected RequestGroup typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestGroup)) {
            return false;
        }
        RequestGroup o = (RequestGroup)other_;
        return RequestGroup.compareDeep(this.identifier, o.identifier, true) && RequestGroup.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && RequestGroup.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && RequestGroup.compareDeep(this.basedOn, o.basedOn, true) && RequestGroup.compareDeep(this.replaces, o.replaces, true) && RequestGroup.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && RequestGroup.compareDeep(this.status, o.status, true) && RequestGroup.compareDeep(this.intent, o.intent, true) && RequestGroup.compareDeep(this.priority, o.priority, true) && RequestGroup.compareDeep(this.code, o.code, true) && RequestGroup.compareDeep(this.subject, o.subject, true) && RequestGroup.compareDeep(this.encounter, o.encounter, true) && RequestGroup.compareDeep(this.authoredOn, o.authoredOn, true) && RequestGroup.compareDeep(this.author, o.author, true) && RequestGroup.compareDeep(this.reason, o.reason, true) && RequestGroup.compareDeep(this.goal, o.goal, true) && RequestGroup.compareDeep(this.note, o.note, true) && RequestGroup.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestGroup)) {
            return false;
        }
        RequestGroup o = (RequestGroup)other_;
        return RequestGroup.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && RequestGroup.compareValues(this.instantiatesUri, o.instantiatesUri, true) && RequestGroup.compareValues(this.status, o.status, true) && RequestGroup.compareValues(this.intent, o.intent, true) && RequestGroup.compareValues(this.priority, o.priority, true) && RequestGroup.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.intent, this.priority, this.code, this.subject, this.encounter, this.authoredOn, this.author, this.reason, this.goal, this.note, this.action});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RequestGroup;
    }

    @Block
    public static class RequestGroupActionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="careteam | device | group | healthcareservice | location | organization | patient | practitioner | practitionerrole | relatedperson", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected CodeType type;
        @Child(name="typeReference", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can participate", formalDefinition="The type of participant in the action.")
        protected Reference typeReference;
        @Child(name="role", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent, etc.", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/action-participant-role")
        protected CodeableConcept role;
        @Child(name="function", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Author, Reviewer, Witness, etc.", formalDefinition="Indicates how the actor will be involved in the action - author, reviewer, witness, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-function")
        protected CodeableConcept function;
        @Child(name="actor", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who/what is participating?", formalDefinition="A reference to the actual participant.")
        protected Reference actor;
        private static final long serialVersionUID = 354939821L;

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RequestGroupActionParticipantComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public RequestGroupActionParticipantComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Reference getTypeReference() {
            if (this.typeReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionParticipantComponent.typeReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeReference = new Reference();
                }
            }
            return this.typeReference;
        }

        public boolean hasTypeReference() {
            return this.typeReference != null && !this.typeReference.isEmpty();
        }

        public RequestGroupActionParticipantComponent setTypeReference(Reference value) {
            this.typeReference = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public RequestGroupActionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public RequestGroupActionParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public RequestGroupActionParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
            children.add(new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 2074825009: {
                    return new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 2074825009: {
                    Base[] baseArray;
                    if (this.typeReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.typeReference;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.role;
                    }
                    return baseArray;
                }
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCode(value);
                    return value;
                }
                case 2074825009: {
                    this.typeReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCode(value);
            } else if (name.equals("typeReference")) {
                this.typeReference = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 2074825009: {
                    return this.getTypeReference();
                }
                case 3506294: {
                    return this.getRole();
                }
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 2074825009: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.participant.type");
            }
            if (name.equals("typeReference")) {
                this.typeReference = new Reference();
                return this.typeReference;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionParticipantComponent copy() {
            RequestGroupActionParticipantComponent dst = new RequestGroupActionParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestGroupActionParticipantComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.typeReference = this.typeReference == null ? null : this.typeReference.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionParticipantComponent)) {
                return false;
            }
            RequestGroupActionParticipantComponent o = (RequestGroupActionParticipantComponent)other_;
            return RequestGroupActionParticipantComponent.compareDeep(this.type, o.type, true) && RequestGroupActionParticipantComponent.compareDeep(this.typeReference, o.typeReference, true) && RequestGroupActionParticipantComponent.compareDeep(this.role, o.role, true) && RequestGroupActionParticipantComponent.compareDeep(this.function, o.function, true) && RequestGroupActionParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionParticipantComponent)) {
                return false;
            }
            RequestGroupActionParticipantComponent o = (RequestGroupActionParticipantComponent)other_;
            return RequestGroupActionParticipantComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.typeReference, this.role, this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action.participant";
        }
    }

    @Block
    public static class RequestGroupActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="targetId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What action this is related to", formalDefinition="The element id of the target related action.")
        protected IdType targetId;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before-start | before | before-end | concurrent-with-start | concurrent | concurrent-with-end | after-start | after | after-end", formalDefinition="The relationship of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected CodeType relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected DataType offset;
        private static final long serialVersionUID = 1412792231L;

        public RequestGroupActionRelatedActionComponent() {
        }

        public RequestGroupActionRelatedActionComponent(String targetId, String relationship) {
            this.setTargetId(targetId);
            this.setRelationship(relationship);
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionRelatedActionComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public RequestGroupActionRelatedActionComponent setTargetId(String value) {
            if (this.targetId == null) {
                this.targetId = new IdType();
            }
            this.targetId.setValue(value);
            return this;
        }

        public CodeType getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeType();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setRelationshipElement(CodeType value) {
            this.relationship = value;
            return this;
        }

        public String getRelationship() {
            return this.relationship == null ? null : (String)this.relationship.getValue();
        }

        public RequestGroupActionRelatedActionComponent setRelationship(String value) {
            if (this.relationship == null) {
                this.relationship = new CodeType();
            }
            this.relationship.setValue(value);
            return this;
        }

        public DataType getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Duration();
            }
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this != null && this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Range();
            }
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this != null && this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setOffset(DataType value) {
            if (value != null && !(value instanceof Duration) && !(value instanceof Range)) {
                throw new Error("Not the right type for RequestGroup.action.relatedAction.offset[x]: " + value.fhirType());
            }
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId));
            children.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship));
            children.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -441951604: {
                    return new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship);
                }
                case -1960684787: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case -1019779949: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 134075207: {
                    return new Property("offset[x]", "Duration", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 1263585386: {
                    return new Property("offset[x]", "Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.targetId;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    this.targetId = TypeConvertor.castToId(value);
                    return value;
                }
                case -261851592: {
                    this.relationship = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1019779949: {
                    this.offset = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("targetId")) {
                this.targetId = TypeConvertor.castToId(value);
            } else if (name.equals("relationship")) {
                this.relationship = TypeConvertor.castToCode(value);
            } else if (name.equals("offset[x]")) {
                this.offset = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return this.getTargetIdElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return new String[]{"id"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case -1019779949: {
                    return new String[]{"Duration", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.relatedAction.targetId");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.relatedAction.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionRelatedActionComponent copy() {
            RequestGroupActionRelatedActionComponent dst = new RequestGroupActionRelatedActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestGroupActionRelatedActionComponent dst) {
            super.copyValues(dst);
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionRelatedActionComponent)) {
                return false;
            }
            RequestGroupActionRelatedActionComponent o = (RequestGroupActionRelatedActionComponent)other_;
            return RequestGroupActionRelatedActionComponent.compareDeep(this.targetId, o.targetId, true) && RequestGroupActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && RequestGroupActionRelatedActionComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionRelatedActionComponent)) {
                return false;
            }
            RequestGroupActionRelatedActionComponent o = (RequestGroupActionRelatedActionComponent)other_;
            return RequestGroupActionRelatedActionComponent.compareValues(this.targetId, o.targetId, true) && RequestGroupActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.targetId, this.relationship, this.offset});
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action.relatedAction";
        }
    }

    @Block
    public static class RequestGroupActionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="applicability | start | stop", formalDefinition="The kind of condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind")
        protected CodeType kind;
        @Child(name="expression", type={Expression.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether or not the condition is satisfied.")
        protected Expression expression;
        private static final long serialVersionUID = 372366087L;

        public RequestGroupActionConditionComponent() {
        }

        public RequestGroupActionConditionComponent(String kind) {
            this.setKind(kind);
        }

        public CodeType getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new CodeType();
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public RequestGroupActionConditionComponent setKindElement(CodeType value) {
            this.kind = value;
            return this;
        }

        public String getKind() {
            return this.kind == null ? null : (String)this.kind.getValue();
        }

        public RequestGroupActionConditionComponent setKind(String value) {
            if (this.kind == null) {
                this.kind = new CodeType();
            }
            this.kind.setValue(value);
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public RequestGroupActionConditionComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", "code", "The kind of condition.", 0, 1, this.kind));
            children.add(new Property("expression", "Expression", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", "code", "The kind of condition.", 0, 1, this.kind);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    this.kind = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                this.kind = TypeConvertor.castToCode(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.condition.kind");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionConditionComponent copy() {
            RequestGroupActionConditionComponent dst = new RequestGroupActionConditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestGroupActionConditionComponent dst) {
            super.copyValues(dst);
            dst.kind = this.kind == null ? null : this.kind.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionConditionComponent)) {
                return false;
            }
            RequestGroupActionConditionComponent o = (RequestGroupActionConditionComponent)other_;
            return RequestGroupActionConditionComponent.compareDeep(this.kind, o.kind, true) && RequestGroupActionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionConditionComponent)) {
                return false;
            }
            RequestGroupActionConditionComponent o = (RequestGroupActionConditionComponent)other_;
            return RequestGroupActionConditionComponent.compareValues(this.kind, o.kind, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.kind, this.expression});
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action.condition";
        }
    }

    @Block
    public static class RequestGroupActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item from the PlanDefinition", formalDefinition="The linkId of the action from the PlanDefinition that corresponds to this action in the RequestGroup resource.")
        protected StringType linkId;
        @Child(name="prefix", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible prefix for the action (e.g. 1. or A.)", formalDefinition="A user-visible prefix for the action. For example a section or item numbering such as 1. or A.")
        protected StringType prefix;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
        protected StringType title;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
        protected StringType description;
        @Child(name="textEquivalent", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.")
        protected StringType textEquivalent;
        @Child(name="priority", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the action should be addressed with respect to other actions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
        protected CodeType priority;
        @Child(name="code", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code representing the meaning of the action or sub-actions", formalDefinition="A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-code")
        protected List<CodeableConcept> code;
        @Child(name="documentation", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="goal", type={Goal.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What goals", formalDefinition="Goals that are intended to be achieved by following the requests in this action.")
        protected List<Reference> goal;
        @Child(name="condition", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not the action is applicable", formalDefinition="An expression that describes applicability criteria, or start/stop conditions for the action.")
        protected List<RequestGroupActionConditionComponent> condition;
        @Child(name="relatedAction", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected List<RequestGroupActionRelatedActionComponent> relatedAction;
        @Child(name="timing", type={DateTimeType.class, Age.class, Period.class, Duration.class, Range.class, Timing.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should take place", formalDefinition="An optional value describing when the action should be performed.")
        protected DataType timing;
        @Child(name="location", type={CodeableReference.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.")
        protected CodeableReference location;
        @Child(name="participant", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who should perform the action", formalDefinition="The participant that should perform or be responsible for this action.")
        protected List<RequestGroupActionParticipantComponent> participant;
        @Child(name="type", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-type")
        protected CodeableConcept type;
        @Child(name="groupingBehavior", type={CodeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="visual-group | logical-group | sentence-group", formalDefinition="Defines the grouping behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior")
        protected CodeType groupingBehavior;
        @Child(name="selectionBehavior", type={CodeType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="any | all | all-or-none | exactly-one | at-most-one | one-or-more", formalDefinition="Defines the selection behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior")
        protected CodeType selectionBehavior;
        @Child(name="requiredBehavior", type={CodeType.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="must | could | must-unless-documented", formalDefinition="Defines expectations around whether an action is required.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior")
        protected CodeType requiredBehavior;
        @Child(name="precheckBehavior", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="yes | no", formalDefinition="Defines whether the action should usually be preselected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior")
        protected CodeType precheckBehavior;
        @Child(name="cardinalityBehavior", type={CodeType.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="single | multiple", formalDefinition="Defines whether the action can be selected multiple times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior")
        protected CodeType cardinalityBehavior;
        @Child(name="resource", type={Reference.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target of the action", formalDefinition="The resource that is the target of the action (e.g. CommunicationRequest).")
        protected Reference resource;
        @Child(name="action", type={RequestGroupActionComponent.class}, order=22, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Sub action", formalDefinition="Sub actions.")
        protected List<RequestGroupActionComponent> action;
        private static final long serialVersionUID = 478054352L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public RequestGroupActionComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public RequestGroupActionComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getPrefixElement() {
            if (this.prefix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.prefix");
                }
                if (Configuration.doAutoCreate()) {
                    this.prefix = new StringType();
                }
            }
            return this.prefix;
        }

        public boolean hasPrefixElement() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public boolean hasPrefix() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public RequestGroupActionComponent setPrefixElement(StringType value) {
            this.prefix = value;
            return this;
        }

        public String getPrefix() {
            return this.prefix == null ? null : (String)this.prefix.getValue();
        }

        public RequestGroupActionComponent setPrefix(String value) {
            if (Utilities.noString((String)value)) {
                this.prefix = null;
            } else {
                if (this.prefix == null) {
                    this.prefix = new StringType();
                }
                this.prefix.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public RequestGroupActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public RequestGroupActionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RequestGroupActionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RequestGroupActionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new StringType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public RequestGroupActionComponent setTextEquivalentElement(StringType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public RequestGroupActionComponent setTextEquivalent(String value) {
            if (Utilities.noString((String)value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new StringType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public CodeType getPriorityElement() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new CodeType();
                }
            }
            return this.priority;
        }

        public boolean hasPriorityElement() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public RequestGroupActionComponent setPriorityElement(CodeType value) {
            this.priority = value;
            return this;
        }

        public String getPriority() {
            return this.priority == null ? null : (String)this.priority.getValue();
        }

        public RequestGroupActionComponent setPriority(String value) {
            if (Utilities.noString((String)value)) {
                this.priority = null;
            } else {
                if (this.priority == null) {
                    this.priority = new CodeType();
                }
                this.priority.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public RequestGroupActionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public RequestGroupActionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public RequestGroupActionComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public RequestGroupActionComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<Reference> getGoal() {
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            return this.goal;
        }

        public RequestGroupActionComponent setGoal(List<Reference> theGoal) {
            this.goal = theGoal;
            return this;
        }

        public boolean hasGoal() {
            if (this.goal == null) {
                return false;
            }
            for (Reference item : this.goal) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addGoal() {
            Reference t = new Reference();
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return t;
        }

        public RequestGroupActionComponent addGoal(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return this;
        }

        public Reference getGoalFirstRep() {
            if (this.getGoal().isEmpty()) {
                this.addGoal();
            }
            return this.getGoal().get(0);
        }

        public List<RequestGroupActionConditionComponent> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            return this.condition;
        }

        public RequestGroupActionComponent setCondition(List<RequestGroupActionConditionComponent> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (RequestGroupActionConditionComponent item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionConditionComponent addCondition() {
            RequestGroupActionConditionComponent t = new RequestGroupActionConditionComponent();
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            this.condition.add(t);
            return t;
        }

        public RequestGroupActionComponent addCondition(RequestGroupActionConditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            this.condition.add(t);
            return this;
        }

        public RequestGroupActionConditionComponent getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<RequestGroupActionRelatedActionComponent> getRelatedAction() {
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            return this.relatedAction;
        }

        public RequestGroupActionComponent setRelatedAction(List<RequestGroupActionRelatedActionComponent> theRelatedAction) {
            this.relatedAction = theRelatedAction;
            return this;
        }

        public boolean hasRelatedAction() {
            if (this.relatedAction == null) {
                return false;
            }
            for (RequestGroupActionRelatedActionComponent item : this.relatedAction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionRelatedActionComponent addRelatedAction() {
            RequestGroupActionRelatedActionComponent t = new RequestGroupActionRelatedActionComponent();
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return t;
        }

        public RequestGroupActionComponent addRelatedAction(RequestGroupActionRelatedActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return this;
        }

        public RequestGroupActionRelatedActionComponent getRelatedActionFirstRep() {
            if (this.getRelatedAction().isEmpty()) {
                this.addRelatedAction();
            }
            return this.getRelatedAction().get(0);
        }

        public DataType getTiming() {
            return this.timing;
        }

        public DateTimeType getTimingDateTimeType() throws FHIRException {
            if (this.timing == null) {
                this.timing = new DateTimeType();
            }
            if (!(this.timing instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.timing;
        }

        public boolean hasTimingDateTimeType() {
            return this != null && this.timing instanceof DateTimeType;
        }

        public Age getTimingAge() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Age();
            }
            if (!(this.timing instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Age)this.timing;
        }

        public boolean hasTimingAge() {
            return this != null && this.timing instanceof Age;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Period();
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public Duration getTimingDuration() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Duration();
            }
            if (!(this.timing instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Duration)this.timing;
        }

        public boolean hasTimingDuration() {
            return this != null && this.timing instanceof Duration;
        }

        public Range getTimingRange() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Range();
            }
            if (!(this.timing instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Range)this.timing;
        }

        public boolean hasTimingRange() {
            return this != null && this.timing instanceof Range;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Timing();
            }
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this != null && this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public RequestGroupActionComponent setTiming(DataType value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Duration || value instanceof Range || value instanceof Timing)) {
                throw new Error("Not the right type for RequestGroup.action.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public CodeableReference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new CodeableReference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public RequestGroupActionComponent setLocation(CodeableReference value) {
            this.location = value;
            return this;
        }

        public List<RequestGroupActionParticipantComponent> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<RequestGroupActionParticipantComponent>();
            }
            return this.participant;
        }

        public RequestGroupActionComponent setParticipant(List<RequestGroupActionParticipantComponent> theParticipant) {
            this.participant = theParticipant;
            return this;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (RequestGroupActionParticipantComponent item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionParticipantComponent addParticipant() {
            RequestGroupActionParticipantComponent t = new RequestGroupActionParticipantComponent();
            if (this.participant == null) {
                this.participant = new ArrayList<RequestGroupActionParticipantComponent>();
            }
            this.participant.add(t);
            return t;
        }

        public RequestGroupActionComponent addParticipant(RequestGroupActionParticipantComponent t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<RequestGroupActionParticipantComponent>();
            }
            this.participant.add(t);
            return this;
        }

        public RequestGroupActionParticipantComponent getParticipantFirstRep() {
            if (this.getParticipant().isEmpty()) {
                this.addParticipant();
            }
            return this.getParticipant().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RequestGroupActionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeType getGroupingBehaviorElement() {
            if (this.groupingBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.groupingBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingBehavior = new CodeType();
                }
            }
            return this.groupingBehavior;
        }

        public boolean hasGroupingBehaviorElement() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public boolean hasGroupingBehavior() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public RequestGroupActionComponent setGroupingBehaviorElement(CodeType value) {
            this.groupingBehavior = value;
            return this;
        }

        public String getGroupingBehavior() {
            return this.groupingBehavior == null ? null : (String)this.groupingBehavior.getValue();
        }

        public RequestGroupActionComponent setGroupingBehavior(String value) {
            if (Utilities.noString((String)value)) {
                this.groupingBehavior = null;
            } else {
                if (this.groupingBehavior == null) {
                    this.groupingBehavior = new CodeType();
                }
                this.groupingBehavior.setValue(value);
            }
            return this;
        }

        public CodeType getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new CodeType();
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public RequestGroupActionComponent setSelectionBehaviorElement(CodeType value) {
            this.selectionBehavior = value;
            return this;
        }

        public String getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (String)this.selectionBehavior.getValue();
        }

        public RequestGroupActionComponent setSelectionBehavior(String value) {
            if (Utilities.noString((String)value)) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new CodeType();
                }
                this.selectionBehavior.setValue(value);
            }
            return this;
        }

        public CodeType getRequiredBehaviorElement() {
            if (this.requiredBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.requiredBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.requiredBehavior = new CodeType();
                }
            }
            return this.requiredBehavior;
        }

        public boolean hasRequiredBehaviorElement() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public boolean hasRequiredBehavior() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public RequestGroupActionComponent setRequiredBehaviorElement(CodeType value) {
            this.requiredBehavior = value;
            return this;
        }

        public String getRequiredBehavior() {
            return this.requiredBehavior == null ? null : (String)this.requiredBehavior.getValue();
        }

        public RequestGroupActionComponent setRequiredBehavior(String value) {
            if (Utilities.noString((String)value)) {
                this.requiredBehavior = null;
            } else {
                if (this.requiredBehavior == null) {
                    this.requiredBehavior = new CodeType();
                }
                this.requiredBehavior.setValue(value);
            }
            return this;
        }

        public CodeType getPrecheckBehaviorElement() {
            if (this.precheckBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.precheckBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.precheckBehavior = new CodeType();
                }
            }
            return this.precheckBehavior;
        }

        public boolean hasPrecheckBehaviorElement() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public boolean hasPrecheckBehavior() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public RequestGroupActionComponent setPrecheckBehaviorElement(CodeType value) {
            this.precheckBehavior = value;
            return this;
        }

        public String getPrecheckBehavior() {
            return this.precheckBehavior == null ? null : (String)this.precheckBehavior.getValue();
        }

        public RequestGroupActionComponent setPrecheckBehavior(String value) {
            if (Utilities.noString((String)value)) {
                this.precheckBehavior = null;
            } else {
                if (this.precheckBehavior == null) {
                    this.precheckBehavior = new CodeType();
                }
                this.precheckBehavior.setValue(value);
            }
            return this;
        }

        public CodeType getCardinalityBehaviorElement() {
            if (this.cardinalityBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.cardinalityBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.cardinalityBehavior = new CodeType();
                }
            }
            return this.cardinalityBehavior;
        }

        public boolean hasCardinalityBehaviorElement() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public boolean hasCardinalityBehavior() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public RequestGroupActionComponent setCardinalityBehaviorElement(CodeType value) {
            this.cardinalityBehavior = value;
            return this;
        }

        public String getCardinalityBehavior() {
            return this.cardinalityBehavior == null ? null : (String)this.cardinalityBehavior.getValue();
        }

        public RequestGroupActionComponent setCardinalityBehavior(String value) {
            if (Utilities.noString((String)value)) {
                this.cardinalityBehavior = null;
            } else {
                if (this.cardinalityBehavior == null) {
                    this.cardinalityBehavior = new CodeType();
                }
                this.cardinalityBehavior.setValue(value);
            }
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public RequestGroupActionComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public List<RequestGroupActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            return this.action;
        }

        public RequestGroupActionComponent setAction(List<RequestGroupActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (RequestGroupActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionComponent addAction() {
            RequestGroupActionComponent t = new RequestGroupActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public RequestGroupActionComponent addAction(RequestGroupActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public RequestGroupActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "string", "The linkId of the action from the PlanDefinition that corresponds to this action in the RequestGroup resource.", 0, 1, this.linkId));
            children.add(new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix));
            children.add(new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title));
            children.add(new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description));
            children.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent));
            children.add(new Property("priority", "code", "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority));
            children.add(new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this action.", 0, Integer.MAX_VALUE, this.goal));
            children.add(new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            children.add(new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing));
            children.add(new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
            children.add(new Property("participant", "", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant));
            children.add(new Property("type", "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type));
            children.add(new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior));
            children.add(new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior));
            children.add(new Property("requiredBehavior", "code", "Defines expectations around whether an action is required.", 0, 1, this.requiredBehavior));
            children.add(new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior));
            children.add(new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior));
            children.add(new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource));
            children.add(new Property("action", "@RequestGroup.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "string", "The linkId of the action from the PlanDefinition that corresponds to this action in the RequestGroup resource.", 0, 1, this.linkId);
                }
                case -980110702: {
                    return new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix);
                }
                case 110371416: {
                    return new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description);
                }
                case -900391049: {
                    return new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent);
                }
                case -1165461084: {
                    return new Property("priority", "code", "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case 3178259: {
                    return new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this action.", 0, Integer.MAX_VALUE, this.goal);
                }
                case -861311717: {
                    return new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition);
                }
                case -384107967: {
                    return new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction);
                }
                case 164632566: {
                    return new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1837458939: {
                    return new Property("timing[x]", "dateTime", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 164607061: {
                    return new Property("timing[x]", "Age", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "Period", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1327253506: {
                    return new Property("timing[x]", "Duration", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -710871277: {
                    return new Property("timing[x]", "Range", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -497554124: {
                    return new Property("timing[x]", "Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 1901043637: {
                    return new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
                }
                case 767422259: {
                    return new Property("participant", "", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type);
                }
                case 586678389: {
                    return new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior);
                }
                case 168639486: {
                    return new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior);
                }
                case -1163906287: {
                    return new Property("requiredBehavior", "code", "Defines expectations around whether an action is required.", 0, 1, this.requiredBehavior);
                }
                case -1174249033: {
                    return new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior);
                }
                case -922577408: {
                    return new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior);
                }
                case -341064690: {
                    return new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource);
                }
                case -1422950858: {
                    return new Property("action", "@RequestGroup.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -980110702: {
                    Base[] baseArray;
                    if (this.prefix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.prefix;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.priority;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case 3178259: {
                    return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
                }
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case -384107967: {
                    return this.relatedAction == null ? new Base[]{} : this.relatedAction.toArray(new Base[this.relatedAction.size()]);
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.timing;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.location;
                    }
                    return baseArray;
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.type;
                    }
                    return baseArray;
                }
                case 586678389: {
                    Base[] baseArray;
                    if (this.groupingBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.groupingBehavior;
                    }
                    return baseArray;
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1163906287: {
                    Base[] baseArray;
                    if (this.requiredBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.requiredBehavior;
                    }
                    return baseArray;
                }
                case -1174249033: {
                    Base[] baseArray;
                    if (this.precheckBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.precheckBehavior;
                    }
                    return baseArray;
                }
                case -922577408: {
                    Base[] baseArray;
                    if (this.cardinalityBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.cardinalityBehavior;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.resource;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToString(value);
                    return value;
                }
                case -980110702: {
                    this.prefix = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -900391049: {
                    this.textEquivalent = TypeConvertor.castToString(value);
                    return value;
                }
                case -1165461084: {
                    this.priority = TypeConvertor.castToCode(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case 3178259: {
                    this.getGoal().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -861311717: {
                    this.getCondition().add((RequestGroupActionConditionComponent)value);
                    return value;
                }
                case -384107967: {
                    this.getRelatedAction().add((RequestGroupActionRelatedActionComponent)value);
                    return value;
                }
                case -873664438: {
                    this.timing = TypeConvertor.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 767422259: {
                    this.getParticipant().add((RequestGroupActionParticipantComponent)value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 586678389: {
                    this.groupingBehavior = TypeConvertor.castToCode(value);
                    return value;
                }
                case 168639486: {
                    this.selectionBehavior = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1163906287: {
                    this.requiredBehavior = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1174249033: {
                    this.precheckBehavior = TypeConvertor.castToCode(value);
                    return value;
                }
                case -922577408: {
                    this.cardinalityBehavior = TypeConvertor.castToCode(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((RequestGroupActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToString(value);
            } else if (name.equals("prefix")) {
                this.prefix = TypeConvertor.castToString(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = TypeConvertor.castToString(value);
            } else if (name.equals("priority")) {
                this.priority = TypeConvertor.castToCode(value);
            } else if (name.equals("code")) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("goal")) {
                this.getGoal().add(TypeConvertor.castToReference(value));
            } else if (name.equals("condition")) {
                this.getCondition().add((RequestGroupActionConditionComponent)value);
            } else if (name.equals("relatedAction")) {
                this.getRelatedAction().add((RequestGroupActionRelatedActionComponent)value);
            } else if (name.equals("timing[x]")) {
                this.timing = TypeConvertor.castToType(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("participant")) {
                this.getParticipant().add((RequestGroupActionParticipantComponent)value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("groupingBehavior")) {
                this.groupingBehavior = TypeConvertor.castToCode(value);
            } else if (name.equals("selectionBehavior")) {
                this.selectionBehavior = TypeConvertor.castToCode(value);
            } else if (name.equals("requiredBehavior")) {
                this.requiredBehavior = TypeConvertor.castToCode(value);
            } else if (name.equals("precheckBehavior")) {
                this.precheckBehavior = TypeConvertor.castToCode(value);
            } else if (name.equals("cardinalityBehavior")) {
                this.cardinalityBehavior = TypeConvertor.castToCode(value);
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToReference(value);
            } else if (name.equals("action")) {
                this.getAction().add((RequestGroupActionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -980110702: {
                    return this.getPrefixElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -900391049: {
                    return this.getTextEquivalentElement();
                }
                case -1165461084: {
                    return this.getPriorityElement();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case 3178259: {
                    return this.addGoal();
                }
                case -861311717: {
                    return this.addCondition();
                }
                case -384107967: {
                    return this.addRelatedAction();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    return this.getType();
                }
                case 586678389: {
                    return this.getGroupingBehaviorElement();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1163906287: {
                    return this.getRequiredBehaviorElement();
                }
                case -1174249033: {
                    return this.getPrecheckBehaviorElement();
                }
                case -922577408: {
                    return this.getCardinalityBehaviorElement();
                }
                case -341064690: {
                    return this.getResource();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -980110702: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -900391049: {
                    return new String[]{"string"};
                }
                case -1165461084: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case 3178259: {
                    return new String[]{"Reference"};
                }
                case -861311717: {
                    return new String[0];
                }
                case -384107967: {
                    return new String[0];
                }
                case -873664438: {
                    return new String[]{"dateTime", "Age", "Period", "Duration", "Range", "Timing"};
                }
                case 1901043637: {
                    return new String[]{"CodeableReference"};
                }
                case 767422259: {
                    return new String[0];
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 586678389: {
                    return new String[]{"code"};
                }
                case 168639486: {
                    return new String[]{"code"};
                }
                case -1163906287: {
                    return new String[]{"code"};
                }
                case -1174249033: {
                    return new String[]{"code"};
                }
                case -922577408: {
                    return new String[]{"code"};
                }
                case -341064690: {
                    return new String[]{"Reference"};
                }
                case -1422950858: {
                    return new String[]{"@RequestGroup.action"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.linkId");
            }
            if (name.equals("prefix")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.prefix");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.textEquivalent");
            }
            if (name.equals("priority")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.priority");
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("goal")) {
                return this.addGoal();
            }
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("relatedAction")) {
                return this.addRelatedAction();
            }
            if (name.equals("timingDateTime")) {
                this.timing = new DateTimeType();
                return this.timing;
            }
            if (name.equals("timingAge")) {
                this.timing = new Age();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("timingDuration")) {
                this.timing = new Duration();
                return this.timing;
            }
            if (name.equals("timingRange")) {
                this.timing = new Range();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("location")) {
                this.location = new CodeableReference();
                return this.location;
            }
            if (name.equals("participant")) {
                return this.addParticipant();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("groupingBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.groupingBehavior");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.selectionBehavior");
            }
            if (name.equals("requiredBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.requiredBehavior");
            }
            if (name.equals("precheckBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.precheckBehavior");
            }
            if (name.equals("cardinalityBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.action.cardinalityBehavior");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionComponent copy() {
            RequestGroupActionComponent dst = new RequestGroupActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestGroupActionComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.prefix = this.prefix == null ? null : this.prefix.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            CodeType codeType = dst.priority = this.priority == null ? null : this.priority.copy();
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.goal != null) {
                dst.goal = new ArrayList<Reference>();
                for (Reference reference : this.goal) {
                    dst.goal.add(reference.copy());
                }
            }
            if (this.condition != null) {
                dst.condition = new ArrayList<RequestGroupActionConditionComponent>();
                for (RequestGroupActionConditionComponent requestGroupActionConditionComponent : this.condition) {
                    dst.condition.add(requestGroupActionConditionComponent.copy());
                }
            }
            if (this.relatedAction != null) {
                dst.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
                for (RequestGroupActionRelatedActionComponent requestGroupActionRelatedActionComponent : this.relatedAction) {
                    dst.relatedAction.add(requestGroupActionRelatedActionComponent.copy());
                }
            }
            dst.timing = this.timing == null ? null : this.timing.copy();
            CodeableReference codeableReference = dst.location = this.location == null ? null : this.location.copy();
            if (this.participant != null) {
                dst.participant = new ArrayList<RequestGroupActionParticipantComponent>();
                for (RequestGroupActionParticipantComponent requestGroupActionParticipantComponent : this.participant) {
                    dst.participant.add(requestGroupActionParticipantComponent.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupingBehavior = this.groupingBehavior == null ? null : this.groupingBehavior.copy();
            dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            dst.requiredBehavior = this.requiredBehavior == null ? null : this.requiredBehavior.copy();
            dst.precheckBehavior = this.precheckBehavior == null ? null : this.precheckBehavior.copy();
            dst.cardinalityBehavior = this.cardinalityBehavior == null ? null : this.cardinalityBehavior.copy();
            Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.action != null) {
                dst.action = new ArrayList<RequestGroupActionComponent>();
                for (RequestGroupActionComponent requestGroupActionComponent : this.action) {
                    dst.action.add(requestGroupActionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionComponent)) {
                return false;
            }
            RequestGroupActionComponent o = (RequestGroupActionComponent)other_;
            return RequestGroupActionComponent.compareDeep(this.linkId, o.linkId, true) && RequestGroupActionComponent.compareDeep(this.prefix, o.prefix, true) && RequestGroupActionComponent.compareDeep(this.title, o.title, true) && RequestGroupActionComponent.compareDeep(this.description, o.description, true) && RequestGroupActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && RequestGroupActionComponent.compareDeep(this.priority, o.priority, true) && RequestGroupActionComponent.compareDeep(this.code, o.code, true) && RequestGroupActionComponent.compareDeep(this.documentation, o.documentation, true) && RequestGroupActionComponent.compareDeep(this.goal, o.goal, true) && RequestGroupActionComponent.compareDeep(this.condition, o.condition, true) && RequestGroupActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && RequestGroupActionComponent.compareDeep(this.timing, o.timing, true) && RequestGroupActionComponent.compareDeep(this.location, o.location, true) && RequestGroupActionComponent.compareDeep(this.participant, o.participant, true) && RequestGroupActionComponent.compareDeep(this.type, o.type, true) && RequestGroupActionComponent.compareDeep(this.groupingBehavior, o.groupingBehavior, true) && RequestGroupActionComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && RequestGroupActionComponent.compareDeep(this.requiredBehavior, o.requiredBehavior, true) && RequestGroupActionComponent.compareDeep(this.precheckBehavior, o.precheckBehavior, true) && RequestGroupActionComponent.compareDeep(this.cardinalityBehavior, o.cardinalityBehavior, true) && RequestGroupActionComponent.compareDeep(this.resource, o.resource, true) && RequestGroupActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionComponent)) {
                return false;
            }
            RequestGroupActionComponent o = (RequestGroupActionComponent)other_;
            return RequestGroupActionComponent.compareValues(this.linkId, o.linkId, true) && RequestGroupActionComponent.compareValues(this.prefix, o.prefix, true) && RequestGroupActionComponent.compareValues(this.title, o.title, true) && RequestGroupActionComponent.compareValues(this.description, o.description, true) && RequestGroupActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && RequestGroupActionComponent.compareValues(this.priority, o.priority, true) && RequestGroupActionComponent.compareValues(this.groupingBehavior, o.groupingBehavior, true) && RequestGroupActionComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true) && RequestGroupActionComponent.compareValues(this.requiredBehavior, o.requiredBehavior, true) && RequestGroupActionComponent.compareValues(this.precheckBehavior, o.precheckBehavior, true) && RequestGroupActionComponent.compareValues(this.cardinalityBehavior, o.cardinalityBehavior, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.linkId, this.prefix, this.title, this.description, this.textEquivalent, this.priority, this.code, this.documentation, this.goal, this.condition, this.relatedAction, this.timing, this.location, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.resource, this.action});
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action";
        }
    }
}

