/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetUtilities {
    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasExperimental()) {
            vs.setExperimental(false);
        }
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return vs;
    }

    public static boolean makeVSShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return false;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return true;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }

    public static boolean hasOID(ValueSet vs) {
        return ValueSetUtilities.getOID(vs) != null;
    }

    public static String getOID(ValueSet vs) {
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ValueSet vs, String oid) {
        if (!oid.startsWith("urn:oid:")) {
            oid = "urn:oid:" + oid;
        }
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue(oid);
            return;
        }
        vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue(oid);
    }

    public static void markStatus(ValueSet vs, String wg, StandardsStatus status, String pckage, String fmm, IWorkerContext context, String normativeVersion) throws FHIRException {
        if (vs.hasUserData("external.url")) {
            return;
        }
        if (wg != null && (!ToolingExtensions.hasExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || !Utilities.existsInList((String)ToolingExtensions.readStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            ToolingExtensions.setCodeExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg);
        }
        if (status != null) {
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(vs);
            if (ss == null || ss.isLowerThan(status)) {
                ToolingExtensions.setStandardsStatus(vs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!vs.hasUserData("ballot.package")) {
                    vs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(vs.getUserString("ballot.package")) && !"infrastructure".equals(vs.getUserString("ballot.package"))) {
                    System.out.println("Value Set " + vs.getUrl() + ": ownership clash " + pckage + " vs " + vs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                vs.setExperimental(false);
                vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null) {
            String sfmm = ToolingExtensions.readStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
            if (Utilities.noString((String)sfmm) || Integer.parseInt(sfmm) < Integer.parseInt(fmm)) {
                ToolingExtensions.setIntegerExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
            }
            if (Integer.parseInt(fmm) <= 1) {
                vs.setExperimental(true);
            }
        }
        if (vs.hasUserData("cs")) {
            CodeSystemUtilities.markStatus((CodeSystem)vs.getUserData("cs"), wg, status, pckage, fmm, normativeVersion);
        } else if (status == StandardsStatus.NORMATIVE && context != null) {
            for (ValueSet.ConceptSetComponent csc : vs.getCompose().getInclude()) {
                CodeSystem cs;
                if (!csc.hasSystem() || (cs = context.fetchCodeSystem(csc.getSystem())) == null) continue;
                CodeSystemUtilities.markStatus(cs, wg, status, pckage, fmm, normativeVersion);
            }
        }
    }

    private static int ssval(String status) {
        if ("Draft".equals("status")) {
            return 1;
        }
        if ("Informative".equals("status")) {
            return 2;
        }
        if ("External".equals("status")) {
            return 3;
        }
        if ("Trial Use".equals("status")) {
            return 3;
        }
        if ("Normative".equals("status")) {
            return 4;
        }
        return -1;
    }

    public static ValueSet generateImplicitValueSet(String uri) {
        if (uri.startsWith("http://snomed.info/sct")) {
            return ValueSetUtilities.generateImplicitSnomedValueSet(uri);
        }
        if (uri.startsWith("http://loinc.org/vs")) {
            return ValueSetUtilities.generateImplicitLoincValueSet(uri);
        }
        if (uri.equals("http://hl7.org/fhir/ValueSet/mimetypes")) {
            return ValueSetUtilities.generateImplicitMimetypesValueSet(uri);
        }
        return null;
    }

    private static ValueSet generateImplicitMimetypesValueSet(String theUri) {
        ValueSet valueSet = new ValueSet();
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        valueSet.setUrl(theUri);
        valueSet.setDescription("This value set includes all possible codes from BCP-13 (http://tools.ietf.org/html/bcp13)");
        valueSet.getCompose().addInclude().setSystem("urn:ietf:bcp:13");
        return valueSet;
    }

    private static ValueSet generateImplicitLoincValueSet(String uri) {
        if ("http://loinc.org/vs".equals(uri)) {
            return ValueSetUtilities.makeLoincValueSet();
        }
        if (uri.startsWith("http://loinc.org/vs/LL")) {
            return ValueSetUtilities.makeAnswerList(ValueSetUtilities.makeLoincValueSet(), uri);
        }
        return null;
    }

    private static ValueSet makeAnswerList(ValueSet vs, String uri) {
        vs.setUrl(uri);
        String c = uri.substring(20);
        vs.setName("LOINCAnswers" + c);
        vs.setTitle("LOINC Answer Codes for " + c);
        vs.getCompose().getIncludeFirstRep().addFilter().setProperty("LIST").setOp(Enumerations.FilterOperator.EQUAL).setValue(c);
        return vs;
    }

    private static ValueSet makeLoincValueSet() {
        ValueSet vs = new ValueSet();
        vs.setUrl("http://loinc.org/vs");
        vs.setName("LOINCCodes");
        vs.setTitle("All LOINC codes");
        vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.getCompose().addInclude().setSystem("http://loinc.org");
        return vs;
    }

    private static ValueSet generateImplicitSnomedValueSet(String uri) {
        if ("http://snomed.info/sct?fhir_vs".equals(uri)) {
            return ValueSetUtilities.makeImplicitSnomedValueSet(uri);
        }
        return null;
    }

    private static ValueSet makeImplicitSnomedValueSet(String uri) {
        ValueSet vs = new ValueSet();
        vs.setUrl(uri);
        vs.setName("SCTValueSet");
        vs.setTitle("SCT ValueSet");
        vs.setDescription("All SNOMED CT Concepts");
        vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.getCompose().addInclude().setSystem("http://snomed.info/sct");
        return vs;
    }

    public static void setDeprecated(List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, ValueSet.ValueSetExpansionContainsComponent n) {
        n.addProperty().setCode("status").setValue(new CodeType("deprecated"));
        for (ValueSet.ValueSetExpansionPropertyComponent o : vsProp) {
            if (!"status".equals(o.getCode())) continue;
            return;
        }
        vsProp.add(new ValueSet.ValueSetExpansionPropertyComponent().setCode("status").setUri("http://hl7.org/fhir/concept-properties#status"));
    }

    public static void sortInclude(ValueSet.ConceptSetComponent inc) {
        Collections.sort(inc.getConcept(), new ConceptReferenceComponentSorter());
    }

    public static String getAllCodesSystem(ValueSet vs) {
        ValueSet.ConceptSetComponent i;
        ValueSet.ValueSetComposeComponent c;
        if (vs.hasCompose() && (c = vs.getCompose()).getExclude().isEmpty() && c.getInclude().size() == 1 && (i = c.getIncludeFirstRep()).hasSystem() && !i.hasValueSet() && !i.hasConcept() && !i.hasFilter()) {
            return i.getSystem();
        }
        return null;
    }

    public static class ConceptReferenceComponentSorter
    implements Comparator<ValueSet.ConceptReferenceComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceComponent o1, ValueSet.ConceptReferenceComponent o2) {
            return o1.getCode().compareToIgnoreCase(o2.getCode());
        }
    }
}

