/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.context.TerminologyCache;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.test.utils.TestPackageLoader;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;
import org.hl7.fhir.utilities.tests.TestConfig;

public class TestingUtilities
extends BaseTestingUtilities {
    public static Map<String, IWorkerContext> fcontexts;
    public static final String DEFAULT_CONTEXT_VERSION = "5.0.0";
    public static String fixedpath;
    public static String contentpath;

    public static IWorkerContext getSharedWorkerContext() {
        return TestingUtilities.getSharedWorkerContext(DEFAULT_CONTEXT_VERSION);
    }

    public static IWorkerContext getSharedWorkerContext(String version) {
        String v = VersionUtilities.getMajMin((String)version);
        if (fcontexts == null) {
            fcontexts = new HashMap<String, IWorkerContext>();
        }
        if (!fcontexts.containsKey(v)) {
            IWorkerContext fcontext = TestingUtilities.getWorkerContext(version);
            fcontexts.put(v, fcontext);
        }
        return fcontexts.get(v);
    }

    public static IWorkerContext getWorkerContext(String version) {
        try {
            FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager(true, 3);
            SimpleWorkerContext fcontext = TestingUtilities.getWorkerContext(pcm.loadPackage(VersionUtilities.packageForVersion((String)version), version));
            fcontext.setUcumService((UcumService)new UcumEssenceService(TestingUtilities.loadTestResourceStream((String[])new String[]{"ucum", "ucum-essence.xml"})));
            fcontext.setExpansionProfile(new Parameters());
            if (!fcontext.hasPackage("hl7.terminology.r5", null)) {
                NpmPackage utg = new FilesystemPackageCacheManager(true, 3).loadPackage("hl7.terminology.r5");
                System.out.println("Loading THO: " + utg.name() + "#" + utg.version());
                fcontext.loadFromPackage(utg, new TestPackageLoader(new String[]{"CodeSystem", "ValueSet"}));
            }
            return fcontext;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public static String getTerminologyCacheDirectory() {
        return TestConfig.getInstance().getTxCacheDirectory(new String[]{"org.hl7.fhir.r5"});
    }

    public static SimpleWorkerContext getWorkerContext(NpmPackage npmPackage) throws Exception {
        SimpleWorkerContext swc = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).withUserAgent("fhir/r5-test-cases").withTerminologyCachePath(TestingUtilities.getTerminologyCacheDirectory()).fromPackage(npmPackage);
        TerminologyCache.setCacheErrors(true);
        return swc;
    }

    public static SimpleWorkerContext getWorkerContext(NpmPackage npmPackage, IWorkerContext.IContextResourceLoader loader) throws Exception {
        SimpleWorkerContext swc = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).withUserAgent("fhir/r5-test-cases").withTerminologyCachePath(TestingUtilities.getTerminologyCacheDirectory()).fromPackage(npmPackage, loader);
        TerminologyCache.setCacheErrors(true);
        return swc;
    }

    public static String home() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir\\build";
        s = "/Users/jamesagnew/git/fhir";
        if (new File(s).exists()) {
            return s;
        }
        throw new Error("FHIR Home directory not configured");
    }

    public static String content() throws IOException {
        if (contentpath != null) {
            return contentpath;
        }
        String s = "R:\\fhir\\publish";
        if (new File(s).exists()) {
            return s;
        }
        return Utilities.path((String[])new String[]{TestingUtilities.home(), "publish"});
    }

    public static String us() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir.us";
        if (new File(s).exists()) {
            return s;
        }
        throw new Error("FHIR US directory not configured");
    }
}

