/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.Utilities;

public class MimeType {
    private String source;
    private String base;
    private Map<String, String> params = new HashMap<String, String>();

    public MimeType(String s) {
        this.source = s;
        for (String p : s.split("\\;")) {
            if (this.base == null) {
                this.base = p;
                continue;
            }
            this.params.put(p.substring(0, p.indexOf("=")), p.substring(p.indexOf("=") + 1));
        }
        if ("xml".equals(this.base)) {
            this.base = "application/fhir+xml";
        }
        if ("json".equals(this.base)) {
            this.base = "application/fhir+json";
        }
        if ("ttl".equals(this.base)) {
            this.base = "application/fhir+ttl";
        }
    }

    public String main() {
        if (this.base.contains("/")) {
            return this.base.substring(0, this.base.indexOf("/"));
        }
        return this.base;
    }

    public String sub() {
        if (this.base.contains("/")) {
            return this.base.substring(this.base.indexOf("/") + 1);
        }
        return null;
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public boolean isValid() {
        return (Utilities.existsInList(this.main(), "application", "audio", "font", "example", "image", "message", "model", "multipart", "text", "video") || this.main().startsWith("x-")) && !Utilities.noString(this.sub());
    }

    public static List<MimeType> parseList(String s) {
        ArrayList<MimeType> result = new ArrayList<MimeType>();
        for (String e : s.split("\\,")) {
            result.add(new MimeType(e));
        }
        return result;
    }

    public String display() {
        return this.source;
    }
}

