/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.NpmPackage;

public class PackageCacheManager {
    public static final String PACKAGE_REGEX = "^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+$";
    public static final String PACKAGE_VERSION_REGEX = "^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*$";
    private static final int BUFFER_SIZE = 1024;
    private static final String CACHE_VERSION = "2";
    private static final int ANALYSIS_VERSION = 2;
    private String cacheFolder;
    private boolean buildLoaded;
    private JsonArray buildInfo;
    private boolean progress = true;
    private List<NpmPackage> temporaryPackages = new ArrayList<NpmPackage>();
    private Map<String, String> ciList = new HashMap<String, String>();
    private List<String> allUrls;
    private Map<String, VersionHistory> historyCache = new HashMap<String, VersionHistory>();

    public PackageCacheManager(boolean userMode, int toolsVersion) throws IOException {
        this.cacheFolder = userMode ? Utilities.path(System.getProperty("user.home"), ".fhir", "packages") : Utilities.path("var", "lib", ".fhir", "packages");
        if (!new File(this.cacheFolder).exists()) {
            Utilities.createDirectory(this.cacheFolder);
        }
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            TextFile.stringToFile("[cache]\r\nversion=2\r\n\r\n[urls]\r\n\r\n[local]\r\n\r\n", Utilities.path(this.cacheFolder, "packages.ini"), false);
        }
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        boolean save = false;
        String v = ini.getStringProperty("cache", "version");
        if ("1".equals(v)) {
            this.convertPackageCacheFrom1To2();
            ini.setStringProperty("cache", "version", CACHE_VERSION, null);
            v = ini.getStringProperty("cache", "version");
            save = true;
        }
        if (!CACHE_VERSION.equals(v)) {
            this.clearCache();
            ini.setStringProperty("cache", "version", CACHE_VERSION, null);
            save = true;
        }
        save = this.checkIniHasMapping("hl7.fhir.core", "http://hl7.org/fhir", ini) || save;
        save = this.checkIniHasMapping("fhir.argonaut.ehr", "http://fhir.org/guides/argonaut", ini) || save;
        save = this.checkIniHasMapping("fhir.argonaut.pd", "http://fhir.org/guides/argonaut-pd", ini) || save;
        save = this.checkIniHasMapping("fhir.argonaut.scheduling", "http://fhir.org/guides/argonaut-scheduling", ini) || save;
        save = this.checkIniHasMapping("fhir.hspc.acog", "http://hl7.org/fhir/fpar", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.au.argonaut", "http://hl7.org.au/fhir/argonaut", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.au.base", "http://hl7.org.au/fhir/base", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.au.pd", "http://hl7.org.au/fhir/pd", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.smart", "http://hl7.org/fhir/smart-app-launch", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.snomed", "http://hl7.org/fhir/ig/snomed", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.test.v10", "http://hl7.org/fhir/test-ig-10", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.test.v30", "http://hl7.org/fhir/test", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.breastcancer", "http://hl7.org/fhir/us/breastcancer", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.ccda", "http://hl7.org/fhir/us/ccda", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.cds.opioids", "http://hl7.org/fhir/ig/opioid-cds", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.core", "http://hl7.org/fhir/us/core", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.dafresearch", "http://hl7.org/fhir/us/daf-research", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.ecr", "http://fhir.hl7.org/us/ecr", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.hai", "http://hl7.org/fhir/us/hai", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.hedis", "http://hl7.org/fhir/us/hedis", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.meds", "http://hl7.org/fhir/us/meds", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.qicore", "http://hl7.org/fhir/us/qicore", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.sdc", "http://hl7.org/fhir/us/sdc", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.us.sdcde", "http://hl7.org/fhir/us/sdcde", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.uv.genomicsreporting", "http://hl7.org/fhir/uv/genomics-reporting", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.uv.immds", "http://hl7.org/fhir/uv/cdsi", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.uv.ips", "http://hl7.org/fhir/uv/ips", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.uv.phd", "http://hl7.org/fhir/devices", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.uv.vhdir", "http://hl7.org/fhir/ig/vhdir", ini) || save;
        save = this.checkIniHasMapping("hl7.fhir.vn.base", "http://hl7.org/fhir/ig/vietnam", ini) || save;
        boolean bl = save = this.checkIniHasMapping("hl7.fhir.vocabpoc", "http://hl7.org/fhir/ig/vocab-poc", ini) || save;
        if (save) {
            if (!CACHE_VERSION.equals(ini.getStringProperty("cache", "version"))) {
                throw new Error("what?");
            }
            ini.save();
        }
        this.checkDeleteVersion("hl7.fhir.core", "1.0.2", 2);
        this.checkDeleteVersion("hl7.fhir.core", "1.4.0", 2);
        this.checkDeleteVersion("hl7.fhir.core", "current", toolsVersion);
        this.checkDeleteVersion("hl7.fhir.core", "4.0.0", toolsVersion);
    }

    private void checkDeleteVersion(String id, String ver, int minVer) {
        if (this.hasPackage(id, ver)) {
            boolean del = true;
            try {
                NpmPackage pck = this.loadPackageFromCacheOnly(id, ver);
                if (pck.getNpm().has("tools-version")) {
                    del = pck.getNpm().get("tools-version").getAsInt() < minVer;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (del) {
                try {
                    this.removePackage(id, ver);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void removePackage(String id, String ver) throws IOException {
        String f = Utilities.path(this.cacheFolder, id + "#" + ver);
        Utilities.clearDirectory(f, new String[0]);
        new File(f).delete();
    }

    private void convertPackageCacheFrom1To2() throws IOException {
        for (File f : new File(this.cacheFolder).listFiles()) {
            if (!f.isDirectory() || !f.getName().contains("-")) continue;
            String s = f.getName();
            int i = s.lastIndexOf("-");
            File nf = new File(Utilities.path(this.cacheFolder, s = s.substring(0, i) + "#" + s.substring(i + 1)));
            if (f.renameTo(nf)) continue;
            throw new IOException("Unable to rename " + f.getAbsolutePath() + " to " + nf.getAbsolutePath());
        }
    }

    private boolean checkIniHasMapping(String pid, String curl, IniFile ini) {
        if (curl.equals(ini.getStringProperty("urls", pid))) {
            return false;
        }
        ini.setStringProperty("urls", pid, curl, null);
        return true;
    }

    private void clearCache() throws IOException {
        for (File f : new File(this.cacheFolder).listFiles()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            if (f.getName().equals("packages.ini")) continue;
            FileUtils.forceDelete((File)f);
        }
    }

    public void recordMap(String url, String id) throws IOException {
        if (url == null) {
            return;
        }
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            throw new Error("File " + Utilities.path(this.cacheFolder, "packages.ini") + " not found #1");
        }
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        ini.setStringProperty("urls", id, url, null);
        if (!CACHE_VERSION.equals(ini.getStringProperty("cache", "version"))) {
            throw new Error("File " + Utilities.path(this.cacheFolder, "packages.ini") + " cache version mismatch: expected '" + CACHE_VERSION + "', found '" + ini.getStringProperty("cache", "version") + "'");
        }
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            throw new Error("File " + Utilities.path(this.cacheFolder, "packages.ini") + " not found #2");
        }
        ini.save();
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            throw new Error("File " + Utilities.path(this.cacheFolder, "packages.ini") + " not found #3");
        }
    }

    public String getPackageUrl(String id) throws IOException {
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        return ini.getStringProperty("urls", id);
    }

    public String getPackageId(String url) throws IOException {
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        String[] ids = ini.getPropertyNames("urls");
        if (ids != null) {
            for (String id : ids) {
                if (!url.equals(ini.getStringProperty("urls", id))) continue;
                return id;
            }
        }
        return null;
    }

    private List<String> sorted(String[] keys) {
        ArrayList<String> names = new ArrayList<String>();
        for (String s : keys) {
            names.add(s);
        }
        Collections.sort(names);
        return names;
    }

    public NpmPackage loadPackageFromCacheOnly(String id) throws IOException {
        Object match = null;
        List<String> l = this.sorted(new File(this.cacheFolder).list());
        for (int i = l.size() - 1; i >= 0; --i) {
            String f = l.get(i);
            if (!f.startsWith(id + "#")) continue;
            return this.loadPackageInfo(Utilities.path(this.cacheFolder, f));
        }
        return null;
    }

    public NpmPackage loadPackageFromCacheOnly(String id, String version) throws IOException {
        for (NpmPackage p : this.temporaryPackages) {
            if (!p.name().equals(id) || !"current".equals(version) && !"dev".equals(version) && !p.version().equals(version)) continue;
            return p;
        }
        Object match = null;
        for (String f : this.sorted(new File(this.cacheFolder).list())) {
            if (!f.equals(id + "#" + version)) continue;
            return this.loadPackageInfo(Utilities.path(this.cacheFolder, f));
        }
        if ("dev".equals(version)) {
            return this.loadPackageFromCacheOnly(id, "current");
        }
        return null;
    }

    private NpmPackage loadPackageInfo(String path) throws IOException {
        NpmPackage pi = new NpmPackage(path);
        return pi;
    }

    public NpmPackage addPackageToCache(String id, String version, InputStream tgz) throws IOException {
        JsonObject npm;
        if (this.progress) {
            System.out.println("Installing " + id + "#" + (version == null ? "?" : version) + " to the package cache");
            System.out.print("  Fetching:");
        }
        ArrayList<PackageEntry> files = new ArrayList<PackageEntry>();
        long size = this.unPackage(tgz, files);
        byte[] npmb = null;
        for (PackageEntry e : files) {
            if (!e.name.equals("package/package.json")) continue;
            npmb = e.bytes;
        }
        if (npmb == null) {
            throw new IOException("Unable to find package/package.json in the package file");
        }
        if (this.progress) {
            System.out.print("|");
        }
        if (!((npm = (JsonObject)new JsonParser().parse(TextFile.bytesToString(npmb))).get("name") != null && id != null && id.equals(npm.get("name").getAsString()) || npm.get("name").getAsString().startsWith(id))) {
            throw new IOException("Attempt to import a mis-identified package. Expected " + id + ", got " + npm.get("name").getAsString());
        }
        if (version == null) {
            version = npm.get("version").getAsString();
        }
        String packRoot = Utilities.path(this.cacheFolder, id + "#" + version);
        Utilities.createDirectory(packRoot);
        Utilities.clearDirectory(packRoot, new String[0]);
        for (PackageEntry e : files) {
            if (e.bytes == null) {
                File f = new File(Utilities.path(packRoot, e.name));
                if (f.mkdir()) continue;
                throw new IOException("Unable to create directory '%s', during extraction of archive contents: " + f.getAbsolutePath());
            }
            String fn = Utilities.path(packRoot, e.name);
            String dir = Utilities.getDirectoryForFile(fn);
            if (!new File(dir).exists()) {
                Utilities.createDirectory(dir);
            }
            TextFile.bytesToFile(e.bytes, fn);
        }
        if (this.progress) {
            System.out.println("");
            System.out.print("  Analysing");
        }
        HashMap<String, String> profiles = new HashMap<String, String>();
        HashMap<String, String> canonicals = new HashMap<String, String>();
        if ("hl7.fhir.core".equals(npm.get("name").getAsString())) {
            this.analysePackage(packRoot, npm.get("version").getAsString(), profiles, canonicals);
        } else if (npm.has("dependencies")) {
            this.analysePackage(packRoot, npm.getAsJsonObject("dependencies").get("hl7.fhir.core").getAsString(), profiles, canonicals);
        }
        IniFile ini = new IniFile(Utilities.path(packRoot, "cache.ini"));
        ini.setTimeStampFormat("dd/MM/yyyy h:mm:ss a");
        ini.setLongProperty("Package", "size", size, null);
        ini.setTimestampProperty("Package", "install", Timestamp.from(Instant.now()), null);
        for (String p : profiles.keySet()) {
            ini.setStringProperty("Profiles", p, (String)profiles.get(p), null);
        }
        for (String p : canonicals.keySet()) {
            ini.setStringProperty("Canonicals", p, (String)canonicals.get(p), null);
        }
        ini.setIntegerProperty("Packages", "analysis", 2, null);
        ini.save();
        if (this.progress) {
            System.out.println(" done.");
        }
        return this.loadPackageInfo(packRoot);
    }

    public long unPackage(InputStream tgz, List<PackageEntry> files) throws IOException {
        long size = 0L;
        GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(tgz);
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            int i = 0;
            int c = 12;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                if (this.progress && ++i % 20 == 0) {
                    System.out.print(".");
                    if (++c == 120) {
                        System.out.println("");
                        System.out.print("  ");
                        c = 2;
                    }
                }
                if (entry.isDirectory()) {
                    files.add(new PackageEntry(entry.getName()));
                    continue;
                }
                byte[] data = new byte[1024];
                ByteArrayOutputStream fos = new ByteArrayOutputStream();
                try (BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);){
                    int count;
                    while ((count = tarIn.read(data, 0, 1024)) != -1) {
                        dest.write(data, 0, count);
                    }
                }
                fos.close();
                files.add(new PackageEntry(entry.getName(), fos.toByteArray()));
                size += (long)fos.size();
            }
        }
        return size;
    }

    private void analysePackage(String dir, String v, Map<String, String> profiles, Map<String, String> canonicals) throws IOException {
        File[] packages;
        int i = 0;
        int c = 11;
        for (File f : packages = new File(Utilities.path(dir, "package")).listFiles()) {
            if (this.progress && ++i % 20 == 0) {
                System.out.print(".");
                if (++c == 120) {
                    System.out.println("");
                    System.out.print("  ");
                    c = 2;
                }
            }
            if (f.getName().startsWith("Bundle-")) continue;
            try {
                JsonObject j = (JsonObject)new JsonParser().parse(TextFile.fileToString(f));
                if (!Utilities.noString(j.get("url").getAsString()) && !Utilities.noString(j.get("resourceType").getAsString())) {
                    canonicals.put(j.get("url").getAsString(), f.getName());
                }
                if (!"StructureDefinition".equals(j.get("resourceType").getAsString()) || !"resource".equals(j.get("kind").getAsString())) continue;
                String bd = null;
                bd = "1.0.2".equals(v) ? j.get("constrainedType").getAsString() : j.get("type").getAsString();
                if (Utilities.noString(bd)) {
                    bd = j.get("name").getAsString();
                }
                if ("Extension".equals(bd)) continue;
                profiles.put(j.get("url").getAsString(), bd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NpmPackage extractLocally(String filename) throws IOException {
        return this.extractLocally(new FileInputStream(filename), filename);
    }

    public NpmPackage extractLocally(InputStream tgz, String name) throws IOException {
        if (this.progress) {
            System.out.println("Loading " + name + " to the package cache");
            System.out.print("  Fetching:");
        }
        ArrayList<PackageEntry> files = new ArrayList<PackageEntry>();
        this.unPackage(tgz, files);
        byte[] npmb = null;
        for (PackageEntry e : files) {
            if (!e.name.equals("package/package.json")) continue;
            npmb = e.bytes;
        }
        if (npmb == null) {
            throw new IOException("Unable to find package/package.json in the package file");
        }
        JsonObject npm = (JsonObject)new JsonParser().parse(TextFile.bytesToString(npmb));
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        ArrayList<String> folders = new ArrayList<String>();
        for (PackageEntry e : files) {
            if (e.bytes == null) {
                folders.add(e.name);
                continue;
            }
            content.put(e.name, e.bytes);
        }
        System.out.println(" done.");
        NpmPackage p = new NpmPackage(npm, content, folders);
        this.recordMap(p.canonical(), p.name());
        return p;
    }

    public String getFolder() {
        return this.cacheFolder;
    }

    public JsonArray loadFromBuildServer() throws IOException {
        this.buildLoaded = true;
        URL url = new URL("https://build.fhir.org/ig/qas.json?nocache=" + System.currentTimeMillis());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        InputStream json = connection.getInputStream();
        this.buildInfo = (JsonArray)new JsonParser().parse(TextFile.streamToString(json));
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (!o.has("url") || !o.has("package-id") || !o.get("package-id").getAsString().contains(".")) continue;
            String u = o.get("url").getAsString();
            if (u.contains("/ImplementationGuide/")) {
                u = u.substring(0, u.indexOf("/ImplementationGuide/"));
            }
            this.recordMap(u, o.get("package-id").getAsString());
            this.ciList.put(o.get("package-id").getAsString(), "https://build.fhir.org/ig/" + o.get("repo").getAsString());
        }
        return this.buildInfo;
    }

    public boolean isBuildLoaded() {
        return this.buildLoaded;
    }

    public String buildPath(String url) {
        for (JsonElement e : this.buildInfo) {
            JsonObject j = (JsonObject)e;
            if (!j.has("url") || !url.equals(j.get("url").getAsString()) && !j.get("url").getAsString().startsWith(url + "/ImplementationGuide")) continue;
            return "https://build.fhir.org/ig/" + j.get("repo").getAsString();
        }
        return null;
    }

    public boolean checkBuildLoaded() throws IOException {
        if (this.isBuildLoaded()) {
            return true;
        }
        this.loadFromBuildServer();
        return false;
    }

    public NpmPackage loadPackage(String id) throws FHIRException, IOException {
        throw new Error("Not done yet");
    }

    public NpmPackage loadPackage(String id, String v) throws FHIRException, IOException {
        JsonObject json;
        String url;
        NpmPackage p = this.loadPackageFromCacheOnly(id, v);
        if (p != null) {
            return p;
        }
        if ("dev".equals(v)) {
            p = this.loadPackageFromCacheOnly(id, "current");
            if (p != null) {
                return p;
            }
            v = "current";
        }
        if ((url = this.getPackageUrl(id)) == null) {
            throw new FHIRException("Unable to resolve the package '" + id + "'");
        }
        if (v == null) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(url, "package.tgz"), true);
            if (stream == null && this.isBuildLoaded()) {
                stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.buildPath(url), "package.tgz"), true);
            }
            if (stream != null) {
                return this.addPackageToCache(id, null, stream);
            }
            throw new FHIRException("Unable to find the package source for '" + id + "' at " + url);
        }
        if ("current".equals(v) && this.ciList.containsKey(id)) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.ciList.get(id), "package.tgz"), true);
            return this.addPackageToCache(id, v, stream);
        }
        String pu = Utilities.pathURL(url, "package-list.json");
        try {
            json = this.fetchJson(pu);
        }
        catch (Exception e) {
            throw new FHIRException("Error fetching package list for " + id + " from " + pu + ": " + e.getMessage(), e);
        }
        if (!id.equals(json.get("package-id").getAsString())) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + json.get("package-id").getAsString());
        }
        for (JsonElement e : json.getAsJsonArray("list")) {
            JsonObject vo = (JsonObject)e;
            if (!v.equals(vo.get("version").getAsString())) continue;
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(vo.get("path").getAsString(), "package.tgz"), true);
            if (stream == null) {
                throw new FHIRException("Unable to find the package source for '" + id + "#" + v + "' at " + Utilities.pathURL(vo.get("path").getAsString(), "package.tgz"));
            }
            return this.addPackageToCache(id, v, stream);
        }
        throw new FHIRException("Unable to resolve version " + v + " for package " + id);
    }

    private JsonObject fetchJson(String source) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        return (JsonObject)new JsonParser().parse(TextFile.streamToString(c.getInputStream()));
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException {
        try {
            URL url = new URL(source);
            URLConnection c = url.openConnection();
            return c.getInputStream();
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw new FHIRException(e.getMessage(), e);
        }
    }

    public void loadFromFolder(String packagesFolder) throws IOException {
        for (File f : new File(packagesFolder).listFiles()) {
            if (!f.getName().endsWith(".tgz")) continue;
            this.temporaryPackages.add(this.extractLocally(new FileInputStream(f), f.getName()));
        }
    }

    public Map<String, String> getCiList() {
        return this.ciList;
    }

    public boolean hasPackage(String id, String version) {
        for (NpmPackage p : this.temporaryPackages) {
            if (!p.name().equals(id) || !"current".equals(version) && !"dev".equals(version) && !p.version().equals(version)) continue;
            return true;
        }
        for (String f : this.sorted(new File(this.cacheFolder).list())) {
            if (!f.equals(id + "#" + version)) continue;
            return true;
        }
        if ("dev".equals(version)) {
            return this.hasPackage(id, "current");
        }
        return false;
    }

    public List<String> getUrls() throws IOException {
        if (this.allUrls == null) {
            IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
            this.allUrls = new ArrayList<String>();
            for (String s : ini.getPropertyNames("urls")) {
                this.allUrls.add(ini.getStringProperty("urls", s));
            }
            try {
                URL url = new URL("https://raw.githubusercontent.com/FHIR/ig-registry/master/fhir-ig-list.json?nocache=" + System.currentTimeMillis());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                InputStream json = connection.getInputStream();
                JsonObject packages = (JsonObject)new JsonParser().parse(TextFile.streamToString(json));
                JsonArray guides = packages.getAsJsonArray("guides");
                for (JsonElement g : guides) {
                    JsonObject gi = (JsonObject)g;
                    if (!gi.has("canonical") || this.allUrls.contains(gi.get("canonical").getAsString())) continue;
                    this.allUrls.add(gi.get("canonical").getAsString());
                }
            }
            catch (Exception e) {
                System.out.println("Listing known Implementation Guides failed: " + e.getMessage());
            }
        }
        return this.allUrls;
    }

    public VersionHistory listVersions(String url) throws IOException {
        if (this.historyCache.containsKey(url)) {
            return this.historyCache.get(url);
        }
        URL url1 = new URL(Utilities.pathURL(url, "package-list.json") + "?nocache=" + System.currentTimeMillis());
        HttpURLConnection connection = (HttpURLConnection)url1.openConnection();
        connection.setRequestMethod("GET");
        InputStream json = connection.getInputStream();
        JsonObject packageList = (JsonObject)new JsonParser().parse(TextFile.streamToString(json));
        VersionHistory res = new VersionHistory();
        res.id = packageList.get("package-id").getAsString();
        res.canonical = packageList.get("canonical").getAsString();
        for (JsonElement j : packageList.getAsJsonArray("list")) {
            JsonObject jo = (JsonObject)j;
            if ("current".equals(jo.get("version").getAsString())) {
                res.current = jo.get("path").getAsString();
                continue;
            }
            res.versions.put(jo.get("version").getAsString(), jo.get("path").getAsString());
        }
        this.historyCache.put(url, res);
        return res;
    }

    public void clear() throws IOException {
        for (File f : new File(this.cacheFolder).listFiles()) {
            if (!f.isDirectory()) continue;
            Utilities.clearDirectory(f.getAbsolutePath(), new String[0]);
            f.delete();
        }
    }

    public class PackageEntry {
        private byte[] bytes;
        private String name;

        public PackageEntry(String name) {
            this.name = name;
        }

        public PackageEntry(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }
    }

    public class VersionHistory {
        private String id;
        private String canonical;
        private String current;
        private Map<String, String> versions = new HashMap<String, String>();

        public String getCanonical() {
            return this.canonical;
        }

        public String getCurrent() {
            return this.current;
        }

        public Map<String, String> getVersions() {
            return this.versions;
        }

        public String getId() {
            return this.id;
        }
    }
}

