/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.PrintStream;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.tasks.ValidationEngineTask;
import org.hl7.fhir.validation.cli.utils.Display;

public class ValidateTask
extends ValidationEngineTask {
    static final String[][] PLACEHOLDERS = new String[][]{{"XML_AND_JSON_FHIR_VERSIONS", "1.0, 1.4, 3.0, 4.0, 5.0, 6.0"}, {"TURTLE_FHIR_VERSIONS", "3.0, 4.0, 5.0"}, {"FHIR_MAJOR_VERSIONS", VersionUtilities.listSupportedMajorVersions()}, {"FHIR_MINOR_VERSIONS", VersionUtilities.listSupportedVersions()}, {"FHIR_CURRENT_VERSION", "5.0"}};

    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getDisplayName() {
        return "Validation";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return false;
    }

    @Override
    public void printHelp(PrintStream out) {
        Display.displayHelpDetails(out, "help/validate.txt", PLACEHOLDERS);
    }

    @Override
    public void executeTask(ValidationService validationService, ValidationEngine validationEngine, CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        for (String s : cliContext.getProfiles()) {
            if (validationEngine.getContext().hasResource(StructureDefinition.class, s) || validationEngine.getContext().hasResource(ImplementationGuide.class, s)) continue;
            System.out.println("  Fetch Profile from " + s);
            validationEngine.loadProfile(cliContext.getLocations().getOrDefault(s, s));
        }
        System.out.println("Validating");
        validationService.validateSources(cliContext, validationEngine, cliContext.getWatchMode(), cliContext.getWatchScanDelay(), cliContext.getWatchSettleTime());
    }
}

