/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.QIP;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SPR
extends AbstractSegment {
    public SPR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(106)}, "Query/Response Format Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Stored Procedure Name");
            this.add(QIP.class, false, 0, 256, new Object[]{this.getMessage()}, "Input Parameter List");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SPR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getSpr1_QueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getSpr2_QueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getStoredProcedureName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getSpr3_StoredProcedureName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public QIP[] getInputParameterList() {
        QIP[] retVal = (QIP[])this.getTypedField(4, (Type[])new QIP[0]);
        return retVal;
    }

    public QIP[] getSpr4_InputParameterList() {
        QIP[] retVal = (QIP[])this.getTypedField(4, (Type[])new QIP[0]);
        return retVal;
    }

    public int getInputParameterListReps() {
        return this.getReps(4);
    }

    public QIP getInputParameterList(int rep) {
        QIP retVal = (QIP)this.getTypedField(4, rep);
        return retVal;
    }

    public QIP getSpr4_InputParameterList(int rep) {
        QIP retVal = (QIP)this.getTypedField(4, rep);
        return retVal;
    }

    public int getSpr4_InputParameterListReps() {
        return this.getReps(4);
    }

    public QIP insertInputParameterList(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(4, rep);
    }

    public QIP insertSpr4_InputParameterList(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(4, rep);
    }

    public QIP removeInputParameterList(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(4, rep);
    }

    public QIP removeSpr4_InputParameterList(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(4, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(106));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new QIP(this.getMessage());
            }
        }
        return null;
    }
}

