/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.classify.backend;

import cc.factorie.app.classify.backend.MulticlassClassification;
import cc.factorie.app.classify.backend.MulticlassClassifier;
import cc.factorie.la.Tensor1;
import cc.factorie.maths.package$ArrayOps$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class AdaBoostTrainer$ {
    public static final AdaBoostTrainer$ MODULE$;

    static {
        new AdaBoostTrainer$();
    }

    public Seq<Tuple2<MulticlassClassifier<Tensor1>, Object>> train(Seq<Tensor1> features2, Seq<Object> labels2, int numLabels, int numIterations, Function1<Seq<Object>, MulticlassClassifier<Tensor1>> trainWeakClassifier) {
        int K = numLabels;
        int numInstances = labels2.length();
        double[] instanceWeights = (double[])Array$.MODULE$.fill(numInstances, (Function0)new Serializable(numInstances){
            private final int numInstances$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0 / (double)this.numInstances$1;
            }
            {
                this.numInstances$1 = numInstances$1;
            }
        }, ClassTag$.MODULE$.Double());
        boolean converged = false;
        Nil$ weightedClassifiers = Nil$.MODULE$;
        int i = 0;
        while (!converged) {
            MulticlassClassifier currentClassifier = (MulticlassClassifier)trainWeakClassifier.apply((Object)Predef$.MODULE$.wrapDoubleArray(instanceWeights));
            MulticlassClassification[] classifications2 = (MulticlassClassification[])((TraversableOnce)features2.map((Function1)new Serializable(currentClassifier){
                private final MulticlassClassifier currentClassifier$1;

                public final MulticlassClassification apply(Tensor1 v) {
                    return this.currentClassifier$1.classification(v);
                }
                {
                    this.currentClassifier$1 = currentClassifier$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MulticlassClassification.class));
            IndexedSeq isFail = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).map((Function1)new Serializable(labels2, classifications2){
                private final Seq labels$2;
                private final MulticlassClassification[] classifications$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                public boolean apply$mcZI$sp(int i) {
                    return this.classifications$1[i].bestLabelIndex() != BoxesRunTime.unboxToInt((Object)this.labels$2.apply(i));
                }
                {
                    this.labels$2 = labels$2;
                    this.classifications$1 = classifications$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            double amountOfFail = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).filter((Function1)isFail)).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(instanceWeights){
                private final double[] instanceWeights$1;

                public final double apply(double acc, int el) {
                    return this.apply$mcDDI$sp(acc, el);
                }

                public double apply$mcDDI$sp(double acc, int el) {
                    return acc + this.instanceWeights$1[el];
                }
                {
                    this.instanceWeights$1 = instanceWeights$1;
                }
            }));
            double classifierWeight = package$.MODULE$.log((1.0 - amountOfFail) / amountOfFail) + package$.MODULE$.log((double)(K - 1));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).foreach$mVc$sp((Function1)new Serializable(instanceWeights, isFail, classifierWeight){
                private final double[] instanceWeights$1;
                private final IndexedSeq isFail$1;
                private final double classifierWeight$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.instanceWeights$1[i] = this.instanceWeights$1[i] * package$.MODULE$.exp(BoxesRunTime.unboxToBoolean((Object)this.isFail$1.apply(i)) ? this.classifierWeight$1 : 0.0);
                }
                {
                    this.instanceWeights$1 = instanceWeights$1;
                    this.isFail$1 = isFail$1;
                    this.classifierWeight$1 = classifierWeight$1;
                }
            });
            double dSum = package$ArrayOps$.MODULE$.oneNorm(instanceWeights);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).foreach$mVc$sp((Function1)new Serializable(instanceWeights, dSum){
                private final double[] instanceWeights$1;
                private final double dSum$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.instanceWeights$1[i] = this.instanceWeights$1[i] / this.dSum$1;
                }
                {
                    this.instanceWeights$1 = instanceWeights$1;
                    this.dSum$1 = dSum$1;
                }
            });
            Tuple2 tuple2 = new Tuple2((Object)currentClassifier, (Object)BoxesRunTime.boxToDouble((double)classifierWeight));
            weightedClassifiers = weightedClassifiers.$colon$colon((Object)tuple2);
            converged = i > numIterations || amountOfFail == 0.0;
            ++i;
        }
        return i == 1 ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(((Tuple2)weightedClassifiers.apply(0))._1(), (Object)BoxesRunTime.boxToDouble((double)1.0))})) : weightedClassifiers;
    }

    private AdaBoostTrainer$() {
        MODULE$ = this;
    }
}

