/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.coref;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.DocumentAnnotator;
import cc.factorie.app.nlp.DocumentAnnotatorPipeline$;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.coref.AcronymNounPhraseFinder$;
import cc.factorie.app.nlp.coref.ConllProperNounPhraseFinder$;
import cc.factorie.app.nlp.coref.CorefOptions;
import cc.factorie.app.nlp.coref.ForwardCoref$;
import cc.factorie.app.nlp.coref.Mention;
import cc.factorie.app.nlp.coref.MentionAlignment;
import cc.factorie.app.nlp.coref.MentionAlignment$;
import cc.factorie.app.nlp.coref.PronounFinder$;
import cc.factorie.app.nlp.coref.WithinDocCoref;
import cc.factorie.app.nlp.coref.WithinDocEntity;
import cc.factorie.app.nlp.phrase.NounPhraseEntityTypeLabeler$;
import cc.factorie.app.nlp.phrase.OntonotesPhraseEntityType;
import cc.factorie.app.nlp.phrase.OntonotesPhraseEntityType$;
import cc.factorie.app.nlp.phrase.ParseAndNerBasedPhraseFinder$;
import cc.factorie.app.nlp.phrase.ParseBasedPhraseFinder$;
import cc.factorie.app.nlp.phrase.Phrase;
import cc.factorie.app.nlp.pos.PennPosTag;
import cc.factorie.app.nlp.wordnet.WordNet;
import cc.factorie.app.nlp.wordnet.WordNet$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class MentionAlignment$ {
    public static final MentionAlignment$ MODULE$;

    static {
        new MentionAlignment$();
    }

    public Seq<Document> makeLabeledData(Seq<Document> documents, String outfile, boolean useEntityTypes, CorefOptions options, Map<Class<?>, Function0<DocumentAnnotator>> map2) {
        if (!options.useGoldBoundaries()) {
            documents.foreach((Function1)new Serializable(){

                public final void apply(Document d) {
                    d.tokens().foreach((Function1)new Serializable(this){

                        public final void apply(Token t) {
                            t.attr().remove(ClassTag$.MODULE$.apply(PennPosTag.class));
                        }
                    });
                }
            });
        }
        ArrayBuffer shifts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        shifts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), options.mentionAlignmentShiftWidth()).foreach((Function1)new Serializable(shifts){
            private final ArrayBuffer shifts$1;

            public final ArrayBuffer<Object> apply(int i) {
                this.shifts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return this.shifts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(-1 * i)));
            }
            {
                this.shifts$1 = shifts$1;
            }
        });
        ParSeq alignmentInfo = (ParSeq)((ParIterableLike)documents.par()).map((Function1)new Serializable(useEntityTypes, options, shifts){
            private final boolean useEntityTypes$1;
            private final CorefOptions options$1;
            private final ArrayBuffer shifts$1;

            public final MentionAlignment.PrecRecReport apply(Document d) {
                return MentionAlignment$.MODULE$.alignMentions(d, WordNet$.MODULE$, this.useEntityTypes$1, this.options$1, (Seq<Object>)this.shifts$1, MentionAlignment$.MODULE$.alignMentions$default$6());
            }
            {
                this.useEntityTypes$1 = useEntityTypes$1;
                this.options$1 = options$1;
                this.shifts$1 = shifts$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
        double numCorrect = BoxesRunTime.unboxToInt((Object)((ParIterableLike)alignmentInfo.map((Function1)new Serializable(){

            public final int apply(MentionAlignment.PrecRecReport x$1) {
                return x$1.numcorrect();
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double numGT = BoxesRunTime.unboxToInt((Object)((ParIterableLike)alignmentInfo.map((Function1)new Serializable(){

            public final int apply(MentionAlignment.PrecRecReport x$2) {
                return x$2.numGT();
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double numDetected = BoxesRunTime.unboxToInt((Object)((ParIterableLike)alignmentInfo.map((Function1)new Serializable(){

            public final int apply(MentionAlignment.PrecRecReport x$3) {
                return x$3.numDetected();
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"precision = ").append((Object)BoxesRunTime.boxToDouble((double)numCorrect)).append((Object)" / ").append((Object)BoxesRunTime.boxToDouble((double)numDetected)).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)(numCorrect / numDetected))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"recall = ").append((Object)BoxesRunTime.boxToDouble((double)numCorrect)).append((Object)" / ").append((Object)BoxesRunTime.boxToDouble((double)numGT)).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)(numCorrect / numGT))).toString());
        return documents;
    }

    public void findMentions(Document doc, CorefOptions options, Map<Class<?>, Function0<DocumentAnnotator>> annotatorMap) {
        if (options.useGoldBoundaries()) {
            doc.getTargetCoref().mentions().foreach((Function1)new Serializable(doc){
                private final Document doc$1;

                public final OntonotesPhraseEntityType apply(Mention m) {
                    return (OntonotesPhraseEntityType)this.doc$1.coref().addMention(m.phrase()).phrase().attr().$plus$eq(m.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)));
                }
                {
                    this.doc$1 = doc$1;
                }
            });
        } else if (options.useNERMentions()) {
            Map<Class<?>, Function0<DocumentAnnotator>> defaultMap = annotatorMap == null ? DocumentAnnotatorPipeline$.MODULE$.defaultDocumentAnnotationMap() : annotatorMap;
            Seq preReqs = (Seq)((TraversableLike)ConllProperNounPhraseFinder$.MODULE$.prereqAttrs().$plus$plus(PronounFinder$.MODULE$.prereqAttrs(), Seq$.MODULE$.canBuildFrom())).$plus$plus(AcronymNounPhraseFinder$.MODULE$.prereqAttrs(), Seq$.MODULE$.canBuildFrom());
            DocumentAnnotatorPipeline$.MODULE$.apply((Map<Class<?>, Function0<DocumentAnnotator>>)defaultMap.toMap(Predef$.MODULE$.$conforms()), (Seq<Class<?>>)Nil$.MODULE$, (Iterable<Class<?>>)preReqs).process(doc);
            WithinDocCoref withinDocCoref = doc.getCoref();
            ((IterableLike)((TraversableLike)ConllProperNounPhraseFinder$.MODULE$.apply(doc).$plus$plus(PronounFinder$.MODULE$.apply(doc), Seq$.MODULE$.canBuildFrom())).$plus$plus(AcronymNounPhraseFinder$.MODULE$.apply(doc), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(withinDocCoref){
                private final WithinDocCoref eta$0$2$1;

                public final Mention apply(Phrase phrase) {
                    return this.eta$0$2$1.addMention(phrase);
                }
                {
                    this.eta$0$2$1 = eta$0$2$1;
                }
            });
        } else {
            ParseAndNerBasedPhraseFinder$.MODULE$.FILTER_APPOS_$eq(true);
            Map<Class<?>, Function0<DocumentAnnotator>> map2 = annotatorMap == null ? DocumentAnnotatorPipeline$.MODULE$.defaultDocumentAnnotationMap() : annotatorMap;
            DocumentAnnotatorPipeline$.MODULE$.apply(map2, (Seq<Class<?>>)Nil$.MODULE$, (Iterable<Class<?>>)ParseBasedPhraseFinder$.MODULE$.prereqAttrs().toSeq()).process(doc);
            WithinDocCoref withinDocCoref = doc.coref();
            ParseBasedPhraseFinder$.MODULE$.getPhrases(doc).foreach((Function1)new Serializable(withinDocCoref){
                private final WithinDocCoref eta$0$1$1;

                public final Mention apply(Phrase phrase) {
                    return this.eta$0$1$1.addMention(phrase);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            });
        }
        DocumentAnnotatorPipeline$.MODULE$.apply(DocumentAnnotatorPipeline$.MODULE$.defaultDocumentAnnotationMap(), (Seq<Class<?>>)Nil$.MODULE$, (Iterable<Class<?>>)ForwardCoref$.MODULE$.prereqAttrs()).process(doc);
    }

    public Map<Class<?>, Function0<DocumentAnnotator>> findMentions$default$3() {
        return null;
    }

    public MentionAlignment.PrecRecReport alignMentions(Document gtDoc, WordNet wn, boolean useEntityTypes, CorefOptions options, Seq<Object> shifts, Map<Class<?>, Function0<DocumentAnnotator>> annotatorMap) {
        Seq groundTruthMentions = ((TraversableOnce)((TraversableLike)gtDoc.targetCoref().entities().filter((Function1)new Serializable(){

            public final boolean apply(WithinDocEntity x$4) {
                return !x$4.isSingleton();
            }
        })).flatMap((Function1)new Serializable(){

            public final Iterable<Mention> apply(WithinDocEntity e) {
                return e.children();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        int relevantGTMentions = groundTruthMentions.size();
        if (gtDoc.coref().mentions().isEmpty()) {
            this.findMentions(gtDoc, options, this.findMentions$default$3());
        }
        Seq detectedMentions = gtDoc.getCoref().mentions().toSeq();
        HashMap gtSpanHash = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        gtSpanHash.$plus$plus$eq((TraversableOnce)groundTruthMentions.map((Function1)new Serializable(){

            public final Tuple2<Tuple2<Object, Object>, Mention> apply(Mention m) {
                return new Tuple2((Object)new Tuple2.mcII.sp(m.phrase().start(), m.phrase().length()), (Object)m);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        HashMap gtHeadHash = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        gtHeadHash.$plus$plus$eq((TraversableOnce)groundTruthMentions.map((Function1)new Serializable(){

            public final Tuple2<Object, Mention> apply(Mention m) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)MentionAlignment$.MODULE$.getHeadTokenInDoc(m)), (Object)m);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        HashMap gtAligned = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        gtAligned.$plus$plus$eq((TraversableOnce)groundTruthMentions.map((Function1)new Serializable(){

            public final Tuple2<Mention, Object> apply(Mention m) {
                return new Tuple2((Object)m, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }, Seq$.MODULE$.canBuildFrom()));
        IntRef exactMatches = IntRef.create((int)0);
        IntRef relevantExactMatches = IntRef.create((int)0);
        IntRef unAlignedEntityCount = IntRef.create((int)0);
        boolean debug = false;
        scala.collection.immutable.Map entityHash = groundTruthMentions.groupBy((Function1)new Serializable(){

            public final WithinDocEntity apply(Mention m) {
                return m.entity();
            }
        }).toMap(Predef$.MODULE$.$conforms());
        ArrayBuffer falsePositives1 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        detectedMentions.foreach((Function1)new Serializable(gtDoc, options, shifts, gtSpanHash, gtHeadHash, gtAligned, exactMatches, relevantExactMatches, unAlignedEntityCount, debug, entityHash, falsePositives1){
            private final Document gtDoc$1;
            private final CorefOptions options$2;
            private final Seq shifts$2;
            private final HashMap gtSpanHash$1;
            private final HashMap gtHeadHash$1;
            private final HashMap gtAligned$1;
            private final IntRef exactMatches$1;
            private final IntRef relevantExactMatches$1;
            private final IntRef unAlignedEntityCount$1;
            private final boolean debug$1;
            private final scala.collection.immutable.Map entityHash$1;
            private final ArrayBuffer falsePositives1$1;

            public final Object apply(Mention m) {
                BoxedUnit boxedUnit;
                Option<Mention> alignment = MentionAlignment$.MODULE$.checkContainment((HashMap<Tuple2<Object, Object>, Mention>)this.gtSpanHash$1, (HashMap<Object, Mention>)this.gtHeadHash$1, m, this.options$2, (Seq<Object>)this.shifts$2);
                if (alignment.isDefined()) {
                    Mention gtMention = (Mention)alignment.get();
                    WithinDocEntity entity = gtMention.entity();
                    if (entity == null) {
                        Object object;
                        if (this.options$2.useEntityType()) {
                            object = m.phrase().attr().$plus$eq(gtMention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)));
                        } else {
                            NounPhraseEntityTypeLabeler$.MODULE$.process(m.phrase());
                            object = BoxedUnit.UNIT;
                        }
                        WithinDocEntity newEntity = this.gtDoc$1.coref().entityFromUniqueId(new StringBuilder().append((Object)this.gtDoc$1.name()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.gtDoc$1.targetCoref().entities().size())).append((Object)BoxesRunTime.boxToInteger((int)this.unAlignedEntityCount$1.elem)).toString());
                        newEntity.$plus$eq(m);
                        ++this.unAlignedEntityCount$1.elem;
                        boxedUnit = this.falsePositives1$1.$plus$eq((Object)m);
                    } else {
                        Object object;
                        if (((SeqLike)this.entityHash$1.apply((Object)gtMention.entity())).length() > 1 && !BoxesRunTime.unboxToBoolean((Object)this.gtAligned$1.apply((Object)gtMention))) {
                            ++this.relevantExactMatches$1.elem;
                        }
                        this.gtAligned$1.update((Object)gtMention, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        if (this.debug$1) {
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"aligned: ").append((Object)gtMention.string()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)gtMention.phrase().start())).append((Object)"  ").append((Object)m.phrase().string()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)m.phrase().start())).append((Object)" ").append(gtMention.entity().uniqueId()).toString());
                        }
                        ++this.exactMatches$1.elem;
                        if (this.options$2.useEntityType()) {
                            object = m.phrase().attr().$plus$eq(gtMention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)));
                        } else {
                            NounPhraseEntityTypeLabeler$.MODULE$.process(m.phrase());
                            object = BoxedUnit.UNIT;
                        }
                        WithinDocEntity newEntity = this.gtDoc$1.coref().entityFromUniqueId((String)gtMention.entity().uniqueId());
                        newEntity.$plus$eq(m);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    if (this.debug$1) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"not aligned: ").append((Object)m.string()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)m.phrase().start())).toString());
                    }
                    m.phrase().attr().$plus$eq(new OntonotesPhraseEntityType(m.phrase(), "O", OntonotesPhraseEntityType$.MODULE$.$lessinit$greater$default$3()));
                    WithinDocEntity newEntity = this.gtDoc$1.coref().entityFromUniqueId(new StringBuilder().append((Object)this.gtDoc$1.name()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.gtDoc$1.targetCoref().entities().size())).append((Object)BoxesRunTime.boxToInteger((int)this.unAlignedEntityCount$1.elem)).toString());
                    newEntity.$plus$eq(m);
                    ++this.unAlignedEntityCount$1.elem;
                    boxedUnit = this.falsePositives1$1.$plus$eq((Object)m);
                }
                return boxedUnit;
            }
            {
                this.gtDoc$1 = gtDoc$1;
                this.options$2 = options$2;
                this.shifts$2 = shifts$2;
                this.gtSpanHash$1 = gtSpanHash$1;
                this.gtHeadHash$1 = gtHeadHash$1;
                this.gtAligned$1 = gtAligned$1;
                this.exactMatches$1 = exactMatches$1;
                this.relevantExactMatches$1 = relevantExactMatches$1;
                this.unAlignedEntityCount$1 = unAlignedEntityCount$1;
                this.debug$1 = debug$1;
                this.entityHash$1 = entityHash$1;
                this.falsePositives1$1 = falsePositives1$1;
            }
        });
        int countUnAligned = gtAligned.count((Function1)new Serializable(){

            public final boolean apply(Tuple2<Mention, Object> x$5) {
                return !x$5._2$mcZ$sp();
            }
        });
        WithinDocCoref newCoref = new WithinDocCoref(gtDoc);
        newCoref.target_$eq(gtDoc.coref());
        gtDoc.coref().mentions().foreach((Function1)new Serializable(newCoref){
            private final WithinDocCoref newCoref$1;

            public final Mention apply(Mention m) {
                return this.newCoref$1.addMention(m.phrase());
            }
            {
                this.newCoref$1 = newCoref$1;
            }
        });
        gtDoc.attr().$plus$eq(newCoref);
        return new MentionAlignment.PrecRecReport(relevantGTMentions - countUnAligned, relevantGTMentions, detectedMentions.length());
    }

    public Map<Class<?>, Function0<DocumentAnnotator>> alignMentions$default$6() {
        return null;
    }

    public int getHeadTokenInDoc(Mention m) {
        return m.phrase().start() + m.phrase().headTokenOffset();
    }

    public Option<Mention> checkContainment(HashMap<Tuple2<Object, Object>, Mention> startLengthHash, HashMap<Object, Mention> headHash, Mention m, CorefOptions options, Seq<Object> shifts) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Option option;
            Object object = new Object();
            try {
                int start = m.phrase().start();
                int length2 = m.phrase().length();
                int headTokIdxInDoc = m.phrase().headTokenOffset() + m.phrase().start();
                int startIdx = start;
                int endIdx = start + length2;
                shifts.foreach((Function1)new Serializable(startLengthHash, shifts, startIdx, endIdx, object){
                    public final HashMap startLengthHash$1;
                    private final Seq shifts$3;
                    public final int startIdx$1;
                    public final int endIdx$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(int startShift) {
                        this.apply$mcVI$sp(startShift);
                    }

                    public void apply$mcVI$sp(int startShift) {
                        this.shifts$3.withFilter((Function1)new Serializable(this, startShift){
                            private final /* synthetic */ anonfun.checkContainment.1 $outer;
                            private final int startShift$1;

                            public final boolean apply(int endShift) {
                                return this.apply$mcZI$sp(endShift);
                            }

                            public boolean apply$mcZI$sp(int endShift) {
                                return this.$outer.startIdx$1 + this.startShift$1 <= this.$outer.endIdx$1 + endShift;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.startShift$1 = startShift$1;
                            }
                        }).foreach((Function1)new Serializable(this, startShift){
                            private final /* synthetic */ anonfun.checkContainment.1 $outer;
                            private final int startShift$1;

                            public final void apply(int endShift) {
                                this.apply$mcVI$sp(endShift);
                            }

                            public void apply$mcVI$sp(int endShift) {
                                int newStart = this.$outer.startIdx$1 + this.startShift$1;
                                int newEnd = this.$outer.endIdx$1 + endShift;
                                Tuple2.mcII.sp key = new Tuple2.mcII.sp(newStart, newEnd - newStart);
                                if (this.$outer.startLengthHash$1.contains((Object)key)) {
                                    throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)new Some(this.$outer.startLengthHash$1.apply((Object)key)));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.startShift$1 = startShift$1;
                            }
                        });
                    }
                    {
                        this.startLengthHash$1 = startLengthHash$1;
                        this.shifts$3 = shifts$3;
                        this.startIdx$1 = startIdx$1;
                        this.endIdx$1 = endIdx$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (headHash.contains((Object)BoxesRunTime.boxToInteger((int)headTokIdxInDoc))) {
                    return new Some(headHash.apply((Object)BoxesRunTime.boxToInteger((int)headTokIdxInDoc)));
                }
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    private MentionAlignment$() {
        MODULE$ = this;
    }
}

