/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.embeddings;

import cc.factorie.app.nlp.embeddings.EmbeddingOpts;
import cc.factorie.app.nlp.embeddings.TensorUtils$;
import cc.factorie.la.DenseTensor1;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.PriorityQueue;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;

public final class EmbeddingDistance$ {
    public static final EmbeddingDistance$ MODULE$;
    private int threshold;
    private String[] vocab;
    private DenseTensor1[] weights;
    private int D;
    private int V;
    private int top;

    static {
        new EmbeddingDistance$();
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    public String[] vocab() {
        return this.vocab;
    }

    public void vocab_$eq(String[] x$1) {
        this.vocab = x$1;
    }

    public DenseTensor1[] weights() {
        return this.weights;
    }

    public void weights_$eq(DenseTensor1[] x$1) {
        this.weights = x$1;
    }

    public int D() {
        return this.D;
    }

    public void D_$eq(int x$1) {
        this.D = x$1;
    }

    public int V() {
        return this.V;
    }

    public void V_$eq(int x$1) {
        this.V = x$1;
    }

    public int top() {
        return this.top;
    }

    public void top_$eq(int x$1) {
        this.top = x$1;
    }

    public void main(String[] args) {
        if (Predef$.MODULE$.refArrayOps((Object[])args).size() != 1) {
            Predef$.MODULE$.println((Object)"Input vectors file missing. USAGE : distance vectors.txt");
            return;
        }
        String inputFile = args[0];
        this.load(inputFile, this.load$default$2());
        this.play();
    }

    public void run(EmbeddingOpts opts) {
        this.load(opts.explore().value(), opts.encoding().value());
        this.play();
    }

    public void nearestNeighbours(String inputFile, int numNeighbours) {
        this.top_$eq(numNeighbours);
        this.load(inputFile, this.load$default$2());
        this.play();
    }

    public int nearestNeighbours$default$2() {
        return 30;
    }

    public void load(String embeddingsFile, String encoding) {
        ObjectRef lineItr = ObjectRef.create((Object)Source$.MODULE$.fromFile(embeddingsFile, encoding).getLines());
        int[] details = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)((Iterator)lineItr.elem).next())).stripLineEnd())).split(' ')).map((Function1)new Serializable(){

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.V_$eq(this.threshold() > 0 && details[0] > this.threshold() ? this.threshold() : details[0]);
        this.D_$eq(details[1]);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("# words : %d , # size : %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.V()), BoxesRunTime.boxToInteger((int)this.D())})));
        this.vocab_$eq(new String[this.V()]);
        this.weights_$eq(new DenseTensor1[this.V()]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.V()).foreach$mVc$sp((Function1)new Serializable(lineItr){
            private final ObjectRef lineItr$1;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                String[] line = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)((Iterator)this.lineItr$1.elem).next())).stripLineEnd())).split(' ');
                EmbeddingDistance$.MODULE$.vocab()[v] = line[0].toLowerCase();
                EmbeddingDistance$.MODULE$.weights()[v] = new DenseTensor1(EmbeddingDistance$.MODULE$.D(), 0.0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), EmbeddingDistance$.MODULE$.D()).foreach$mVc$sp((Function1)new Serializable(this, line, v){
                    private final String[] line$1;
                    private final int v$1;

                    public final void apply(int d) {
                        this.apply$mcVI$sp(d);
                    }

                    public void apply$mcVI$sp(int d) {
                        EmbeddingDistance$.MODULE$.weights()[this.v$1].update(d, new StringOps(Predef$.MODULE$.augmentString(this.line$1[d + 1])).toDouble());
                    }
                    {
                        this.line$1 = line$1;
                        this.v$1 = v$1;
                    }
                });
                EmbeddingDistance$.MODULE$.weights()[v].$div$eq(EmbeddingDistance$.MODULE$.weights()[v].twoNorm());
            }
            {
                this.lineItr$1 = lineItr$1;
            }
        });
        Predef$.MODULE$.println((Object)"loaded vocab and their embeddings");
    }

    public String load$default$2() {
        return "UTF8";
    }

    /*
     * WARNING - void declaration
     */
    public void play() {
        block0: while (true) {
            Predef$.MODULE$.print((Object)"Enter word (EXIT to break) : ");
            ObjectRef words = ObjectRef.create((Object)((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.readLine())).stripLineEnd().toLowerCase())).split(' ')).map((Function1)new Serializable(){

                public final int apply(String word) {
                    return EmbeddingDistance$.MODULE$.cc$factorie$app$nlp$embeddings$EmbeddingDistance$$getID(word);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).filter((Function1)new Serializable(){

                public final boolean apply(int id) {
                    return this.apply$mcZI$sp(id);
                }

                public boolean apply$mcZI$sp(int id) {
                    return id != -1;
                }
            })));
            if (Predef$.MODULE$.intArrayOps((int[])words.elem).size() == 0) {
                Predef$.MODULE$.println((Object)"words not in vocab");
                continue;
            }
            DenseTensor1 embedding_in = new DenseTensor1(this.D(), 0.0);
            Predef$.MODULE$.intArrayOps((int[])words.elem).foreach((Function1)new Serializable(embedding_in){
                private final DenseTensor1 embedding_in$1;

                public final void apply(int word) {
                    this.apply$mcVI$sp(word);
                }

                public void apply$mcVI$sp(int word) {
                    this.embedding_in$1.$plus$eq(EmbeddingDistance$.MODULE$.weights()[word]);
                }
                {
                    this.embedding_in$1 = embedding_in$1;
                }
            });
            embedding_in.$div$eq(Predef$.MODULE$.intArrayOps((int[])words.elem).size());
            ObjectRef pq = ObjectRef.create((Object)new PriorityQueue(this.dis()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])this.vocab()).size()).foreach$mVc$sp((Function1)new Serializable(words, embedding_in, pq){
                private final ObjectRef words$1;
                private final DenseTensor1 embedding_in$1;
                private final ObjectRef pq$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (Predef$.MODULE$.intArrayOps((int[])this.words$1.elem).size() != 1 || !((Object)BoxesRunTime.boxToInteger((int)((int[])this.words$1.elem)[0])).equals(EmbeddingDistance$.MODULE$.vocab()[i])) {
                        DenseTensor1 embedding_out = EmbeddingDistance$.MODULE$.weights()[i];
                        double score2 = TensorUtils$.MODULE$.cosineDistance(this.embedding_in$1, embedding_out);
                        if (i < EmbeddingDistance$.MODULE$.top()) {
                            ((PriorityQueue)this.pq$1.elem).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmbeddingDistance$.MODULE$.vocab()[i]), (Object)BoxesRunTime.boxToDouble((double)score2))}));
                        } else if (score2 > ((Tuple2)((PriorityQueue)this.pq$1.elem).head())._2$mcD$sp()) {
                            ((PriorityQueue)this.pq$1.elem).dequeue();
                            ((PriorityQueue)this.pq$1.elem).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmbeddingDistance$.MODULE$.vocab()[i]), (Object)BoxesRunTime.boxToDouble((double)score2))}));
                        }
                    }
                }
                {
                    this.words$1 = words$1;
                    this.embedding_in$1 = embedding_in$1;
                    this.pq$1 = pq$1;
                }
            });
            Tuple2[] arr = new Tuple2[((PriorityQueue)pq.elem).size()];
            boolean i = false;
            while (true) {
                void var5_5;
                void var3_3;
                if (((PriorityQueue)pq.elem).isEmpty()) {
                    Predef$.MODULE$.println((Object)"\t\t\t\t\t\tWord\t\tCosine Distance");
                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arr).reverse()).foreach((Function1)new Serializable(){

                        public final void apply(Tuple2<String, Object> x) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%50s\t\t%f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x._1(), BoxesRunTime.boxToDouble((double)x._2$mcD$sp())})));
                        }
                    });
                    continue block0;
                }
                var4_4[var5_5] = new Tuple2(((Tuple2)((PriorityQueue)var3_3.elem).head())._1(), (Object)BoxesRunTime.boxToDouble((double)((Tuple2)((PriorityQueue)var3_3.elem).head())._2$mcD$sp()));
                ++var5_5;
                ((PriorityQueue)var3_3.elem).dequeue();
            }
            break;
        }
    }

    private Object dis() {
        return new Ordering<Tuple2<String, Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple2<String, Object>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple2<String, Object>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple2<String, Object> a, Tuple2<String, Object> b) {
                return -new RichDouble(Predef$.MODULE$.doubleWrapper(a._2$mcD$sp())).compare((Object)BoxesRunTime.boxToDouble((double)b._2$mcD$sp()));
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }

    public int cc$factorie$app$nlp$embeddings$EmbeddingDistance$$getID(String word) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.vocab().length).foreach$mVc$sp((Function1)new Serializable(word, object){
                private final String word$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (EmbeddingDistance$.MODULE$.vocab()[i].equalsIgnoreCase(this.word$1)) {
                        throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey1$1, i);
                    }
                }
                {
                    this.word$1 = word$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return -1;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcI$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private EmbeddingDistance$() {
        MODULE$ = this;
        this.threshold = 0;
        this.vocab = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.weights = (DenseTensor1[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DenseTensor1.class));
        this.D = 0;
        this.V = 0;
        this.top = 30;
    }
}

