/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.embeddings;

import cc.factorie.app.nlp.embeddings.WordEmbeddingModel;
import cc.factorie.la.Tensor;
import cc.factorie.la.WeightsMapAccumulator;
import cc.factorie.model.Weights;
import cc.factorie.optimize.Example;
import cc.factorie.util.DoubleAccumulator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001b\tQ2k[5q\u000fJ\fWNT3h'\u0006l\u0007\u000f\\5oO\u0016C\u0018-\u001c9mK*\u00111\u0001B\u0001\u000bK6\u0014W\r\u001a3j]\u001e\u001c(BA\u0003\u0007\u0003\rqG\u000e\u001d\u0006\u0003\u000f!\t1!\u00199q\u0015\tI!\"\u0001\u0005gC\u000e$xN]5f\u0015\u0005Y\u0011AA2d\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\t_B$\u0018.\\5{K&\u0011\u0011D\u0006\u0002\b\u000bb\fW\u000e\u001d7f\u0011!Y\u0002A!A!\u0002\u0013a\u0012!B7pI\u0016d\u0007CA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u0005I9vN\u001d3F[\n,G\rZ5oO6{G-\u001a7\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nAa^8sIB\u0011qbI\u0005\u0003IA\u00111!\u00138u\u0011!1\u0003A!A!\u0002\u0013\u0011\u0013aB2p]R,\u0007\u0010\u001e\u0005\tQ\u0001\u0011\t\u0011)A\u0005E\u0005)A.\u00192fY\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"R\u0001L\u0017/_A\u0002\"!\b\u0001\t\u000bmI\u0003\u0019\u0001\u000f\t\u000b\u0005J\u0003\u0019\u0001\u0012\t\u000b\u0019J\u0003\u0019\u0001\u0012\t\u000b!J\u0003\u0019\u0001\u0012\t\u000bI\u0002A\u0011A\u001a\u00025\u0005\u001c7-^7vY\u0006$XMV1mk\u0016\fe\u000eZ$sC\u0012LWM\u001c;\u0015\u0007Q:t\b\u0005\u0002\u0010k%\u0011a\u0007\u0005\u0002\u0005+:LG\u000fC\u00039c\u0001\u0007\u0011(A\u0003wC2,X\r\u0005\u0002;{5\t1H\u0003\u0002=\u0011\u0005!Q\u000f^5m\u0013\tq4HA\tE_V\u0014G.Z!dGVlW\u000f\\1u_JDQ\u0001Q\u0019A\u0002\u0005\u000b\u0001b\u001a:bI&,g\u000e\u001e\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\"\t!\u0001\\1\n\u0005\u0019\u001b%!F,fS\u001eDGo]'ba\u0006\u001b7-^7vY\u0006$xN\u001d")
public class SkipGramNegSamplingExample
implements Example {
    private final WordEmbeddingModel model;
    private final int word;
    private final int context;
    private final int label;

    @Override
    public void accumulateValueAndGradient(DoubleAccumulator value2, WeightsMapAccumulator gradient) {
        Tensor wordEmbedding = ((Weights)this.model.weights().apply(this.word)).value();
        Tensor contextEmbedding = ((Weights)this.model.weights().apply(this.context)).value();
        double score2 = wordEmbedding.dot(contextEmbedding);
        double exp = package$.MODULE$.exp(-score2);
        double objective = 0.0;
        double factor = 0.0;
        if (this.label == 1) {
            objective = -package$.MODULE$.log1p(exp);
            factor = exp / (1.0 + exp);
        }
        if (this.label == -1) {
            objective = -score2 - package$.MODULE$.log1p(exp);
            factor = (double)-1 / (1.0 + exp);
        }
        if (value2 != null) {
            value2.accumulate(BoxesRunTime.boxToDouble((double)objective));
        }
        if (gradient != null) {
            gradient.accumulate((Weights)this.model.weights().apply(this.word), contextEmbedding, factor);
            gradient.accumulate((Weights)this.model.weights().apply(this.context), wordEmbedding, factor);
        }
    }

    public SkipGramNegSamplingExample(WordEmbeddingModel model, int word, int context, int label) {
        this.model = model;
        this.word = word;
        this.context = context;
        this.label = label;
    }
}

