/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.load;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.coref.Mention;
import cc.factorie.app.nlp.coref.WithinDocCoref;
import cc.factorie.app.nlp.coref.WithinDocEntity;
import cc.factorie.app.nlp.load.ACEEntityIdentifiers;
import cc.factorie.app.nlp.load.ACEFileIdentifier;
import cc.factorie.app.nlp.load.ACEMentionIdentifiers;
import cc.factorie.app.nlp.load.LoadACE$;
import cc.factorie.app.nlp.phrase.Phrase;
import cc.factorie.app.nlp.segment.DeterministicSentenceSegmenter$;
import cc.factorie.app.nlp.segment.DeterministicTokenizer$;
import cc.factorie.variable.SpanVar;
import java.io.File;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;

public final class LoadACE$ {
    public static final LoadACE$ MODULE$;
    private final Regex matchTag;

    static {
        new LoadACE$();
    }

    private Regex matchTag() {
        return this.matchTag;
    }

    private Document makeDoc(String sgm) {
        BufferedSource source = Source$.MODULE$.fromFile(sgm, Codec$.MODULE$.fallbackSystemCodec());
        String sgmString = source.mkString();
        source.close();
        Document doc = new Document(this.matchTag().replaceAllIn((CharSequence)sgmString, (Function1)new Serializable(){

            public final String apply(Regex.Match x$1) {
                return "";
            }
        })).setName(sgm);
        doc.attr().$plus$eq(new ACEFileIdentifier(new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(sgm)).dropRight(4))).append((Object)".apf.xml").toString()));
        DeterministicTokenizer$.MODULE$.process(doc);
        DeterministicSentenceSegmenter$.MODULE$.process(doc);
        int end = ((SpanVar)doc.asSection().sentences().last()).end();
        Object object = end != doc.asSection().length() - 1 ? new Sentence(doc.asSection(), end + 1, doc.asSection().length() - 1 - end) : BoxedUnit.UNIT;
        return doc;
    }

    public int cc$factorie$app$nlp$load$LoadACE$$tokenIndexAtCharIndex(int charOffset, Document doc) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            int n;
            Object object = new Object();
            try {
                Predef$.MODULE$.require(charOffset >= 0 && charOffset <= doc.string().length());
                IntRef i = IntRef.create((int)0);
                doc.tokens().foreach((Function1)new Serializable(charOffset, i, object){
                    private final int charOffset$1;
                    private final IntRef i$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Token t) {
                        if (t.stringStart() <= this.charOffset$1 && this.charOffset$1 <= t.stringEnd()) {
                            throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey1$1, this.i$1.elem);
                        }
                        ++this.i$1.elem;
                    }
                    {
                        this.charOffset$1 = charOffset$1;
                        this.i$1 = i$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                n = -1;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                n = nonLocalReturnControl2.value$mcI$sp();
            }
            return n;
        }
        throw nonLocalReturnControl2;
    }

    public Tuple2<Object, Object> cc$factorie$app$nlp$load$LoadACE$$getTokenIdxAndLength(NodeSeq mention, Document doc) {
        int start = new StringOps(Predef$.MODULE$.augmentString(this.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("extent").$bslash("charseq"), "START"))).toInt();
        int end = new StringOps(Predef$.MODULE$.augmentString(this.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("extent").$bslash("charseq"), "END"))).toInt() + 1;
        int startTokenIdx = this.cc$factorie$app$nlp$load$LoadACE$$tokenIndexAtCharIndex(start, doc);
        int endTokenIdx = this.cc$factorie$app$nlp$load$LoadACE$$tokenIndexAtCharIndex(end, doc);
        return new Tuple2.mcII.sp(startTokenIdx, endTokenIdx - startTokenIdx + 1);
    }

    public String cc$factorie$app$nlp$load$LoadACE$$getAttr(NodeSeq ns, String key) {
        Seq k = (Seq)ns.apply(0).attribute(key).getOrElse((Function0)new Serializable(){

            public final Null$ apply() {
                return null;
            }
        });
        return k == null ? "None" : NodeSeq$.MODULE$.seqToNodeSeq(k).text();
    }

    public void addMentionsFromApf(NodeSeq apf, Document doc) {
        WithinDocCoref coref = doc.getTargetCoref();
        apf.$bslash$bslash("entity").foreach((Function1)new Serializable(doc, coref){
            public final Document doc$1;
            public final WithinDocCoref coref$1;

            public final void apply(Node entity) {
                String entityKey = entity.$bslash("entity_attributes").$bslash("name").$bslash("charseq").text();
                WithinDocEntity e = this.coref$1.entityFromUniqueId(entityKey);
                e.attr().$plus$eq(new ACEEntityIdentifiers(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)entity, "ID"), LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)entity, "TYPE"), LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)entity, "SUBTYPE"), LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)entity, "CLASS")));
                entity.$bslash("entity_mention").foreach((Function1)new Serializable(this, e){
                    private final /* synthetic */ anonfun.addMentionsFromApf.1 $outer;
                    private final WithinDocEntity e$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object apply(Node mention) {
                        Object object;
                        Tuple2.mcII.sp sp2;
                        Tuple2<Object, Object> tuple2 = LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getTokenIdxAndLength((NodeSeq)mention, this.$outer.doc$1);
                        if (tuple2 == null) throw new MatchError(tuple2);
                        int start = tuple2._1$mcI$sp();
                        int length2 = tuple2._2$mcI$sp();
                        Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(start, length2);
                        int start2 = sp3._1$mcI$sp();
                        int length3 = sp3._2$mcI$sp();
                        int headCharIndex = new StringOps(Predef$.MODULE$.augmentString(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("head").$bslash("charseq"), "END"))).toInt();
                        int headLeftCharIndex = new StringOps(Predef$.MODULE$.augmentString(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("head").$bslash("charseq"), "START"))).toInt();
                        try {
                            int tokIndRight = LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$tokenIndexAtCharIndex(headCharIndex, this.$outer.doc$1);
                            Phrase phrase = new Phrase(this.$outer.doc$1.asSection(), start2, length3, tokIndRight - start2);
                            if (phrase.sentence() == null) {
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("NULL mention: (%d, %d) -> %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)start2), BoxesRunTime.boxToInteger((int)length3), phrase.string()})));
                            }
                            Mention newMention = this.$outer.coref$1.addMention(phrase);
                            this.e$1.$plus$eq(newMention);
                            object = newMention.attr().$plus$eq(new ACEMentionIdentifiers(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)mention, "ID"), LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)mention, "TYPE"), LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr((NodeSeq)mention, "LDCTYPE"), new StringOps(Predef$.MODULE$.augmentString(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("extent").$bslash("charseq"), "START"))).toInt(), new StringOps(Predef$.MODULE$.augmentString(LoadACE$.MODULE$.cc$factorie$app$nlp$load$LoadACE$$getAttr(mention.$bslash("extent").$bslash("charseq"), "END"))).toInt()));
                            return object;
                        }
                        catch (Exception exception) {
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"doc: ").append((Object)this.$outer.doc$1.tokens().mkString("\n")).toString());
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"mention: ").append((Object)mention).toString());
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"headIndex: ").append((Object)BoxesRunTime.boxToInteger((int)headCharIndex)).toString());
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"headLeftIndex: ").append((Object)BoxesRunTime.boxToInteger((int)headLeftCharIndex)).toString());
                            exception.printStackTrace();
                            System.exit(1);
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.e$1 = e$1;
                    }
                });
            }
            {
                this.doc$1 = doc$1;
                this.coref$1 = coref$1;
            }
        });
    }

    private Mention lookupEntityMention(String id, Document doc) {
        return (Mention)doc.targetCoref().mentions().find((Function1)new Serializable(id){
            private final String id$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Mention m) {
                ACEMentionIdentifiers a = (ACEMentionIdentifiers)m.attr().apply(ClassTag$.MODULE$.apply(ACEMentionIdentifiers.class));
                if (a == null) return false;
                String string = a.mId();
                String string2 = this.id$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.id$1 = id$1;
            }
        }).get();
    }

    /*
     * WARNING - void declaration
     */
    private NodeSeq loadXML(String apfFile) {
        void var3_3;
        BufferedSource source = Source$.MODULE$.fromFile(apfFile, Codec$.MODULE$.fallbackSystemCodec());
        Elem result = (Elem)XML$.MODULE$.loadString(source.getLines().drop(2).mkString("\n"));
        source.close();
        return var3_3;
    }

    public Document fromApf(String apfFile) {
        return this.fromApf(apfFile, this.makeDoc(new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(apfFile)).dropRight(8))).append((Object)".sgm").toString()));
    }

    public Document fromApf(String apfFile, Document doc) {
        this.addMentionsFromApf(this.loadXML(apfFile), doc);
        return doc;
    }

    public Seq<Document> fromDirectory(String dir, int takeOnly) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dir).listFiles()).filter((Function1)new Serializable(){

            public final boolean apply(File x$3) {
                return x$3.getName().endsWith(".apf.xml");
            }
        })).take(takeOnly)).map((Function1)new Serializable(){

            public final Document apply(File f) {
                return LoadACE$.MODULE$.fromApf(f.getAbsolutePath());
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public int fromDirectory$default$2() {
        return Integer.MAX_VALUE;
    }

    public void main(String[] args) {
        Seq<Document> docs = this.fromDirectory(args[0], this.fromDirectory$default$2());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"docs: ").append((Object)BoxesRunTime.boxToInteger((int)docs.size())).toString());
        docs.foreach((Function1)new Serializable(){

            public final void apply(Document d) {
                d.getTargetCoref().mentions().foreach((Function1)new Serializable(this){

                    public final void apply(Mention s) {
                        Predef$.MODULE$.println((Object)s);
                    }
                });
            }
        });
    }

    private LoadACE$() {
        MODULE$ = this;
        this.matchTag = new StringOps(Predef$.MODULE$.augmentString("<[A-Za-z=_\"/ ]*>")).r();
    }
}

