/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.load;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.UnknownDocumentAnnotator$;
import cc.factorie.app.nlp.lemma.TokenLemma;
import cc.factorie.app.nlp.parse.ParseTree;
import cc.factorie.app.nlp.pos.PennPosTag;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class LoadConll2008$ {
    public static final LoadConll2008$ MODULE$;
    private boolean loadLemma;

    static {
        new LoadConll2008$();
    }

    public void cc$factorie$app$nlp$load$LoadConll2008$$addDepInfo(Sentence s, Seq<Tuple3<Object, Object, String>> depInfoSeq) {
        ParseTree tree = new ParseTree(s);
        depInfoSeq.withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple3<Object, Object, String> check$ifrefutable$1) {
                Tuple3<Object, Object, String> tuple3 = check$ifrefutable$1;
                boolean bl = tuple3 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(tree){
            private final ParseTree tree$1;

            public final void apply(Tuple3<Object, Object, String> x$1) {
                Tuple3<Object, Object, String> tuple3 = x$1;
                if (tuple3 != null) {
                    int childIdx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    int parentIdx = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    String depLabel = (String)tuple3._3();
                    this.tree$1.setParent(childIdx, parentIdx);
                    this.tree$1.label(childIdx).setCategory(depLabel, null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.tree$1 = tree$1;
            }
        });
        s.attr().$plus$eq(tree);
    }

    public boolean loadLemma() {
        return this.loadLemma;
    }

    public void loadLemma_$eq(boolean x$1) {
        this.loadLemma = x$1;
    }

    public Seq<Document> fromFilename(String filename) {
        ObjectRef document2 = ObjectRef.create((Object)new Document());
        ((Document)document2.elem).annotators().update(Token.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        ((Document)document2.elem).annotators().update(Sentence.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        ((Document)document2.elem).annotators().update(PennPosTag.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        if (this.loadLemma()) {
            ((Document)document2.elem).annotators().update(TokenLemma.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        }
        BufferedSource source = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        ObjectRef sentence2 = ObjectRef.create((Object)new Sentence((Document)document2.elem));
        ObjectRef depInfoSeq = ObjectRef.create((Object)new ArrayBuffer());
        source.getLines().foreach((Function1)new Serializable(document2, sentence2, depInfoSeq){
            private final ObjectRef document$1;
            private final ObjectRef sentence$1;
            private final ObjectRef depInfoSeq$1;

            public final void apply(String line) {
                if (line.length() < 2) {
                    ((Document)this.document$1.elem).appendString("\n");
                    LoadConll2008$.MODULE$.cc$factorie$app$nlp$load$LoadConll2008$$addDepInfo((Sentence)this.sentence$1.elem, (Seq<Tuple3<Object, Object, String>>)((ArrayBuffer)this.depInfoSeq$1.elem));
                    this.depInfoSeq$1.elem = new ArrayBuffer();
                    this.sentence$1.elem = null;
                } else {
                    String[] fields;
                    if ((Sentence)this.sentence$1.elem == null) {
                        this.sentence$1.elem = new Sentence((Document)this.document$1.elem);
                    }
                    Predef$.MODULE$.assert((fields = new StringOps(Predef$.MODULE$.augmentString(line)).split('\t')).length >= 10);
                    int currTokenIdx = new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt() - 1;
                    String word = fields[1];
                    String lemma = fields[2];
                    String partOfSpeech = fields[3];
                    int parentIdx = new StringOps(Predef$.MODULE$.augmentString(fields[8])).toInt() - 1;
                    String depLabel = fields[9];
                    ((Document)this.document$1.elem).appendString(" ");
                    Token token = new Token((Sentence)this.sentence$1.elem, word);
                    token.attr().$plus$eq(new PennPosTag(token, partOfSpeech));
                    Object object = LoadConll2008$.MODULE$.loadLemma() ? token.attr().$plus$eq(new TokenLemma(token, lemma)) : BoxedUnit.UNIT;
                    ((ArrayBuffer)this.depInfoSeq$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)currTokenIdx), (Object)BoxesRunTime.boxToInteger((int)parentIdx), (Object)depLabel)}));
                }
            }
            {
                this.document$1 = document$1;
                this.sentence$1 = sentence$1;
                this.depInfoSeq$1 = depInfoSeq$1;
            }
        });
        if ((Sentence)sentence2.elem != null) {
            this.cc$factorie$app$nlp$load$LoadConll2008$$addDepInfo((Sentence)sentence2.elem, (Seq<Tuple3<Object, Object, String>>)((ArrayBuffer)depInfoSeq.elem));
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loaded 1 document with ").append((Object)BoxesRunTime.boxToInteger((int)((Document)document2.elem).sentences().size())).append((Object)" sentences with ").append((Object)BoxesRunTime.boxToInteger((int)((Document)document2.elem).asSection().length())).append((Object)" tokens total from file ").append((Object)filename).toString());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Document[]{(Document)document2.elem}));
    }

    public void printDocument(Document d) {
        d.sentences().foreach((Function1)new Serializable(){

            public final void apply(Sentence s) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)((ParseTree)s.attr().apply(ClassTag$.MODULE$.apply(ParseTree.class))).toString()).append((Object)"\n").toString());
            }
        });
    }

    public void main(String[] args) {
        Predef$.MODULE$.refArrayOps((Object[])args).foreach((Function1)new Serializable(){

            public final void apply(String filename) {
                LoadConll2008$.MODULE$.printDocument((Document)LoadConll2008$.MODULE$.fromFilename(filename).head());
            }
        });
    }

    private LoadConll2008$() {
        MODULE$ = this;
        this.loadLemma = true;
    }
}

