/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.load;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.UnknownDocumentAnnotator$;
import cc.factorie.app.nlp.coref.Mention;
import cc.factorie.app.nlp.coref.WithinDocCoref;
import cc.factorie.app.nlp.load.ACEFileIdentifier;
import cc.factorie.app.nlp.load.LoadReACE$;
import cc.factorie.app.nlp.load.LoadReACE$$anonfun$makeDoc$1$;
import cc.factorie.app.nlp.load.ReACEMentionIdentifiers;
import cc.factorie.app.nlp.load.ReACESentenceAnnotations;
import cc.factorie.app.nlp.load.ReACEWordAnnotations;
import cc.factorie.app.nlp.ner.ConllNerSpan;
import cc.factorie.app.nlp.ner.ConllNerSpanBuffer;
import cc.factorie.app.nlp.phrase.Phrase;
import cc.factorie.app.nlp.pos.PennPosTag;
import java.io.File;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class LoadReACE$ {
    public static final LoadReACE$ MODULE$;

    static {
        new LoadReACE$();
    }

    public Option<String> cc$factorie$app$nlp$load$LoadReACE$$getAttr(NodeSeq ns, String key) {
        String v;
        String fullKey = new StringBuilder().append((Object)"@").append((Object)key).toString();
        String string = v = ns.$bslash(fullKey).text();
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)v);
    }

    public ReACEWordAnnotations cc$factorie$app$nlp$load$LoadReACE$$makeTokenAnnotations(NodeSeq wordXml) {
        Serializable a = new Serializable(wordXml){
            private final NodeSeq wordXml$1;

            public final Option<String> apply(String x$1) {
                return LoadReACE$.MODULE$.cc$factorie$app$nlp$load$LoadReACE$$getAttr(this.wordXml$1, x$1);
            }
            {
                this.wordXml$1 = wordXml$1;
            }
        };
        return new ReACEWordAnnotations((Function1)a){
            private final Option<String> lemma;
            private final Option<String> pos;
            private final Option<String> chunk;
            private final Option<String> nounHead;
            private final Option<String> verbStem;
            private final Option<String> verbHead;
            private final Option<String> verbVoice;
            private final Option<String> verbNeg;

            public Option<String> lemma() {
                return this.lemma;
            }

            public Option<String> pos() {
                return this.pos;
            }

            public Option<String> chunk() {
                return this.chunk;
            }

            public Option<String> nounHead() {
                return this.nounHead;
            }

            public Option<String> verbStem() {
                return this.verbStem;
            }

            public Option<String> verbHead() {
                return this.verbHead;
            }

            public Option<String> verbVoice() {
                return this.verbVoice;
            }

            public Option<String> verbNeg() {
                return this.verbNeg;
            }
            {
                this.lemma = (Option)a$1.apply((Object)"l");
                this.pos = (Option)a$1.apply((Object)"p");
                this.chunk = (Option)a$1.apply((Object)"phr");
                this.nounHead = (Option)a$1.apply((Object)"headn");
                this.verbStem = (Option)a$1.apply((Object)"vstem");
                this.verbHead = (Option)a$1.apply((Object)"headv");
                this.verbVoice = (Option)a$1.apply((Object)"voice");
                this.verbNeg = (Option)a$1.apply((Object)"neg");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private Document makeDoc(String xml) {
        void var2_2;
        Document doc = new Document().setName(xml);
        doc.annotators().update(Token.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        doc.annotators().update(Sentence.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        doc.annotators().update(PennPosTag.class, UnknownDocumentAnnotator$.MODULE$.getClass());
        doc.attr().$plus$eq(new ACEFileIdentifier(xml));
        Node xmlText = XML$.MODULE$.loadFile(new StringBuilder().append((Object)xml).append((Object)".ttt.xml").toString());
        IntRef currP = IntRef.create((int)0);
        xmlText.$bslash$bslash("p").foreach((Function1)new Serializable(doc, currP){
            public final Document doc$1;
            public final IntRef currP$1;

            public final void apply(Node p) {
                ++this.currP$1.elem;
                p.$bslash$bslash("s").foreach((Function1)new Serializable(this){
                    private final /* synthetic */ anonfun.makeDoc.1 $outer;

                    public final void apply(Node s) {
                        Option<String> sId = LoadReACE$.MODULE$.cc$factorie$app$nlp$load$LoadReACE$$getAttr((NodeSeq)s, "id");
                        Sentence sent = new Sentence(this.$outer.doc$1);
                        sent.attr().$plus$eq(new ReACESentenceAnnotations(this, sId){
                            private final Some<String> paragraphId;
                            private final Option<String> sentenceId;

                            public Some<String> paragraphId() {
                                return this.paragraphId;
                            }

                            public Option<String> sentenceId() {
                                return this.sentenceId;
                            }
                            {
                                this.paragraphId = new Some((Object)((Object)BoxesRunTime.boxToInteger((int)$outer.cc$factorie$app$nlp$load$LoadReACE$$anonfun$$anonfun$$$outer().currP$1.elem)).toString());
                                this.sentenceId = sId$1;
                            }
                        });
                        s.$bslash$bslash("w").foreach((Function1)new Serializable(this, sent){
                            private final /* synthetic */ anonfun$makeDoc$1$$anonfun$apply$1 $outer;
                            private final Sentence sent$1;

                            public final void apply(Node w) {
                                Token t = new Token(this.sent$1, w.text());
                                this.$outer.cc$factorie$app$nlp$load$LoadReACE$$anonfun$$anonfun$$$outer().doc$1.appendString(" ");
                                ReACEWordAnnotations annotations = LoadReACE$.MODULE$.cc$factorie$app$nlp$load$LoadReACE$$makeTokenAnnotations((NodeSeq)w);
                                t.attr().$plus$eq(annotations);
                                annotations.pos().foreach((Function1)new Serializable(this, t){
                                    private final Token t$1;

                                    public final PennPosTag apply(String p) {
                                        return this.t$1.attr().$plus$eq(new PennPosTag(this.t$1, p));
                                    }
                                    {
                                        this.t$1 = t$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.sent$1 = sent$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.makeDoc.1 cc$factorie$app$nlp$load$LoadReACE$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.doc$1 = doc$1;
                this.currP$1 = currP$1;
            }
        });
        return var2_2;
    }

    private Option<Mention> lookupEntityMention(Document doc, String id) {
        Option opt;
        Option option = opt = ((IndexedSeqOptimized)doc.attr().apply(ClassTag$.MODULE$.apply(ConllNerSpanBuffer.class))).find((Function1)new Serializable(id){
            private final String id$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(ConllNerSpan s) {
                ReACEMentionIdentifiers a = (ReACEMentionIdentifiers)s.attr().apply(ClassTag$.MODULE$.apply(ReACEMentionIdentifiers.class));
                if (a == null) return false;
                Object object = a.mId().get();
                String string = this.id$1;
                if (object != null) {
                    if (!object.equals(string)) return false;
                    return true;
                }
                if (string == null) return true;
                return false;
            }
            {
                this.id$1 = id$1;
            }
        });
        None$ none$ = None$.MODULE$;
        return !(option != null ? !option.equals(none$) : none$ != null) ? None$.MODULE$ : new Some((Object)((Mention)opt.get()));
    }

    public Document addNrm(Document doc, String xml) {
        WithinDocCoref coref = doc.getCoref();
        Node xmlText = XML$.MODULE$.loadFile(new StringBuilder().append((Object)xml).append((Object)".nrm.xml").toString());
        String string = ((ACEFileIdentifier)doc.attr().apply(ClassTag$.MODULE$.apply(ACEFileIdentifier.class))).fileId();
        String string2 = xml;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        xmlText.$bslash$bslash("ne").foreach((Function1)new Serializable(doc, coref){
            private final Document doc$2;
            private final WithinDocCoref coref$1;

            public final ReACEMentionIdentifiers apply(Node mention) {
                int start = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(mention.$bslash("@fr").text())).drop(1))).toInt() - 1;
                int end = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(mention.$bslash("@to").text())).drop(1))).toInt() - 1;
                int length2 = end - start + 1;
                int hstart = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(mention.$bslash("@hfr").text())).drop(1))).toInt() - 1;
                int hend = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(mention.$bslash("@hto").text())).drop(1))).toInt() - 1;
                int hlength = hend - hstart + 1;
                String nerType = mention.$bslash("@t").text();
                String nerSubType = mention.$bslash("@st").text();
                Phrase phrase = new Phrase(this.doc$2.asSection(), start, length2, hend);
                phrase.attr().$plus$eq(new ConllNerSpan(this.doc$2.asSection(), start, length2, nerType));
                Mention m = this.coref$1.addMention(phrase);
                return m.attr().$plus$eq(new ReACEMentionIdentifiers(this, hstart, hend, hlength, nerType, nerSubType, mention){
                    private final Option<String> mId;
                    private final Option<String> eId;
                    private final Some<Object> headStart;
                    private final Some<Object> headEnd;
                    private final Some<Object> headLength;
                    private final String mType;
                    private final String mSubType;

                    public Option<String> mId() {
                        return this.mId;
                    }

                    public Option<String> eId() {
                        return this.eId;
                    }

                    public Some<Object> headStart() {
                        return this.headStart;
                    }

                    public Some<Object> headEnd() {
                        return this.headEnd;
                    }

                    public Some<Object> headLength() {
                        return this.headLength;
                    }

                    public String mType() {
                        return this.mType;
                    }

                    public String mSubType() {
                        return this.mSubType;
                    }
                    {
                        this.mId = LoadReACE$.MODULE$.cc$factorie$app$nlp$load$LoadReACE$$getAttr((NodeSeq)mention$1, "id");
                        this.eId = LoadReACE$.MODULE$.cc$factorie$app$nlp$load$LoadReACE$$getAttr((NodeSeq)mention$1, "gid");
                        this.headStart = new Some((Object)BoxesRunTime.boxToInteger((int)hstart$1));
                        this.headEnd = new Some((Object)BoxesRunTime.boxToInteger((int)hend$1));
                        this.headLength = new Some((Object)BoxesRunTime.boxToInteger((int)hlength$1));
                        this.mType = nerType$1;
                        this.mSubType = nerSubType$1;
                    }
                });
            }
            {
                this.doc$2 = doc$2;
                this.coref$1 = coref$1;
            }
        });
        xmlText = XML$.MODULE$.loadFile(new StringBuilder().append((Object)xml).append((Object)".nrm.xml").toString());
        return doc;
    }

    /*
     * WARNING - void declaration
     */
    public Document fromTtt(String ttt) {
        void var3_3;
        String fileStr = (String)new StringOps(Predef$.MODULE$.augmentString(ttt)).dropRight(8);
        Document doc = this.makeDoc(fileStr);
        this.addNrm(doc, fileStr);
        return var3_3;
    }

    public Seq<Document> fromDirectory(String dir, int takeOnly) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dir).listFiles()).filter((Function1)new Serializable(){

            public final boolean apply(File x$2) {
                return x$2.getName().endsWith(".ttt.xml");
            }
        })).take(takeOnly)).map((Function1)new Serializable(){

            public final Document apply(File f) {
                return LoadReACE$.MODULE$.fromTtt(f.getAbsolutePath());
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public int fromDirectory$default$2() {
        return Integer.MAX_VALUE;
    }

    public void main(String[] args) {
        Seq<Document> docs = this.fromDirectory(args[0], this.fromDirectory$default$2());
        docs.foreach((Function1)new Serializable(){

            public final void apply(Document d) {
                ((ResizableArray)d.attr().apply(ClassTag$.MODULE$.apply(ConllNerSpanBuffer.class))).foreach((Function1)new Serializable(this){

                    public final void apply(ConllNerSpan s) {
                        Predef$.MODULE$.println((Object)s);
                    }
                });
            }
        });
    }

    private LoadReACE$() {
        MODULE$ = this;
    }
}

