/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.ner;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.ner.ChainNerOpts;
import cc.factorie.app.nlp.ner.ConllChainNer;
import cc.factorie.app.nlp.ner.ConllChainNer$;
import cc.factorie.package$;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import java.io.FileOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

public final class ConllChainNerTrainer$
implements HyperparameterMain {
    public static final ConllChainNerTrainer$ MODULE$;

    static {
        new ConllChainNerTrainer$();
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    @Override
    public double evaluateParameters(String[] args) {
        ChainNerOpts opts = new ChainNerOpts();
        Random random = new Random(0);
        opts.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        ConllChainNer ner = new ConllChainNer(ConllChainNer$.MODULE$.$lessinit$greater$default$1());
        if (opts.brownClusFile().wasInvoked()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading brown cluster file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.brownClusFile().value()})));
            Source$.MODULE$.fromFile(opts.brownClusFile().value(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(ner){
                private final ConllChainNer ner$1;

                public final void apply(String line) {
                    String[] splitLine = line.split("\t");
                    this.ner$1.clusters().update((Object)splitLine[1], (Object)splitLine[0]);
                }
                {
                    this.ner$1 = ner$1;
                }
            });
        }
        Predef$.MODULE$.assert(opts.train().wasInvoked() && opts.test().wasInvoked(), (Function0)new Serializable(){

            public final String apply() {
                return "No train/test data file provided.";
            }
        });
        double trainPortionToTake = opts.trainPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.trainPortion().value()) : 1.0;
        double testPortionToTake = opts.testPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.testPortion().value()) : 1.0;
        Seq<Document> trainDocsFull = ner.loadDocs(opts.train().value());
        Seq<Document> testDocsFull = ner.loadDocs(opts.test().value());
        Seq trainDocs = (Seq)trainDocsFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)trainDocsFull.length() * trainPortionToTake)));
        Seq testDocs = (Seq)testDocsFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)testDocsFull.length() * testPortionToTake)));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using training set: ", " ; test set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.train().value(), opts.test().value()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of training data; ", " of test data:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainPortionToTake), BoxesRunTime.boxToDouble((double)testPortionToTake)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using ", " / ", " train docs, ", " tokens"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)trainDocs.length()), BoxesRunTime.boxToInteger((int)trainDocsFull.length()), ((TraversableOnce)trainDocs.map((Function1)new Serializable(){

            public final int apply(Document x$26) {
                return x$26.tokenCount();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using ", " / ", " test docs, ", " tokens"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)testDocs.length()), BoxesRunTime.boxToInteger((int)testDocsFull.length()), ((TraversableOnce)testDocs.map((Function1)new Serializable(){

            public final int apply(Document x$27) {
                return x$27.tokenCount();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        double ret = ner.train((Seq<Document>)trainDocs, (Seq<Document>)testDocs, BoxesRunTime.unboxToDouble((Object)opts.rate().value()), BoxesRunTime.unboxToDouble((Object)opts.delta().value()), random);
        if (BoxesRunTime.unboxToBoolean((Object)opts.serialize().value())) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"serializing model to ").append((Object)opts.saveModel().value()).toString());
            ner.serialize(new FileOutputStream(opts.saveModel().value()));
        }
        if (opts.targetAccuracy().wasInvoked()) {
            package$.MODULE$.assertMinimalAccuracy(ret, new StringOps(Predef$.MODULE$.augmentString(opts.targetAccuracy().value())).toDouble());
        }
        return ret;
    }

    private ConllChainNerTrainer$() {
        MODULE$ = this;
        HyperparameterMain$class.$init$(this);
    }
}

