/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.phrase;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.load.BILOUChunkDomain$;
import cc.factorie.app.nlp.load.BILOUChunkTag;
import cc.factorie.app.nlp.load.BILOUNestedChunkDomain$;
import cc.factorie.app.nlp.load.BILOUNestedChunkTag;
import cc.factorie.app.nlp.load.BIOChunkDomain$;
import cc.factorie.app.nlp.load.BIOChunkTag;
import cc.factorie.app.nlp.load.ChunkTag;
import cc.factorie.app.nlp.load.LoadConll2000$;
import cc.factorie.app.nlp.phrase.ChainChunker;
import cc.factorie.app.nlp.phrase.ChunkerOpts;
import cc.factorie.app.nlp.pos.PennPosTag;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import cc.factorie.variable.CategoricalDomain;
import cc.factorie.variable.CategoricalLabeling;
import cc.factorie.variable.CategoricalVar;
import cc.factorie.variable.HammingObjective$;
import cc.factorie.variable.LabeledDiscreteVar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

public final class ChainChunkerTrainer$
implements HyperparameterMain {
    public static final ChainChunkerTrainer$ MODULE$;

    static {
        new ChainChunkerTrainer$();
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    public String generateErrorOutput(Sentence sentence2) {
        StringBuffer sb = new StringBuffer();
        return ((TraversableOnce)sentence2.tokens().map((Function1)new Serializable(sb){
            private final StringBuffer sb$1;

            public final StringBuffer apply(Token t) {
                return this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%s %20s %10s %10s  %s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LabeledDiscreteVar)t.attr().all(ClassTag$.MODULE$.apply(ChunkTag.class)).head()).valueIsTarget() ? " " : "*", t.string(), t.attr().apply(ClassTag$.MODULE$.apply(PennPosTag.class)), ((CategoricalLabeling)t.attr().all(ClassTag$.MODULE$.apply(ChunkTag.class)).head()).target().categoryValue(), ((CategoricalVar)t.attr().all(ClassTag$.MODULE$.apply(ChunkTag.class)).head()).categoryValue()})));
            }
            {
                this.sb$1 = sb$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double evaluateParameters(String[] args) {
        String string;
        block9: {
            void var3_3;
            block12: {
                Seq testSentences;
                Seq trainSentences;
                Seq<Document> testDocs;
                ChainChunker chunk;
                ChunkerOpts opts;
                Random random;
                block11: {
                    block10: {
                        ChainChunker chainChunker;
                        block7: {
                            block8: {
                                block6: {
                                    random = new Random(0);
                                    opts = new ChunkerOpts();
                                    opts.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
                                    Predef$.MODULE$.assert(opts.trainFile().wasInvoked());
                                    string = opts.trainingEncoding().value();
                                    if (!"BILOU".equals(string)) break block6;
                                    chainChunker = new ChainChunker((CategoricalDomain<String>)BILOUChunkDomain$.MODULE$.dimensionDomain(), new Serializable(){

                                        public final BILOUChunkTag apply(Token t) {
                                            return new BILOUChunkTag(t, "O");
                                        }
                                    }, ManifestFactory$.MODULE$.classType(BILOUChunkTag.class));
                                    break block7;
                                }
                                if (!"BIO".equals(string)) break block8;
                                chainChunker = new ChainChunker((CategoricalDomain<String>)BIOChunkDomain$.MODULE$.dimensionDomain(), new Serializable(){

                                    public final BIOChunkTag apply(Token t) {
                                        return new BIOChunkTag(t, "O");
                                    }
                                }, ManifestFactory$.MODULE$.classType(BIOChunkTag.class));
                                break block7;
                            }
                            if (!"NESTED".equals(string)) break block9;
                            chainChunker = new ChainChunker((CategoricalDomain<String>)BILOUNestedChunkDomain$.MODULE$.dimensionDomain(), new Serializable(){

                                public final BILOUNestedChunkTag apply(Token t) {
                                    return new BILOUNestedChunkTag(t, "O:O");
                                }
                            }, ManifestFactory$.MODULE$.classType(BILOUNestedChunkTag.class));
                        }
                        chunk = chainChunker;
                        Seq<Document> trainDocs = LoadConll2000$.MODULE$.fromSource((Source)Source$.MODULE$.fromFile(opts.trainFile().value(), Codec$.MODULE$.fallbackSystemCodec()), opts.inputEncoding().value());
                        testDocs = LoadConll2000$.MODULE$.fromSource((Source)Source$.MODULE$.fromFile(opts.testFile().value(), Codec$.MODULE$.fallbackSystemCodec()), opts.inputEncoding().value());
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Read %d training tokens.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)trainDocs.map((Function1)new Serializable(){

                            public final int apply(Document x$10) {
                                return x$10.tokenCount();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Read %d testing tokens.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)testDocs.map((Function1)new Serializable(){

                            public final int apply(Document x$11) {
                                return x$11.tokenCount();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
                        double trainPortionToTake = opts.trainPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.trainPortion().value()) : 1.0;
                        double testPortionToTake = opts.testPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.testPortion().value()) : 1.0;
                        Seq trainSentencesFull = (Seq)((TraversableLike)trainDocs.flatMap((Function1)new Serializable(){

                            public final Iterable<Sentence> apply(Document x$12) {
                                return x$12.sentences();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){

                            public final boolean apply(Sentence x$13) {
                                return !x$13.isEmpty();
                            }
                        });
                        trainSentences = (Seq)trainSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(trainPortionToTake * (double)trainSentencesFull.length())));
                        Seq testSentencesFull = (Seq)((TraversableLike)testDocs.flatMap((Function1)new Serializable(){

                            public final Iterable<Sentence> apply(Document x$14) {
                                return x$14.sentences();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){

                            public final boolean apply(Sentence x$15) {
                                return !x$15.isEmpty();
                            }
                        });
                        testSentences = (Seq)testSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(testPortionToTake * (double)testSentencesFull.length())));
                        String string2 = opts.trainingEncoding().value();
                        String string3 = "BILOU";
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block10;
                        String string4 = opts.inputEncoding().value();
                        String string5 = "BIO";
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                        LoadConll2000$.MODULE$.convertBIOtoBILOU((Seq<Sentence>)testSentences);
                        LoadConll2000$.MODULE$.convertBIOtoBILOU((Seq<Sentence>)trainSentences);
                        break block11;
                    }
                    if (!BoxesRunTime.equals((Object)opts.trainingEncoding().value(), (Object)opts.inputEncoding().value())) break block12;
                }
                Seq x$32 = trainSentences;
                Seq x$33 = testSentences;
                boolean x$34 = BoxesRunTime.unboxToBoolean((Object)opts.useFullFeatures().value());
                double x$35 = BoxesRunTime.unboxToDouble((Object)opts.rate().value());
                double x$36 = BoxesRunTime.unboxToDouble((Object)opts.delta().value());
                int x$37 = BoxesRunTime.unboxToInt((Object)opts.cutoff().value());
                boolean x$38 = BoxesRunTime.unboxToBoolean((Object)opts.updateExamples().value());
                boolean x$39 = BoxesRunTime.unboxToBoolean((Object)opts.useHingeLoss().value());
                double x$40 = BoxesRunTime.unboxToDouble((Object)opts.l1().value());
                double x$41 = BoxesRunTime.unboxToDouble((Object)opts.l2().value());
                int x$42 = chunk.train$default$9();
                chunk.train((Seq<Sentence>)x$32, (Seq<Sentence>)x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$42, x$40, x$41, random);
                if (BoxesRunTime.unboxToBoolean((Object)opts.saveModel().value())) {
                    chunk.serialize(new FileOutputStream(new File(opts.modelFile().value())));
                    Predef$.MODULE$.println((Object)"Model Serialized");
                }
                double acc = HammingObjective$.MODULE$.accuracy((Iterable)testDocs.flatMap((Function1)new Serializable(){

                    public final Iterable<ChunkTag> apply(Document d) {
                        return (Iterable)d.sentences().flatMap((Function1)new Serializable(this){

                            public final IndexedSeq<ChunkTag> apply(Sentence s) {
                                return (IndexedSeq)s.tokens().map((Function1)new Serializable(this){

                                    public final ChunkTag apply(Token x$16) {
                                        return (ChunkTag)x$16.attr().all(ClassTag$.MODULE$.apply(ChunkTag.class)).head();
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                if (opts.targetAccuracy().wasInvoked()) {
                    Predef$.MODULE$.assert(acc > new StringOps(Predef$.MODULE$.augmentString(opts.targetAccuracy().value())).toDouble(), (Function0)new Serializable(){

                        public final String apply() {
                            return "Did not reach accuracy requirement";
                        }
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)opts.errorOutput().value())) {
                    PrintWriter writer = new PrintWriter(new File("ChainChunkingOutput.txt"));
                    testSentences.foreach((Function1)new Serializable(writer){
                        private final PrintWriter writer$1;

                        public final void apply(Sentence s) {
                            this.writer$1.write(ChainChunkerTrainer$.MODULE$.generateErrorOutput(s));
                            this.writer$1.write("");
                        }
                        {
                            this.writer$1 = writer$1;
                        }
                    });
                    writer.close();
                }
                return acc;
            }
            throw new Exception(new StringBuilder().append((Object)"Specified Training Encoding: ").append((Object)var3_3.trainingEncoding().value()).append((Object)" does not match Document Encoding: ").append((Object)var3_3.inputEncoding().value()).toString());
        }
        throw new MatchError((Object)string);
    }

    private ChainChunkerTrainer$() {
        MODULE$ = this;
        HyperparameterMain$class.$init$(this);
    }
}

