/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.phrase;

import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.phrase.NounPhraseType;
import cc.factorie.app.nlp.phrase.Phrase;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;

public final class DeterministicNounPhraseTypeLabeler$ {
    public static final DeterministicNounPhraseTypeLabeler$ MODULE$;
    private final Seq<String> PERSONAL_PRONOUNS;
    private final Seq<String> COMMON_NOUNS;
    private final Seq<String> PROPER_NOUNS;
    private final Seq<String> ALL_NOUNS;

    static {
        new DeterministicNounPhraseTypeLabeler$();
    }

    private final Seq<String> PERSONAL_PRONOUNS() {
        return this.PERSONAL_PRONOUNS;
    }

    private final Seq<String> COMMON_NOUNS() {
        return this.COMMON_NOUNS;
    }

    private final Seq<String> PROPER_NOUNS() {
        return this.PROPER_NOUNS;
    }

    private final Seq<String> ALL_NOUNS() {
        return this.ALL_NOUNS;
    }

    private boolean isPersonalPronoun(Token t) {
        return this.PERSONAL_PRONOUNS().contains((Object)((String)t.posTag().categoryValue()).toUpperCase());
    }

    private boolean isCommonNoun(Token t) {
        return this.COMMON_NOUNS().contains((Object)((String)t.posTag().categoryValue()).toUpperCase());
    }

    private boolean isProperNoun(Token t) {
        return this.PROPER_NOUNS().contains((Object)((String)t.posTag().categoryValue()).toUpperCase());
    }

    private boolean isNoun(Token t) {
        return this.ALL_NOUNS().contains((Object)((String)t.posTag().categoryValue()).toUpperCase());
    }

    public void process(Phrase phrase) {
        if (phrase.attr().apply(ClassTag$.MODULE$.apply(NounPhraseType.class)) != null) {
            return;
        }
        String nounType = this.isPersonalPronoun(phrase.headToken()) ? "PRO" : (this.isCommonNoun(phrase.headToken()) ? "NOM" : (this.isProperNoun(phrase.headToken()) ? "NAM" : "NOM"));
        phrase.attr().$plus$eq(new NounPhraseType(phrase, nounType));
    }

    private DeterministicNounPhraseTypeLabeler$() {
        MODULE$ = this;
        this.PERSONAL_PRONOUNS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRP", "PRP$"}));
        this.COMMON_NOUNS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NN", "NNS"}));
        this.PROPER_NOUNS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NNP", "NNPS"}));
        this.ALL_NOUNS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NN", "NNS", "NNP", "NNPS", "PRP", "PRP$"}));
    }
}

