/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.pos;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.load.LoadOWPL$;
import cc.factorie.app.nlp.load.LoadOntonotes5$;
import cc.factorie.app.nlp.pos.ForwardPosOptions;
import cc.factorie.app.nlp.pos.ForwardPosTagger;
import cc.factorie.app.nlp.pos.package$;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.FileUtils$;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import cc.factorie.variable.MutableCategoricalVar;
import java.io.File;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

public final class ForwardPosTrainer$
implements HyperparameterMain {
    public static final ForwardPosTrainer$ MODULE$;

    static {
        new ForwardPosTrainer$();
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    @Override
    public double evaluateParameters(String[] args) {
        Random random = new Random(0);
        ForwardPosOptions opts = new ForwardPosOptions();
        opts.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        Predef$.MODULE$.assert(opts.trainFile().wasInvoked() || opts.trainDir().wasInvoked() || opts.trainFiles().wasInvoked());
        ForwardPosTagger pos = new ForwardPosTagger();
        Predef$.MODULE$.assert(!opts.trainDir().wasInvoked() || !opts.trainFiles().wasInvoked());
        WrappedArray trainFileList = (WrappedArray)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{opts.trainFile().value()}));
        if (opts.trainDir().wasInvoked()) {
            trainFileList = FileUtils$.MODULE$.getFileListFromDir(opts.trainDir().value(), FileUtils$.MODULE$.getFileListFromDir$default$2());
        } else if (opts.trainFiles().wasInvoked()) {
            trainFileList = Predef$.MODULE$.wrapRefArray((Object[])opts.trainFiles().value().split(","));
        }
        Predef$.MODULE$.assert(!opts.testDir().wasInvoked() || !opts.testFiles().wasInvoked());
        WrappedArray testFileList = (WrappedArray)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{opts.testFile().value()}));
        if (opts.testDir().wasInvoked()) {
            testFileList = FileUtils$.MODULE$.getFileListFromDir(opts.testDir().value(), FileUtils$.MODULE$.getFileListFromDir$default$2());
        } else if (opts.testFiles().wasInvoked()) {
            testFileList = Predef$.MODULE$.wrapRefArray((Object[])opts.testFiles().value().split(","));
        }
        Seq trainDocs = (Seq)trainFileList.map((Function1)new Serializable(opts){
            private final ForwardPosOptions opts$2;

            public final Document apply(String fname) {
                return BoxesRunTime.unboxToBoolean((Object)this.opts$2.owpl().value()) ? (Document)LoadOWPL$.MODULE$.fromFilename(fname, (Function2<Token, Seq<String>, Seq<MutableCategoricalVar<String>>>)new Serializable(this){

                    public final Seq<MutableCategoricalVar<String>> apply(Token tok, Seq<String> labels2) {
                        return package$.MODULE$.pennPosLabelMaker(tok, labels2);
                    }
                }, LoadOWPL$.MODULE$.fromFilename$default$3(), LoadOWPL$.MODULE$.fromFilename$default$4()).head() : (Document)LoadOntonotes5$.MODULE$.fromFilename(fname, LoadOntonotes5$.MODULE$.fromFilename$default$2(), LoadOntonotes5$.MODULE$.fromFilename$default$3(), LoadOntonotes5$.MODULE$.fromFilename$default$4(), LoadOntonotes5$.MODULE$.fromFilename$default$5(), LoadOntonotes5$.MODULE$.fromFilename$default$6()).head();
            }
            {
                this.opts$2 = opts$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq testDocs = (Seq)testFileList.map((Function1)new Serializable(opts){
            private final ForwardPosOptions opts$2;

            public final Document apply(String fname) {
                return BoxesRunTime.unboxToBoolean((Object)this.opts$2.owpl().value()) ? (Document)LoadOWPL$.MODULE$.fromFilename(fname, (Function2<Token, Seq<String>, Seq<MutableCategoricalVar<String>>>)new Serializable(this){

                    public final Seq<MutableCategoricalVar<String>> apply(Token tok, Seq<String> labels2) {
                        return package$.MODULE$.pennPosLabelMaker(tok, labels2);
                    }
                }, LoadOWPL$.MODULE$.fromFilename$default$3(), LoadOWPL$.MODULE$.fromFilename$default$4()).head() : (Document)LoadOntonotes5$.MODULE$.fromFilename(fname, LoadOntonotes5$.MODULE$.fromFilename$default$2(), LoadOntonotes5$.MODULE$.fromFilename$default$3(), LoadOntonotes5$.MODULE$.fromFilename$default$4(), LoadOntonotes5$.MODULE$.fromFilename$default$5(), LoadOntonotes5$.MODULE$.fromFilename$default$6()).head();
            }
            {
                this.opts$2 = opts$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Read %d training tokens from %d files.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)trainDocs.map((Function1)new Serializable(){

            public final int apply(Document x$14) {
                return x$14.tokenCount();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), BoxesRunTime.boxToInteger((int)trainDocs.size())})));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Read %d testing tokens from %d files.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)testDocs.map((Function1)new Serializable(){

            public final int apply(Document x$15) {
                return x$15.tokenCount();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), BoxesRunTime.boxToInteger((int)testDocs.size())})));
        double trainPortionToTake = opts.trainPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.trainPortion().value()) : 1.0;
        double testPortionToTake = opts.testPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.testPortion().value()) : 1.0;
        Seq trainSentencesFull = (Seq)trainDocs.flatMap((Function1)new Serializable(){

            public final Iterable<Sentence> apply(Document x$16) {
                return x$16.sentences();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq trainSentences = (Seq)trainSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(trainPortionToTake * (double)trainSentencesFull.length())));
        Seq testSentencesFull = (Seq)testDocs.flatMap((Function1)new Serializable(){

            public final Iterable<Sentence> apply(Document x$17) {
                return x$17.sentences();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq testSentences = (Seq)testSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(testPortionToTake * (double)testSentencesFull.length())));
        pos.train((Seq<Sentence>)trainSentences, (Seq<Sentence>)testSentences, BoxesRunTime.unboxToDouble((Object)opts.rate().value()), BoxesRunTime.unboxToDouble((Object)opts.delta().value()), BoxesRunTime.unboxToInt((Object)opts.cutoff().value()), BoxesRunTime.unboxToBoolean((Object)opts.updateExamples().value()), BoxesRunTime.unboxToBoolean((Object)opts.useHingeLoss().value()), BoxesRunTime.unboxToInt((Object)opts.numIters().value()), BoxesRunTime.unboxToDouble((Object)opts.l1().value()), BoxesRunTime.unboxToDouble((Object)opts.l2().value()), random);
        if (BoxesRunTime.unboxToBoolean((Object)opts.saveModel().value())) {
            pos.serialize(opts.modelFile().value());
            ForwardPosTagger pos2 = new ForwardPosTagger();
            pos2.deserialize(new File(opts.modelFile().value()));
            pos.printAccuracy((Iterable<Sentence>)((Iterable)testDocs.flatMap((Function1)new Serializable(){

                public final Iterable<Sentence> apply(Document x$18) {
                    return x$18.sentences();
                }
            }, Seq$.MODULE$.canBuildFrom())), "pre-serialize accuracy: ");
            pos2.printAccuracy((Iterable<Sentence>)((Iterable)testDocs.flatMap((Function1)new Serializable(){

                public final Iterable<Sentence> apply(Document x$19) {
                    return x$19.sentences();
                }
            }, Seq$.MODULE$.canBuildFrom())), "post-serialize accuracy: ");
        }
        double acc = BoxesRunTime.unboxToDouble((Object)pos.accuracy((Iterable<Sentence>)((Iterable)testDocs.flatMap((Function1)new Serializable(){

            public final Iterable<Sentence> apply(Document x$20) {
                return x$20.sentences();
            }
        }, Seq$.MODULE$.canBuildFrom())))._1());
        if (opts.targetAccuracy().wasInvoked()) {
            cc.factorie.package$.MODULE$.assertMinimalAccuracy(acc, new StringOps(Predef$.MODULE$.augmentString(opts.targetAccuracy().value())).toDouble());
        }
        return acc;
    }

    private ForwardPosTrainer$() {
        MODULE$ = this;
        HyperparameterMain$class.$init$(this);
    }
}

