/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.pos;

import cc.factorie.app.chain.Observations$;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.pos.ChainPosTagger;
import cc.factorie.app.nlp.pos.PennPosTag;
import cc.factorie.app.strings.package$;
import java.net.URL;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u001b\t9rJ\u001c;p]>$Xm]\"iC&t\u0007k\\:UC\u001e<WM\u001d\u0006\u0003\u0007\u0011\t1\u0001]8t\u0015\t)a!A\u0002oYBT!a\u0002\u0005\u0002\u0007\u0005\u0004\bO\u0003\u0002\n\u0015\u0005Aa-Y2u_JLWMC\u0001\f\u0003\t\u00197m\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\t!!\u0003\u0002\u0012\u0005\tq1\t[1j]B{7\u000fV1hO\u0016\u0014\bCA\b\u0014\u0013\t!\"A\u0001\u0006QK:t\u0007k\\:UC\u001eDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtD#\u0001\r\u0011\u0005=\u0001\u0001\"\u0002\f\u0001\t\u0003QBC\u0001\r\u001c\u0011\u0015a\u0012\u00041\u0001\u001e\u0003\r)(\u000f\u001c\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\n1A\\3u\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\u0007U\u0013F\nC\u0003'\u0001\u0011\u0005q%A\bj]&$\bkT*GK\u0006$XO]3t)\tAc\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0003V]&$\b\"B\u0018&\u0001\u0004\u0001\u0014\u0001C:f]R,gnY3\u0011\u0005E\u0012T\"\u0001\u0003\n\u0005M\"!\u0001C*f]R,gnY3\b\u000bU\u0012\u0001\u0012\u0001\u001c\u0002/=sGo\u001c8pi\u0016\u001c8\t[1j]B{7\u000fV1hO\u0016\u0014\bCA\b8\r\u0015\t!\u0001#\u00019'\t9\u0004\u0004C\u0003\u0017o\u0011\u0005!\bF\u00017\u0001")
public class OntonotesChainPosTagger
extends ChainPosTagger<PennPosTag> {
    @Override
    public void initPOSFeatures(Sentence sentence2) {
        sentence2.tokens().foreach((Function1)new Serializable(this){
            private final /* synthetic */ OntonotesChainPosTagger $outer;

            public final void apply(Token token) {
                if (token.attr().apply(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class)) != null) {
                    token.attr().remove(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class));
                }
                ChainPosTagger.PosFeatures features2 = token.attr().$plus$eq(new ChainPosTagger.PosFeatures(this.$outer, token));
                String rawWord = token.string();
                String word = package$.MODULE$.simplifyDigits(rawWord).toLowerCase();
                features2.$plus$eq(new StringBuilder().append((Object)"W=").append((Object)word).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"STEM=").append((Object)package$.MODULE$.porterStem(word)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"SHAPE2=").append((Object)package$.MODULE$.stringShape(rawWord, 2)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"SHAPE3=").append((Object)package$.MODULE$.stringShape(rawWord, 3)).toString());
                int i = 3;
                features2.$plus$eq(new StringBuilder().append((Object)"SUFFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).takeRight(i)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"PREFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).take(i)).toString());
                if (token.isCapitalized()) {
                    features2.$plus$eq("CAPITALIZED");
                }
                if (token.string().matches("[A-Z]")) {
                    features2.$plus$eq("CONTAINS_CAPITAL");
                }
                if (token.string().matches("-")) {
                    features2.$plus$eq("CONTAINS_DASH");
                }
                if (token.containsDigit()) {
                    features2.$plus$eq("NUMERIC");
                }
                if (token.isPunctuation()) {
                    features2.$plus$eq("PUNCTUATION");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Observations$.MODULE$.addNeighboringFeatureConjunctions(sentence2.tokens(), new Serializable(this){

            public final ChainPosTagger.PosFeatures apply(Token t) {
                return (ChainPosTagger.PosFeatures)t.attr().apply(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class));
            }
        }, "W=[^@]*$", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2, -1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0}))}));
    }

    public OntonotesChainPosTagger() {
        super(new Serializable(){

            public final PennPosTag apply(Token t) {
                return new PennPosTag(t, 0);
            }
        }, ClassTag$.MODULE$.apply(PennPosTag.class));
    }

    public OntonotesChainPosTagger(URL url) {
        this();
        this.deserialize(url.openConnection().getInputStream());
    }
}

