/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.topics.lda;

import cc.factorie.app.strings.RegexSegmenter;
import cc.factorie.app.topics.lda.Doc;
import cc.factorie.app.topics.lda.Document;
import cc.factorie.app.topics.lda.Document$;
import cc.factorie.app.topics.lda.SparseOnlineLDA;
import cc.factorie.app.topics.lda.SparseOnlineLDA$WordSeqDomain$;
import cc.factorie.app.topics.lda.SparseOnlineLDA$opts$2$;
import cc.factorie.package$;
import cc.factorie.variable.CategoricalDomain;
import cc.factorie.variable.CategoricalSeqVariable;
import cc.factorie.variable.DiscreteDomain;
import java.io.File;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.VolatileObjectRef;
import scala.util.Random;
import scala.util.matching.Regex;

public final class SparseOnlineLDA$ {
    public static final SparseOnlineLDA$ MODULE$;
    private final ArrayBuffer<Doc> docBuffer;
    private final int minDocLength;
    private int numDocs;
    private final Regex tokenRegex;
    private final RegexSegmenter mySegmenter;

    static {
        new SparseOnlineLDA$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SparseOnlineLDA$opts$2$ opts$1$lzycompute(VolatileObjectRef x$1) {
        SparseOnlineLDA$ sparseOnlineLDA$ = this;
        synchronized (sparseOnlineLDA$) {
            if (x$1.elem != null) return (SparseOnlineLDA$opts$2$)x$1.elem;
            x$1.elem = new SparseOnlineLDA$opts$2$();
            return (SparseOnlineLDA$opts$2$)x$1.elem;
        }
    }

    public ArrayBuffer<Doc> docBuffer() {
        return this.docBuffer;
    }

    public int minDocLength() {
        return this.minDocLength;
    }

    public int numDocs() {
        return this.numDocs;
    }

    public void numDocs_$eq(int x$1) {
        this.numDocs = x$1;
    }

    public Regex tokenRegex() {
        return this.tokenRegex;
    }

    public RegexSegmenter mySegmenter() {
        return this.mySegmenter;
    }

    public Stream<CategoricalSeqVariable<String>> nextDocument() {
        return Stream.cons$.MODULE$.apply(this.getRandomDocument(), (Function0)new Serializable(){

            public final Stream<CategoricalSeqVariable<String>> apply() {
                return SparseOnlineLDA$.MODULE$.nextDocument();
            }
        });
    }

    public Stream<CategoricalSeqVariable<String>> initializeDocuments(String fileName) {
        BufferedSource source = Source$.MODULE$.fromFile(new File(fileName), Codec$.MODULE$.fallbackSystemCodec());
        IntRef count = IntRef.create((int)0);
        source.getLines().foreach((Function1)new Serializable(fileName, count){
            private final String fileName$1;
            private final IntRef count$1;

            public final void apply(String line) {
                String text = line;
                Document doc = Document$.MODULE$.fromString(SparseOnlineLDA$WordSeqDomain$.MODULE$, new StringBuilder().append((Object)this.fileName$1).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.count$1.elem)).toString(), text, SparseOnlineLDA$.MODULE$.mySegmenter(), Document$.MODULE$.fromString$default$5(), Document$.MODULE$.fromString$default$6());
                Object object = doc.length() >= SparseOnlineLDA$.MODULE$.minDocLength() ? SparseOnlineLDA$.MODULE$.docBuffer().$plus$eq((Object)doc) : BoxedUnit.UNIT;
                ++this.count$1.elem;
                if (this.count$1.elem % 1000 == 0) {
                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.count$1.elem)).toString());
                    Console$.MODULE$.flush();
                }
                if (this.count$1.elem % 10000 == 0) {
                    Predef$.MODULE$.println();
                }
            }
            {
                this.fileName$1 = fileName$1;
                this.count$1 = count$1;
            }
        });
        source.close();
        this.numDocs_$eq(this.docBuffer().length());
        return this.nextDocument();
    }

    public CategoricalSeqVariable<String> getRandomDocument() {
        int docIndex = package$.MODULE$.random().nextInt(this.numDocs());
        return ((Doc)this.docBuffer().apply(docIndex)).ws();
    }

    public void main(String[] args) {
        VolatileObjectRef opts$module = VolatileObjectRef.zero();
        this.opts$1(opts$module).parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        int numTopics = BoxesRunTime.unboxToInt((Object)this.opts$1(opts$module).numTopics().value());
        double alpha = BoxesRunTime.unboxToDouble((Object)this.opts$1(opts$module).alpha().value());
        double beta = BoxesRunTime.unboxToDouble((Object)this.opts$1(opts$module).beta().value());
        int batchSize = BoxesRunTime.unboxToInt((Object)this.opts$1(opts$module).batchSize().value());
        int numSamples = BoxesRunTime.unboxToInt((Object)this.opts$1(opts$module).numSamples().value());
        int burninSamples = BoxesRunTime.unboxToInt((Object)this.opts$1(opts$module).burninSamples().value());
        double learningRate = BoxesRunTime.unboxToDouble((Object)this.opts$1(opts$module).initLearningRate().value());
        double kappa = BoxesRunTime.unboxToDouble((Object)this.opts$1(opts$module).kappa().value());
        Random random = new Random(1);
        Stream<CategoricalSeqVariable<String>> docs = this.initializeDocuments(this.opts$1(opts$module).readLines().value());
        DiscreteDomain wordDomain = SparseOnlineLDA$WordSeqDomain$.MODULE$.elementDomain();
        SparseOnlineLDA lda = new SparseOnlineLDA((CategoricalDomain<String>)wordDomain, this.numDocs(), numTopics, alpha, beta, batchSize, numSamples, burninSamples, learningRate, kappa, BoxesRunTime.unboxToInt((Object)this.opts$1(opts$module).numBatches().value()), this.$lessinit$greater$default$12(), this.$lessinit$greater$default$13(), random);
        lda.train(docs);
    }

    public int $lessinit$greater$default$3() {
        return 10;
    }

    public double $lessinit$greater$default$4() {
        return 0.1;
    }

    public double $lessinit$greater$default$5() {
        return 0.1;
    }

    public int $lessinit$greater$default$6() {
        return 100;
    }

    public int $lessinit$greater$default$7() {
        return 5;
    }

    public int $lessinit$greater$default$8() {
        return 2;
    }

    public double $lessinit$greater$default$9() {
        return 100.0;
    }

    public double $lessinit$greater$default$10() {
        return 0.6;
    }

    public int $lessinit$greater$default$11() {
        return 2000;
    }

    public int $lessinit$greater$default$12() {
        return 10;
    }

    public String $lessinit$greater$default$13() {
        return "lda.topics";
    }

    private final SparseOnlineLDA$opts$2$ opts$1(VolatileObjectRef opts$module$1) {
        return opts$module$1.elem == null ? this.opts$1$lzycompute(opts$module$1) : (SparseOnlineLDA$opts$2$)opts$module$1.elem;
    }

    private SparseOnlineLDA$() {
        MODULE$ = this;
        this.docBuffer = new ArrayBuffer();
        this.minDocLength = 3;
        this.numDocs = 0;
        this.tokenRegex = new Regex("\\p{Alpha}+", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.mySegmenter = new RegexSegmenter(this.tokenRegex());
    }
}

