/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.util;

import cc.factorie.la.ArraySparseBinaryTensor;
import cc.factorie.la.ArraySparseIndexedTensor;
import cc.factorie.la.DenseTensor;
import cc.factorie.la.DenseTensor1;
import cc.factorie.la.DenseTensor2;
import cc.factorie.la.DenseTensor3;
import cc.factorie.la.SparseBinaryTensor;
import cc.factorie.la.SparseBinaryTensor1;
import cc.factorie.la.SparseBinaryTensor2;
import cc.factorie.la.SparseBinaryTensor3;
import cc.factorie.la.SparseIndexedTensor;
import cc.factorie.la.SparseIndexedTensor1;
import cc.factorie.la.SparseIndexedTensor2;
import cc.factorie.la.SparseIndexedTensor3;
import cc.factorie.la.Tensor;
import cc.factorie.package$;
import cc.factorie.package$AnyExtras$;
import cc.factorie.util.Cubbie;
import cc.factorie.util.GlobalLogging;
import cc.factorie.util.GlobalLogging$class;
import cc.factorie.util.Logger;
import cc.factorie.util.Logger$;
import cc.factorie.util.Logging$class;
import cc.factorie.util.StoreFetchCubbie;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class BinarySerializer$
implements GlobalLogging {
    public static final BinarySerializer$ MODULE$;
    private final String currentVersion;
    private final byte cc$factorie$util$BinarySerializer$$INT;
    private final byte DOUBLE;
    private final byte BOOLEAN;
    private final byte STRING;
    private final byte TENSOR;
    private final byte MAP;
    private final byte LIST;
    private final byte NULL;
    private final byte SPARSE_INDEXED_TENSOR;
    private final byte SPARSE_BINARY_TENSOR;
    private final byte DENSE_TENSOR;

    static {
        new BinarySerializer$();
    }

    @Override
    public Logger logger() {
        return GlobalLogging$class.logger(this);
    }

    private Seq<Cubbie> getLazyCubbieSeq(Seq<Function0<Cubbie>> vals) {
        return (Seq)vals.view().map((Function1)new Serializable(){

            public final Cubbie apply(Function0<Cubbie> x$1) {
                return (Cubbie)x$1.apply();
            }
        }, SeqView$.MODULE$.canBuildFrom());
    }

    public void serialize(Function0<Cubbie> c1, File file, boolean gzip) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1})))), file, gzip);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, File file, boolean gzip) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2})))), file, gzip);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, File file, boolean gzip) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3})))), file, gzip);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, Function0<Cubbie> c4, File file, boolean gzip) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3, c4})))), file, gzip);
    }

    public void deserialize(Function0<Cubbie> c1, File file, boolean gzip) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1})))), file, gzip);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, File file, boolean gzip) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2})))), file, gzip);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, File file, boolean gzip) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3})))), file, gzip);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, Function0<Cubbie> c4, File file, boolean gzip) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3, c4})))), file, gzip);
    }

    public void serialize(Function0<Cubbie> c1, String filename) {
        this.serialize(c1, new File(filename));
    }

    public void serialize(Function0<Cubbie> c1, File file) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1})))), file, false);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, File file) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2})))), file, false);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, File file) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3})))), file, false);
    }

    public void serialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, Function0<Cubbie> c4, File file) {
        this.serialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3, c4})))), file, false);
    }

    public void deserialize(Function0<Cubbie> c1, String filename) {
        this.deserialize(c1, new File(filename));
    }

    public void deserialize(Function0<Cubbie> c1, File file) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1})))), file, false);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, File file) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2})))), file, false);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, File file) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3})))), file, false);
    }

    public void deserialize(Function0<Cubbie> c1, Function0<Cubbie> c2, Function0<Cubbie> c3, Function0<Cubbie> c4, File file) {
        this.deserialize(this.getLazyCubbieSeq((Seq<Function0<Cubbie>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{c1, c2, c3, c4})))), file, false);
    }

    public <T> T deserialize(String filename, StoreFetchCubbie<T> cc) {
        this.deserialize((Function0<Cubbie>)new Serializable(cc){
            private final StoreFetchCubbie cc$3;

            public final StoreFetchCubbie<T> apply() {
                return this.cc$3;
            }
            {
                this.cc$3 = cc$3;
            }
        }, filename);
        return cc.fetch();
    }

    public <T> T deserialize(File file, StoreFetchCubbie<T> cc) {
        this.deserialize((Function0<Cubbie>)new Serializable(cc){
            private final StoreFetchCubbie cc$2;

            public final StoreFetchCubbie<T> apply() {
                return this.cc$2;
            }
            {
                this.cc$2 = cc$2;
            }
        }, file);
        return cc.fetch();
    }

    public <T> T deserialize(File file, boolean gzip, StoreFetchCubbie<T> cc) {
        this.deserialize((Function0<Cubbie>)new Serializable(cc){
            private final StoreFetchCubbie cc$1;

            public final StoreFetchCubbie<T> apply() {
                return this.cc$1;
            }
            {
                this.cc$1 = cc$1;
            }
        }, file, gzip);
        return cc.fetch();
    }

    public void serialize(Seq<Cubbie> cs, File file, boolean gzip) {
        DataOutputStream stream = this.writeFile(file, gzip);
        cs.foreach((Function1)new Serializable(stream){
            private final DataOutputStream stream$1;

            public final void apply(Cubbie c) {
                BinarySerializer$.MODULE$.serialize(c, this.stream$1);
            }
            {
                this.stream$1 = stream$1;
            }
        });
        stream.close();
    }

    public void deserialize(Seq<Cubbie> cs, File file, boolean gzip) {
        DataInputStream stream = this.readFile(file, gzip);
        cs.foreach((Function1)new Serializable(stream){
            private final DataInputStream stream$2;

            public final void apply(Cubbie c) {
                if (BinarySerializer$.MODULE$.logger().level() == Logger$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Before deserializing cubbie ").append((Object)c.getClass().getName()).toString());
                    System.gc();
                    Runtime runtime = Runtime.getRuntime();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Used memory: ").append((Object)BoxesRunTime.boxToDouble((double)((double)(runtime.totalMemory() - runtime.freeMemory()) / 1.0747904E9))).append((Object)" GB").toString());
                }
                BinarySerializer$.MODULE$.deserialize(c, this.stream$2);
            }
            {
                this.stream$2 = stream$2;
            }
        });
        stream.close();
        if (this.logger().level() == Logger$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)"After deserialization.");
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Used memory: ").append((Object)BoxesRunTime.boxToDouble((double)((double)(runtime.totalMemory() - runtime.freeMemory()) / 1.0747904E9))).append((Object)" GB").toString());
        }
    }

    public DataOutputStream writeFile(File file, boolean gzip) {
        file.createNewFile();
        BufferedOutputStream fileStream = new BufferedOutputStream(new FileOutputStream(file));
        return new DataOutputStream(gzip ? new BufferedOutputStream(new GZIPOutputStream(fileStream)) : fileStream);
    }

    public boolean writeFile$default$2() {
        return false;
    }

    public DataInputStream readFile(File file, boolean gzip) {
        BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));
        return new DataInputStream(gzip ? new BufferedInputStream(new GZIPInputStream(fileStream)) : fileStream);
    }

    public boolean readFile$default$2() {
        return false;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public void serialize(Cubbie c, DataOutputStream s) {
        this.cc$factorie$util$BinarySerializer$$serialize((Option<String>)new Some((Object)"version"), this.currentVersion(), s);
        this.cc$factorie$util$BinarySerializer$$serialize((Option<String>)new Some((Object)"cubbieVersion"), c.version(), s);
        this.cc$factorie$util$BinarySerializer$$serialize((Option<String>)new Some((Object)"cubbieName"), c.cubbieName(), s);
        c._map().toSeq().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(s){
            private final DataOutputStream s$1;

            public final void apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$serialize((Option<String>)new Some((Object)k), v, this.s$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public void deserialize(Cubbie c, DataInputStream s) {
        this.assertSame$1("version", this.readField$1("version", s), this.currentVersion());
        this.assertSame$1("cubbieVersion", this.readField$1("cubbieVersion", s), c.version());
        this.assertSame$1("cubbieName", this.readField$1("cubbieName", s), c.cubbieName());
        c._map().toSeq().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(c, s){
            private final Cubbie c$1;
            private final DataInputStream s$2;

            public final void apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    String key = BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$readString(this.s$2);
                    String string = k;
                    String string2 = key;
                    Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(this, k, key){
                        private final String k$1;
                        private final String key$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cubbie keys don't match with serialized data! (got \"%s\", expected \"%s\")")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.k$1}));
                        }
                        {
                            this.k$1 = k$1;
                            this.key$1 = key$1;
                        }
                    });
                    this.c$1._map().update((Object)key, BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$deserializeInner(v, this.s$2.readByte(), this.s$2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.c$1 = c$1;
                this.s$2 = s$2;
            }
        });
    }

    public boolean deserialize$default$3() {
        return false;
    }

    public byte cc$factorie$util$BinarySerializer$$INT() {
        return this.cc$factorie$util$BinarySerializer$$INT;
    }

    private byte DOUBLE() {
        return this.DOUBLE;
    }

    private byte BOOLEAN() {
        return this.BOOLEAN;
    }

    private byte STRING() {
        return this.STRING;
    }

    private byte TENSOR() {
        return this.TENSOR;
    }

    private byte MAP() {
        return this.MAP;
    }

    private byte LIST() {
        return this.LIST;
    }

    private byte NULL() {
        return this.NULL;
    }

    private byte SPARSE_INDEXED_TENSOR() {
        return this.SPARSE_INDEXED_TENSOR;
    }

    private byte SPARSE_BINARY_TENSOR() {
        return this.SPARSE_BINARY_TENSOR;
    }

    private byte DENSE_TENSOR() {
        return this.DENSE_TENSOR;
    }

    public Object cc$factorie$util$BinarySerializer$$deserializeInner(Object preexisting, byte tag2, DataInputStream s) {
        byte by;
        block27: {
            Object object;
            block3: {
                block26: {
                    block25: {
                        block24: {
                            block7: {
                                Tuple2 tuple2;
                                block19: {
                                    Tensor tensor;
                                    block23: {
                                        Tensor newBlank;
                                        block21: {
                                            Object object2;
                                            block22: {
                                                int activeDomainSize2;
                                                block20: {
                                                    Tensor tensor2;
                                                    block9: {
                                                        Tensor tensor3;
                                                        block11: {
                                                            int[] dims;
                                                            block18: {
                                                                block17: {
                                                                    block16: {
                                                                        block15: {
                                                                            block14: {
                                                                                block13: {
                                                                                    block12: {
                                                                                        block10: {
                                                                                            int order;
                                                                                            block8: {
                                                                                                block6: {
                                                                                                    block5: {
                                                                                                        block4: {
                                                                                                            block2: {
                                                                                                                by = tag2;
                                                                                                                if (this.DOUBLE() != by) break block2;
                                                                                                                object = BoxesRunTime.boxToDouble((double)s.readDouble());
                                                                                                                break block3;
                                                                                                            }
                                                                                                            if (this.cc$factorie$util$BinarySerializer$$INT() != by) break block4;
                                                                                                            object = BoxesRunTime.boxToInteger((int)s.readInt());
                                                                                                            break block3;
                                                                                                        }
                                                                                                        if (this.BOOLEAN() != by) break block5;
                                                                                                        object = BoxesRunTime.boxToBoolean((s.readShort() != 0 ? 1 : 0) != 0);
                                                                                                        break block3;
                                                                                                    }
                                                                                                    if (this.STRING() != by) break block6;
                                                                                                    object = this.cc$factorie$util$BinarySerializer$$readString(s);
                                                                                                    break block3;
                                                                                                }
                                                                                                boolean bl = this.SPARSE_INDEXED_TENSOR() == by ? true : (this.SPARSE_BINARY_TENSOR() == by ? true : this.DENSE_TENSOR() == by);
                                                                                                if (!bl) break block7;
                                                                                                activeDomainSize2 = s.readInt();
                                                                                                dims = this.readIntArray(s);
                                                                                                order = dims.length;
                                                                                                Option preexistingTensor = package$AnyExtras$.MODULE$.toNotNull$extension(package$.MODULE$.AnyExtras(preexisting)).flatMap((Function1)new Serializable(){

                                                                                                    public final Option<Tensor> apply(Object x$4) {
                                                                                                        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                                                                                                        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(BinarySerializer$.MODULE$.getClass().getClassLoader());
                                                                                                        return package$AnyExtras$.MODULE$.cast$extension(package$.MODULE$.AnyExtras(x$4), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                                                                                                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                                                                                                Universe $u = $m$untyped.universe();
                                                                                                                Mirror<U> $m = $m$untyped;
                                                                                                                return $m.staticClass("cc.factorie.la.Tensor").asType().toTypeConstructor();
                                                                                                            }
                                                                                                        }), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
                                                                                                    }
                                                                                                });
                                                                                                if (!preexistingTensor.exists((Function1)new Serializable(dims){
                                                                                                    private final int[] dims$1;

                                                                                                    public final boolean apply(Tensor x$5) {
                                                                                                        return Predef$.MODULE$.intArrayOps(x$5.dimensions()).sameElements((GenIterable)Predef$.MODULE$.wrapIntArray(this.dims$1));
                                                                                                    }
                                                                                                    {
                                                                                                        this.dims$1 = dims$1;
                                                                                                    }
                                                                                                })) break block8;
                                                                                                tensor2 = (Tensor)preexistingTensor.get();
                                                                                                break block9;
                                                                                            }
                                                                                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)tag2), (Object)BoxesRunTime.boxToInteger((int)order));
                                                                                            if (tuple2 == null) break block10;
                                                                                            byte by2 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                                            int n = tuple2._2$mcI$sp();
                                                                                            if (this.SPARSE_INDEXED_TENSOR() != by2 || 1 != n) break block10;
                                                                                            tensor3 = new SparseIndexedTensor1(dims[0]);
                                                                                            break block11;
                                                                                        }
                                                                                        if (tuple2 == null) break block12;
                                                                                        byte by3 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                                        int n = tuple2._2$mcI$sp();
                                                                                        if (this.SPARSE_INDEXED_TENSOR() != by3 || 2 != n) break block12;
                                                                                        tensor3 = new SparseIndexedTensor2(dims[0], dims[1]);
                                                                                        break block11;
                                                                                    }
                                                                                    if (tuple2 == null) break block13;
                                                                                    byte by4 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                                    int n = tuple2._2$mcI$sp();
                                                                                    if (this.SPARSE_INDEXED_TENSOR() != by4 || 3 != n) break block13;
                                                                                    tensor3 = new SparseIndexedTensor3(dims[0], dims[1], dims[2]);
                                                                                    break block11;
                                                                                }
                                                                                if (tuple2 == null) break block14;
                                                                                byte by5 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                                int n = tuple2._2$mcI$sp();
                                                                                if (this.SPARSE_BINARY_TENSOR() != by5 || 1 != n) break block14;
                                                                                tensor3 = new SparseBinaryTensor1(dims[0]);
                                                                                break block11;
                                                                            }
                                                                            if (tuple2 == null) break block15;
                                                                            byte by6 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                            int n = tuple2._2$mcI$sp();
                                                                            if (this.SPARSE_BINARY_TENSOR() != by6 || 2 != n) break block15;
                                                                            tensor3 = new SparseBinaryTensor2(dims[0], dims[1]);
                                                                            break block11;
                                                                        }
                                                                        if (tuple2 == null) break block16;
                                                                        byte by7 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                        int n = tuple2._2$mcI$sp();
                                                                        if (this.SPARSE_BINARY_TENSOR() != by7 || 3 != n) break block16;
                                                                        tensor3 = new SparseBinaryTensor3(dims[0], dims[1], dims[2]);
                                                                        break block11;
                                                                    }
                                                                    if (tuple2 == null) break block17;
                                                                    byte by8 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                    int n = tuple2._2$mcI$sp();
                                                                    if (this.DENSE_TENSOR() != by8 || 1 != n) break block17;
                                                                    tensor3 = new DenseTensor1(dims[0]);
                                                                    break block11;
                                                                }
                                                                if (tuple2 == null) break block18;
                                                                byte by9 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                                int n = tuple2._2$mcI$sp();
                                                                if (this.DENSE_TENSOR() != by9 || 2 != n) break block18;
                                                                tensor3 = new DenseTensor2(dims[0], dims[1]);
                                                                break block11;
                                                            }
                                                            if (tuple2 == null) break block19;
                                                            byte by10 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                                            int n = tuple2._2$mcI$sp();
                                                            if (this.DENSE_TENSOR() != by10 || 3 != n) break block19;
                                                            tensor3 = new DenseTensor3(dims[0], dims[1], dims[2]);
                                                        }
                                                        tensor2 = tensor3;
                                                    }
                                                    tensor = newBlank = tensor2;
                                                    if (!(tensor instanceof ArraySparseIndexedTensor)) break block20;
                                                    ArraySparseIndexedTensor arraySparseIndexedTensor = (ArraySparseIndexedTensor)tensor;
                                                    arraySparseIndexedTensor.sizeHint(activeDomainSize2);
                                                    int[] idxArr = this.readIntArray(s);
                                                    double[] valArr = this.readDoubleArray(s);
                                                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(idxArr).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(valArr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){

                                                        public final boolean apply(Tuple2<Object, Object> check$ifrefutable$3) {
                                                            Tuple2<Object, Object> tuple2 = check$ifrefutable$3;
                                                            boolean bl = tuple2 != null;
                                                            return bl;
                                                        }
                                                    }).foreach((Function1)new Serializable(arraySparseIndexedTensor){
                                                        private final ArraySparseIndexedTensor x2$1;

                                                        public final void apply(Tuple2<Object, Object> x$6) {
                                                            Tuple2<Object, Object> tuple2 = x$6;
                                                            if (tuple2 != null) {
                                                                int i = tuple2._1$mcI$sp();
                                                                double v = tuple2._2$mcD$sp();
                                                                this.x2$1.$plus$eq(i, v);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                return;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            this.x2$1 = x2$1;
                                                        }
                                                    });
                                                    object2 = BoxedUnit.UNIT;
                                                    break block21;
                                                }
                                                if (!(tensor instanceof ArraySparseBinaryTensor)) break block22;
                                                ArraySparseBinaryTensor arraySparseBinaryTensor = (ArraySparseBinaryTensor)tensor;
                                                arraySparseBinaryTensor.sizeHint(activeDomainSize2);
                                                arraySparseBinaryTensor.$plus$plus$eq(this.readIntArray(s));
                                                object2 = BoxedUnit.UNIT;
                                                break block21;
                                            }
                                            if (!(tensor instanceof DenseTensor)) break block23;
                                            DenseTensor denseTensor = (DenseTensor)tensor;
                                            object2 = this.readDoubleArray(s, denseTensor.asArray());
                                        }
                                        object = newBlank;
                                        break block3;
                                    }
                                    throw new MatchError((Object)tensor);
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (this.TENSOR() != by) break block24;
                            Tensor tensor = (Tensor)package$AnyExtras$.MODULE$.toNotNull$extension(package$.MODULE$.AnyExtras(preexisting)).flatMap((Function1)new Serializable(){

                                public final Option<Tensor> apply(Object x$7) {
                                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(BinarySerializer$.MODULE$.getClass().getClassLoader());
                                    return package$AnyExtras$.MODULE$.cast$extension(package$.MODULE$.AnyExtras(x$7), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                            Universe $u = $m$untyped.universe();
                                            Mirror<U> $m = $m$untyped;
                                            return $m.staticClass("cc.factorie.la.Tensor").asType().toTypeConstructor();
                                        }
                                    }), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
                                }
                            }).getOrElse((Function0)new Serializable(){

                                public final Nothing$ apply() {
                                    return scala.sys.package$.MODULE$.error("Require pre-existing tensor value in cubbie for general \"TENSOR\" slot.");
                                }
                            });
                            package$.MODULE$.repeat(s.readInt(), (Function0<BoxedUnit>)new Serializable(s, tensor){
                                private final DataInputStream s$5;
                                private final Tensor tensor$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.tensor$1.update(this.s$5.readInt(), this.s$5.readDouble());
                                }
                                {
                                    this.s$5 = s$5;
                                    this.tensor$1 = tensor$1;
                                }
                            });
                            object = tensor;
                            break block3;
                        }
                        if (this.MAP() != by) break block25;
                        HashMap m = preexisting == null ? new HashMap() : (Map)preexisting;
                        package$.MODULE$.repeat(s.readInt(), (Function0<BoxedUnit>)new Serializable(s, (Map)m){
                            private final DataInputStream s$5;
                            private final Map m$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                String key;
                                this.m$1.update((Object)key, BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$deserializeInner(this.m$1.contains((Object)(key = BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$readString(this.s$5))) ? this.m$1.apply((Object)key) : null, this.s$5.readByte(), this.s$5));
                            }
                            {
                                this.s$5 = s$5;
                                this.m$1 = m$1;
                            }
                        });
                        object = m;
                        break block3;
                    }
                    if (this.LIST() != by) break block26;
                    byte innerTag = s.readByte();
                    int len = s.readInt();
                    ArrayBuffer buff = innerTag == this.cc$factorie$util$BinarySerializer$$INT() ? new ArrayBuffer() : (innerTag == this.DOUBLE() ? new ArrayBuffer() : new ArrayBuffer());
                    Iterator iter = ((TraversableLike)(preexisting == null ? Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Traversable)preexisting)).toIterator();
                    package$.MODULE$.repeat(len, (Function0<BoxedUnit>)new Serializable(s, innerTag, buff, iter){
                        private final DataInputStream s$5;
                        private final byte innerTag$1;
                        private final ArrayBuffer buff$1;
                        private final Iterator iter$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Object pre = this.iter$1.hasNext() ? this.iter$1.next() : null;
                            byte nextTag = BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$isPrimitiveTag(this.innerTag$1) ? this.innerTag$1 : this.s$5.readByte();
                            this.buff$1.$plus$eq(BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$deserializeInner(pre, nextTag, this.s$5));
                        }
                        {
                            this.s$5 = s$5;
                            this.innerTag$1 = innerTag$1;
                            this.buff$1 = buff$1;
                            this.iter$1 = iter$1;
                        }
                    });
                    object = buff;
                    break block3;
                }
                if (this.NULL() != by) break block27;
                s.readByte();
                object = null;
            }
            return object;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    private double[] readDoubleArray(DataInputStream s, double[] arr) {
        int length2 = s.readInt();
        for (int i = 0; i < length2; ++i) {
            arr[i] = s.readDouble();
        }
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    private double[] readDoubleArray(DataInputStream s) {
        void var2_2;
        double[] arr = new double[s.readInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s.readDouble();
        }
        return var2_2;
    }

    private void writeDoubleArray(DataOutputStream s, double[] arr) {
        this.writeDoubleArray(s, arr, arr.length);
    }

    private void writeDoubleArray(DataOutputStream s, double[] arr, int length2) {
        s.writeInt(length2);
        for (int i = 0; i < length2; ++i) {
            s.writeDouble(arr[i]);
        }
    }

    private int[] readIntArray(DataInputStream s, int[] arr) {
        int length2 = Predef$.MODULE$.readInt();
        for (int i = 0; i < length2; ++i) {
            arr[i] = s.readInt();
        }
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    private int[] readIntArray(DataInputStream s) {
        void var2_2;
        int[] arr = new int[s.readInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s.readInt();
        }
        return var2_2;
    }

    private void writeIntArray(DataOutputStream s, int[] arr) {
        this.writeIntArray(s, arr, arr.length);
    }

    private void writeIntArray(DataOutputStream s, int[] arr, int length2) {
        s.writeInt(length2);
        for (int i = 0; i < length2; ++i) {
            s.writeInt(arr[i]);
        }
    }

    public String cc$factorie$util$BinarySerializer$$readString(DataInputStream s) {
        StringBuilder bldr = new StringBuilder();
        package$.MODULE$.repeat(s.readInt(), (Function0<BoxedUnit>)new Serializable(s, bldr){
            private final DataInputStream s$4;
            private final StringBuilder bldr$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.bldr$1.$plus$eq(this.s$4.readChar());
            }
            {
                this.s$4 = s$4;
                this.bldr$1 = bldr$1;
            }
        });
        return bldr.mkString();
    }

    public void cc$factorie$util$BinarySerializer$$writeString(String str, DataOutputStream s) {
        s.writeInt(str.length());
        new StringOps(Predef$.MODULE$.augmentString(str)).foreach((Function1)new Serializable(s){
            private final DataOutputStream s$6;

            public final void apply(char x$8) {
                this.s$6.writeChar(x$8);
            }
            {
                this.s$6 = s$6;
            }
        });
    }

    public byte cc$factorie$util$BinarySerializer$$tagForType(Object value2) {
        Object object;
        block13: {
            byte by;
            block3: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        object = value2;
                                                        if (!(object instanceof Integer)) break block2;
                                                        by = this.cc$factorie$util$BinarySerializer$$INT();
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Double)) break block4;
                                                    by = this.DOUBLE();
                                                    break block3;
                                                }
                                                if (!(object instanceof Boolean)) break block5;
                                                by = this.BOOLEAN();
                                                break block3;
                                            }
                                            if (!(object instanceof String)) break block6;
                                            by = this.STRING();
                                            break block3;
                                        }
                                        if (!(object instanceof SparseIndexedTensor)) break block7;
                                        by = this.SPARSE_INDEXED_TENSOR();
                                        break block3;
                                    }
                                    if (!(object instanceof SparseBinaryTensor)) break block8;
                                    by = this.SPARSE_BINARY_TENSOR();
                                    break block3;
                                }
                                if (!(object instanceof DenseTensor)) break block9;
                                by = this.DENSE_TENSOR();
                                break block3;
                            }
                            if (!(object instanceof Tensor)) break block10;
                            by = this.TENSOR();
                            break block3;
                        }
                        if (!(object instanceof Map)) break block11;
                        by = this.MAP();
                        break block3;
                    }
                    if (!(object instanceof Traversable)) break block12;
                    by = this.LIST();
                    break block3;
                }
                if (object != null) break block13;
                by = this.NULL();
            }
            return by;
        }
        throw new MatchError(object);
    }

    public boolean cc$factorie$util$BinarySerializer$$isPrimitiveTag(byte tag2) {
        byte by = tag2;
        boolean bl = this.DOUBLE() == by ? true : (this.BOOLEAN() == by ? true : (this.cc$factorie$util$BinarySerializer$$INT() == by ? true : this.NULL() == by));
        boolean bl2 = bl;
        return bl2;
    }

    private boolean isPrimitive(Object value2) {
        return this.cc$factorie$util$BinarySerializer$$isPrimitiveTag(this.cc$factorie$util$BinarySerializer$$tagForType(value2));
    }

    public void cc$factorie$util$BinarySerializer$$serialize(Option<String> key, Object value2, DataOutputStream s) {
        Object object;
        block17: {
            block5: {
                block16: {
                    block15: {
                        block14: {
                            Tensor tensor;
                            boolean bl;
                            block9: {
                                Tensor tensor2;
                                block13: {
                                    block11: {
                                        int activeDomainSize2;
                                        block12: {
                                            block10: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                key.foreach((Function1)new Serializable(s){
                                                                    private final DataOutputStream s$3;

                                                                    public final void apply(String x$9) {
                                                                        BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$writeString(x$9, this.s$3);
                                                                    }
                                                                    {
                                                                        this.s$3 = s$3;
                                                                    }
                                                                });
                                                                if (key.isDefined() || !this.isPrimitive(value2)) {
                                                                    s.writeByte(this.cc$factorie$util$BinarySerializer$$tagForType(value2));
                                                                }
                                                                bl = false;
                                                                tensor = null;
                                                                object = value2;
                                                                if (!(object instanceof Integer)) break block4;
                                                                int n = BoxesRunTime.unboxToInt((Object)object);
                                                                s.writeInt(n);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block5;
                                                            }
                                                            if (!(object instanceof Boolean)) break block6;
                                                            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
                                                            s.writeShort(bl2 ? 1 : 0);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block5;
                                                        }
                                                        if (!(object instanceof Double)) break block7;
                                                        double d = BoxesRunTime.unboxToDouble((Object)object);
                                                        s.writeDouble(d);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block5;
                                                    }
                                                    if (!(object instanceof String)) break block8;
                                                    String string = (String)object;
                                                    this.cc$factorie$util$BinarySerializer$$writeString(string, s);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block5;
                                                }
                                                if (!(object instanceof Tensor)) break block9;
                                                bl = true;
                                                tensor = (Tensor)object;
                                                if (!(tensor instanceof SparseIndexedTensor) && !(tensor instanceof SparseBinaryTensor) && !(tensor instanceof DenseTensor)) break block9;
                                                activeDomainSize2 = tensor.activeDomainSize();
                                                s.writeInt(activeDomainSize2);
                                                this.writeIntArray(s, tensor.dimensions());
                                                tensor2 = tensor;
                                                if (!(tensor2 instanceof SparseIndexedTensor)) break block10;
                                                SparseIndexedTensor sparseIndexedTensor = (SparseIndexedTensor)tensor2;
                                                this.writeIntArray(s, sparseIndexedTensor._indices(), activeDomainSize2);
                                                this.writeDoubleArray(s, sparseIndexedTensor._values(), activeDomainSize2);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block11;
                                            }
                                            if (!(tensor2 instanceof SparseBinaryTensor)) break block12;
                                            SparseBinaryTensor sparseBinaryTensor = (SparseBinaryTensor)tensor2;
                                            this.writeIntArray(s, sparseBinaryTensor._indices(), activeDomainSize2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block11;
                                        }
                                        if (!(tensor2 instanceof DenseTensor)) break block13;
                                        DenseTensor denseTensor = (DenseTensor)tensor2;
                                        this.writeDoubleArray(s, denseTensor.asArray(), activeDomainSize2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block5;
                                }
                                throw new MatchError((Object)tensor2);
                            }
                            if (!bl) break block14;
                            s.writeInt(tensor.activeDomainSize());
                            tensor.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable(s){
                                private final DataOutputStream s$3;

                                public final void apply(int i, double v) {
                                    this.apply$mcVID$sp(i, v);
                                }

                                public void apply$mcVID$sp(int i, double v) {
                                    this.s$3.writeInt(i);
                                    this.s$3.writeDouble(v);
                                }
                                {
                                    this.s$3 = s$3;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (!(object instanceof Map)) break block15;
                        Map map2 = (Map)object;
                        s.writeInt(map2.size());
                        map2.withFilter((Function1)new Serializable(){

                            public final boolean apply(Tuple2<String, Object> check$ifrefutable$4) {
                                Tuple2<String, Object> tuple2 = check$ifrefutable$4;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(s){
                            private final DataOutputStream s$3;

                            public final void apply(Tuple2<String, Object> x$10) {
                                Tuple2<String, Object> tuple2 = x$10;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    Object v = tuple2._2();
                                    BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$serialize((Option<String>)new Some((Object)k), v, this.s$3);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.s$3 = s$3;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    if (!(object instanceof Traversable)) break block16;
                    Traversable traversable = (Traversable)object;
                    byte tag2 = BoxesRunTime.unboxToByte((Object)traversable.headOption().map((Function1)new Serializable(){

                        public final byte apply(Object value2) {
                            return BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$tagForType(value2);
                        }
                    }).getOrElse((Function0)new Serializable(){

                        public final byte apply() {
                            return this.apply$mcB$sp();
                        }

                        public byte apply$mcB$sp() {
                            return BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$INT();
                        }
                    }));
                    s.writeByte(tag2);
                    s.writeInt(traversable.size());
                    traversable.foreach((Function1)new Serializable(s){
                        private final DataOutputStream s$3;

                        public final void apply(Object x$11) {
                            BinarySerializer$.MODULE$.cc$factorie$util$BinarySerializer$$serialize((Option<String>)None$.MODULE$, x$11, this.s$3);
                        }
                        {
                            this.s$3 = s$3;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (object != null) break block17;
                s.writeByte(0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            s.flush();
            return;
        }
        throw new MatchError(object);
    }

    public boolean serialize$default$3() {
        return false;
    }

    private final String readField$1(String fieldName, DataInputStream s$2) {
        String string = this.cc$factorie$util$BinarySerializer$$readString(s$2);
        String string2 = fieldName;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(fieldName){
            private final String fieldName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cubbie must have \"%s\" field serialized.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldName$1}));
            }
            {
                this.fieldName$1 = fieldName$1;
            }
        });
        s$2.readByte();
        return (String)this.cc$factorie$util$BinarySerializer$$deserializeInner(null, this.STRING(), s$2);
    }

    private final void assertSame$1(String fieldName, String written, String expected) {
        String string = written;
        String string2 = expected;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(fieldName, written, expected){
            private final String fieldName$2;
            private final String written$1;
            private final String expected$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Expected written cubbie %s to be \"%s\", instead got \"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldName$2, this.written$1, this.expected$1}));
            }
            {
                this.fieldName$2 = fieldName$2;
                this.written$1 = written$1;
                this.expected$1 = expected$1;
            }
        });
    }

    private BinarySerializer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        GlobalLogging$class.$init$(this);
        this.currentVersion = "1.0";
        this.cc$factorie$util$BinarySerializer$$INT = 1;
        this.DOUBLE = (byte)2;
        this.BOOLEAN = (byte)3;
        this.STRING = (byte)4;
        this.TENSOR = (byte)5;
        this.MAP = (byte)6;
        this.LIST = (byte)7;
        this.NULL = (byte)8;
        this.SPARSE_INDEXED_TENSOR = (byte)9;
        this.SPARSE_BINARY_TENSOR = (byte)16;
        this.DENSE_TENSOR = (byte)17;
    }
}

