/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Method;
import java.util.Comparator;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.FactoryCache;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.ReflectUtils;
import net.sf.cglib.SorterTemplate;

public abstract class ParallelSorter
extends SorterTemplate {
    static final Class TYPE = class$net$sf$cglib$ParallelSorter == null ? (class$net$sf$cglib$ParallelSorter = ParallelSorter.class$("net.sf.cglib.ParallelSorter")) : class$net$sf$cglib$ParallelSorter;
    private static final FactoryCache cache = new FactoryCache();
    private static final ClassLoader defaultLoader = TYPE.getClassLoader();
    private static final ClassNameFactory nameFactory = new ClassNameFactory("SortedByCGLIB");
    private static final ParallelSorterKey keyFactory = (ParallelSorterKey)((Object)KeyFactory.create(class$net$sf$cglib$ParallelSorter$ParallelSorterKey == null ? (class$net$sf$cglib$ParallelSorter$ParallelSorterKey = ParallelSorter.class$("net.sf.cglib.ParallelSorter$ParallelSorterKey")) : class$net$sf$cglib$ParallelSorter$ParallelSorterKey, null));
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("ParallelSorter.cglib_newInstance(Object[])");
    private static final Method SWAP_METHOD = ReflectUtils.findMethod("SorterTemplate.swap(int, int)");
    protected Object[] a;
    private Comparer comparer;
    static /* synthetic */ Class class$net$sf$cglib$ParallelSorter;
    static /* synthetic */ Class class$net$sf$cglib$ParallelSorter$ParallelSorterKey;

    protected ParallelSorter() {
    }

    protected abstract ParallelSorter cglib_newInstance(Object[] var1);

    public static ParallelSorter create(Object[] arrays) {
        return ParallelSorter.create(arrays, null);
    }

    public static ParallelSorter create(Object[] arrays, ClassLoader loader) {
        ParallelSorter factory;
        if (loader == null) {
            loader = defaultLoader;
        }
        Class[] classes = ReflectUtils.getClasses(arrays);
        Object key = keyFactory.newInstance(classes);
        FactoryCache factoryCache = cache;
        synchronized (factoryCache) {
            factory = (ParallelSorter)cache.get(loader, key);
            if (factory == null) {
                ParallelSorter.validate(classes);
                String className = nameFactory.getNextName(TYPE);
                Class result = new Generator(className, classes, loader).define();
                factory = (ParallelSorter)ReflectUtils.newInstance(result, Constants.TYPES_OBJECT_ARRAY, new Object[]{arrays});
                cache.put(loader, key, factory);
                ParallelSorter parallelSorter = factory;
                return parallelSorter;
            }
        }
        return factory.cglib_newInstance(arrays);
    }

    private int len() {
        return ((Object[])this.a[0]).length;
    }

    public void quickSort(int index) {
        this.quickSort(index, 0, this.len(), null);
    }

    public void quickSort(int index, int lo, int hi) {
        this.quickSort(index, lo, hi, null);
    }

    public void quickSort(int index, Comparator cmp) {
        this.quickSort(index, 0, this.len(), cmp);
    }

    public void quickSort(int index, int lo, int hi, Comparator cmp) {
        this.chooseComparer(index, cmp);
        super.quickSort(lo, hi - 1);
    }

    public void mergeSort(int index) {
        this.mergeSort(index, 0, this.len(), null);
    }

    public void mergeSort(int index, int lo, int hi) {
        this.mergeSort(index, lo, hi, null);
    }

    public void mergeSort(int index, Comparator cmp) {
        this.mergeSort(index, 0, this.len(), cmp);
    }

    public void mergeSort(int index, int lo, int hi, Comparator cmp) {
        this.chooseComparer(index, cmp);
        super.mergeSort(lo, hi - 1);
    }

    private static void validate(Class[] classes) {
        if (classes.length == 0) {
            throw new IllegalArgumentException("No arrays specified to sort");
        }
        int i = 0;
        while (i < classes.length) {
            if (!classes[i].isArray()) {
                throw new IllegalArgumentException(classes[i] + " is not an array");
            }
            ++i;
        }
    }

    private void chooseComparer(int index, Comparator cmp) {
        Object array = this.a[index];
        Class<?> type = array.getClass().getComponentType();
        this.comparer = type.equals(Integer.TYPE) ? new IntComparer((int[])array) : (type.equals(Long.TYPE) ? new LongComparer((long[])array) : (type.equals(Double.TYPE) ? new DoubleComparer((double[])array) : (type.equals(Float.TYPE) ? new FloatComparer((float[])array) : (type.equals(Short.TYPE) ? new ShortComparer((short[])array) : (type.equals(Byte.TYPE) ? new ByteComparer((byte[])array) : (cmp != null ? new ComparatorComparer((Object[])array, cmp) : new ObjectComparer((Object[])array)))))));
    }

    protected int compare(int i, int j) {
        return this.comparer.compare(i, j);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ByteComparer
    implements Comparer {
        private byte[] a;

        public ByteComparer(byte[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            return this.a[i] - this.a[j];
        }
    }

    static class ShortComparer
    implements Comparer {
        private short[] a;

        public ShortComparer(short[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            return this.a[i] - this.a[j];
        }
    }

    static class DoubleComparer
    implements Comparer {
        private double[] a;

        public DoubleComparer(double[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            double vi = this.a[i];
            double vj = this.a[j];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class FloatComparer
    implements Comparer {
        private float[] a;

        public FloatComparer(float[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            float vi = this.a[i];
            float vj = this.a[j];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class LongComparer
    implements Comparer {
        private long[] a;

        public LongComparer(long[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            long vi = this.a[i];
            long vj = this.a[j];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class IntComparer
    implements Comparer {
        private int[] a;

        public IntComparer(int[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            return this.a[i] - this.a[j];
        }
    }

    static class ObjectComparer
    implements Comparer {
        private Object[] a;

        public ObjectComparer(Object[] a) {
            this.a = a;
        }

        public int compare(int i, int j) {
            return ((Comparable)this.a[i]).compareTo(this.a[j]);
        }
    }

    static class ComparatorComparer
    implements Comparer {
        private Object[] a;
        private Comparator cmp;

        public ComparatorComparer(Object[] a, Comparator cmp) {
            this.a = a;
            this.cmp = cmp;
        }

        public int compare(int i, int j) {
            return this.cmp.compare(this.a[i], this.a[j]);
        }
    }

    static interface Comparer {
        public int compare(int var1, int var2);
    }

    private static class Generator
    extends CodeGenerator {
        private Class[] classes;
        static /* synthetic */ Class class$net$sf$cglib$ParallelSorter;

        private String getFieldName(int index) {
            return "FIELD_" + index;
        }

        public Generator(String className, Class[] classes, ClassLoader loader) {
            super(className, class$net$sf$cglib$ParallelSorter == null ? (class$net$sf$cglib$ParallelSorter = Generator.class$("net.sf.cglib.ParallelSorter")) : class$net$sf$cglib$ParallelSorter, loader);
            this.classes = classes;
        }

        protected void generate() throws NoSuchFieldException {
            this.generateFactoryMethod(NEW_INSTANCE);
            this.generateConstructor();
            this.generateSwap();
        }

        private void generateConstructor() throws NoSuchFieldException {
            this.begin_constructor(Constants.TYPES_OBJECT_ARRAY);
            this.load_this();
            this.super_invoke_constructor();
            this.load_this();
            this.load_arg(0);
            this.super_putfield("a");
            int i = 0;
            while (i < this.classes.length) {
                this.declare_field(2, this.classes[i], this.getFieldName(i));
                this.load_this();
                this.load_arg(0);
                this.push(i);
                this.aaload();
                this.checkcast(this.classes[i]);
                this.putfield(this.getFieldName(i));
                ++i;
            }
            this.return_value();
            this.end_method();
        }

        private void generateSwap() {
            this.begin_method(SWAP_METHOD);
            int i = 0;
            while (i < this.classes.length) {
                Class type = this.classes[i];
                Class<?> component = type.getComponentType();
                Object T = this.make_local(type);
                this.load_this();
                this.getfield(this.getFieldName(i));
                this.store_local(T);
                this.load_local(T);
                this.load_arg(0);
                this.load_local(T);
                this.load_arg(1);
                this.array_load(component);
                this.load_local(T);
                this.load_arg(1);
                this.load_local(T);
                this.load_arg(0);
                this.array_load(component);
                this.array_store(component);
                this.array_store(component);
                ++i;
            }
            this.return_value();
            this.end_method();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static interface ParallelSorterKey {
        public Object newInstance(Class[] var1);
    }
}

