/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.pdf;

import ch.codeblock.qrinvoice.TechnicalException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSmartCopy;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class QrPdfMerger {
    public static byte[] mergePdfs(byte[] inputPdf, byte[] paymentPartReceiptPdf) throws IOException, TechnicalException {
        return QrPdfMerger.mergePdfs(inputPdf, paymentPartReceiptPdf, 1);
    }

    public static byte[] mergePdfs(byte[] inputPdf, byte[] paymentPartReceiptPdf, int onPage) throws IOException, TechnicalException {
        PdfReader reader = new PdfReader(inputPdf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)baos);
            PdfContentByte canvas = stamper.getOverContent(onPage);
            Rectangle basePage = reader.getPageSize(1);
            PdfReader r = new PdfReader(paymentPartReceiptPdf);
            PdfImportedPage paymentPartPage = stamper.getImportedPage(r, 1);
            float x = basePage.getWidth() - paymentPartPage.getWidth();
            canvas.addTemplate((PdfTemplate)paymentPartPage, x, 0.0f);
            stamper.getWriter().freeReader(r);
            r.close();
            stamper.close();
        }
        catch (DocumentException e) {
            throw new TechnicalException("Unable to merge PDFs", (Throwable)e);
        }
        return baos.toByteArray();
    }

    public static byte[] appendPdfs(List<byte[]> data) throws IOException, TechnicalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = new Document();
        try {
            PdfSmartCopy copy = new PdfSmartCopy(document, (OutputStream)baos);
            document.open();
            for (byte[] dataLoop : data) {
                PdfReader pdfReaderOne = new PdfReader(dataLoop);
                QrPdfMerger.importPdf(pdfReaderOne, (PdfCopy)copy).freeReader(pdfReaderOne);
                pdfReaderOne.close();
            }
            document.close();
        }
        catch (DocumentException e) {
            throw new TechnicalException("Unable to append PDFs", (Throwable)e);
        }
        return baos.toByteArray();
    }

    public static PdfCopy importPdf(PdfReader pdfReader, PdfCopy copy) throws IOException {
        int n = pdfReader.getNumberOfPages();
        try {
            for (int i = 1; i <= n; ++i) {
                PdfImportedPage page = copy.getImportedPage(pdfReader, i);
                copy.addPage(page);
            }
        }
        catch (BadPdfFormatException e) {
            throw new TechnicalException("Unable to import PDF document", (Throwable)e);
        }
        return copy;
    }
}

