/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.docker.LocalstackDocker;
import cloud.localstack.docker.annotation.IEnvironmentVariableProvider;
import cloud.localstack.docker.annotation.IHostNameResolver;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class LocalstackDockerTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = Logger.getLogger(LocalstackDockerTestRunner.class.getName());
    private static String externalHostName = "localhost";
    private static boolean pullNewImage = true;
    private static boolean randomizePorts = false;
    private static Map<String, String> environmentVariables = new HashMap<String, String>();
    private static LocalstackDocker localstackDocker = LocalstackDocker.getLocalstackDocker();

    public LocalstackDockerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.processAnnotations(klass.getAnnotations());
    }

    public void run(RunNotifier notifier) {
        LocalstackTestRunner.teardownInfrastructure();
        localstackDocker.setExternalHostName(externalHostName);
        localstackDocker.setPullNewImage(pullNewImage);
        localstackDocker.setRandomizePorts(randomizePorts);
        localstackDocker.setEnvironmentVariables(environmentVariables);
        try {
            localstackDocker.startup();
            super.run(notifier);
        }
        finally {
            localstackDocker.stop();
        }
    }

    private void processAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof LocalstackDockerProperties)) continue;
            this.processDockerPropertiesAnnotation((LocalstackDockerProperties)annotation);
        }
    }

    private void processDockerPropertiesAnnotation(LocalstackDockerProperties properties) {
        pullNewImage = properties.pullNewImage();
        randomizePorts = properties.randomizePorts();
        try {
            IHostNameResolver hostNameResolver = properties.hostNameResolver().newInstance();
            String resolvedName = hostNameResolver.getHostName();
            if (StringUtils.isNotBlank((CharSequence)resolvedName)) {
                externalHostName = resolvedName;
            }
            LOG.info("External host name is set to: " + externalHostName);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to resolve hostname", ex);
        }
        try {
            IEnvironmentVariableProvider environmentProvider = properties.environmentVariableProvider().newInstance();
            environmentVariables = environmentProvider.getEnvironmentVariables();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to get environment variables", ex);
        }
        String services = String.join((CharSequence)",", properties.services());
        if (StringUtils.isNotEmpty((CharSequence)services)) {
            environmentVariables.put("SERVICES", services);
        }
    }

    public static LocalstackDocker getLocalstackDocker() {
        return localstackDocker;
    }
}

