/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.process_tree_killer;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;
import org.ow2.proactive.process_tree_killer.EnvVars;
import org.ow2.proactive.process_tree_killer.ProcessTreeRemoting;
import org.ow2.proactive.process_tree_killer.QuotedStringTokenizer;
import org.ow2.proactive.process_tree_killer.jna.GNUCLibrary;

public abstract class ProcessTree
implements Iterable<OSProcess>,
ProcessTreeRemoting.IProcessTree,
Serializable {
    protected final Map<Integer, OSProcess> processes = new HashMap<Integer, OSProcess>();
    static final ProcessTree DEFAULT = new Local(){

        @Override
        public OSProcess get(final Process proc) {
            return new OSProcess(-1){

                @Override
                public OSProcess getParent() {
                    return null;
                }

                @Override
                public void killRecursively() {
                    proc.destroy();
                }

                @Override
                public void kill() throws InterruptedException {
                    proc.destroy();
                }

                @Override
                public List<String> getArguments() {
                    return Collections.emptyList();
                }

                @Override
                public EnvVars getEnvironmentVariables() {
                    return new EnvVars();
                }
            };
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars) {
        }
    };
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    private static final Logger LOGGER = Logger.getLogger(ProcessTree.class.getName());
    public static boolean enabled = !Boolean.getBoolean(ProcessTree.class.getName() + ".disable");

    private ProcessTree() {
    }

    public final OSProcess get(int pid) {
        return this.processes.get(pid);
    }

    @Override
    public final Iterator<OSProcess> iterator() {
        return this.processes.values().iterator();
    }

    public abstract OSProcess get(Process var1);

    @Override
    public abstract void killAll(Map<String, String> var1) throws InterruptedException;

    public void killAll(Process proc, Map<String, String> modelEnvVars) throws InterruptedException {
        LOGGER.fine("killAll: process=" + proc + " and envs=" + modelEnvVars);
        OSProcess p = this.get(proc);
        if (p != null) {
            p.killRecursively();
        }
        if (modelEnvVars != null) {
            this.killAll(modelEnvVars);
        }
    }

    public static ProcessTree get() {
        if (!enabled) {
            return DEFAULT;
        }
        try {
            if (File.pathSeparatorChar == ';') {
                return new Windows();
            }
            String os = ProcessTree.fixNull(System.getProperty("os.name"));
            if (os.equals("Linux")) {
                return new Linux();
            }
            if (os.equals("SunOS")) {
                return new Solaris();
            }
            if (os.equals("Mac OS X")) {
                return new Darwin();
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.WARNING, "Failed to load winp. Reverting to the default", e);
            enabled = false;
        }
        return DEFAULT;
    }

    private static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static abstract class Local
    extends ProcessTree {
        Local() {
        }
    }

    private static class Darwin
    extends Unix {
        private final int sizeOf_kinfo_proc;
        private static final int sizeOf_kinfo_proc_32 = 492;
        private static final int sizeOf_kinfo_proc_64 = 648;
        private final int kinfo_proc_pid_offset;
        private static final int kinfo_proc_pid_offset_32 = 24;
        private static final int kinfo_proc_pid_offset_64 = 40;
        private final int kinfo_proc_ppid_offset;
        private static final int kinfo_proc_ppid_offset_32 = 416;
        private static final int kinfo_proc_ppid_offset_64 = 560;
        private static final int sizeOfInt = Native.getNativeSize(Integer.TYPE);
        private static final int CTL_KERN = 1;
        private static final int KERN_PROC = 14;
        private static final int KERN_PROC_ALL = 0;
        private static final int ENOMEM = 12;
        private static int[] MIB_PROC_ALL = new int[]{1, 14, 0};
        private static final int KERN_ARGMAX = 8;
        private static final int KERN_PROCARGS2 = 49;

        Darwin() {
            String arch = System.getProperty("sun.arch.data.model");
            if ("64".equals(arch)) {
                this.sizeOf_kinfo_proc = 648;
                this.kinfo_proc_pid_offset = 40;
                this.kinfo_proc_ppid_offset = 560;
            } else {
                this.sizeOf_kinfo_proc = 492;
                this.kinfo_proc_pid_offset = 24;
                this.kinfo_proc_ppid_offset = 416;
            }
            try {
                Memory m;
                IntByReference size;
                block7: {
                    IntByReference underscore = new IntByReference(sizeOfInt);
                    size = new IntByReference(sizeOfInt);
                    int nRetry = 0;
                    do {
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, Pointer.NULL, size, Pointer.NULL, underscore) != 0) {
                            throw new IOException("Failed to obtain memory requirement: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                        }
                        m = new Memory((long)size.getValue());
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, (Pointer)m, size, Pointer.NULL, underscore) == 0) break block7;
                    } while (Native.getLastError() == 12 && nRetry++ < 16);
                    throw new IOException("Failed to call kern.proc.all: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                }
                int count = size.getValue() / this.sizeOf_kinfo_proc;
                LOGGER.fine("Found " + count + " processes");
                for (int base = 0; base < size.getValue(); base += this.sizeOf_kinfo_proc) {
                    int pid = m.getInt((long)(base + this.kinfo_proc_pid_offset));
                    int ppid = m.getInt((long)(base + this.kinfo_proc_ppid_offset));
                    this.processes.put(pid, new DarwinProcess(pid, ppid));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to obtain process list", e);
            }
        }

        private class DarwinProcess
        extends UnixProcess {
            private final int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            DarwinProcess(int pid, int ppid) {
                super(pid);
                this.ppid = ppid;
            }

            @Override
            public OSProcess getParent() {
                return Darwin.this.get(this.ppid);
            }

            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.parse();
                return this.envVars;
            }

            @Override
            public List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.parse();
                return this.arguments;
            }

            private void parse() {
                try {
                    this.arguments = new ArrayList<String>();
                    this.envVars = new EnvVars();
                    IntByReference underscore = new IntByReference();
                    IntByReference argmaxRef = new IntByReference(0);
                    IntByReference size = new IntByReference(sizeOfInt);
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, underscore) != 0) {
                        throw new IOException("Failed to get kernl.argmax: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    int argmax = argmaxRef.getValue();
                    class StringArrayMemory
                    extends Memory {
                        private long offset;

                        StringArrayMemory(long l) {
                            super(l);
                            this.offset = 0L;
                        }

                        int readInt() {
                            int r = this.getInt(this.offset);
                            this.offset += (long)sizeOfInt;
                            return r;
                        }

                        byte peek() {
                            return this.getByte(this.offset);
                        }

                        String readString() {
                            byte ch;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            while ((ch = this.getByte(this.offset++)) != 0) {
                                baos.write(ch);
                            }
                            return baos.toString();
                        }

                        void skip0() {
                            while (this.getByte(this.offset) == 0) {
                                ++this.offset;
                            }
                        }
                    }
                    StringArrayMemory m = new StringArrayMemory(argmax);
                    size.setValue(argmax);
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 49, this.pid}, 3, (Pointer)m, size, Pointer.NULL, underscore) != 0) {
                        throw new IOException("Failed to obtain ken.procargs2: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    int argc = m.readInt();
                    String args0 = m.readString();
                    m.skip0();
                    try {
                        for (int i = 0; i < argc; ++i) {
                            this.arguments.add(m.readString());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalStateException("Failed to parse arguments: pid=" + this.pid + ", arg0=" + args0 + ", arguments=" + this.arguments + ", nargs=" + argc + ". Please run 'ps e " + this.pid + "' and report this to https://issues.jenkins-ci.org/browse/JENKINS-9634", e);
                    }
                    while (m.peek() != 0) {
                        this.envVars.addLine(m.readString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static class Solaris
    extends ProcfsUnix {
        Solaris() {
        }

        @Override
        protected OSProcess createProcess(int pid) throws IOException {
            return new SolarisProcess(pid);
        }

        private static long to64(int i) {
            return (long)i & 0xFFFFFFFFL;
        }

        private static int adjust(int i) {
            if (IS_LITTLE_ENDIAN) {
                return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
            }
            return i;
        }

        private class SolarisProcess
        extends UnixProcess {
            private final int ppid;
            private final int envp;
            private final int argp;
            private final int argc;
            private EnvVars envVars;
            private List<String> arguments;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private SolarisProcess(int pid) throws IOException {
                super(pid);
                try (RandomAccessFile psinfo = new RandomAccessFile(this.getFile("psinfo"), "r");){
                    psinfo.seek(8L);
                    if (Solaris.adjust(psinfo.readInt()) != pid) {
                        throw new IOException("psinfo PID mismatch");
                    }
                    this.ppid = Solaris.adjust(psinfo.readInt());
                    psinfo.seek(188L);
                    this.argc = Solaris.adjust(psinfo.readInt());
                    this.argp = Solaris.adjust(psinfo.readInt());
                    this.envp = Solaris.adjust(psinfo.readInt());
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            public OSProcess getParent() {
                return Solaris.this.get(this.ppid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>(this.argc);
                try {
                    RandomAccessFile as = new RandomAccessFile(this.getFile("as"), "r");
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Reading " + this.getFile("as"));
                    }
                    try {
                        for (int n = 0; n < this.argc; ++n) {
                            as.seek(Solaris.to64(this.argp + n * 4));
                            int p = Solaris.adjust(as.readInt());
                            this.arguments.add(this.readLine(as, p, "argv[" + n + "]"));
                        }
                    }
                    finally {
                        as.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                try {
                    RandomAccessFile as = new RandomAccessFile(this.getFile("as"), "r");
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Reading " + this.getFile("as"));
                    }
                    try {
                        int n = 0;
                        while (true) {
                            as.seek(Solaris.to64(this.envp + n * 4));
                            int p = Solaris.adjust(as.readInt());
                            if (p == 0) {
                                break;
                            }
                            this.envVars.addLine(this.readLine(as, p, "env[" + n + "]"));
                            ++n;
                        }
                    }
                    finally {
                        as.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }

            private String readLine(RandomAccessFile as, int p, String prefix) throws IOException {
                int ch;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Reading " + prefix + " at " + p);
                }
                as.seek(Solaris.to64(p));
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int i = 0;
                while ((ch = as.read()) > 0) {
                    if (++i % 100 == 0 && LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(prefix + " is so far " + buf.toString());
                    }
                    buf.write(ch);
                }
                String line = buf.toString();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(prefix + " was " + line);
                }
                return line;
            }
        }
    }

    static class Linux
    extends ProcfsUnix {
        Linux() {
        }

        @Override
        protected LinuxProcess createProcess(int pid) throws IOException {
            return new LinuxProcess(pid);
        }

        public byte[] readFileToByteArray(File file) throws IOException {
            return Files.readAllBytes(file.toPath());
        }

        class LinuxProcess
        extends UnixProcess {
            private int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            LinuxProcess(int pid) throws IOException {
                super(pid);
                this.ppid = -1;
                try (BufferedReader r = new BufferedReader(new FileReader(this.getFile("status")));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("ppid:")) continue;
                        this.ppid = Integer.parseInt(line.substring(5).trim());
                        break;
                    }
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            public OSProcess getParent() {
                return Linux.this.get(this.ppid);
            }

            @Override
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>();
                try {
                    byte[] cmdline = Linux.this.readFileToByteArray(this.getFile("cmdline"));
                    int pos = 0;
                    for (int i = 0; i < cmdline.length; ++i) {
                        byte b = cmdline[i];
                        if (b != 0) continue;
                        this.arguments.add(new String(cmdline, pos, i - pos));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                try {
                    byte[] environ = Linux.this.readFileToByteArray(this.getFile("environ"));
                    int pos = 0;
                    for (int i = 0; i < environ.length; ++i) {
                        byte b = environ[i];
                        if (b != 0) continue;
                        this.envVars.addLine(new String(environ, pos, i - pos));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }
        }
    }

    private static final class UnixReflection {
        private static final Field JAVA8_PID_FIELD;
        private static final Method JAVA9_PID_METHOD;
        private static final Method JAVA8_DESTROY_PROCESS;
        private static final Method JAVA_9_PROCESSHANDLE_OF;
        private static final Method JAVA_9_PROCESSHANDLE_DESTROY;

        private UnixReflection() {
        }

        public static void destroy(int pid) throws IllegalAccessException, InvocationTargetException {
            if (JAVA8_DESTROY_PROCESS != null) {
                JAVA8_DESTROY_PROCESS.invoke(null, pid, false);
            } else {
                Optional handle = (Optional)JAVA_9_PROCESSHANDLE_OF.invoke(null, pid);
                if (handle.isPresent()) {
                    JAVA_9_PROCESSHANDLE_DESTROY.invoke(handle.get(), new Object[0]);
                }
            }
        }

        public static int pid(Process proc) {
            try {
                if (JAVA8_PID_FIELD != null) {
                    return JAVA8_PID_FIELD.getInt(proc);
                }
                long pid = (Long)JAVA9_PID_METHOD.invoke((Object)proc, new Object[0]);
                if (pid > Integer.MAX_VALUE) {
                    throw new IllegalAccessError("PID is out of bounds: " + pid);
                }
                return (int)pid;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
        }

        private static String getJavaVersionFromSystemProperty() {
            return System.getProperty("java.version");
        }

        private static boolean isPostJava8() {
            return !UnixReflection.getJavaVersionFromSystemProperty().startsWith("1.");
        }

        static {
            try {
                if (UnixReflection.isPostJava8()) {
                    Class<Process> clazz = Process.class;
                    JAVA9_PID_METHOD = clazz.getMethod("pid", new Class[0]);
                    JAVA8_PID_FIELD = null;
                    Class<?> processHandleClazz = Class.forName("java.lang.ProcessHandle");
                    JAVA_9_PROCESSHANDLE_OF = processHandleClazz.getMethod("of", Long.TYPE);
                    JAVA_9_PROCESSHANDLE_DESTROY = processHandleClazz.getMethod("destroy", new Class[0]);
                    JAVA8_DESTROY_PROCESS = null;
                } else {
                    Class<?> clazz = Class.forName("java.lang.UNIXProcess");
                    JAVA8_PID_FIELD = clazz.getDeclaredField("pid");
                    JAVA8_PID_FIELD.setAccessible(true);
                    JAVA9_PID_METHOD = null;
                    JAVA8_DESTROY_PROCESS = clazz.getDeclaredMethod("destroyProcess", Integer.TYPE, Boolean.TYPE);
                    JAVA8_DESTROY_PROCESS.setAccessible(true);
                    JAVA_9_PROCESSHANDLE_OF = null;
                    JAVA_9_PROCESSHANDLE_DESTROY = null;
                }
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                LinkageError x = new LinkageError("Cannot initialize reflection for Unix Processes", e);
                throw x;
            }
        }
    }

    public abstract class UnixProcess
    extends OSProcess {
        protected UnixProcess(int pid) {
            super(pid);
        }

        protected final File getFile(String relativePath) {
            return new File(new File("/proc/" + this.getPid()), relativePath);
        }

        @Override
        public void kill() throws InterruptedException {
            try {
                int pid = this.getPid();
                LOGGER.fine("Killing pid=" + pid);
                UnixReflection.destroy(pid);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                LOGGER.log(Level.INFO, "Failed to terminate pid=" + this.getPid(), e);
            }
        }

        @Override
        public void killRecursively() throws InterruptedException {
            LOGGER.fine("Recursively killing pid=" + this.getPid());
            for (OSProcess p : this.getChildren()) {
                p.killRecursively();
            }
            this.kill();
        }

        @Override
        public abstract List<String> getArguments();
    }

    static abstract class ProcfsUnix
    extends Unix {
        ProcfsUnix() {
            File[] processes = new File("/proc").listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            if (processes == null) {
                LOGGER.info("No /proc");
                return;
            }
            for (File p : processes) {
                int pid;
                try {
                    pid = Integer.parseInt(p.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    this.processes.put(pid, this.createProcess(pid));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected abstract OSProcess createProcess(int var1) throws IOException;
    }

    static abstract class Unix
    extends Local {
        Unix() {
        }

        @Override
        public OSProcess get(Process proc) {
            try {
                return this.get(UnixReflection.pid(proc));
            }
            catch (IllegalAccessError e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars) throws InterruptedException {
            for (OSProcess p : this) {
                if (!p.hasMatchingEnvVars(modelEnvVars)) continue;
                p.killRecursively();
            }
        }
    }

    private static final class Windows
    extends Local {
        Windows() {
            for (final WinProcess p : WinProcess.all()) {
                int pid = p.getPid();
                if (pid == 0 || pid == 4) continue;
                this.processes.put(pid, new OSProcess(pid){
                    private EnvVars env;
                    private List<String> args;

                    @Override
                    public OSProcess getParent() {
                        return null;
                    }

                    @Override
                    public void killRecursively() throws InterruptedException {
                        LOGGER.finer("Killing recursively " + this.getPid());
                        p.killRecursively();
                    }

                    @Override
                    public void kill() throws InterruptedException {
                        LOGGER.finer("Killing " + this.getPid());
                        p.kill();
                    }

                    @Override
                    public synchronized List<String> getArguments() {
                        if (this.args == null) {
                            this.args = Arrays.asList(QuotedStringTokenizer.tokenize(p.getCommandLine()));
                        }
                        return this.args;
                    }

                    @Override
                    public synchronized EnvVars getEnvironmentVariables() {
                        if (this.env != null) {
                            return this.env;
                        }
                        this.env = new EnvVars();
                        try {
                            this.env.putAll(p.getEnvironmentVariables());
                        }
                        catch (WinpException e) {
                            LOGGER.log(Level.FINE, "Failed to get environment variable ", e);
                        }
                        return this.env;
                    }
                });
            }
        }

        @Override
        public OSProcess get(Process proc) {
            return this.get(new WinProcess(proc).getPid());
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars) throws InterruptedException {
            for (OSProcess p : this) {
                boolean matched;
                if (p.getPid() < 10) continue;
                LOGGER.finest("Considering to kill " + p.getPid());
                try {
                    matched = p.hasMatchingEnvVars(modelEnvVars);
                }
                catch (WinpException e) {
                    LOGGER.log(Level.FINEST, "  Failed to check environment variable match", e);
                    continue;
                }
                if (matched) {
                    p.killRecursively();
                    continue;
                }
                LOGGER.finest("Environment variable didn't match");
            }
        }

        static {
            WinProcess.enableDebugPrivilege();
        }
    }

    private final class SerializedProcess
    implements Serializable {
        private final int pid;
        private static final long serialVersionUID = 1L;

        private SerializedProcess(int pid) {
            this.pid = pid;
        }

        Object readResolve() {
            return ProcessTree.this.get(this.pid);
        }
    }

    public abstract class OSProcess
    implements ProcessTreeRemoting.IOSProcess,
    Serializable {
        final int pid;

        private OSProcess(int pid) {
            this.pid = pid;
        }

        @Override
        public final int getPid() {
            return this.pid;
        }

        @Override
        public abstract OSProcess getParent();

        final ProcessTree getTree() {
            return ProcessTree.this;
        }

        public final List<OSProcess> getChildren() {
            ArrayList<OSProcess> r = new ArrayList<OSProcess>();
            for (OSProcess p : ProcessTree.this) {
                if (p.getParent() != this) continue;
                r.add(p);
            }
            return r;
        }

        @Override
        public abstract void kill() throws InterruptedException;

        @Override
        public abstract void killRecursively() throws InterruptedException;

        @Override
        public abstract List<String> getArguments();

        @Override
        public abstract EnvVars getEnvironmentVariables();

        public final boolean hasMatchingEnvVars(Map<String, String> modelEnvVar) {
            if (modelEnvVar.isEmpty()) {
                return false;
            }
            EnvVars envs = this.getEnvironmentVariables();
            for (Map.Entry<String, String> e : modelEnvVar.entrySet()) {
                String v = (String)envs.get(e.getKey());
                if (v != null && v.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        Object writeReplace() {
            return new SerializedProcess(this.pid);
        }
    }
}

