/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.process_tree_killer;

import java.io.File;
import java.util.Locale;
import org.ow2.proactive.process_tree_killer.VersionNumber;

public enum Platform {
    WINDOWS(';'),
    UNIX(':');

    public final char pathSeparator;

    private Platform(char pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public static Platform current() {
        if (File.pathSeparatorChar == ':') {
            return UNIX;
        }
        return WINDOWS;
    }

    public static boolean isDarwin() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("mac");
    }

    public static boolean isSnowLeopardOrLater() {
        try {
            return Platform.isDarwin() && new VersionNumber(System.getProperty("os.version")).compareTo(new VersionNumber("10.6")) >= 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

