/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelCollectionParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHanlderResult;
import cn.afterturn.easypoi.excel.imports.CellValueServer;
import cn.afterturn.easypoi.excel.imports.base.ImportBaseService;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelModel;
import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import cn.afterturn.easypoi.util.PoiValidationUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportServer
extends ImportBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportServer.class);
    private CellValueServer cellValueServer = new CellValueServer();
    private boolean verfiyFail = false;
    private CellStyle errorCellStyle;

    private void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        Collection collection = (Collection)PoiReflectorUtil.fromCache(object.getClass()).getValue(object, param.getName());
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        for (int i = row.getFirstCellNum(); i < titlemap.size(); ++i) {
            Cell cell = row.getCell(i);
            String titleString = titlemap.get(i);
            if (!param.getExcelParams().containsKey(titleString)) continue;
            if (param.getExcelParams().get(titleString).getType() == 2) {
                String picId = row.getRowNum() + "_" + i;
                this.saveImage(object, picId, param.getExcelParams(), titleString, pictures, params);
            } else {
                this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString, row);
            }
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private String getKeyValue(Cell cell) {
        String obj = PoiCellUtil.getCellValue(cell);
        return obj == null ? null : obj.toString().trim();
    }

    private String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if (excelImportEntity.getSaveUrl().equals("upload")) {
            if (excelImportEntity.getMethods() != null && excelImportEntity.getMethods().size() > 0) {
                object = this.getFieldBySomeMethod(excelImportEntity.getMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return excelImportEntity.getSaveUrl() + "/" + url;
        }
        return excelImportEntity.getSaveUrl();
    }

    /*
     * Unable to fully structure code
     */
    private <T> List<T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        collection = new ArrayList<Object>();
        excelParams = new HashMap<String, ExcelImportEntity>();
        excelCollection = new ArrayList<ExcelCollectionParams>();
        targetId = null;
        if (!Map.class.equals(pojoClass)) {
            fileds = PoiPublicUtil.getClassFields(pojoClass);
            etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                targetId = etarget.value();
            }
            this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
        }
        rows = sheet.rowIterator();
        for (j = 0; j < params.getTitleRows(); ++j) {
            rows.next();
        }
        titlemap = this.getTitleMap(rows, params, excelCollection);
        this.checkIsValidTemplate(titlemap, excelParams, params, excelCollection);
        row = null;
        object = null;
        readRow = 0;
        for (i = 0; i < params.getStartRows(); ++i) {
            rows.next();
        }
        while (!(!rows.hasNext() || row != null && sheet.getLastRowNum() - row.getRowNum() <= params.getLastOfInvalidRow() || params.getReadRows() > 0 && readRow > params.getReadRows())) {
            row = (Row)rows.next();
            if (sheet.getLastRowNum() - row.getRowNum() < params.getLastOfInvalidRow()) break;
            if (params.getKeyIndex() != null && (row.getCell(params.getKeyIndex().intValue()) == null || StringUtils.isEmpty((CharSequence)this.getKeyValue(row.getCell(params.getKeyIndex().intValue())))) && object != null) {
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
            } else {
                object = PoiPublicUtil.createObject(pojoClass, targetId);
                try {
                    le = titlemap.size();
                    for (i = (int)row.getFirstCellNum(); i < le; ++i) {
                        cell = row.getCell(i);
                        titleString = titlemap.get(i);
                        if (!excelParams.containsKey(titleString) && !Map.class.equals(pojoClass)) continue;
                        if (excelParams.get(titleString) != null && ((ExcelImportEntity)excelParams.get(titleString)).getType() == 2) {
                            picId = row.getRowNum() + "_" + i;
                            this.saveImage(object, picId, excelParams, titleString, pictures, params);
                            continue;
                        }
                        this.saveFieldValue(params, object, cell, excelParams, titleString, row);
                    }
                    for (ExcelCollectionParams param : excelCollection) {
                        this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                    }
                    if (!this.verifyingDataValidity(object, row, params, pojoClass)) ** GOTO lbl60
                    collection.add(object);
                }
                catch (ExcelImportException e) {
                    ExcelImportServer.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                    if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) ** GOTO lbl60
                    throw new ExcelImportException(e.getType(), (Throwable)e);
                }
                catch (Exception e) {
                    ExcelImportServer.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                    throw new RuntimeException(e);
                }
            }
lbl60:
            // 4 sources

            ++readRow;
        }
        return collection;
    }

    private boolean verifyingDataValidity(Object object, Row row, ImportParams params, Class<?> pojoClass) {
        ExcelVerifyHanlderResult result;
        IExcelModel model;
        String errorMsg;
        boolean isAdd = true;
        Cell cell = null;
        if (params.isNeedVerfiy() && StringUtils.isNotEmpty((CharSequence)(errorMsg = PoiValidationUtil.validation(object)))) {
            cell = row.createCell((int)row.getLastCellNum());
            cell.setCellValue(errorMsg);
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg(errorMsg);
            } else {
                isAdd = false;
            }
            this.verfiyFail = true;
        }
        if (params.getVerifyHanlder() != null && !(result = params.getVerifyHanlder().verifyHandler(object)).isSuccess()) {
            if (cell == null) {
                cell = row.createCell((int)row.getLastCellNum());
            }
            cell.setCellValue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cell.getStringCellValue()}) ? cell.getStringCellValue() + "," : "") + result.getMsg());
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{model.getErrorMsg()}) ? model.getErrorMsg() + "," : "") + result.getMsg());
            } else {
                isAdd = false;
            }
            this.verfiyFail = true;
        }
        if (cell != null) {
            cell.setCellStyle(this.errorCellStyle);
        }
        return isAdd;
    }

    private Map<Integer, String> getTitleMap(Iterator<Row> rows, ImportParams params, List<ExcelCollectionParams> excelCollection) {
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        String collectionName = null;
        ExcelCollectionParams collectionParams = null;
        Row row = null;
        for (int j = 0; j < params.getHeadRows(); ++j) {
            row = rows.next();
            if (row == null) continue;
            Iterator cellTitle = row.cellIterator();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = this.getKeyValue(cell);
                value = value.replace("\n", "");
                int i = cell.getColumnIndex();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                if (titlemap.containsKey(i)) {
                    collectionName = (String)titlemap.get(i);
                    collectionParams = this.getCollectionParams(excelCollection, collectionName);
                    titlemap.put(i, collectionName + "_" + value);
                } else if (StringUtils.isNotEmpty(collectionName) && collectionParams != null && collectionParams.getExcelParams().containsKey(collectionName + "_" + value)) {
                    titlemap.put(i, collectionName + "_" + value);
                } else {
                    collectionName = null;
                    collectionParams = null;
                }
                if (!StringUtils.isEmpty((CharSequence)collectionName)) continue;
                titlemap.put(i, value);
            }
        }
        return titlemap;
    }

    private ExcelCollectionParams getCollectionParams(List<ExcelCollectionParams> excelCollection, String collectionName) {
        for (ExcelCollectionParams excelCollectionParams : excelCollection) {
            if (!collectionName.equals(excelCollectionParams.getExcelName())) continue;
            return excelCollectionParams;
        }
        return null;
    }

    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel import start ,class is {}", pojoClass);
        }
        ArrayList result = new ArrayList();
        HSSFWorkbook book = null;
        boolean isXSSFWorkbook = true;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputstream)) {
            book = new HSSFWorkbook(inputstream);
            isXSSFWorkbook = false;
        } else if (DocumentFactoryHelper.hasOOXMLHeader((InputStream)inputstream)) {
            book = new XSSFWorkbook(OPCPackage.open((InputStream)inputstream));
        }
        ExcelImportResult importResult = new ExcelImportResult(result, this.verfiyFail, (Workbook)book);
        this.createErrorCellStyle((Workbook)book);
        for (int i = params.getStartSheetIndex(); i < params.getStartSheetIndex() + params.getSheetNum(); ++i) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" start to read excel by is ,startTime is {}", (Object)new Date().getTime());
            }
            Map<String, PictureData> pictures = isXSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), book);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" end to read excel by is ,endTime is {}", (Object)new Date().getTime());
            }
            result.addAll(this.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" end to read excel list by pos ,endTime is {}", (Object)new Date().getTime());
            }
            if (!params.isReadSingleCell()) continue;
            this.readSingleCell(importResult, book.getSheetAt(i), params);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(" read Key-Value ,endTime is {}", (Object)new Date().getTime());
        }
        if (params.isNeedSave()) {
            this.saveThisExcel(params, pojoClass, isXSSFWorkbook, (Workbook)book);
        }
        importResult.setVerfiyFail(this.verfiyFail);
        return importResult;
    }

    private void readSingleCell(ExcelImportResult result, Sheet sheet, ImportParams params) {
        int i;
        if (result.getMap() == null) {
            result.setMap(new HashMap<String, Object>());
        }
        for (i = 0; i < params.getTitleRows() + params.getHeadRows() + params.getStartRows(); ++i) {
            this.getSingleCellValueForRow(result, sheet.getRow(i), params);
        }
        for (i = sheet.getLastRowNum() - params.getLastOfInvalidRow(); i < sheet.getLastRowNum(); ++i) {
            this.getSingleCellValueForRow(result, sheet.getRow(i), params);
        }
    }

    private void getSingleCellValueForRow(ExcelImportResult result, Row row, ImportParams params) {
        short le = row.getLastCellNum();
        for (int j = row.getFirstCellNum(); j < le; ++j) {
            String text = PoiCellUtil.getCellValue(row.getCell(j));
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{text}) || !text.endsWith(params.getKeyMark())) continue;
            if (result.getMap().containsKey(text)) {
                if (result.getMap().get(text) instanceof String) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)result.getMap().get(text));
                    result.getMap().put(text, list);
                }
                ((List)result.getMap().get(text)).add(PoiCellUtil.getCellValue(row.getCell(++j)));
                continue;
            }
            result.getMap().put(text, PoiCellUtil.getCellValue(row.getCell(++j)));
        }
    }

    private void checkIsValidTemplate(Map<Integer, String> titlemap, Map<String, ExcelImportEntity> excelParams, ImportParams params, List<ExcelCollectionParams> excelCollection) {
        if (params.getImportFields() != null) {
            int le = params.getImportFields().length;
            for (int i = 0; i < le; ++i) {
                if (titlemap.containsValue(params.getImportFields()[i])) continue;
                throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
            }
        } else {
            Collection<ExcelImportEntity> collection = excelParams.values();
            for (ExcelImportEntity excelImportEntity : collection) {
                if (!excelImportEntity.isImportField() || titlemap.containsValue(excelImportEntity.getName())) continue;
                LOGGER.error(excelImportEntity.getName() + "\u5fc5\u987b\u6709,\u4f46\u662f\u6ca1\u627e\u5230");
                throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
            }
            int le = excelCollection.size();
            for (int i = 0; i < le; ++i) {
                ExcelCollectionParams collectionparams = excelCollection.get(i);
                collection = collectionparams.getExcelParams().values();
                for (ExcelImportEntity excelImportEntity : collection) {
                    if (!excelImportEntity.isImportField() || titlemap.containsValue(collectionparams.getExcelName() + "_" + excelImportEntity.getName())) continue;
                    throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
                }
            }
        }
    }

    private void saveFieldValue(ImportParams params, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, Row row) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHanlder(), object, cell, excelParams, titleString);
        if (object instanceof Map) {
            if (params.getDataHanlder() != null) {
                params.getDataHanlder().setMapValue((Map)object, titleString, value);
            } else {
                ((Map)object).put(titleString, value);
            }
        } else {
            this.setValues(excelParams.get(titleString), object, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        if (image == null) {
            return;
        }
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName(data);
        if (excelParams.get(titleString).getSaveType() == 1) {
            String path = PoiPublicUtil.getWebRootPath(this.getSaveUrl(excelParams.get(titleString), object));
            File savefile = new File(path);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(path + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(savefile);
            try {
                fos.write(data);
            }
            finally {
                IOUtils.closeQuietly((Closeable)fos);
            }
            this.setValues(excelParams.get(titleString), object, this.getSaveUrl(excelParams.get(titleString), object) + "/" + fileName);
        } else {
            this.setValues(excelParams.get(titleString), object, data);
        }
    }

    private void createErrorCellStyle(Workbook workbook) {
        this.errorCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor((short)10);
        this.errorCellStyle.setFont(font);
    }
}

