/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiCssUtils {
    private static final Logger log = LoggerFactory.getLogger(PoiCssUtils.class);
    private static final String COLOR_PATTERN_VALUE_SHORT = "^(#(?:[a-f]|\\d){3})$";
    private static final String COLOR_PATTERN_VALUE_LONG = "^(#(?:[a-f]|\\d{2}){3})$";
    private static final String COLOR_PATTERN_RGB = "^(rgb\\s*\\(\\s*(.+)\\s*,\\s*(.+)\\s*,\\s*(.+)\\s*\\))$";
    private static Map<String, HSSFColor> colors = new HashMap<String, HSSFColor>();

    private static String colorName(Class<? extends HSSFColor> color) {
        return color.getSimpleName().replace("_", "").toLowerCase();
    }

    public static int getInt(String strValue) {
        Matcher m;
        int value = 0;
        if (StringUtils.isNotBlank((CharSequence)strValue) && (m = Pattern.compile("^(\\d+)(?:\\w+|%)?$").matcher(strValue)).find()) {
            value = Integer.parseInt(m.group(1));
        }
        return value;
    }

    public static boolean isNum(String strValue) {
        return StringUtils.isNotBlank((CharSequence)strValue) && strValue.matches("^\\d+(\\w+|%)?$");
    }

    public static String processColor(String color) {
        log.info("Process Color [{}].", (Object)color);
        String colorRtn = null;
        if (StringUtils.isNotBlank((CharSequence)color)) {
            HSSFColor poiColor = null;
            if (color.matches(COLOR_PATTERN_VALUE_SHORT)) {
                log.debug("Short Hex Color [{}] Found.", (Object)color);
                StringBuffer sbColor = new StringBuffer();
                Matcher m = Pattern.compile("([a-f]|\\d)").matcher(color);
                while (m.find()) {
                    m.appendReplacement(sbColor, "$1$1");
                }
                colorRtn = sbColor.toString();
                log.debug("Translate Short Hex Color [{}] To [{}].", (Object)color, (Object)colorRtn);
            } else if (color.matches(COLOR_PATTERN_VALUE_LONG)) {
                colorRtn = color;
                log.debug("Hex Color [{}] Found, Return.", (Object)color);
            } else if (color.matches(COLOR_PATTERN_RGB)) {
                Matcher m = Pattern.compile(COLOR_PATTERN_RGB).matcher(color);
                if (m.matches()) {
                    log.debug("RGB Color [{}] Found.", (Object)color);
                    colorRtn = PoiCssUtils.convertColor(PoiCssUtils.calcColorValue(m.group(2)), PoiCssUtils.calcColorValue(m.group(3)), PoiCssUtils.calcColorValue(m.group(4)));
                    log.debug("Translate RGB Color [{}] To Hex [{}].", (Object)color, (Object)colorRtn);
                }
            } else {
                poiColor = PoiCssUtils.getColor(color);
                if (poiColor != null) {
                    log.debug("Color Name [{}] Found.", (Object)color);
                    short[] t = poiColor.getTriplet();
                    colorRtn = PoiCssUtils.convertColor(t[0], t[1], t[2]);
                    log.debug("Translate Color Name [{}] To Hex [{}].", (Object)color, (Object)colorRtn);
                }
            }
        }
        return colorRtn;
    }

    public static HSSFColor parseColor(HSSFWorkbook workBook, String color) {
        Color awtColor;
        HSSFColor poiColor = null;
        if (StringUtils.isNotBlank((CharSequence)color) && (awtColor = Color.decode(color)) != null) {
            int r = awtColor.getRed();
            int g = awtColor.getGreen();
            int b = awtColor.getBlue();
            HSSFPalette palette = workBook.getCustomPalette();
            poiColor = palette.findColor((byte)r, (byte)g, (byte)b);
            if (poiColor == null) {
                poiColor = palette.findSimilarColor(r, g, b);
            }
        }
        return poiColor;
    }

    public static XSSFColor parseColor(String color) {
        Color awtColor;
        XSSFColor poiColor = null;
        if (StringUtils.isNotBlank((CharSequence)color) && (awtColor = Color.decode(color)) != null) {
            poiColor = new XSSFColor(awtColor);
        }
        return poiColor;
    }

    private static HSSFColor getColor(String color) {
        return colors.get(color.replace("_", ""));
    }

    private static String convertColor(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static int calcColorValue(String color) {
        int rtn = 0;
        Matcher m = Pattern.compile("^(\\d*\\.?\\d+)\\s*(%)?$").matcher(color);
        if (m.matches()) {
            rtn = m.group(2) == null ? Math.round(Float.parseFloat(m.group(1))) % 256 : Math.round(Float.parseFloat(m.group(1)) * 255.0f / 100.0f) % 256;
        }
        return rtn;
    }

    static {
        for (Map.Entry color : HSSFColor.getIndexHash().entrySet()) {
            colors.put(PoiCssUtils.colorName(((HSSFColor)color.getValue()).getClass()), (HSSFColor)color.getValue());
        }
        HSSFColor color = colors.get(PoiCssUtils.colorName(HSSFColor.GREY_25_PERCENT.class));
        colors.put("lightgray", color);
        colors.put("lightgrey", color);
        colors.put("silver", colors.get(PoiCssUtils.colorName(HSSFColor.GREY_40_PERCENT.class)));
        color = colors.get(PoiCssUtils.colorName(HSSFColor.GREY_50_PERCENT.class));
        colors.put("darkgray", color);
        colors.put("darkgrey", color);
        color = colors.get(PoiCssUtils.colorName(HSSFColor.GREY_80_PERCENT.class));
        colors.put("gray", color);
        colors.put("grey", color);
    }
}

