/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.mail.MailException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

public class InternalMailUtil {
    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        InternetAddress[] internetAddresses = InternalMailUtil.parseAddress(address, charset);
        if (ArrayUtil.isEmpty(internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        InternetAddress[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtil.isNotEmpty(addresses)) {
            for (InternetAddress internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

