/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.InternalMailUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailException;
import cn.hutool.extra.mail.UserPassAuthenticator;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mail {
    private MailAccount mailAccount;
    private String[] tos;
    private String title;
    private String content;
    private boolean isHtml;
    private File[] files;
    private Charset charset = CharsetUtil.CHARSET_UTF_8;

    public static Mail create(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public static Mail create() {
        return new Mail();
    }

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    public Mail(MailAccount mailAccount) {
        mailAccount = null == mailAccount ? null : GlobalMailAccount.INSTANCE.getAccount();
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public Mail to(String ... tos) {
        return this.setTos(tos);
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setFiles(File ... files) {
        this.files = files;
        return this;
    }

    public Mail setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Mail send() throws MailException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private Mail doSend() throws MessagingException {
        Transport.send((Message)this.buildMsg());
        return this;
    }

    private MimeMessage buildMsg() throws MessagingException {
        MimeMessage msg = new MimeMessage(this.createSession());
        msg.setFrom((Address)InternalMailUtil.parseFirstAddress(this.mailAccount.getFrom(), this.charset));
        msg.setSubject(this.title, this.charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent());
        InternetAddress[] toAdds = new InternetAddress[this.tos.length];
        for (int i = 0; i < this.tos.length; ++i) {
            toAdds[i] = new InternetAddress(this.tos[i]);
        }
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])toAdds);
        return msg;
    }

    private Multipart buildContent() throws MessagingException {
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StrUtil.format((CharSequence)"text/{}; charset={}", this.isHtml ? "html" : "plain", this.charset));
        mainPart.addBodyPart((BodyPart)body);
        if (ArrayUtil.isNotEmpty(this.files)) {
            for (File file : this.files) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                bodyPart.setFileName(InternalMailUtil.encodeText(file.getName(), this.charset));
                mainPart.addBodyPart((BodyPart)bodyPart);
            }
        }
        return mainPart;
    }

    private Session createSession() {
        return Session.getDefaultInstance((Properties)this.mailAccount.getSmtpProps(), (Authenticator)(this.mailAccount.isAuth() != false ? new UserPassAuthenticator(this.mailAccount.getUser(), this.mailAccount.getPass()) : null));
    }
}

