/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.Mail;
import cn.hutool.extra.mail.MailAccount;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class MailUtil {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitTos(to), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), tos, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, MailUtil.splitTos(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        Console.log(mailAccount);
        Mail.create(mailAccount).to(tos.toArray(new String[tos.size()])).setTitle(subject).setContent(content).setHtml(isHtml).setFiles(files).send();
    }

    private static List<String> splitTos(String to) {
        Assert.notBlank(to);
        List<String> tos = StrUtil.contains(to, ',') ? StrUtil.splitTrim((CharSequence)to, ',') : (StrUtil.contains(to, ';') ? StrUtil.splitTrim((CharSequence)to, ';') : CollUtil.newArrayList(to));
        return tos;
    }
}

