/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.util.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.Connector;
import cn.hutool.extra.ssh.JschRuntimeException;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JschUtil {
    public static final String SSH_NONE = "none";
    private static Map<String, Session> sessionPool = new ConcurrentHashMap<String, Session>();
    private static volatile int alternativePort = 10000;

    public static int generateLocalPort() {
        while (!NetUtil.isUsableLocalPort(alternativePort)) {
            ++alternativePort;
        }
        return alternativePort;
    }

    public static synchronized Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        Session session = sessionPool.get(sshHost);
        if (session != null && session.isConnected()) {
            return session;
        }
        Session newSession = JschUtil.openSession(sshHost, sshPort, sshUser, sshPass);
        sessionPool.put(sshHost, newSession);
        return session;
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        if (StrUtil.isEmpty(sshHost) || sshPort < 0 || StrUtil.isEmpty(sshUser) || StrUtil.isEmpty(sshPass)) {
            return null;
        }
        try {
            Session session = new JSch().getSession(sshUser, sshHost, sshPort);
            session.setPassword(sshPass);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            return session;
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws JSchException {
        if (session != null && session.isConnected()) {
            session.setPortForwardingL(localPort, remoteHost, remotePort);
            return true;
        }
        return false;
    }

    public static synchronized boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
            return true;
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws JschRuntimeException {
        Session session = JschUtil.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        if (session == null) {
            throw new JschRuntimeException("Error to create SSH Session\uff01");
        }
        int localPort = JschUtil.generateLocalPort();
        try {
            JschUtil.bindPort(session, remoteHost, remotePort, localPort);
        }
        catch (JSchException e) {
            throw new JschRuntimeException("From [" + remoteHost + "] Mapping to [" + localPort + "] error\uff01", e);
        }
        return localPort;
    }

    public static synchronized void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static void close(String host) {
        Session session = sessionPool.get(host);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        sessionPool.remove(host);
    }

    public static void closeAll() {
        Collection<Session> sessions = sessionPool.values();
        for (Session session : sessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        sessionPool.clear();
    }
}

