/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMac {
    private Mac mac;
    private SecretKey secretKey;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (SecretKey)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac(HmacAlgorithm algorithm, SecretKey key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public HMac init(String algorithm, SecretKey key) {
        try {
            this.mac = Mac.getInstance(algorithm);
            this.secretKey = null != key ? key : SecureUtil.generateKey(algorithm);
            this.mac.init(this.secretKey);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StrUtil.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtil.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr(this.digest(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.mac.doFinal(data);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data, bufferLength));
    }

    public Mac getMac() {
        return this.mac;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

