/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.db.AbstractSqlRunner;
import cn.hutool.db.DbUtil;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.sql.Wrapper;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SqlRunner
extends AbstractSqlRunner {
    private DataSource ds;

    public static SqlRunner create() {
        return SqlRunner.create(DSFactory.get());
    }

    public static SqlRunner create(String group) {
        return SqlRunner.create(DSFactory.get(group));
    }

    public static SqlRunner create(DataSource ds) {
        return ds == null ? null : new SqlRunner(ds);
    }

    public static SqlRunner create(DataSource ds, Dialect dialect) {
        return new SqlRunner(ds, dialect);
    }

    public static SqlRunner create(DataSource ds, String driverClassName) {
        return new SqlRunner(ds, DialectFactory.newDialect(driverClassName));
    }

    public SqlRunner(DataSource ds) {
        this(ds, DialectFactory.newDialect(ds));
    }

    public SqlRunner(DataSource ds, Dialect dialect) {
        this.runner = new SqlConnRunner(dialect);
        this.ds = ds;
    }

    public SqlRunner(DataSource ds, String driverClassName) {
        this.runner = new SqlConnRunner(driverClassName);
        this.ds = ds;
    }

    @Override
    public SqlRunner setWrapper(Character wrapperChar) {
        return (SqlRunner)super.setWrapper(wrapperChar);
    }

    @Override
    public SqlRunner setWrapper(Wrapper wrapper) {
        return (SqlRunner)super.setWrapper(wrapper);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public void closeConnection(Connection conn) {
        DbUtil.close(conn);
    }
}

