/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.util.ImageUtil;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import cn.hutool.extra.qrcode.QrCodeException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class QrCodeUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImageUtil.write(image, targetFile);
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImageUtil.write((Image)image, imageType, out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        BitMatrix bitMatrix = QrCodeUtil.encode(content, width, height);
        return QrCodeUtil.toImage(bitMatrix);
    }

    public static BitMatrix encode(String content, int width, int height) {
        return QrCodeUtil.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        try {
            bitMatrix = multiFormatWriter.encode(content, format, width, height, hints);
        }
        catch (WriterException e) {
            throw new QrCodeException(e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeUtil.decode(ImageUtil.read(qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeUtil.decode(ImageUtil.read(qrCodeFile));
    }

    public static String decode(Image image) {
        Result result;
        MultiFormatReader formatReader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(ImageUtil.toBufferedImage(image));
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        try {
            result = formatReader.decode(binaryBitmap, hints);
        }
        catch (NotFoundException e) {
            throw new QrCodeException(e);
        }
        return result.getText();
    }

    public static BufferedImage toImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

