/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.handler.EntityListHandler;
import cn.hutool.db.handler.NumberHandler;
import cn.hutool.db.handler.PageResultHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.db.sql.SqlUtil;
import cn.hutool.db.sql.Wrapper;
import cn.hutool.log.StaticLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlConnRunner {
    private Dialect dialect;

    public static SqlConnRunner create(Dialect dialect) {
        return new SqlConnRunner(dialect);
    }

    public static SqlConnRunner create(DataSource ds) {
        return new SqlConnRunner(DialectFactory.newDialect(ds));
    }

    public static SqlConnRunner create(String driverClassName) {
        return new SqlConnRunner(driverClassName);
    }

    public SqlConnRunner(Dialect dialect) {
        StaticLog.debug("Use Dialect: [{}].", dialect.getClass().getSimpleName());
        this.dialect = dialect;
    }

    public SqlConnRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    public int insert(Connection conn, Entity record) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int insertOrUpdate(Connection conn, Entity record, String ... keys) throws SQLException {
        Entity where = record.filter(keys);
        if (MapUtil.isNotEmpty(where) && this.count(conn, where) > 0) {
            return this.update(conn, record, where);
        }
        return this.insert(conn, record);
    }

    public int[] insert(Connection conn, Collection<Entity> records) throws SQLException {
        return this.insert(conn, records.toArray(new Entity[records.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Connection conn, Entity ... records) throws SQLException {
        int[] nArray;
        this.checkConn(conn);
        if (ArrayUtil.isEmpty(records)) {
            return new int[]{0};
        }
        if (1 == records.length) {
            return new int[]{this.insert(conn, records[0])};
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsertBatch(conn, records);
            nArray = ps.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return nArray;
    }

    public List<Object> insertForGeneratedKeys(Connection conn, Entity record) throws SQLException {
        List<Object> list;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            list = StatementUtil.getGeneratedKeys(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return list;
    }

    public Long insertForGeneratedKey(Connection conn, Entity record) throws SQLException {
        Long l;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            l = StatementUtil.getGeneratedKeyOfLong(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return l;
    }

    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(where)) {
            throw new SQLException("Empty entity provided!");
        }
        Query query = new Query(SqlUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        if (CollectionUtil.isEmpty(where)) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank(tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        T t;
        this.checkConn(conn);
        Assert.notNull(query, "[query] is null !", new Object[0]);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForFind(conn, query);
            t = SqlExecutor.query(ps, rsh, new Object[0]);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return t;
    }

    public <T> T find(Connection conn, Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        Query query = new Query(SqlUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        return this.find(conn, query, rsh);
    }

    public <T> T find(Connection conn, Entity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        return this.find(conn, CollectionUtil.newArrayList(fields), where, rsh);
    }

    public List<Entity> find(Connection conn, Entity where) throws SQLException {
        return this.find(conn, where.getFieldNames(), where, EntityListHandler.create());
    }

    public List<Entity> findAll(Connection conn, Entity where) throws SQLException {
        return this.find(conn, where, EntityListHandler.create(), new String[0]);
    }

    public List<Entity> findAll(Connection conn, String tableName) throws SQLException {
        return this.findAll(conn, Entity.create(tableName));
    }

    public List<Entity> findBy(Connection conn, String tableName, String field, Object value) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, value));
    }

    public List<Entity> findLike(Connection conn, String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, SqlUtil.buildLikeValue(value, likeType, true)));
    }

    public List<Entity> findIn(Connection conn, String tableName, String field, Object ... values) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, values));
    }

    public int count(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        Query query = new Query(SqlUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForCount(conn, query);
            n = SqlExecutor.query(ps, new NumberHandler(), new Object[0]).intValue();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, int pageNumber, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.page(conn, fields, where, new Page(pageNumber, numPerPage), rsh);
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return this.find(conn, fields, where, rsh);
        }
        Query query = new Query(SqlUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        query.setPage(page);
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        this.checkConn(conn);
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page, numPerPage, count));
        return this.page(conn, fields, where, page, numPerPage, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            List<Entity> entityList = this.find(conn, fields, where, new EntityListHandler());
            PageResult<Entity> pageResult = new PageResult<Entity>(0, entityList.size(), entityList.size());
            pageResult.addAll(entityList);
            return pageResult;
        }
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page.getPageNumber(), page.getPageSize(), count));
        return this.page(conn, fields, where, page, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Entity where, Page page) throws SQLException {
        return this.page(conn, null, where, page);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlConnRunner setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public SqlConnRunner setWrapper(Character wrapperChar) {
        return this.setWrapper(new Wrapper(wrapperChar));
    }

    public SqlConnRunner setWrapper(Wrapper wrapper) {
        this.dialect.setWrapper(wrapper);
        return this;
    }

    private void checkConn(Connection conn) {
        if (null == conn) {
            throw new NullPointerException("Connection object is null!");
        }
    }
}

