/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtil {
    public static Workbook createBook(String excelFilePath) {
        return WorkbookUtil.createBook(FileUtil.file(excelFilePath), null);
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookUtil.createBook(excelFile, null);
    }

    public static Workbook createBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createBook(in, null, closeAfterRead);
    }

    public static Workbook createBook(InputStream in, String password, boolean closeAfterRead) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoUtil.toMarkSupportStream(in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            if (closeAfterRead) {
                IoUtil.close(in);
            }
        }
    }

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

