/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class BCUtil {
    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return BCUtil.decodeECPoint(SecureUtil.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        ECNamedCurveParameterSpec namedSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        ECCurve curve = namedSpec.getCurve();
        EllipticCurve ecCurve = new EllipticCurve(new ECFieldFp(curve.getField().getCharacteristic()), curve.getA().toBigInteger(), curve.getB().toBigInteger());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)ecCurve, (byte[])encodeByte);
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, namedSpec.getG(), namedSpec.getN());
        KeyFactory PubKeyGen = KeyUtil.getKeyFactory("EC");
        try {
            return PubKeyGen.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey readPrivateKey(InputStream pemStream) {
        return KeyUtil.generateRSAPrivateKey(BCUtil.readKeyBytes(pemStream));
    }

    public static PublicKey readPublicKey(InputStream pemStream) {
        Certificate certificate = KeyUtil.readX509Certificate(pemStream);
        if (null == certificate) {
            return null;
        }
        return certificate.getPublicKey();
    }

    public static Key readKey(InputStream keyStream) {
        PemObject object = BCUtil.readPemObject(keyStream);
        String type = object.getType();
        if (StrUtil.isNotBlank(type) && type.endsWith("PRIVATE KEY")) {
            return KeyUtil.generateRSAPrivateKey(object.getContent());
        }
        return KeyUtil.readX509Certificate(keyStream).getPublicKey();
    }

    public static byte[] readKeyBytes(InputStream keyStream) {
        PemObject pemObject = BCUtil.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)IoUtil.getReader(keyStream, CharsetUtil.CHARSET_UTF_8));
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(pemReader);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)pemReader);
        return pemObject;
    }
}

