/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.map.MapUtil;
import cn.hutool.db.Db;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import java.sql.SQLException;
import java.util.Collection;

public class ActiveEntity
extends Entity {
    private static final long serialVersionUID = 6112321379601134750L;
    private final Db db;

    public static ActiveEntity create() {
        return new ActiveEntity();
    }

    public static ActiveEntity create(String tableName) {
        return new ActiveEntity(tableName);
    }

    public static <T> ActiveEntity parse(T bean) {
        return ActiveEntity.create(null).parseBean((Object)bean);
    }

    public static <T> ActiveEntity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return ActiveEntity.create(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> ActiveEntity parseWithUnderlineCase(T bean) {
        return ActiveEntity.create(null).parseBean((Object)bean, true, true);
    }

    public ActiveEntity() {
        this(Db.use(), (String)null);
    }

    public ActiveEntity(String tableName) {
        this(Db.use(), tableName);
    }

    public ActiveEntity(Entity entity) {
        this(Db.use(), entity);
    }

    public ActiveEntity(Db db, String tableName) {
        super(tableName);
        this.db = db;
    }

    public ActiveEntity(Db db, Entity entity) {
        super(entity.getTableName());
        this.putAll(entity);
        this.db = db;
    }

    @Override
    public ActiveEntity setTableName(String tableName) {
        return (ActiveEntity)super.setTableName(tableName);
    }

    @Override
    public ActiveEntity setFieldNames(Collection<String> fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity setFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity addFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.addFieldNames(fieldNames);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean) {
        return (ActiveEntity)super.parseBean((Object)bean);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return (ActiveEntity)super.parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    @Override
    public ActiveEntity set(String field, Object value) {
        return (ActiveEntity)super.set(field, value);
    }

    @Override
    public ActiveEntity setIgnoreNull(String field, Object value) {
        return (ActiveEntity)super.setIgnoreNull(field, value);
    }

    @Override
    public ActiveEntity clone() {
        return (ActiveEntity)super.clone();
    }

    public ActiveEntity add() {
        try {
            this.db.insert(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity load() {
        try {
            Entity result = this.db.get(this);
            if (MapUtil.isNotEmpty(result)) {
                this.putAll(result);
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity del() {
        try {
            this.db.del(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity update(String primaryKey) {
        try {
            this.db.update(this, Entity.create().set(primaryKey, this.get(primaryKey)));
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }
}

